/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ij.IJ;
import ij.ImageJ;
import java.awt.Desktop;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.imageio.ImageIO;
import javax.script.ScriptException;
import javax.swing.SwingUtilities;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.core.ExtensionCatalogManager;
import qupath.ext.extensionmanager.core.savedentities.Registry;
import qupath.ext.extensionmanager.core.savedentities.SavedCatalog;
import qupath.fx.controls.InputDisplay;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.LogTools;
import qupath.lib.common.Timeit;
import qupath.lib.common.Version;
import qupath.lib.gui.BuildInfo;
import qupath.lib.gui.ExtensionLoader;
import qupath.lib.gui.MenuItemVisibilityManager;
import qupath.lib.gui.ParameterDialogWrapper;
import qupath.lib.gui.PathClassManager;
import qupath.lib.gui.QuPathMainPaneManager;
import qupath.lib.gui.QuPathUncaughtExceptionHandler;
import qupath.lib.gui.ScriptMenuLoader;
import qupath.lib.gui.SharedThreadPoolManager;
import qupath.lib.gui.TaskRunnerFX;
import qupath.lib.gui.ToolManager;
import qupath.lib.gui.UndoRedoManager;
import qupath.lib.gui.UpdateManager;
import qupath.lib.gui.UserDirectoryManager;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.AutomateActions;
import qupath.lib.gui.actions.CommonActions;
import qupath.lib.gui.actions.OverlayActions;
import qupath.lib.gui.actions.ViewerActions;
import qupath.lib.gui.actions.menus.Menus;
import qupath.lib.gui.commands.LogViewerCommand;
import qupath.lib.gui.commands.ProjectCommands;
import qupath.lib.gui.commands.TMACommands;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.images.stores.ImageRegionStoreFactory;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.logging.LogManager;
import qupath.lib.gui.panes.ImageDetailsPane;
import qupath.lib.gui.panes.PreferencePane;
import qupath.lib.gui.panes.ProjectBrowser;
import qupath.lib.gui.panes.ServerSelector;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.prefs.QuPathStyleManager;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.gui.scripting.DefaultScriptEditor;
import qupath.lib.gui.scripting.QPEx;
import qupath.lib.gui.scripting.ScriptEditor;
import qupath.lib.gui.scripting.languages.GroovyLanguage;
import qupath.lib.gui.scripting.languages.ScriptLanguageProvider;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.MenuTools;
import qupath.lib.gui.viewer.DragDropImportListener;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.ViewerManager;
import qupath.lib.gui.viewer.tools.PathTool;
import qupath.lib.gui.viewer.tools.PathTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerProvider;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.io.PathIO;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.plugins.PathInteractivePlugin;
import qupath.lib.plugins.PathPlugin;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectIO;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.projects.Projects;
import qupath.lib.scripting.QP;
import qupath.lib.scripting.ScriptParameters;
import qupath.lib.scripting.languages.ExecutableLanguage;
import qupath.lib.scripting.languages.ScriptLanguage;

public class QuPathGUI {
    private static final Logger logger = LoggerFactory.getLogger(QuPathGUI.class);
    private static final ExtensionCatalogManager extensionCatalogManager = new ExtensionCatalogManager(UserDirectoryManager.getInstance().extensionsDirectoryProperty(), QuPathGUI.class.getClassLoader(), String.format("v%s", BuildInfo.getInstance().getVersion().toString()), new Registry(List.of(new SavedCatalog("QuPath catalog", "Extensions maintained by the QuPath team", URI.create("https://github.com/qupath/qupath-catalog"), URI.create("https://raw.githubusercontent.com/qupath/qupath-catalog/refs/heads/main/catalog.json"), false))));
    private static QuPathGUI instance;
    public static final int TOOLBAR_ICON_SIZE = 16;
    private Stage stage;
    private HostServices hostServices;
    private MenuBar menuBar;
    private DefaultImageRegionStore imageRegionStore;
    private ToolManager toolManager;
    private SharedThreadPoolManager threadPoolManager;
    private PreferencePane prefsPane;
    private LogViewerCommand logViewerCommand;
    private ScriptEditor scriptEditor;
    private ViewerManager viewerManager;
    private PathClassManager pathClassManager;
    private UpdateManager updateManager;
    private QuPathMainPaneManager mainPaneManager;
    private UndoRedoManager undoRedoManager;
    private MenuItemVisibilityManager menuVisibilityManager;
    private boolean isStandalone = true;
    private DragDropImportListener dragAndDrop;
    private ObjectProperty<Project<BufferedImage>> projectProperty = new SimpleObjectProperty();
    private ObjectProperty<QuPathViewer> viewerProperty = new SimpleObjectProperty();
    private StringBinding titleBinding;
    private BooleanProperty readOnlyProperty = new SimpleBooleanProperty(false);
    private BooleanProperty showAnalysisPane = new SimpleBooleanProperty(true);
    private BooleanBinding noProject = this.projectProperty.isNull();
    private BooleanBinding noViewer = this.viewerProperty.isNull();
    private BooleanBinding noImageData;
    private BooleanProperty pluginRunning = new SimpleBooleanProperty(false);
    private BooleanProperty scriptRunning = new SimpleBooleanProperty(false);
    private BooleanBinding uiBlocked = this.pluginRunning.or((ObservableBooleanValue)this.scriptRunning);
    private InputDisplay inputDisplay;
    private BiMap<KeyCombination, Action> comboMap = HashBiMap.create();
    private Set<Action> actions = new LinkedHashSet<Action>();
    private CommonActions commonActions;
    private AutomateActions automateActions;
    private BooleanProperty menusInitializing = new SimpleBooleanProperty(false);
    private OverlayActions overlayActions;
    private ViewerActions viewerActions;

    private QuPathGUI(Stage stage, HostServices hostServices, boolean showStage) {
        logger.info("Initializing: {}", (Object)System.currentTimeMillis());
        this.stage = stage;
        this.hostServices = hostServices;
        Timeit timeit = new Timeit().start("Starting");
        this.toolManager = ToolManager.create();
        this.threadPoolManager = SharedThreadPoolManager.create();
        this.imageRegionStore = ImageRegionStoreFactory.createImageRegionStore();
        this.prefsPane = new PreferencePane();
        this.viewerManager = ViewerManager.create(this);
        this.pathClassManager = PathClassManager.create();
        this.updateManager = UpdateManager.create(this);
        this.dragAndDrop = new DragDropImportListener(this);
        this.noImageData = this.imageDataProperty().isNull();
        this.titleBinding = this.createTitleBinding();
        this.logViewerCommand = new LogViewerCommand((Window)stage);
        this.initializeLoggingToFile();
        this.logBuildVersion();
        Dialogs.setPrimaryWindow((Window)stage);
        this.ensureQuPathInstanceSet();
        this.setDefaultUncaughtExceptionHandler();
        timeit.checkpoint("Creating tile cache");
        this.initializeImageTileCache();
        this.initializeProjectBehavior();
        this.undoRedoManager = UndoRedoManager.createForObservableViewer(this.viewerProperty);
        this.viewerProperty.bind(this.viewerManager.activeViewerProperty());
        this.viewerProperty.addListener((v, o, n) -> this.activateToolsForViewer((QuPathViewer)n));
        timeit.checkpoint("Creating menubar");
        this.createMenubar();
        this.toolManager.getTools().addListener(c -> this.registerAcceleratorsForAllTools());
        this.registerAcceleratorsForAllTools();
        this.setupToolsMenu(this.getMenu(QuPathResources.getString("Menu.Tools"), true));
        timeit.checkpoint("Creating main component");
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)this.initializeMainComponent());
        pane.setTop((Node)this.menuBar);
        Scene scene = this.createAndInitializeMainScene((Parent)pane);
        this.mainPaneManager.setDividerPosition(Math.min(0.5, 400.0 / scene.getWidth()));
        this.initializeStage(scene);
        this.syncDefaultImageDataAndProjectForScripting();
        if (showStage) {
            Platform.runLater(this::tryToInstallAppQuitHandler);
        }
        this.initializeLocaleChangeListeners();
        timeit.checkpoint("Refreshing style");
        this.initializeStyle();
        TMACommands.installDragAndDropHandler(this);
        if (showStage) {
            timeit.checkpoint("Showing");
            stage.show();
        }
        timeit.checkpoint("Adding extensions");
        new QP();
        ExtensionLoader.loadFromManager(extensionCatalogManager, this);
        timeit.checkpoint("Adding script menus");
        timeit.checkpoint("Updating menu item visibility");
        this.menuVisibilityManager = MenuItemVisibilityManager.createMenubarVisibilityManager(this.menuBar);
        this.menuVisibilityManager.ignorePredicateProperty().bind((ObservableValue)this.menusInitializing);
        this.populateScriptingMenu(this.getMenu(QuPathResources.getString("Menu.Automate"), false));
        SystemMenuBar.manageMainMenuBar(this.menuBar);
        stage.setMinWidth(600.0);
        stage.setMinHeight(400.0);
        logger.debug("{}", (Object)timeit.stop());
        Platform.runLater(this::maybeRunStartupScript);
    }

    private void maybeRunStartupScript() {
        String property = System.getProperty("qupath.startup.script", null);
        String path = (String)PathPrefs.startupScriptProperty().get();
        if (property != null) {
            if ("false".equalsIgnoreCase(property) || "block".equalsIgnoreCase(property)) {
                logger.debug("Startup script blocked by system property");
                return;
            }
            if (path != null && !path.isEmpty()) {
                logger.warn("Startup script is overridden by system property");
            } else {
                logger.debug("Startup script specified by system property");
            }
            path = property;
        }
        if (path == null || path.isEmpty()) {
            logger.debug("No startup script found");
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            logger.warn("Startup script does not exist: {}", (Object)path);
            return;
        }
        try {
            logger.info("Running startup script {}", (Object)path);
            Dialogs.showInfoNotification((String)QuPathResources.getString("Startup.scriptTitle"), (String)String.format(QuPathResources.getString("Startup.scriptRun"), file.getName()));
            this.runScript(file, null);
        }
        catch (IllegalArgumentException | ScriptException e) {
            logger.warn("Exception running startup script: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static QuPathGUI createInstance(Stage stage) throws IllegalStateException {
        return QuPathGUI.createInstance(stage, null);
    }

    public static QuPathGUI createInstance(Stage stage, HostServices hostServices) throws IllegalStateException {
        QuPathGUI instance = QuPathGUI.getInstance();
        if (instance != null) {
            throw new IllegalStateException("QuPathGUI already exists, cannot create a new instance!");
        }
        if (stage == null) {
            stage = new Stage();
        }
        return new QuPathGUI(stage, hostServices, true);
    }

    public static QuPathGUI createHiddenInstance() throws IllegalStateException {
        Stage stage = new Stage();
        return new QuPathGUI(stage, null, false);
    }

    public static void launchInstanceFromSwing() {
        if (Platform.isFxApplicationThread() || SwingUtilities.isEventDispatchThread()) {
            QuPathGUI.launchNonStandaloneInstance();
        } else {
            System.out.println("QuPath launch requested in " + String.valueOf(Thread.currentThread()));
            SwingUtilities.invokeLater(() -> QuPathGUI.launchNonStandaloneInstance());
            Platform.setImplicitExit((boolean)false);
        }
    }

    private static void launchNonStandaloneInstance() {
        if (Platform.isFxApplicationThread()) {
            System.out.println("Launching new QuPath instance...");
            logger.info("Launching new QuPath instance...");
            QuPathGUI qupath = QuPathGUI.createInstance(new Stage());
            qupath.isStandalone = false;
            qupath.getStage().show();
            System.out.println("Done!");
        } else if (SwingUtilities.isEventDispatchThread()) {
            System.out.println("Initializing with JFXPanel...");
            new JFXPanel();
            Platform.runLater(() -> QuPathGUI.launchNonStandaloneInstance());
        } else {
            try {
                System.out.println("Calling Platform.startup()...");
                Platform.startup(() -> QuPathGUI.launchNonStandaloneInstance());
            }
            catch (IllegalStateException e) {
                System.err.println("If JavaFX is initialized, be sure to call launchQuPath() on the Application thread!");
                System.out.println("Calling Platform.runLater()...");
                Platform.runLater(() -> QuPathGUI.launchNonStandaloneInstance());
            }
        }
    }

    public void requestAutomaticUpdateCheck() {
        this.updateManager.runAutomaticUpdateCheck();
    }

    public void requestFullUpdateCheck() {
        this.updateManager.runManualUpdateCheck();
    }

    private void initializeLoggingToFile() {
        if (PathPrefs.doCreateLogFilesProperty().get()) {
            File fileLogging = this.tryToStartLogFile();
            if (fileLogging != null) {
                logger.info("Logging to file {}", (Object)fileLogging);
            } else {
                logger.warn("No directory set for log files! None will be written.");
            }
        }
    }

    private File tryToStartLogFile() {
        Path pathLogging = UserDirectoryManager.getInstance().getLogDirectoryPath();
        if (pathLogging != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String name = "qupath-" + dateFormat.format(new Date()) + ".log";
            File fileLog = new File(pathLogging.toFile(), name);
            LogManager.logToFile(fileLog);
            return fileLog;
        }
        return null;
    }

    private void logBuildVersion() {
        String buildString = BuildInfo.getInstance().getBuildString();
        Version version = BuildInfo.getInstance().getVersion();
        if (buildString != null) {
            logger.info("QuPath build: {}", (Object)buildString);
        } else if (version != null) {
            logger.info("QuPath version: {}", (Object)version);
        } else {
            logger.warn("QuPath version unknown!");
        }
    }

    private void initializeProjectBehavior() {
        this.setupProjectNameMasking();
        this.pathClassManager.getAvailablePathClasses().addListener(c -> this.syncProjectPathClassesToAvailable());
    }

    private void syncProjectPathClassesToAvailable() {
        Project<BufferedImage> project = this.getProject();
        if (project != null) {
            project.setPathClasses(this.getAvailablePathClasses());
        }
    }

    private void setupProjectNameMasking() {
        this.projectProperty.addListener((v, o, n) -> {
            if (n != null) {
                n.setMaskImageNames(PathPrefs.maskImageNamesProperty().get());
            }
            this.refreshTitle();
        });
        PathPrefs.maskImageNamesProperty().addListener((v, o, n) -> {
            Project<BufferedImage> currentProject = this.getProject();
            if (currentProject != null) {
                currentProject.setMaskImageNames(n.booleanValue());
            }
        });
    }

    private Scene createAndInitializeMainScene(Parent content) {
        Scene scene;
        try {
            Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
            scene = new Scene(content, bounds.getWidth() * 0.8, bounds.getHeight() * 0.8);
        }
        catch (Exception e) {
            logger.debug("Unable to set stage size using primary screen {}", (Object)Screen.getPrimary());
            scene = new Scene(content, 1000.0, 600.0);
        }
        this.addSceneEventFiltersAndHandlers(scene);
        this.dragAndDrop.setupTarget(scene);
        return scene;
    }

    private void initializeStage(Scene scene) {
        this.stage.setScene(scene);
        this.stage.setOnCloseRequest(this::handleCloseMainStageRequest);
        this.stage.getIcons().addAll(this.loadIconList());
        this.stage.titleProperty().bind((ObservableValue)this.titleBinding);
    }

    private void initializeStyle() {
        logger.debug("Setting style to {}", QuPathStyleManager.selectedStyleProperty().get());
        QuPathStyleManager.refresh();
    }

    private void createMenubar() {
        this.menuBar = this.createEmptyMenubarMenus();
        this.populateMenubar();
    }

    private MenuBar createEmptyMenubarMenus() {
        return new MenuBar((Menu[])Arrays.asList("Menu.File", "Menu.Edit", "Menu.Tools", "Menu.View", "Menu.Objects", "Menu.TMA", "Menu.Measure", "Menu.Automate", "Menu.Analyze", "Menu.Classify", "Menu.Extensions", "Menu.Window", "Menu.Help").stream().map(QuPathGUI::createMenuFromKey).toArray(Menu[]::new));
    }

    private static Menu createMenuFromKey(String key) {
        Menu menu = new Menu();
        QuPathResources.getLocalizedResourceManager().registerProperty(menu.textProperty(), key);
        return menu;
    }

    private void populateMenubar() {
        this.installActions(Menus.createAllMenuActions(this));
        this.getMenu(QuPathResources.getString("Menu.File"), true).getItems().add(1, (Object)this.createRecentProjectsMenu());
    }

    private void populateScriptingMenu(Menu menuScripting) {
        Objects.requireNonNull(menuScripting);
        ScriptEditor editor = this.getScriptEditor();
        ScriptMenuLoader sharedScriptMenuLoader = new ScriptMenuLoader("Shared scripts...", (ObservableStringValue)PathPrefs.scriptsPathProperty(), this::getScriptEditor);
        StringBinding projectScriptsPath = Bindings.createStringBinding(() -> {
            Project<BufferedImage> project = this.getProject();
            File dir = project == null ? null : Projects.getBaseDirectory(project);
            return dir == null ? null : new File(dir, "scripts").getAbsolutePath();
        }, (Observable[])new Observable[]{this.projectProperty});
        ScriptMenuLoader projectScriptMenuLoader = new ScriptMenuLoader("Project scripts...", (ObservableStringValue)projectScriptsPath, this::getScriptEditor);
        projectScriptMenuLoader.getMenu().visibleProperty().bind((ObservableValue)this.projectProperty.isNotNull().and((ObservableBooleanValue)this.menuVisibilityManager.ignorePredicateProperty().not()));
        ReadOnlyObjectProperty<Path> scriptDirectoryProperty = UserDirectoryManager.getInstance().scriptsDirectoryProperty();
        StringBinding userScriptsPath = Bindings.createStringBinding(() -> {
            Path path = (Path)scriptDirectoryProperty.get();
            return path == null ? null : path.toString();
        }, (Observable[])new Observable[]{scriptDirectoryProperty});
        ScriptMenuLoader userScriptMenuLoader = new ScriptMenuLoader("User scripts...", (ObservableStringValue)userScriptsPath, this::getScriptEditor);
        MenuTools.addMenuItems(menuScripting, null, sharedScriptMenuLoader.getMenu(), userScriptMenuLoader.getMenu(), projectScriptMenuLoader.getMenu());
    }

    private void setupToolsMenu(Menu menu) {
        this.refreshToolsMenu((List<? extends PathTool>)this.toolManager.getTools(), menu);
        this.toolManager.getTools().addListener(c -> this.refreshToolsMenu((List<? extends PathTool>)c.getList(), menu));
    }

    private void refreshToolsMenu(List<? extends PathTool> tools, Menu menu) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (PathTool pathTool : tools) {
            Action action = this.toolManager.getToolAction(pathTool);
            MenuItem mi = ActionTools.createCheckMenuItem(action);
            items.add(mi);
        }
        menu.getItems().setAll(items);
        MenuTools.addMenuItems(menu, null, ActionTools.createCheckMenuItem(this.toolManager.getSelectionModeAction()));
    }

    private void registerAcceleratorsForAllTools() {
        for (PathTool t : this.toolManager.getTools()) {
            Action action = this.toolManager.getToolAction(t);
            this.registerAccelerator(action);
        }
        this.registerAccelerator(this.toolManager.getSelectionModeAction());
    }

    private void setDefaultUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new QuPathUncaughtExceptionHandler(this));
    }

    public BooleanProperty showAnalysisPaneProperty() {
        return this.showAnalysisPane;
    }

    private Pane initializeMainComponent() {
        this.mainPaneManager = new QuPathMainPaneManager(this);
        this.mainPaneManager.setAnalysisPaneVisible(this.showAnalysisPane.get());
        this.showAnalysisPane.addListener((v, o, n) -> this.mainPaneManager.setAnalysisPaneVisible((boolean)n));
        this.toolManager.selectedToolProperty().addListener((v, o, n) -> {
            Action action = this.toolManager.getToolAction((PathTool)n);
            if (action != null) {
                action.setSelected(true);
            }
            this.activateToolsForViewer(this.getViewer());
            if (n == PathTools.POINTS) {
                this.commonActions.SHOW_POINTS_DIALOG.handle(null);
            }
            this.updateCursorForSelectedTool();
        });
        return this.mainPaneManager.getMainPane();
    }

    public ObservableValue<Boolean> uiBlocked() {
        return this.uiBlocked;
    }

    private void syncDefaultImageDataAndProjectForScripting() {
        this.imageDataProperty().addListener((v, o, n) -> QP.setDefaultImageData((ImageData)n));
        this.projectProperty().addListener((v, o, n) -> QP.setDefaultProject((Project)n));
    }

    private void initializeImageTileCache() {
        PathPrefs.tileCachePercentageProperty().addListener((v, o, n) -> this.imageRegionStore.getCache().clear());
        ImageServerProvider.setCache((Map)this.imageRegionStore.getCache(), BufferedImage.class);
        ImageIO.setUseCache(false);
    }

    private void initializeLocaleChangeListeners() {
        ChangeListener localeListener = (v, o, n) -> FXUtils.refreshAllListsAndTables();
        PathPrefs.defaultLocaleDisplayProperty().addListener(localeListener);
        PathPrefs.defaultLocaleFormatProperty().addListener(localeListener);
    }

    private void tryToInstallAppQuitHandler() {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            desktop.setQuitHandler(new QuPathQuitHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureQuPathInstanceSet() {
        Class<QuPathGUI> clazz = QuPathGUI.class;
        synchronized (QuPathGUI.class) {
            if (instance == null || instance.getStage() == null || !instance.getStage().isShowing()) {
                instance = this;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void addSceneEventFiltersAndHandlers(Scene scene) {
        scene.addEventFilter(MouseEvent.ANY, (EventHandler)new MainSceneMouseEventFilter());
        scene.addEventFilter(KeyEvent.ANY, (EventHandler)new MainSceneKeyEventFilter());
        scene.setOnKeyReleased((EventHandler)new MainSceneKeyEventHandler());
    }

    private void handleCloseMainStageRequest(WindowEvent e) {
        if (Platform.isNestedLoopRunning()) {
            logger.debug("Close request from nested loop - will be discarded");
            e.consume();
            return;
        }
        Collection<? extends QuPathViewer> unsavedViewers = this.getViewersWithUnsavedChanges();
        if (!unsavedViewers.isEmpty()) {
            if (unsavedViewers.size() == 1) {
                if (!this.requestToCloseViewer(unsavedViewers.iterator().next(), "Quit QuPath")) {
                    logger.trace("Pressed no to close viewer!");
                    e.consume();
                    return;
                }
            } else if (!Dialogs.showYesNoDialog((String)"Quit QuPath", (String)("Are you sure you want to quit?\n\nUnsaved changes in " + unsavedViewers.size() + " viewers will be lost."))) {
                logger.trace("Pressed no to quit window!");
                e.consume();
                return;
            }
        }
        if (!this.scriptEditor.requestClose()) {
            e.consume();
            return;
        }
        if (this.scriptRunning.get() && !Dialogs.showYesNoDialog((String)"Quit QuPath", (String)"A script is currently running! Quit anyway?")) {
            logger.trace("Pressed no to quit window with script running!");
            e.consume();
            return;
        }
        Project<BufferedImage> project = this.getProject();
        if (project != null) {
            try {
                project.syncChanges();
            }
            catch (IOException ex) {
                logger.error("Error syncing project: " + ex.getLocalizedMessage(), (Object)e);
            }
        }
        if (this.imageRegionStore != null) {
            this.imageRegionStore.close();
        }
        this.pathClassManager.savePathClassesToPreferences();
        if (!PathPrefs.savePreferences()) {
            logger.error("Error saving preferences");
        }
        this.threadPoolManager.close();
        this.closeAllOpenImagesWithoutPrompts();
        instance = null;
        if (this.isStandalone()) {
            logger.info("Calling Platform.exit();");
            Platform.exit();
            ImageJ ij = IJ.getInstance();
            if (ij != null) {
                logger.debug("Quitting from ImageJ");
                ij.exitWhenQuitting(true);
                ij.quit();
            }
            System.exit(0);
        }
    }

    private Collection<? extends QuPathViewer> getViewersWithUnsavedChanges() {
        LinkedHashSet<QuPathViewer> unsavedViewers = new LinkedHashSet<QuPathViewer>();
        for (QuPathViewer viewer : this.viewerManager.getAllViewers()) {
            if (viewer.getImageData() == null || !viewer.getImageData().isChanged()) continue;
            unsavedViewers.add(viewer);
        }
        return unsavedViewers;
    }

    private void closeAllOpenImagesWithoutPrompts() {
        for (QuPathViewer v : this.getAllViewers()) {
            try {
                if (v.getImageData() == null) continue;
                v.getImageData().getServer().close();
            }
            catch (Exception e2) {
                logger.warn("Problem closing server", (Throwable)e2);
            }
        }
    }

    public static boolean openInBrowser(String url) {
        QuPathGUI instance = QuPathGUI.getInstance();
        if (instance != null && instance.hostServices != null) {
            logger.debug("Showing URL with host services: {}", (Object)url);
            instance.hostServices.showDocument(url);
            return true;
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_OPEN_URI)) {
            try {
                Desktop.getDesktop().browse(new URI(url));
                return true;
            }
            catch (Exception e) {
                logger.error("Failed to launch browser window for {}", (Object)url, (Object)e);
                return false;
            }
        }
        Dialogs.showErrorMessage((String)"Show URL", (String)("Sorry, unable to launch a browser to open \n" + url));
        return false;
    }

    Path getCodeDirectory() {
        URI uri = null;
        try {
            if (this.hostServices != null) {
                String code = this.hostServices.getCodeBase();
                if (code == null || code.isBlank()) {
                    code = this.hostServices.getDocumentBase();
                }
                if (code != null && code.isBlank()) {
                    uri = GeneralTools.toURI((String)code);
                    return Paths.get(uri);
                }
            }
        }
        catch (URISyntaxException e) {
            logger.debug("Exception converting to URI: " + e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            return Paths.get(QuPathGUI.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        catch (Exception e) {
            logger.error("Error identifying code directory: " + e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public SharedThreadPoolManager getThreadPoolManager() {
        return this.threadPoolManager;
    }

    public static ExtensionCatalogManager getExtensionCatalogManager() {
        return extensionCatalogManager;
    }

    public ViewerManager getViewerManager() {
        return this.viewerManager;
    }

    public ObservableList<PathClass> getAvailablePathClasses() {
        return this.pathClassManager.getAvailablePathClasses();
    }

    public DragDropImportListener getDefaultDragDropListener() {
        return this.dragAndDrop;
    }

    public boolean resetAvailablePathClasses() {
        return this.pathClassManager.resetAvailablePathClasses();
    }

    private Menu createRecentProjectsMenu() {
        ObservableList<URI> recentProjects = PathPrefs.getRecentProjectList();
        Menu menuRecent = GuiTools.createRecentItemsMenu("Recent projects...", recentProjects, uri -> {
            try {
                Project project = ProjectIO.loadProject((URI)uri, BufferedImage.class);
                this.setProject((Project<BufferedImage>)project);
            }
            catch (Exception e1) {
                Dialogs.showErrorMessage((String)"Project error", (String)("Cannot find project " + String.valueOf(uri)));
                logger.error("Error loading project", (Throwable)e1);
            }
        });
        return menuRecent;
    }

    public TabPane getAnalysisTabPane() {
        return this.mainPaneManager == null ? null : this.mainPaneManager.getAnalysisTabPane().getTabPane();
    }

    private List<Image> loadIconList() {
        try {
            ArrayList<Image> icons = new ArrayList<Image>();
            for (int i : new int[]{16, 32, 48, 64, 128, 256, 512}) {
                try {
                    Image icon = this.loadIcon(i);
                    icons.add(icon);
                }
                catch (IOException e) {
                    logger.warn("Unable to load icon for size " + i + ": " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (!icons.isEmpty()) {
                return icons;
            }
        }
        catch (Exception e) {
            logger.error("Exception loading icons: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private Image loadIcon(int size) throws IOException {
        String path = "icons/QuPath_" + size + ".png";
        try (InputStream stream = QuPathGUI.class.getClassLoader().getResourceAsStream(path);){
            Image image = new Image(stream);
            return image;
        }
    }

    public boolean isStandalone() {
        return this.isStandalone;
    }

    public ObservableList<QuPathViewer> getAllViewers() {
        return this.viewerManager.getAllViewers();
    }

    public QuPathViewer getViewer() {
        return this.viewerManager == null ? null : this.viewerManager.getActiveViewer();
    }

    public static QuPathGUI getInstance() {
        return instance;
    }

    private void activateToolsForViewer(QuPathViewer viewer) {
        if (viewer != null) {
            viewer.setActiveTool(this.toolManager.getSelectedTool());
        }
    }

    public boolean openSavedData(QuPathViewer viewer, File file, boolean keepExistingServer, boolean promptToSaveChanges) throws IOException {
        if (viewer == null) {
            if (this.getAllViewers().size() == 1) {
                viewer = this.getViewer();
            } else {
                Dialogs.showErrorMessage((String)"Open saved data", (String)"Please specify the viewer where the data should be opened!");
                return false;
            }
        }
        for (QuPathViewer v : this.viewerManager.getAllViewers()) {
            ImageData<BufferedImage> data = v.getImageData();
            if (data == null || data.getLastSavedPath() == null || !new File(data.getLastSavedPath()).equals(file)) continue;
            this.viewerManager.setActiveViewer(v);
            return true;
        }
        ImageServerBuilder.ServerBuilder serverBuilder = null;
        ImageData<BufferedImage> imageData = viewer.getImageData();
        try {
            serverBuilder = PathIO.extractServerBuilder((Path)file.toPath());
        }
        catch (Exception e) {
            logger.warn("Unable to read image server from file: {}", (Object)e.getLocalizedMessage());
        }
        ImageServerBuilder.ServerBuilder existingBuilder = imageData == null || imageData.getServer() == null ? null : imageData.getServer().getBuilder();
        boolean sameServer = Objects.equals(existingBuilder, serverBuilder);
        ImageServer server = null;
        if (sameServer || imageData != null && keepExistingServer) {
            server = imageData.getServer();
        } else {
            try {
                server = serverBuilder.build();
            }
            catch (Exception e) {
                logger.error("Unable to build server " + String.valueOf(serverBuilder), (Throwable)e);
            }
            if (server == null && serverBuilder != null) {
                Collection uris = serverBuilder.getURIs();
                HashMap<URI, URI> urisUpdated = new HashMap<URI, URI>();
                for (URI uri : uris) {
                    Path pathUri = GeneralTools.toPath((URI)uri);
                    if (pathUri != null && Files.exists(pathUri, new LinkOption[0])) {
                        urisUpdated.put(uri, uri);
                        continue;
                    }
                    String currentPath = pathUri == null ? uri.toString() : pathUri.toString();
                    String newPath = FileChoosers.promptForFilePathOrURI((String)"Set path to missing image", (String)currentPath, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[0]);
                    if (newPath == null) {
                        return false;
                    }
                    try {
                        urisUpdated.put(uri, GeneralTools.toURI((String)newPath));
                    }
                    catch (URISyntaxException e) {
                        throw new IOException(e);
                    }
                }
                serverBuilder = serverBuilder.updateURIs(urisUpdated);
                try {
                    server = serverBuilder.build();
                }
                catch (Exception e) {
                    logger.error("Unable to build server {}", (Object)serverBuilder, (Object)e);
                }
            }
            if (server == null) {
                return false;
            }
            ImageServer serverTemp = server;
            this.threadPoolManager.submitShortTask(() -> this.imageRegionStore.getThumbnail(serverTemp, 0, 0, true));
        }
        if (promptToSaveChanges && imageData != null && imageData.isChanged() && !this.isReadOnly() && !this.promptToSaveChangesOrCancel("Save changes", imageData)) {
            return false;
        }
        try {
            ImageData imageData2 = PathIO.readImageData((File)file, (ImageServer)server);
            viewer.setImageData((ImageData<BufferedImage>)imageData2);
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)"Read image data", (String)("Error reading image data\n" + e.getLocalizedMessage()));
            logger.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public boolean openImageEntry(ProjectImageEntry<BufferedImage> entry) {
        Project<BufferedImage> project = this.getProject();
        if (entry == null || project == null) {
            return false;
        }
        QuPathViewer viewer = this.getViewer();
        ImageData imageData = viewer.getImageData();
        if (imageData != null && project.getEntry(imageData) == entry) {
            return false;
        }
        for (QuPathViewer v : this.viewerManager.getAllViewers()) {
            ImageData<BufferedImage> data = v.getImageData();
            if (data == null || project.getEntry(data) != entry) continue;
            this.viewerManager.setActiveViewer(v);
            return true;
        }
        if (imageData != null && project != null && !this.checkSaveChanges((ImageData<BufferedImage>)imageData)) {
            return false;
        }
        try {
            PathPrefs.ImageTypeSetting setType;
            imageData = entry.readImageData();
            viewer.setImageData((ImageData<BufferedImage>)imageData);
            if (!(imageData == null || imageData.getImageType() != null && imageData.getImageType() != ImageData.ImageType.UNSET || (setType = (PathPrefs.ImageTypeSetting)((Object)PathPrefs.imageTypeSettingProperty().get())) != PathPrefs.ImageTypeSetting.AUTO_ESTIMATE && setType != PathPrefs.ImageTypeSetting.PROMPT)) {
                ImageData.ImageType type = GuiTools.estimateImageType((ImageServer<BufferedImage>)imageData.getServer(), (BufferedImage)this.imageRegionStore.getThumbnail(imageData.getServer(), 0, 0, true));
                logger.info("Image type estimated to be {}", (Object)type);
                if (setType == PathPrefs.ImageTypeSetting.PROMPT) {
                    ImageDetailsPane.promptToSetImageType((ImageData<BufferedImage>)imageData, type);
                } else {
                    imageData.setImageType(type);
                    imageData.setChanged(false);
                }
            }
            return true;
        }
        catch (Exception e) {
            Dialogs.showErrorMessage((String)"Load ImageData", (String)("Error attempting to load image data\n" + e.getLocalizedMessage()));
            logger.error(e.getMessage(), (Throwable)e);
            viewer.resetImageData();
            return false;
        }
    }

    ProjectImageEntry<BufferedImage> getProjectImageEntry(ImageData<BufferedImage> imageData) {
        if (imageData == null) {
            return null;
        }
        Project<BufferedImage> project = this.getProject();
        return project == null ? null : project.getEntry(imageData);
    }

    private boolean checkSaveChanges(ImageData<BufferedImage> imageData) {
        if (!imageData.isChanged() || this.isReadOnly()) {
            return true;
        }
        ProjectImageEntry<BufferedImage> entry = this.getProjectImageEntry(imageData);
        String name = entry == null ? ServerTools.getDisplayableImageName((ImageServer)imageData.getServer()) : entry.getImageName();
        Window owner = FXUtils.getWindow((Node)this.getViewer().getView());
        ButtonType response = Dialogs.builder().title("Save changes").owner(owner).contentText("Save changes to " + name + "?").buttons(new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL}).showAndWait().orElse(ButtonType.CANCEL);
        if (response == ButtonType.CANCEL) {
            return false;
        }
        if (response == ButtonType.NO) {
            return true;
        }
        try {
            if (entry == null) {
                String lastPath = imageData.getLastSavedPath();
                File lastFile = lastPath == null ? null : new File(lastPath);
                File file = FileChoosers.promptToSaveFile((String)"Save data", (File)lastFile, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"QuPath data files", (String[])new String[]{PathPrefs.getSerializationExtension()})});
                if (file == null) {
                    return false;
                }
                PathIO.writeImageData((File)file, imageData);
            } else {
                entry.saveImageData(imageData);
                Project<BufferedImage> project = this.getProject();
                if (project != null) {
                    project.syncChanges();
                }
            }
            return true;
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)"Save ImageData", (String)("Error attempting to save image data\n" + e.getLocalizedMessage()));
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean promptToOpenImageFile() {
        try {
            return this.openImage(this.getViewer(), null, true, false);
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)"Open image", (String)("Error opening image\n" + e.getLocalizedMessage()));
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean promptToOpenImageFileOrUri() {
        try {
            return this.openImage(this.getViewer(), null, true, true);
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)"Open image", (String)("Error opening image\n" + e.getLocalizedMessage()));
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean openImage(QuPathViewer viewer, String pathNew) throws IOException {
        return this.openImage(viewer, pathNew, false, false);
    }

    public boolean openImage(QuPathViewer viewer, String pathNew, boolean prompt, boolean includeURLs) throws IOException {
        Collection uris;
        if (viewer == null) {
            if (this.getAllViewers().size() == 1) {
                viewer = this.getViewer();
            } else {
                Dialogs.showErrorMessage((String)"Open image", (String)"Please specify the viewer where the image should be opened!");
                return false;
            }
        }
        ImageServer<BufferedImage> server = viewer.getServer();
        String pathOld = null;
        File fileBase = null;
        if (server != null && (uris = server.getURIs()).size() == 1) {
            URI uri = (URI)uris.iterator().next();
            pathOld = uri.toString();
            try {
                Path path = GeneralTools.toPath((URI)uri);
                if (path != null) {
                    fileBase = path.toFile().getParentFile();
                }
            }
            catch (Exception path) {
                // empty catch block
            }
        }
        File fileNew = null;
        if (pathNew == null) {
            if (includeURLs) {
                pathNew = FileChoosers.promptForFilePathOrURI((String)"Choose path", pathOld, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[0]);
                if (pathNew == null) {
                    return false;
                }
                fileNew = new File(pathNew);
            } else {
                fileNew = ((FileChooser)FileChoosers.buildFileChooser().initialDirectory(fileBase).build()).showOpenDialog(Dialogs.getPrimaryWindow());
                if (fileNew == null) {
                    return false;
                }
                pathNew = fileNew.getAbsolutePath();
            }
        } else {
            fileNew = new File(pathNew);
        }
        if (fileNew.isFile() && GeneralTools.checkExtensions((String)pathNew, (String[])new String[]{PathPrefs.getSerializationExtension()})) {
            return this.openSavedData(viewer, fileNew, false, true);
        }
        if (fileNew.isFile() && GeneralTools.checkExtensions((String)pathNew, (String[])new String[]{ProjectIO.getProjectExtension()})) {
            logger.info("Trying to load project {}", (Object)fileNew.getAbsolutePath());
            try {
                Project project = ProjectIO.loadProject((File)fileNew, BufferedImage.class);
                if (project != null) {
                    this.setProject((Project<BufferedImage>)project);
                    return true;
                }
            }
            catch (Exception e) {
                Dialogs.showErrorMessage((String)"Open project", (Throwable)e);
                logger.error("Error opening project " + fileNew.getAbsolutePath(), (Throwable)e);
                return false;
            }
        }
        if (!pathNew.equals(pathOld)) {
            List builders;
            if (this.getProject() != null) {
                List<ProjectImageEntry<BufferedImage>> entries = ProjectCommands.promptToImportImages(this, pathNew);
                if (entries.isEmpty()) {
                    return false;
                }
                return this.openImageEntry(entries.get(0));
            }
            ImageServer serverNew = null;
            ImageServerBuilder.UriImageSupport support = ImageServerProvider.getPreferredUriImageSupport(BufferedImage.class, (String)pathNew, (String[])new String[0]);
            List list = builders = support == null ? Collections.emptyList() : support.getBuilders();
            if (builders.isEmpty()) {
                String name = fileNew == null ? pathNew : fileNew.getName();
                String message = "No supported image reader found for " + name + ".\nSee View > Show log for more details";
                Dialogs.showErrorMessage((String)"Unable to build server", (String)message);
                return false;
            }
            if (builders.size() == 1) {
                try {
                    serverNew = ((ImageServerBuilder.ServerBuilder)builders.get(0)).build();
                }
                catch (Exception e) {
                    logger.error("Error building server: " + e.getLocalizedMessage(), (Throwable)e);
                }
            } else {
                ServerSelector selector = ServerSelector.createFromBuilders(builders);
                serverNew = selector.promptToSelectImage("Open", false);
                if (serverNew == null) {
                    return false;
                }
            }
            if (serverNew != null) {
                if (pathOld != null && prompt && !viewer.getHierarchy().isEmpty() && !Dialogs.showYesNoDialog((String)"Replace open image", (String)("Close " + ServerTools.getDisplayableImageName(server) + "?"))) {
                    return false;
                }
                ImageData<BufferedImage> imageData = null;
                if (serverNew != null) {
                    int minSize = PathPrefs.minPyramidDimensionProperty().get();
                    if (serverNew.nResolutions() == 1 && Math.max(serverNew.getWidth(), serverNew.getHeight()) > minSize) {
                        long estimatedBytes = (long)serverNew.getWidth() * (long)serverNew.getHeight() * (long)serverNew.nChannels() * (long)serverNew.getPixelType().getBytesPerPixel();
                        double requiredBytes = (double)estimatedBytes * 1.3333333333333333;
                        if (prompt && this.imageRegionStore != null && requiredBytes >= (double)this.imageRegionStore.getTileCacheSize()) {
                            logger.warn("Selected image is {} x {} x {} pixels ({})", new Object[]{serverNew.getWidth(), serverNew.getHeight(), serverNew.nChannels(), serverNew.getPixelType()});
                            Dialogs.showErrorMessage((String)"Image too large", (String)"Non-pyramidal image is too large for the available tile cache!\nTry converting the image to a pyramidal file format, or increasing the memory available to QuPath.");
                            return false;
                        }
                        ImageServer serverWrapped = ImageServers.pyramidalize(serverNew, (double[])new double[0]);
                        if (serverWrapped.nResolutions() > 1 && prompt) {
                            ButtonType response = Dialogs.showYesNoCancelDialog((String)"Auto pyramidalize", (String)("QuPath works best with large images saved in a pyramidal format.\n\nDo you want to generate a pyramid dynamically from " + ServerTools.getDisplayableImageName(serverNew) + "?\n(This requires more memory, but is usually worth it)"));
                            if (response == ButtonType.CANCEL) {
                                return false;
                            }
                            if (response == ButtonType.YES) {
                                serverNew = serverWrapped;
                            }
                        }
                    }
                    imageData = this.createNewImageData(serverNew);
                }
                viewer.setImageData(imageData);
                if (imageData.getImageType() == ImageData.ImageType.UNSET && PathPrefs.imageTypeSettingProperty().get() == PathPrefs.ImageTypeSetting.PROMPT) {
                    ImageData.ImageType type = GuiTools.estimateImageType(serverNew, (BufferedImage)this.imageRegionStore.getThumbnail(serverNew, 0, 0, true));
                    ImageDetailsPane.promptToSetImageType(imageData, type);
                }
                return true;
            }
            Dialogs.showErrorNotification((String)"Open image", (String)("Sorry, I can't open " + pathNew));
        }
        return false;
    }

    private ImageData<BufferedImage> createNewImageData(ImageServer<BufferedImage> server) {
        return this.createNewImageData(server, PathPrefs.imageTypeSettingProperty().get() == PathPrefs.ImageTypeSetting.AUTO_ESTIMATE);
    }

    private ImageData<BufferedImage> createNewImageData(ImageServer<BufferedImage> server, boolean estimateImageType) {
        return new ImageData(server, estimateImageType ? GuiTools.estimateImageType(server, (BufferedImage)this.imageRegionStore.getThumbnail((ImageServer)server, 0, 0, true)) : ImageData.ImageType.UNSET);
    }

    public MenuItem installGroovyCommand(String menuPath, File file) {
        return this.installCommand(menuPath, () -> {
            try {
                this.runScript(file, null);
            }
            catch (ScriptException e) {
                Dialogs.showErrorMessage((String)"Script error", (String)e.getLocalizedMessage());
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    public MenuItem installGroovyCommand(String menuPath, String script) {
        return this.installCommand(menuPath, () -> {
            try {
                this.runScript(null, script);
            }
            catch (ScriptException e) {
                Dialogs.showErrorMessage((String)"Script error", (String)e.getLocalizedMessage());
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    public MenuItem installImageDataCommand(String menuPath, Consumer<ImageData<BufferedImage>> command) {
        if (!Platform.isFxApplicationThread()) {
            return (MenuItem)FXUtils.callOnApplicationThread(() -> this.installImageDataCommand(menuPath, command));
        }
        Menu menu = this.parseMenu(menuPath, "Menu.Extensions", true);
        String name = this.parseName(menuPath);
        Action action = this.createImageDataAction(command, name);
        MenuItem item = ActionTools.createMenuItem(action);
        this.addOrReplaceItem((List<MenuItem>)menu.getItems(), item);
        return item;
    }

    public MenuItem installCommand(String menuPath, Runnable runnable) {
        if (!Platform.isFxApplicationThread()) {
            return (MenuItem)FXUtils.callOnApplicationThread(() -> this.installCommand(menuPath, runnable));
        }
        Menu menu = this.parseMenu(menuPath, "Menu.Extensions", true);
        String name = this.parseName(menuPath);
        Action action = ActionTools.createAction(runnable, name);
        MenuItem item = ActionTools.createMenuItem(action);
        this.addOrReplaceItem((List<MenuItem>)menu.getItems(), item);
        return item;
    }

    private void addOrReplaceItem(List<MenuItem> items, MenuItem item) {
        String name = item.getText();
        if (name != null) {
            for (int i = 0; i < items.size(); ++i) {
                if (!name.equals(items.get(i).getText())) continue;
                items.set(i, item);
                return;
            }
        }
        items.add(item);
    }

    private Menu parseMenu(String menuPath, String defaultMenu, boolean create) {
        int separator = menuPath.lastIndexOf(">");
        if (separator < 0) {
            return this.getMenu(defaultMenu, create);
        }
        return this.getMenu(menuPath.substring(0, separator), create);
    }

    private String parseName(String menuPath) {
        int separator = menuPath.lastIndexOf(">");
        if (separator < 0) {
            return menuPath;
        }
        return menuPath.substring(separator + 1);
    }

    public Object runScript(File file, String script) throws ScriptException, IllegalArgumentException {
        ScriptParameters params = ScriptParameters.builder().setProject(this.getProject()).setImageData(this.getImageData()).setDefaultImports(QPEx.getCoreClasses()).setDefaultStaticImports(Collections.singletonList(QPEx.class)).setFile(file).setScript(script).setBatchSaveResult(false).useLogWriters().build();
        ScriptLanguage language = null;
        if (file != null) {
            language = ScriptLanguageProvider.fromString(file.getName());
        }
        if (!(language instanceof ExecutableLanguage)) {
            language = GroovyLanguage.getInstance();
        }
        return ((ExecutableLanguage)language).execute(params);
    }

    public PreferencePane getPreferencePane() {
        return this.prefsPane;
    }

    public Object lookupAccelerator(String combo) {
        return this.lookupAccelerator(KeyCombination.valueOf((String)combo));
    }

    public Object lookupAccelerator(KeyCombination combo) {
        for (Action action : this.actions) {
            KeyCombination accelerator = action.getAccelerator();
            if (accelerator == null || !Objects.equals(accelerator, combo)) continue;
            return action;
        }
        List<MenuItem> menuItems = MenuTools.getFlattenedMenuItems((List<? extends MenuItem>)this.menuBar.getMenus(), false);
        for (MenuItem mi : menuItems) {
            KeyCombination accelerator = mi.getAccelerator();
            if (accelerator == null || !Objects.equals(accelerator, combo)) continue;
            Action action = ActionTools.getActionProperty(mi);
            return action == null ? mi : action;
        }
        return null;
    }

    public boolean setAccelerator(String menuCommand, String combo) {
        Objects.requireNonNull(menuCommand, "Cannot set accelerator for null menu item");
        MenuItem item = this.lookupMenuItem(menuCommand, new String[0]);
        if (item == null) {
            logger.warn("Could not find command for {}", (Object)menuCommand);
            return false;
        }
        this.setAccelerator(item, combo == null ? null : KeyCombination.valueOf((String)combo));
        return true;
    }

    public boolean setAccelerator(MenuItem item, KeyCombination combo) {
        Object existingItem;
        if (!Platform.isFxApplicationThread()) {
            return (Boolean)FXUtils.callOnApplicationThread(() -> this.setAccelerator(item, combo));
        }
        Objects.requireNonNull(item, "Cannot set accelerator for null menu item");
        Action action = ActionTools.getActionProperty(item);
        Object object = existingItem = combo == null ? null : this.lookupAccelerator(combo);
        if (existingItem != null) {
            if (existingItem == item || existingItem == action) {
                logger.info("Accelerator {} already set for {} - no changes needed", (Object)combo, (Object)item.getText());
                return false;
            }
            if (existingItem != null) {
                if (existingItem instanceof MenuItem) {
                    MenuItem existingMenuItem = (MenuItem)existingItem;
                    this.setAccelerator(existingMenuItem, null);
                } else if (existingItem instanceof Action) {
                    Action existingAction = (Action)existingItem;
                    this.setAccelerator(existingAction, null);
                } else {
                    logger.warn("Can't identify {} to remove accelerator", existingItem);
                }
            }
        }
        if (action != null) {
            if (!this.setAccelerator(action, combo)) {
                return false;
            }
        } else {
            item.acceleratorProperty().unbind();
            if (item.getAccelerator() != null) {
                if (combo == null) {
                    logger.warn("Accelerator {} for {} will be removed", (Object)item.getAccelerator(), (Object)item.getText());
                } else {
                    logger.warn("Accelerator for {} will be changed from {} to {}", new Object[]{item.getText(), item.getAccelerator(), combo});
                }
            }
            item.setAccelerator(combo);
        }
        Menu menu = item.getParentMenu();
        ObservableList items = menu.getItems();
        int ind = items.indexOf((Object)item);
        items.remove((Object)item);
        items.add(ind, (Object)item);
        return true;
    }

    public boolean setAccelerator(Action action, KeyCombination combo) {
        if (!Platform.isFxApplicationThread()) {
            return (Boolean)FXUtils.callOnApplicationThread(() -> this.setAccelerator(action, combo));
        }
        Objects.requireNonNull(action, "Cannot set accelerator for null action");
        if (Objects.equals(action.getAccelerator(), combo)) {
            logger.info("Accelerator {} already set for {} - no changes needed", (Object)combo, (Object)action.getText());
            return false;
        }
        action.acceleratorProperty().unbind();
        if (action.getAccelerator() != null) {
            if (combo == null) {
                logger.warn("Accelerator {} for {} will be removed", (Object)action.getAccelerator(), (Object)action.getText());
            } else {
                logger.info("Accelerator for {} will be changed from {} to {}", new Object[]{action.getText(), action.getAccelerator(), combo});
            }
        }
        action.setAccelerator(combo);
        this.registerAccelerator(action);
        return true;
    }

    public Action createPluginAction(String name, Class<? extends PathPlugin> pluginClass, String arg) {
        return QuPathGUI.createPluginAction(name, pluginClass, this, arg);
    }

    public Action createPluginAction(String name, PathPlugin<BufferedImage> plugin, String arg) {
        Action action = new Action(name, event -> {
            try {
                this.runPlugin(plugin, arg, true);
            }
            catch (Exception e) {
                logger.error("Error running " + plugin.getName() + ": " + e.getLocalizedMessage(), (Throwable)e);
            }
        });
        action.disabledProperty().bind((ObservableValue)this.noImageData);
        return action;
    }

    public void sendQuitRequest() {
        Stage stage = this.getStage();
        if (stage == null || !stage.isShowing()) {
            return;
        }
        stage.fireEvent((Event)new WindowEvent((Window)stage, WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    private static Action createPluginAction(String name, Class<? extends PathPlugin> pluginClass, QuPathGUI qupath, String arg) {
        try {
            Action action = new Action(name, event -> {
                try {
                    PathPlugin<BufferedImage> plugin = qupath.createPlugin(pluginClass);
                    qupath.runPlugin(plugin, arg, true);
                }
                catch (Exception e) {
                    logger.error("Error running " + name + ": " + e.getLocalizedMessage(), (Throwable)e);
                }
            });
            action.disabledProperty().bind((ObservableValue)qupath.noImageData);
            ActionTools.parseAnnotations(action, pluginClass);
            return action;
        }
        catch (Exception e) {
            logger.error("Unable to initialize plugin " + String.valueOf(pluginClass) + ": " + e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runPlugin(PathPlugin<BufferedImage> plugin, String arg, boolean doInteractive) throws Exception {
        ImageData<BufferedImage> imageData = this.getImageData();
        if (doInteractive && plugin instanceof PathInteractivePlugin) {
            PathInteractivePlugin pluginInteractive = (PathInteractivePlugin)plugin;
            ParameterList params = pluginInteractive.getDefaultParameterList(imageData);
            if (arg != null) {
                Map map = GeneralTools.parseArgStringValues((String)arg);
                ParameterList.updateParameterList((ParameterList)params, (Map)map, (Locale)Locale.US);
            }
            TaskRunnerFX runner = new TaskRunnerFX(this);
            ParameterDialogWrapper dialog = new ParameterDialogWrapper(pluginInteractive, params, (TaskRunner)runner);
            dialog.showDialog();
            return !runner.isCancelled();
        }
        try {
            this.pluginRunning.set(true);
            TaskRunnerFX runner = new TaskRunnerFX(this);
            boolean completed = plugin.runPlugin((TaskRunner)runner, imageData, arg);
            boolean bl = !runner.isCancelled();
            return bl;
        }
        finally {
            this.pluginRunning.set(false);
        }
    }

    public PathPlugin<BufferedImage> createPlugin(Class<? extends PathPlugin> pluginClass) {
        PathPlugin plugin = null;
        try {
            plugin = pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e1) {
            logger.error("Unable to construct plugin {}", pluginClass, (Object)e1);
        }
        return plugin;
    }

    private Action registerAccelerator(Action action) {
        KeyCombination accelerator = action.getAccelerator();
        if (accelerator != null && this.comboMap.get((Object)accelerator) == action) {
            return action;
        }
        this.comboMap.inverse().remove((Object)action);
        if (accelerator == null) {
            return action;
        }
        Action previous = (Action)this.comboMap.put((Object)accelerator, (Object)action);
        if (previous != null && previous != action) {
            logger.warn("Multiple actions registered for {}, will keep {} and drop {}", new Object[]{accelerator, action.getText(), previous.getText()});
        }
        return action;
    }

    public ToolBar getToolBar() {
        return this.mainPaneManager == null ? null : this.mainPaneManager.getToolBar();
    }

    public UndoRedoManager getUndoRedoManager() {
        return this.undoRedoManager;
    }

    public boolean isReadOnly() {
        return this.readOnlyProperty.get();
    }

    public ReadOnlyBooleanProperty readOnlyProperty() {
        return this.readOnlyProperty;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnlyProperty.set(readOnly);
    }

    private void updateCursorForSelectedTool() {
        if (this.stage == null || this.stage.getScene() == null) {
            return;
        }
        PathTool mode = this.toolManager.getSelectedTool();
        if (mode == PathTools.MOVE) {
            this.setCursorForAllViewers(Cursor.HAND);
        } else {
            this.setCursorForAllViewers(Cursor.DEFAULT);
        }
    }

    private void setCursorForAllViewers(Cursor cursor) {
        for (QuPathViewer viewer : this.getAllViewers()) {
            viewer.getView().setCursor(cursor);
        }
    }

    public ScriptEditor getScriptEditor() {
        if (this.scriptEditor == null) {
            this.setScriptEditor(new DefaultScriptEditor(this));
        }
        return this.scriptEditor;
    }

    public void setScriptEditor(ScriptEditor scriptEditor) {
        this.scriptEditor = scriptEditor;
        this.scriptRunning.unbind();
        if (scriptEditor instanceof DefaultScriptEditor) {
            DefaultScriptEditor defaultScriptEditor = (DefaultScriptEditor)scriptEditor;
            this.scriptRunning.bind(defaultScriptEditor.scriptRunning());
        } else {
            this.scriptRunning.set(false);
        }
    }

    public OverlayOptions getOverlayOptions() {
        return this.viewerManager == null ? null : this.viewerManager.getOverlayOptions();
    }

    public DefaultImageRegionStore getImageRegionStore() {
        return this.imageRegionStore;
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public Menu getMenu(String name, boolean createMenu) {
        MenuBar menubar = this.getMenuBar();
        if (menubar == null) {
            return null;
        }
        return MenuTools.getMenu((List<Menu>)this.menuBar.getMenus(), name, createMenu);
    }

    public Stage getStage() {
        return this.stage;
    }

    public void refreshTitle() {
        if (Platform.isFxApplicationThread()) {
            this.titleBinding.invalidate();
            this.viewerManager.refreshTitles();
        } else {
            Platform.runLater(() -> this.refreshTitle());
        }
    }

    private StringBinding createTitleBinding() {
        return Bindings.createStringBinding(() -> this.createTitleFromCurrentImage(), (Observable[])new Observable[]{this.projectProperty(), this.imageDataProperty(), PathPrefs.showImageNameInTitleProperty(), PathPrefs.maskImageNamesProperty()});
    }

    private String createTitleFromCurrentImage() {
        ImageData imageData;
        Object name = "QuPath";
        String versionString = QuPathGUI.getVersionString();
        if (versionString != null) {
            name = (String)name + " (" + versionString + ")";
        }
        if ((imageData = (ImageData)this.imageDataProperty().get()) == null || !PathPrefs.showImageNameInTitleProperty().get()) {
            return name;
        }
        return (String)name + " - " + this.getDisplayedImageName((ImageData<BufferedImage>)imageData);
    }

    public String getDisplayedImageName(ImageData<BufferedImage> imageData) {
        ProjectImageEntry entry;
        if (imageData == null) {
            return null;
        }
        Project<BufferedImage> project = this.getProject();
        ProjectImageEntry projectImageEntry = entry = project == null ? null : project.getEntry(imageData);
        if (entry == null) {
            if (PathPrefs.maskImageNamesProperty().get()) {
                return "(Name masked)";
            }
            return ServerTools.getDisplayableImageName((ImageServer)imageData.getServer());
        }
        project.setMaskImageNames(PathPrefs.maskImageNamesProperty().get());
        return entry.getImageName();
    }

    public static String getBuildString() {
        return BuildInfo.getInstance().getBuildString();
    }

    private static String getVersionString() {
        return BuildInfo.getInstance().getVersionString();
    }

    public static Version getVersion() {
        return BuildInfo.getInstance().getVersion();
    }

    public ReadOnlyObjectProperty<ImageData<BufferedImage>> imageDataProperty() {
        return this.viewerManager.imageDataProperty();
    }

    public void setProject(Project<BufferedImage> project) {
        URI uri;
        block19: {
            Project currentProject = (Project)this.projectProperty.get();
            if (currentProject == project) {
                return;
            }
            if (currentProject != null) {
                try {
                    currentProject.syncChanges();
                }
                catch (IOException e) {
                    logger.error("Error syncing project", (Throwable)e);
                    if (Dialogs.showYesNoDialog((String)"Project error", (String)"A problem occurred while saving the last project - do you want to continue?")) break block19;
                    return;
                }
            }
        }
        for (QuPathViewer viewer : this.getAllViewers()) {
            ImageData<BufferedImage> imageData;
            if (viewer == null || !viewer.hasServer() || (imageData = viewer.getImageData()) == null) continue;
            if (!this.checkSaveChanges(imageData)) {
                return;
            }
            viewer.resetImageData();
        }
        if (project != null) {
            try {
                if (!ProjectCommands.promptToCheckURIs(project, true)) {
                    return;
                }
            }
            catch (IOException e) {
                Dialogs.showErrorMessage((String)"Update URIs", (String)("Error updating URIs\n" + e.getLocalizedMessage()));
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
        }
        URI uRI = uri = project == null ? null : project.getURI();
        if (uri != null) {
            ObservableList<URI> list = PathPrefs.getRecentProjectList();
            if (list.contains((Object)uri)) {
                if (!uri.equals(list.get(0))) {
                    list.remove((Object)uri);
                    list.add(0, (Object)uri);
                }
            } else {
                list.add(0, (Object)uri);
            }
        }
        this.projectProperty.set(project);
        ProjectBrowser projectBrowser = this.mainPaneManager.getAnalysisTabPane().getProjectBrowser();
        if (projectBrowser != null && !projectBrowser.setProject(project)) {
            this.projectProperty.set(null);
            projectBrowser.setProject(null);
        }
        if (project != null) {
            ArrayList<PathClass> pathClasses = project.getPathClasses();
            if (pathClasses.isEmpty()) {
                project.setPathClasses(this.getAvailablePathClasses());
            } else {
                if (!pathClasses.contains(PathClass.NULL_CLASS)) {
                    pathClasses = new ArrayList<PathClass>(pathClasses);
                    pathClasses.add(0, PathClass.NULL_CLASS);
                }
                this.getAvailablePathClasses().setAll((Collection)pathClasses);
            }
        }
        logger.info("Project set to {}", project);
    }

    public void refreshProject() {
        if (this.mainPaneManager != null) {
            this.mainPaneManager.getProjectBrowser().refreshProject();
        }
    }

    public ReadOnlyObjectProperty<Project<BufferedImage>> projectProperty() {
        return this.projectProperty;
    }

    public Project<BufferedImage> getProject() {
        return (Project)this.projectProperty.get();
    }

    public ImageData<BufferedImage> getImageData() {
        return (ImageData)this.imageDataProperty().get();
    }

    public ReadOnlyObjectProperty<QuPathViewer> viewerProperty() {
        return this.viewerManager.activeViewerProperty();
    }

    public boolean closeViewer(QuPathViewer viewer) {
        return this.requestToCloseViewer(viewer, "Save changes");
    }

    private boolean requestToCloseViewer(QuPathViewer viewer, String dialogTitle) {
        ImageData<BufferedImage> imageData = viewer.getImageData();
        if (imageData == null) {
            return true;
        }
        if (imageData.isChanged() && !this.isReadOnly() && !this.promptToSaveChangesOrCancel(dialogTitle, imageData)) {
            return false;
        }
        viewer.resetImageData();
        return true;
    }

    private boolean promptToSaveChangesOrCancel(String dialogTitle, ImageData<BufferedImage> imageData) {
        Project<BufferedImage> project = this.getProject();
        ProjectImageEntry entry = project == null ? null : project.getEntry(imageData);
        File filePrevious = null;
        if (entry == null) {
            String lastPath = imageData.getLastSavedPath();
            filePrevious = lastPath == null ? null : new File(lastPath);
        }
        ButtonType response = ButtonType.YES;
        if (imageData.isChanged()) {
            response = Dialogs.showYesNoCancelDialog((String)dialogTitle, (String)("Save changes to " + ServerTools.getDisplayableImageName((ImageServer)imageData.getServer()) + "?"));
        }
        if (response == ButtonType.CANCEL) {
            return false;
        }
        if (response == ButtonType.YES) {
            if (filePrevious == null && entry == null && (filePrevious = FileChoosers.promptToSaveFile((String)"Save image data", (File)new File(ServerTools.getDisplayableImageName((ImageServer)imageData.getServer())), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"QuPath Serialized Data", (String[])new String[]{PathPrefs.getSerializationExtension()})})) == null) {
                return false;
            }
            try {
                if (entry != null) {
                    entry.saveImageData(imageData);
                    project.syncChanges();
                } else {
                    PathIO.writeImageData((File)filePrevious, imageData);
                }
            }
            catch (IOException e) {
                Dialogs.showErrorMessage((String)"Save ImageData", (String)("Error saving image data\n" + e.getLocalizedMessage()));
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public LogViewerCommand getLogViewerCommand() {
        return this.logViewerCommand;
    }

    public Action createImageDataAction(Consumer<ImageData<BufferedImage>> command) {
        Action action = new Action(e -> {
            ImageData<BufferedImage> imageData = this.getImageData();
            if (imageData == null) {
                GuiTools.showNoImageError("No image");
            } else {
                command.accept(imageData);
            }
        });
        action.disabledProperty().bind((ObservableValue)this.noImageData);
        return action;
    }

    BooleanProperty pluginRunningProperty() {
        return this.pluginRunning;
    }

    public BooleanProperty showInputDisplayProperty() {
        if (this.inputDisplay == null) {
            this.inputDisplay = new InputDisplay((Window)this.getStage(), Window.getWindows());
        }
        return this.inputDisplay.showProperty();
    }

    public Action createViewerAction(Consumer<QuPathViewer> command) {
        Action action = new Action(e -> {
            QuPathViewer viewer = this.getViewer();
            if (viewer == null) {
                Dialogs.showErrorMessage((String)"No viewer", (String)"This command required an active viewer!");
            } else {
                command.accept(viewer);
            }
        });
        action.disabledProperty().bind((ObservableValue)this.noViewer);
        return action;
    }

    public Action createImageDataAction(Consumer<ImageData<BufferedImage>> command, String name) {
        Action action = this.createImageDataAction(command);
        action.setText(name);
        return action;
    }

    public Action createProjectAction(Consumer<Project<BufferedImage>> command) {
        Action action = new Action(e -> {
            Project<BufferedImage> project = this.getProject();
            if (project == null) {
                GuiTools.showNoProjectError("No project");
            } else {
                command.accept(project);
            }
        });
        action.disabledProperty().bind((ObservableValue)this.noProject);
        return action;
    }

    public void installActions(Collection<? extends Action> actions) {
        this.actions.addAll(actions);
        this.installActionsToMenubar(actions);
    }

    private void installActionsToMenubar(Collection<? extends Action> actions) {
        ObservableList menus = this.getMenuBar().getMenus();
        HashMap<String, Menu> menuMap = new HashMap<String, Menu>();
        for (Action action : actions) {
            Object menuString = action.getProperties().get((Object)"MENU");
            if (menuString instanceof String) {
                Menu menu = menuMap.computeIfAbsent((String)menuString, s -> MenuTools.getMenu((List<Menu>)menus, s, true));
                ObservableList items = menu.getItems();
                String name = action.getText();
                MenuItem newItem = ActionTools.createMenuItem(action);
                if (!(newItem instanceof SeparatorMenuItem)) {
                    MenuItem existing = items.stream().filter(m -> m.getText() != null && m.getText().equals(name)).findFirst().orElse(null);
                    if (existing != null) {
                        logger.warn("Existing menu item found with name '{}' - this will be replaced", (Object)name);
                        items.set(items.indexOf((Object)existing), (Object)newItem);
                        continue;
                    }
                } else if (items.isEmpty()) continue;
                items.add((Object)newItem);
                this.registerAccelerator(action);
                continue;
            }
            logger.trace("Found command without associated menu: {}", (Object)action.getText());
        }
    }

    public synchronized CommonActions getCommonActions() {
        if (this.commonActions == null) {
            this.commonActions = new CommonActions(this);
            this.installActions(ActionTools.getAnnotatedActions(this.commonActions));
        }
        return this.commonActions;
    }

    public synchronized AutomateActions getAutomateActions() {
        if (this.automateActions == null) {
            this.automateActions = new AutomateActions(this);
            this.installActions(ActionTools.getAnnotatedActions(this.automateActions));
        }
        return this.automateActions;
    }

    public Action lookupActionByText(String text) {
        Action found = this.actions.stream().filter(p -> text.equals(p.getText())).findFirst().orElse(null);
        if (found == null) {
            logger.warn("No action called '{}' could be found!", (Object)text);
        }
        return found;
    }

    public MenuItem lookupMenuItem(String menuPath, String ... parts) {
        Menu menu;
        if (parts.length > 0) {
            menuPath = (String)menuPath + ">" + String.join((CharSequence)">", parts);
        }
        if ((menu = this.parseMenu((String)menuPath, "", false)) == null) {
            return null;
        }
        String name = this.parseName((String)menuPath);
        if (name.isEmpty()) {
            return menu;
        }
        return menu.getItems().stream().filter(m -> name.equals(m.getText())).findFirst().orElse(null);
    }

    public OverlayActions getOverlayActions() {
        if (this.overlayActions == null) {
            this.overlayActions = new OverlayActions(this.getOverlayOptions());
        }
        return this.overlayActions;
    }

    public ViewerActions getViewerActions() {
        if (this.viewerActions == null) {
            this.viewerActions = new ViewerActions(this.getViewerManager());
        }
        return this.viewerActions;
    }

    @Deprecated
    public ExecutorService createSingleThreadExecutor(Object owner) {
        LogTools.logOnce((Logger)logger, (String)"QuPathGUI.createSingleThreadExecutor(Object) is deprecated and will be removed; use QuPathGUI.getThreadPoolManager().getSingleThreadExecutor(owner) instead");
        return this.getThreadPoolManager().getSingleThreadExecutor(owner);
    }

    @Deprecated
    public <V> ExecutorCompletionService<V> createSharedPoolCompletionService(Class<V> cls) {
        LogTools.logOnce((Logger)logger, (String)"QuPathGUI.createSharedPoolCompletionService(Class) is deprecated and will be removed; use QuPathGUI.getThreadPoolManager().createSharedPoolCompletionService(Class) instead");
        return this.getThreadPoolManager().createSharedPoolCompletionService(cls);
    }

    @Deprecated
    public void submitShortTask(Runnable runnable) {
        LogTools.logOnce((Logger)logger, (String)"QuPathGUI.submitShortTask() is deprecated and will be removed; use QuPathGUI.getThreadPoolManager().submitShortTask() instead");
        this.getThreadPoolManager().submitShortTask(runnable);
    }

    class QuPathQuitHandler
    implements QuitHandler {
        QuPathQuitHandler() {
        }

        @Override
        public void handleQuitRequestWith(QuitEvent e, QuitResponse response) {
            Platform.runLater(() -> {
                QuPathGUI.this.sendQuitRequest();
                response.cancelQuit();
            });
        }
    }

    class MainSceneMouseEventFilter
    implements EventHandler<MouseEvent> {
        private long lastMousePressedWarning = 0L;

        MainSceneMouseEventFilter() {
        }

        public void handle(MouseEvent e) {
            if (e.getEventType() == MouseEvent.MOUSE_MOVED || e.getEventType() == MouseEvent.MOUSE_ENTERED || e.getEventType() == MouseEvent.MOUSE_EXITED || e.getEventType() == MouseEvent.MOUSE_ENTERED_TARGET || e.getEventType() == MouseEvent.MOUSE_EXITED_TARGET) {
                return;
            }
            if (QuPathGUI.this.uiBlocked.get()) {
                long time;
                e.consume();
                if (e.getEventType() == MouseEvent.MOUSE_PRESSED && (time = System.currentTimeMillis()) - this.lastMousePressedWarning > 5000L) {
                    if (QuPathGUI.this.scriptRunning.get()) {
                        Dialogs.showWarningNotification((String)"Script running", (String)"Please wait until the current script has finished!");
                        this.lastMousePressedWarning = time;
                    } else if (QuPathGUI.this.pluginRunning.get()) {
                        logger.warn("Please wait until the current command is finished!");
                        this.lastMousePressedWarning = time;
                    }
                }
            } else if (e.getButton() == MouseButton.MIDDLE && e.getEventType() == MouseEvent.MOUSE_CLICKED) {
                logger.debug("Middle button pressed {}x {}", (Object)e.getClickCount(), (Object)System.currentTimeMillis());
                if (QuPathGUI.this.toolManager.getSelectedTool() == PathTools.MOVE) {
                    QuPathGUI.this.toolManager.setSelectedTool(QuPathGUI.this.toolManager.getPreviousSelectedTool());
                } else {
                    QuPathGUI.this.toolManager.setSelectedTool(PathTools.MOVE);
                }
            }
        }
    }

    class MainSceneKeyEventFilter
    implements EventHandler<KeyEvent> {
        MainSceneKeyEventFilter() {
        }

        public void handle(KeyEvent e) {
            if (e.getCode() == KeyCode.SPACE) {
                QuPathViewer active;
                Boolean pressed = null;
                if (e.getEventType() == KeyEvent.KEY_PRESSED) {
                    pressed = Boolean.TRUE;
                } else if (e.getEventType() == KeyEvent.KEY_RELEASED) {
                    pressed = Boolean.FALSE;
                }
                if (pressed != null && (active = QuPathGUI.this.viewerManager.getActiveViewer()) != null) {
                    active.setSpaceDown(pressed);
                }
            } else if (e.getCode() == KeyCode.S && e.getEventType() == KeyEvent.KEY_PRESSED) {
                PathPrefs.tempSelectionModeProperty().set(true);
            } else if (e.getEventType() == KeyEvent.KEY_RELEASED) {
                PathPrefs.tempSelectionModeProperty().set(false);
            }
        }
    }

    class MainSceneKeyEventHandler
    implements EventHandler<KeyEvent> {
        MainSceneKeyEventHandler() {
        }

        public void handle(KeyEvent e) {
            Object node;
            if (e.getEventType() != KeyEvent.KEY_RELEASED) {
                return;
            }
            EventTarget target = e.getTarget();
            boolean propagatedFromAnotherScene = false;
            if (target instanceof Node && (node = (Node)target).getScene() != QuPathGUI.this.stage.getScene()) {
                propagatedFromAnotherScene = true;
            }
            if (!propagatedFromAnotherScene && (e.isConsumed() || e.isShortcutDown() || !GeneralTools.isMac() || !QuPathGUI.this.getMenuBar().isUseSystemMenuBar() || e.getTarget() instanceof TextInputControl)) {
                return;
            }
            for (Map.Entry entry : QuPathGUI.this.comboMap.entrySet()) {
                if (!((KeyCombination)entry.getKey()).match(e)) continue;
                Action action = (Action)entry.getValue();
                if (ActionTools.isSelectable(action)) {
                    action.setSelected(!action.isSelected());
                } else {
                    action.handle(new ActionEvent(e.getSource(), e.getTarget()));
                }
                e.consume();
                return;
            }
            if (new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[0]).match(e)) {
                Action action;
                OverlayActions overlayActions = QuPathGUI.this.getOverlayActions();
                action.setSelected(!(action = overlayActions.SHOW_DETECTIONS).isSelected());
                action = overlayActions.SHOW_PIXEL_CLASSIFICATION;
                action.setSelected(!action.isSelected());
                e.consume();
            }
        }
    }
}

