/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.awt.Desktop;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.Urls;
import qupath.lib.gui.WelcomeStage;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectIO;
import qupath.lib.projects.ProjectImageEntry;

public class QuPathApp
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(QuPathApp.class);
    private static final BooleanProperty showLicenseMessage = PathPrefs.showLicenseMessageOnStartupProperty();
    private static final BooleanProperty promptForExtensions = PathPrefs.createPersistentPreference("showExtensionManagerOnStartup", true);

    public void start(Stage stage) throws Exception {
        logger.trace("Before create instance: {}", (Object)System.currentTimeMillis());
        QuPathGUI qupath = QuPathGUI.createInstance(stage, this.getHostServices());
        logger.trace("Instance created: {}", (Object)System.currentTimeMillis());
        QuPathLaunchParameters params = QuPathLaunchParameters.parse(this.getParameters());
        logger.info("Starting QuPath with parameters: {}", params.getRawParameters());
        Optional<String> projectPath = params.getProjectParameter();
        projectPath.ifPresent(s -> QuPathApp.openProjectOrLogException(qupath, s));
        Optional<String> imagePath = params.getImageParameter();
        imagePath.ifPresent(s -> QuPathApp.openImageOrLogException(qupath, s));
        QuPathApp.tryToRegisterOpenFilesHandler(qupath);
        if (!params.requestQuietLaunch()) {
            if (showLicenseMessage.get()) {
                QuPathApp.showLicenseMessage(qupath);
            }
            if (PathPrefs.showStartupMessageProperty().get()) {
                QuPathApp.showWelcomeMessage(qupath);
            }
            if (promptForExtensions.get() && QuPathGUI.getExtensionCatalogManager().getCatalogManagedInstalledJars().isEmpty()) {
                QuPathApp.promptToOpenExtensionManager(qupath);
            }
            if (!QuPathApp.isCodeRunningFromDirectory()) {
                qupath.requestAutomaticUpdateCheck();
            }
        }
    }

    private static void showLicenseMessage(QuPathGUI qupath) {
        Label labelLicense = new Label(QuPathResources.getString("Startup.license"));
        labelLicense.setTextAlignment(TextAlignment.CENTER);
        Hyperlink hyperlink = new Hyperlink(QuPathResources.getString("Startup.showLicenses"));
        hyperlink.setOnAction(e -> qupath.getCommonActions().SHOW_LICENSE.handle(e));
        Label labelContent = new Label(QuPathResources.getString("Startup.use"));
        labelContent.setTextAlignment(TextAlignment.CENTER);
        labelContent.setStyle("-fx-font-weight: bold;");
        CheckBox cbAskAgain = new CheckBox(QuPathResources.getString("Startup.dontShowAgain"));
        cbAskAgain.setSelected(!showLicenseMessage.get());
        cbAskAgain.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        VBox content = new VBox(new Node[]{labelLicense, hyperlink, labelContent, cbAskAgain});
        content.setSpacing(5.0);
        content.setAlignment(Pos.CENTER);
        ButtonType accept = new ButtonType(QuPathResources.getString("Startup.accept"), ButtonBar.ButtonData.YES);
        ButtonType exit = new ButtonType(QuPathResources.getString("Startup.exit"), ButtonBar.ButtonData.NO);
        if (!Dialogs.builder().content((Node)content).modality(Modality.APPLICATION_MODAL).title(QuPathResources.getString("Startup.title")).buttons(new ButtonType[]{accept, exit}).showAndWait().orElse(exit).equals(accept)) {
            System.exit(0);
        }
        showLicenseMessage.set(!cbAskAgain.isSelected());
    }

    private static void promptToOpenExtensionManager(QuPathGUI qupath) {
        Label labelContent = new Label(QuPathResources.getString("Startup.extensions.prompt"));
        Hyperlink hyperlink = new Hyperlink(QuPathResources.getString("Startup.extensions.more"));
        hyperlink.setOnAction(e -> QuPathGUI.openInBrowser(Urls.getExtensionsDocsUrl()));
        CheckBox cbAskAgain = new CheckBox(QuPathResources.getString("Startup.extensions.remindMe"));
        cbAskAgain.setSelected(promptForExtensions.get());
        VBox content = new VBox(new Node[]{labelContent, hyperlink, cbAskAgain});
        content.setSpacing(5.0);
        content.setAlignment(Pos.CENTER);
        if (Dialogs.builder().headerText(QuPathResources.getString("Startup.extensions.header")).content((Node)content).title(QuPathResources.getString("Startup.extensions.title")).buttons(new ButtonType[]{ButtonType.YES, ButtonType.NO}).showAndWait().orElse(ButtonType.NO) == ButtonType.YES) {
            Commands.showInstalledExtensions(qupath);
        }
        promptForExtensions.set(cbAskAgain.isSelected());
    }

    private static void openProjectOrLogException(QuPathGUI qupath, String projectParameter) {
        try {
            QuPathApp.tryToOpenProject(qupath, projectParameter);
        }
        catch (IOException | URISyntaxException e) {
            logger.error("Unable to open project {}", (Object)projectParameter, (Object)e);
        }
    }

    private static void tryToOpenProject(QuPathGUI qupath, String projectParameter) throws IOException, URISyntaxException {
        URI uri = GeneralTools.toURI((String)projectParameter);
        Project project = ProjectIO.loadProject((URI)uri, BufferedImage.class);
        qupath.setProject((Project<BufferedImage>)project);
    }

    private static void openImageOrLogException(QuPathGUI qupath, String imageParameter) {
        Project<BufferedImage> project = qupath.getProject();
        try {
            if (project != null) {
                QuPathApp.tryToOpenImageFromNamedProjectEntry(qupath, project, imageParameter);
            } else {
                QuPathApp.tryToOpenImageFromPath(qupath, imageParameter);
            }
        }
        catch (Exception e) {
            logger.error("Unable to open image {}: {}", (Object)imageParameter, (Object)e.getLocalizedMessage());
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static void tryToOpenImageFromNamedProjectEntry(QuPathGUI qupath, Project<BufferedImage> project, String imageName) {
        ProjectImageEntry entry = project.getImageList().stream().filter(p -> imageName.equals(p.getImageName())).findFirst().orElse(null);
        if (entry == null) {
            logger.warn("No image found in project with name {}", (Object)imageName);
        } else {
            qupath.openImageEntry((ProjectImageEntry<BufferedImage>)entry);
        }
    }

    private static void tryToOpenImageFromPath(QuPathGUI qupath, String imagePath) throws IOException {
        qupath.openImage(qupath.getViewer(), imagePath);
    }

    private static void showWelcomeMessage(QuPathGUI qupath) {
        Stage welcomeStage = WelcomeStage.getInstance(qupath);
        welcomeStage.showAndWait();
    }

    private static boolean isCodeRunningFromDirectory() {
        return new File(QuPathGUI.class.getProtectionDomain().getCodeSource().getLocation().getFile()).isDirectory();
    }

    private static void tryToRegisterOpenFilesHandler(QuPathGUI qupath) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.APP_OPEN_FILE)) {
            logger.debug("Registering files handler");
            QuPathOpenFilesHandler handler = new QuPathOpenFilesHandler(qupath);
            desktop.setOpenFileHandler(handler);
            return;
        }
        logger.debug("Unable to register file handler (operation not supported)");
    }

    private static class QuPathLaunchParameters {
        private Application.Parameters params;

        private QuPathLaunchParameters(Application.Parameters params) {
            this.params = params;
        }

        public static QuPathLaunchParameters parse(Application.Parameters parameters) {
            return new QuPathLaunchParameters(parameters);
        }

        public boolean requestQuietLaunch() {
            String launchQuietly = this.params.getNamed().getOrDefault("quiet", null);
            if (launchQuietly == null) {
                return false;
            }
            return Boolean.valueOf(launchQuietly);
        }

        public List<String> getRawParameters() {
            return this.params.getRaw();
        }

        public Optional<String> getProjectParameter() {
            Map namedParams = this.params.getNamed();
            String projectPath = namedParams.getOrDefault("project", null);
            return Optional.ofNullable(projectPath);
        }

        public Optional<String> getImageParameter() {
            Map namedParams = this.params.getNamed();
            String imageName = namedParams.getOrDefault("image", null);
            if (imageName == null) {
                return this.getFirstUnnamedParameter();
            }
            return Optional.of(imageName);
        }

        private Optional<String> getFirstUnnamedParameter() {
            List unnamed = this.params.getUnnamed();
            if (unnamed.isEmpty()) {
                return Optional.empty();
            }
            return Optional.ofNullable((String)unnamed.get(0));
        }
    }

    private static class QuPathOpenFilesHandler
    implements OpenFilesHandler {
        private final QuPathGUI qupath;

        private QuPathOpenFilesHandler(QuPathGUI qupath) {
            Objects.requireNonNull(qupath, "QuPathGUI must not be null!");
            this.qupath = qupath;
        }

        @Override
        public void openFiles(OpenFilesEvent e) {
            logger.debug("OpenFileHandler is called! {}", (Object)e);
            List<File> files = e.getFiles();
            if (files.isEmpty()) {
                return;
            }
            if (files.size() > 1) {
                logger.warn("Received a request to open multiple files - will ignore! {}", files);
                return;
            }
            Platform.runLater(() -> this.tryToOpenImage((File)files.get(0)));
        }

        private void tryToOpenImage(File file) {
            try {
                QuPathApp.tryToOpenImageFromPath(this.qupath, file.getAbsolutePath());
            }
            catch (Exception e) {
                Dialogs.showErrorMessage((String)"Open image", (String)("Can't open image: " + e.getLocalizedMessage()));
            }
        }
    }
}

