/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.io.PathIO;
import qupath.lib.objects.classes.PathClass;

class PathClassManager {
    private static final Logger logger = LoggerFactory.getLogger(PathClassManager.class);
    private static final List<PathClass> DEFAULT_PATH_CLASSES = Collections.unmodifiableList(Arrays.asList(PathClass.NULL_CLASS, PathClass.StandardPathClasses.TUMOR, PathClass.StandardPathClasses.STROMA, PathClass.StandardPathClasses.IMMUNE_CELLS, PathClass.StandardPathClasses.NECROSIS, PathClass.StandardPathClasses.OTHER, PathClass.StandardPathClasses.REGION, PathClass.StandardPathClasses.IGNORE, PathClass.StandardPathClasses.POSITIVE, PathClass.StandardPathClasses.NEGATIVE));
    private ObservableList<PathClass> availablePathClasses = FXCollections.observableArrayList();

    private PathClassManager() {
        this.initializePathClasses();
    }

    static PathClassManager create() {
        return new PathClassManager();
    }

    private void initializePathClasses() {
        LinkedHashSet<PathClass> pathClasses = new LinkedHashSet<PathClass>();
        pathClasses.addAll(PathClassManager.loadPathClassesFromPrefs());
        if (pathClasses.isEmpty()) {
            this.resetAvailablePathClasses();
        } else {
            this.availablePathClasses.setAll(pathClasses);
        }
        this.availablePathClasses.addListener(this::handlePathClassesChangeEvent);
    }

    public ObservableList<PathClass> getAvailablePathClasses() {
        return this.availablePathClasses;
    }

    public boolean resetAvailablePathClasses() {
        return this.availablePathClasses.setAll(DEFAULT_PATH_CLASSES);
    }

    private void handlePathClassesChangeEvent(ListChangeListener.Change<? extends PathClass> c) {
        ObservableList list = c.getList();
        LinkedHashSet<PathClass> set = new LinkedHashSet<PathClass>();
        set.add(PathClass.NULL_CLASS);
        set.addAll((Collection<PathClass>)list);
        set.remove(null);
        if (set.size() != list.size() || !set.containsAll((Collection<?>)list)) {
            logger.warn("Invalid PathClass list modification: {} will be corrected to {}", (Object)list, set);
            Platform.runLater(() -> this.availablePathClasses.setAll((Collection)set));
            return;
        }
    }

    private static List<PathClass> loadPathClassesFromPrefs() {
        ArrayList<PathClass> arrayList;
        block11: {
            byte[] bytes = PathPrefs.getUserPreferences().getByteArray("defaultPathClasses", null);
            if (bytes == null || bytes.length == 0) {
                return Collections.emptyList();
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            ObjectInputStream in = PathIO.createObjectInputStream((InputStream)stream);
            try {
                List pathClassesOriginal = (List)in.readObject();
                ArrayList<PathClass> pathClasses = new ArrayList<PathClass>();
                for (PathClass pathClass : pathClassesOriginal) {
                    PathClass singleton = PathClass.getSingleton((PathClass)pathClass);
                    if (singleton != null && pathClass.getColor() != null) {
                        singleton.setColor(pathClass.getColor());
                    }
                    pathClasses.add(singleton);
                }
                arrayList = pathClasses;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Error loading classes", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            in.close();
        }
        return arrayList;
    }

    public void savePathClassesToPreferences() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(stream);){
            ArrayList<PathClass> pathClasses = new ArrayList<PathClass>((Collection<PathClass>)this.availablePathClasses);
            out.writeObject(pathClasses);
            out.flush();
        }
        catch (IOException e) {
            logger.error("Error saving classes", (Throwable)e);
        }
        byte[] bytes = stream.toByteArray();
        if ((double)bytes.length < 6144.0) {
            PathPrefs.getUserPreferences().putByteArray("defaultPathClasses", bytes);
        } else {
            logger.error("Classification list too long ({} bytes) - cannot save it to the preferences.", (Object)bytes.length);
        }
    }
}

