/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.dialogs.ParameterPanelFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.plugins.PathInteractivePlugin;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.Workflow;
import qupath.lib.plugins.workflow.WorkflowStep;

class ParameterDialogWrapper<T> {
    private static final Logger logger = LoggerFactory.getLogger(ParameterDialogWrapper.class);
    private Stage dialog;
    private ParameterPanelFX panel;
    private WorkflowStep lastWorkflowStep;

    public ParameterDialogWrapper(PathInteractivePlugin<T> plugin, ParameterList params, TaskRunner taskRunner) {
        this.dialog = this.createDialog(plugin, params, taskRunner);
    }

    public void showDialog() {
        if (this.panel.getParameters().getKeyValueParameters(false).isEmpty()) {
            for (Node node : this.dialog.getScene().getRoot().getChildrenUnmodifiable()) {
                if (!(node instanceof Button) || !((Button)node).getText().equals("Run")) continue;
                ((Button)node).fire();
            }
            return;
        }
        if (this.dialog.isShowing()) {
            this.dialog.toFront();
        }
        this.dialog.show();
        double maxHeight = Math.max(100.0, FXUtils.getScreenOrPrimary((Window)this.dialog.getOwner()).getBounds().getHeight() * 0.8);
        if (this.dialog.getHeight() > maxHeight) {
            this.dialog.setMaxHeight(maxHeight);
            this.dialog.centerOnScreen();
        }
        this.dialog.toFront();
        FXUtils.addCloseWindowShortcuts((Stage)this.dialog);
        this.dialog.requestFocus();
        Platform.runLater(() -> this.dialog.requestFocus());
    }

    public ParameterList getParameterList() {
        return this.panel.getParameters();
    }

    private Stage createDialog(final PathInteractivePlugin<T> plugin, final ParameterList params, final TaskRunner taskRunner) {
        this.panel = new ParameterPanelFX(params);
        this.panel.getPane().setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        final Button btnRun = new Button("Run");
        btnRun.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (btnRun.isDisabled()) {
                return "Please wait...";
            }
            return "Run";
        }, (Observable[])new Observable[]{btnRun.disabledProperty()}));
        final Stage dialog = new Stage();
        dialog.setMinWidth(300.0);
        dialog.setMinHeight(120.0);
        QuPathGUI qupath = QuPathGUI.getInstance();
        if (qupath != null) {
            dialog.initOwner((Window)qupath.getStage());
        }
        dialog.setTitle(plugin.getName());
        String emptyLabel = " \n";
        final Label label = new Label(" \n");
        label.setStyle("-fx-font-weight: bold;");
        label.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        label.setAlignment(Pos.CENTER);
        label.setTextAlignment(TextAlignment.CENTER);
        label.setMaxWidth(Double.MAX_VALUE);
        btnRun.setOnAction(e -> {
            final ImageData<BufferedImage> imageData = qupath.getImageData();
            if (plugin instanceof PathInteractivePlugin) {
                boolean alwaysPrompt = plugin.alwaysPromptForObjects();
                List selected = imageData == null ? Collections.emptyList() : imageData.getHierarchy().getSelectionModel().getSelectedObjects();
                Collection parents = PathObjectTools.getSupportedObjects(selected, (Collection)plugin.getSupportedParentObjectClasses());
                if ((alwaysPrompt || parents == null || parents.isEmpty()) && !ParameterDialogWrapper.promptForParentObjects(imageData, plugin, alwaysPrompt && !parents.isEmpty())) {
                    return;
                }
            }
            dialog.getScene().setCursor(Cursor.WAIT);
            btnRun.setDisable(true);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Workflow historyWorkflow = imageData.getHistoryWorkflow();
                        WorkflowStep lastStep = historyWorkflow.getLastStep();
                        boolean success = plugin.runPlugin(taskRunner, imageData, ParameterList.convertToJson((ParameterList)params));
                        WorkflowStep lastStepNew = historyWorkflow.getLastStep();
                        ParameterDialogWrapper.this.lastWorkflowStep = success && lastStep != lastStepNew ? lastStepNew : null;
                    }
                    catch (Exception e) {
                        Dialogs.showErrorMessage((String)"Plugin error", (Throwable)e);
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (OutOfMemoryError e) {
                        Dialogs.showErrorMessage((String)"Out of memory error", (String)"Out of memory - try to close other applications, or decrease the number of parallel processors in the QuPath preferences");
                    }
                    finally {
                        Platform.runLater(() -> {
                            QuPathGUI.getInstance().pluginRunningProperty().set(false);
                            dialog.getScene().setCursor(Cursor.DEFAULT);
                            label.setText(plugin.getLastResultsDescription());
                            btnRun.setDisable(false);
                        });
                    }
                }
            };
            Thread t = new Thread(runnable, "Plugin thread");
            QuPathGUI.getInstance().pluginRunningProperty().set(true);
            t.start();
        });
        BorderPane pane = new BorderPane();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)this.panel.getPane());
        scrollPane.setFitToWidth(true);
        pane.setCenter((Node)scrollPane);
        btnRun.setMaxWidth(Double.MAX_VALUE);
        btnRun.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        pane.setBottom((Node)btnRun);
        this.panel.getPane().setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        scrollPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        pane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        Scene scene = new Scene((Parent)pane);
        dialog.setScene(scene);
        btnRun.requestFocus();
        return dialog;
    }

    public WorkflowStep getLastWorkflowStep() {
        return this.lastWorkflowStep;
    }

    public static boolean promptForParentObjects(ImageData<?> imageData, PathInteractivePlugin<?> plugin, boolean includeSelected) {
        return GuiTools.promptForParentObjects(plugin.getName(), imageData, includeSelected, plugin.getSupportedParentObjectClasses());
    }
}

