/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.MenuTools;

class MenuItemVisibilityManager {
    private static final Logger logger = LoggerFactory.getLogger(MenuItemVisibilityManager.class);
    private BooleanProperty showExperimentalOptions = PathPrefs.showExperimentalOptionsProperty();
    private BooleanProperty showTMAOptions = PathPrefs.showTMAOptionsProperty();
    private BooleanProperty showLegacyOptions = PathPrefs.showLegacyOptionsProperty();
    private BooleanProperty ignorePredicateProperty = new SimpleBooleanProperty(false);
    private BooleanProperty includeSubmenusProperty = new SimpleBooleanProperty(true);
    private final Predicate<MenuItem> defaultPredicate = item -> this.checkVisibilityFromPreferences((MenuItem)item);
    private ObjectProperty<Predicate<MenuItem>> predicateProperty = new SimpleObjectProperty(this.defaultPredicate);
    private ObservableList<? extends MenuItem> menuItems;
    private boolean excludeMenusAndSeparators = false;
    private ChangeListener<Predicate<MenuItem>> predicateChangeListener = (v, o, n) -> this.updateVisibility();
    private ChangeListener<Boolean> booleanChangeListener = (v, o, n) -> this.updateVisibility();
    private ListChangeListener<MenuItem> listChangeListener = this::handleListChange;

    private MenuItemVisibilityManager(ObservableList<? extends MenuItem> menuItems) {
        this.menuItems = menuItems;
        this.attachListeners();
        this.updateVisibility();
    }

    public void stop() {
        if (this.menuItems == null) {
            logger.warn("Menu visibility manager is not running!");
            return;
        }
        this.detachListeners();
        this.menuItems = null;
        logger.info("Menu visibility manager stopped");
    }

    private void attachListeners() {
        this.predicateProperty.addListener(this.predicateChangeListener);
        this.ignorePredicateProperty.addListener(this.booleanChangeListener);
        this.includeSubmenusProperty.addListener(this.booleanChangeListener);
        this.showExperimentalOptions.addListener(this.booleanChangeListener);
        this.showTMAOptions.addListener(this.booleanChangeListener);
        this.showLegacyOptions.addListener(this.booleanChangeListener);
        this.menuItems.addListener(this.listChangeListener);
    }

    private void detachListeners() {
        this.menuItems.removeListener(this.listChangeListener);
        this.ignorePredicateProperty.removeListener(this.booleanChangeListener);
        this.includeSubmenusProperty.removeListener(this.booleanChangeListener);
        this.showExperimentalOptions.removeListener(this.booleanChangeListener);
        this.predicateProperty.removeListener(this.predicateChangeListener);
        this.showTMAOptions.removeListener(this.booleanChangeListener);
        this.showLegacyOptions.removeListener(this.booleanChangeListener);
    }

    public static MenuItemVisibilityManager createMenubarVisibilityManager(MenuBar menubar) {
        return MenuItemVisibilityManager.createMenubarVisibilityManager((ObservableList<? extends MenuItem>)menubar.getMenus());
    }

    public static MenuItemVisibilityManager createMenubarVisibilityManager(ObservableList<? extends MenuItem> items) {
        return new MenuItemVisibilityManager(items);
    }

    private void handleListChange(ListChangeListener.Change<? extends MenuItem> c) {
        while (c.next()) {
            List<MenuItem> items = c.getAddedSubList();
            if (this.getIncludeSubmenus()) {
                items = MenuTools.getFlattenedMenuItems((List<? extends MenuItem>)items, this.excludeMenusAndSeparators);
            }
            this.updateVisibilityForItems((Collection<? extends MenuItem>)items);
        }
    }

    private boolean computeVisibility(MenuItem item) {
        if (this.ignorePredicateProperty.get()) {
            return true;
        }
        Predicate predicate = (Predicate)this.predicateProperty.get();
        if (predicate == null) {
            return true;
        }
        return predicate.test(item);
    }

    public Predicate<MenuItem> getDefaultPredicate() {
        return this.defaultPredicate;
    }

    public ObjectProperty<Predicate<MenuItem>> predicateProperty() {
        return this.predicateProperty;
    }

    public Predicate<MenuItem> getPredicate() {
        return (Predicate)this.predicateProperty.get();
    }

    public void setPredicate(Predicate<MenuItem> predicate) {
        this.predicateProperty.set(predicate);
    }

    public BooleanProperty ignorePredicateProperty() {
        return this.ignorePredicateProperty;
    }

    public void setIgnorePredicate(boolean ignore) {
        this.ignorePredicateProperty().set(ignore);
    }

    public boolean getIgnorePredicate() {
        return this.ignorePredicateProperty().get();
    }

    public BooleanProperty includeSubmenusProperty() {
        return this.includeSubmenusProperty;
    }

    public boolean getIncludeSubmenus() {
        return this.includeSubmenusProperty().get();
    }

    public void setIncludeSubmenus(boolean include) {
        this.includeSubmenusProperty().set(include);
    }

    private boolean checkVisibilityFromPreferences(MenuItem item) {
        String text = item.getText();
        if (text == null) {
            return true;
        }
        text = text.trim();
        String lowerText = text.toLowerCase();
        if (!this.showExperimentalOptions.get() && (lowerText.equals("experimental") || lowerText.endsWith("experimental)"))) {
            return false;
        }
        if (!this.showTMAOptions.get() && (text.equals("TMA") || text.endsWith("TMA)"))) {
            return false;
        }
        return this.showLegacyOptions.get() || !lowerText.equals("deprecated") && !lowerText.endsWith("deprecated") && !lowerText.equals("legacy") && !lowerText.endsWith("legacy)");
    }

    private void updateVisibility() {
        if (this.menuItems == null) {
            logger.debug("No menu items!");
            return;
        }
        ObservableList<? extends MenuItem> items = this.getIncludeSubmenus() ? MenuTools.getFlattenedMenuItems(this.menuItems, this.excludeMenusAndSeparators) : this.menuItems;
        this.updateVisibilityForItems((Collection<? extends MenuItem>)items);
    }

    private void updateVisibilityForItems(Collection<? extends MenuItem> items) {
        try {
            for (MenuItem menuItem : items) {
                if (menuItem.visibleProperty().isBound()) continue;
                menuItem.setVisible(this.computeVisibility(menuItem));
            }
        }
        catch (Exception e) {
            logger.warn("Error setting menu visibility: {}", (Object)e.getLocalizedMessage());
            logger.warn("", (Throwable)e);
        }
    }
}

