/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Stream;
import javafx.beans.property.StringProperty;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.WebViews;
import qupath.ui.javadocviewer.gui.viewer.JavadocViewer;
import qupath.ui.javadocviewer.gui.viewer.JavadocViewerCommand;

public class JavadocViewerRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(JavadocViewerRunner.class);
    private static final String JAVADOC_PATH_SYSTEM_PROPERTY = "javadoc";
    private static final String JAVADOC_PATH_PREFERENCE = "javadocPath";
    private static final StringProperty javadocPath = PathPrefs.createPersistentPreference("javadocPath", null);
    private final JavadocViewerCommand command;

    public JavadocViewerRunner(Stage owner) {
        this.command = new JavadocViewerCommand(owner, WebViews.getStyleSheet(), (URI[])Stream.of(JavadocViewerRunner.findJavadocUriAroundExecutable(), System.getProperty(JAVADOC_PATH_SYSTEM_PROPERTY), (String)javadocPath.get(), (String)PathPrefs.userPathProperty().get()).filter(Objects::nonNull).map(uri -> {
            try {
                return GeneralTools.toURI((String)uri);
            }
            catch (Exception e) {
                logger.debug(String.format("Could not create URI from %s", uri), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toArray(URI[]::new));
    }

    public JavadocViewer getJavadocViewer() {
        return this.command.getJavadocViewer();
    }

    @Override
    public void run() {
        this.command.run();
    }

    private static String findJavadocUriAroundExecutable() {
        Path codePath;
        URI codeUri;
        try {
            codeUri = JavadocViewerRunner.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            logger.debug("Could not convert URI", (Throwable)e);
            return null;
        }
        try {
            codePath = Paths.get(codeUri);
        }
        catch (Exception e) {
            logger.debug(String.format("Could not convert URI %s to path", codeUri), (Throwable)e);
            return null;
        }
        if (codePath.getFileName().toString().toLowerCase().endsWith(".jar")) {
            if (codePath.getParent().toString().endsWith("/build/libs")) {
                return codePath.getParent().resolve("../../../").normalize().toString();
            }
            return codePath.getParent().toString();
        }
        return codePath.resolve("../../../").normalize().toString();
    }
}

