/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.control.ButtonType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.gui.commands.Commands;

public class FileCopier {
    private static final Logger logger = LoggerFactory.getLogger(FileCopier.class);
    private OverwriteType overwrite = OverwriteType.PROMPT;
    private boolean promptForUserDirectoryIfMissing = false;
    private List<Path> paths = new ArrayList<Path>();
    private String title = "Copy files";
    private Path outputPath;

    public FileCopier title(String title) {
        this.title = title;
        return this;
    }

    public FileCopier relativeToUserDirectory() {
        this.promptForUserDirectoryIfMissing = true;
        return this;
    }

    public FileCopier outputPath(String name) {
        return this.outputPath(Paths.get(name, new String[0]));
    }

    public FileCopier outputPath(Path name) {
        this.outputPath = name;
        return this;
    }

    public FileCopier inputFiles(Collection<File> files) {
        for (File f : files) {
            this.paths.add(f.toPath());
        }
        return this;
    }

    public FileCopier inputPaths(Collection<Path> paths) {
        this.paths.addAll(paths);
        return this;
    }

    private Path getOutputPathOrNull() throws IOException {
        if (this.promptForUserDirectoryIfMissing) {
            File dir = Commands.requestUserDirectory(true);
            if (dir == null) {
                return null;
            }
            if (this.outputPath == null) {
                return dir.toPath();
            }
            Path path = dir.toPath().resolve(this.outputPath);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            return path;
        }
        if (this.outputPath != null) {
            if (!Files.exists(this.outputPath, new LinkOption[0])) {
                if (Dialogs.showYesNoDialog((String)this.title, (String)("Create directory\n" + String.valueOf(this.outputPath)))) {
                    Files.createDirectories(this.outputPath, new FileAttribute[0]);
                } else {
                    return null;
                }
            }
            return this.outputPath;
        }
        File dir = FileChoosers.promptForDirectory((String)this.title, null);
        if (dir == null) {
            return null;
        }
        return dir.toPath();
    }

    public void doCopy() {
        boolean overwriteExisting;
        Path dir;
        if (this.paths.isEmpty()) {
            logger.debug("No files to copy!");
            return;
        }
        try {
            dir = this.getOutputPathOrNull();
            if (dir == null) {
                logger.warn("Cannot copy files - no output directory available");
                return;
            }
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                Dialogs.showErrorMessage((String)this.title, (String)(String.valueOf(dir) + "\nis not a directory!"));
                return;
            }
        }
        catch (Exception e) {
            Dialogs.showErrorMessage((String)this.title, (String)e.getLocalizedMessage());
            return;
        }
        switch (this.overwrite.ordinal()) {
            case 1: {
                overwriteExisting = false;
                break;
            }
            case 0: {
                overwriteExisting = true;
                break;
            }
            default: {
                long nExisting = this.paths.stream().map(p -> dir.resolve(p.getFileName())).filter(p -> Files.exists(p, new LinkOption[0])).count();
                if (nExisting == 0L) {
                    overwriteExisting = true;
                    break;
                }
                ButtonType response = Dialogs.showYesNoCancelDialog((String)this.title, (String)"Overwrite existing files?");
                if (response == ButtonType.YES) {
                    overwriteExisting = true;
                    break;
                }
                if (response == ButtonType.NO) {
                    overwriteExisting = false;
                    break;
                }
                logger.warn("Files will not be copied (user cancelled at overwrite prompt)");
                return;
            }
        }
        int nCopied = 0;
        for (Path source : this.paths) {
            Path destination;
            if (source.equals(destination = dir.resolve(source.getFileName()))) {
                logger.info("Skipping {} (source and destination are the same)", (Object)source);
                continue;
            }
            if (overwriteExisting || !Files.exists(destination, new LinkOption[0])) {
                try {
                    logger.info("Copying {} -> {}", (Object)source, (Object)destination);
                    Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                    ++nCopied;
                    continue;
                }
                catch (IOException e) {
                    Dialogs.showErrorMessage((String)"Copy error", (String)(String.valueOf(source) + "\ncould not be copied, sorry"));
                    logger.error("Could not copy file {}", (Object)source, (Object)e);
                    return;
                }
            }
            logger.warn("Skipping copy {}", (Object)source);
        }
        if (nCopied == 1) {
            Dialogs.showInfoNotification((String)this.title, (String)"Copied 1 file");
        } else if (nCopied > 1) {
            Dialogs.showInfoNotification((String)this.title, (String)String.format("Copied %d files", nCopied));
        }
    }

    private static enum OverwriteType {
        YES,
        NO,
        PROMPT;

    }
}

