/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import qupath.lib.color.ColorMaps;
import qupath.lib.gui.tools.ColorToolsFX;

public class ColorMapCanvas
extends Canvas {
    private double height;
    private ObjectProperty<ColorMaps.ColorMap> colorMapProperty;
    private Image image;
    private Map<Double, Rectangle> recs;
    private Function<Double, String> fun;
    private Tooltip tooltip;

    public ColorMapCanvas(double height, ColorMaps.ColorMap colorMap, Function<Double, String> fun) {
        this.height = height;
        this.colorMapProperty = new SimpleObjectProperty((Object)Objects.requireNonNull(colorMap));
        this.recs = new HashMap<Double, Rectangle>();
        this.image = ColorMapCanvas.createColorMapImage(colorMap, this.recs);
        if (fun != null) {
            this.installTooltip(fun);
        }
    }

    private void installTooltip(Function<Double, String> fun) {
        this.fun = fun;
        this.tooltip = new Tooltip();
        this.tooltip.setShowDelay(Duration.ZERO);
        this.setOnMouseMoved(e -> {
            this.tooltip.setText(this.fun.apply(Math.floor(e.getX() / this.getWidth() * 255.0)));
            this.tooltip.setGraphic((Node)this.recs.get(Math.floor(e.getX() / this.getWidth() * 255.0)));
        });
        Tooltip.install((Node)this, (Tooltip)this.tooltip);
    }

    public ColorMapCanvas(double height, ColorMaps.ColorMap colorMap) {
        this(height, colorMap, d -> "Value: " + d);
    }

    public double minHeight(double width) {
        return this.height;
    }

    public double maxHeight(double width) {
        return this.height;
    }

    public double prefHeight(double width) {
        return this.height;
    }

    public double minWidth(double width) {
        return 0.0;
    }

    public double maxWidth(double width) {
        return Double.MAX_VALUE;
    }

    public boolean isResizable() {
        return true;
    }

    public void resize(double width, double height) {
        super.setWidth(width);
        super.setHeight(height);
        this.updateColorMapImage(this.image);
    }

    public void setColorMap(ColorMaps.ColorMap ColorMap2) {
        this.colorMapProperty.set((Object)ColorMap2);
        this.image = ColorMapCanvas.createColorMapImage(ColorMap2, this.recs);
        this.updateColorMapImage(this.image);
    }

    public ColorMaps.ColorMap getColorMap() {
        return (ColorMaps.ColorMap)this.colorMapProperty.get();
    }

    public ObjectProperty<ColorMaps.ColorMap> colorMapProperty() {
        return this.colorMapProperty;
    }

    public void setTooltipFunction(Function<Double, String> fun) {
        this.fun = fun;
    }

    private static Image createColorMapImage(ColorMaps.ColorMap colorMap, Map<Double, Rectangle> recs) {
        BufferedImage imgKey = new BufferedImage(255, 10, 2);
        if (colorMap != null) {
            for (int i = 0; i < imgKey.getWidth(); ++i) {
                Integer rgb = colorMap.getColor((double)i, 0.0, 255.0);
                Rectangle rec = new Rectangle(50.0, 50.0);
                rec.setFill((Paint)ColorToolsFX.getCachedColor(rgb));
                recs.put(Double.valueOf(i), rec);
                for (int j = 0; j < imgKey.getHeight(); ++j) {
                    imgKey.setRGB(i, j, rgb);
                }
            }
        }
        WritableImage img = SwingFXUtils.toFXImage((BufferedImage)imgKey, null);
        return img;
    }

    private void updateColorMapImage(Image image) {
        GraphicsContext gc = this.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        if (image != null) {
            gc.drawImage(image, 0.0, 0.0, image.getWidth(), image.getHeight(), 0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }
}

