/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.Version;
import qupath.lib.gui.QuPathGUI;

public class BuildInfo {
    private static final Logger logger = LoggerFactory.getLogger(BuildInfo.class);
    private String buildString = null;
    private String versionString = null;
    private Version version;
    private String latestCommitTag = null;
    private static final BuildInfo INSTANCE = new BuildInfo();

    private BuildInfo() {
        try {
            String versionString = null;
            for (URL url : Collections.list(QuPathGUI.class.getClassLoader().getResources("META-INF/MANIFEST.MF"))) {
                if (url == null) continue;
                try {
                    InputStream stream = url.openStream();
                    try {
                        Manifest manifest = new Manifest(url.openStream());
                        Attributes attributes = manifest.getMainAttributes();
                        versionString = attributes.getValue("Implementation-Version");
                        String buildTime = attributes.getValue("QuPath-build-time");
                        String latestCommit = attributes.getValue("QuPath-latest-commit");
                        if (latestCommit != null) {
                            this.latestCommitTag = latestCommit;
                        }
                        if (versionString == null || buildTime == null) continue;
                        this.buildString = "Version: " + versionString + "\nBuild time: " + buildTime;
                        if (this.latestCommitTag != null) {
                            this.buildString = this.buildString + "\nLatest commit tag: " + this.latestCommitTag;
                        }
                        this.version = Version.parse((String)versionString);
                        break;
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    logger.error("Error reading manifest", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    logger.error("Error determining version: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (versionString == null && (versionString = GeneralTools.getVersion()) != null) {
                logger.trace("Parsing version from {}", (Object)versionString);
                this.version = Version.parse((String)versionString);
            }
        }
        catch (Exception e) {
            logger.error("Error searching for build string", (Throwable)e);
        }
    }

    public static BuildInfo getInstance() {
        return INSTANCE;
    }

    public Version getVersion() {
        return this.version;
    }

    String getVersionString() {
        return this.versionString;
    }

    public String getBuildString() {
        return this.buildString;
    }

    public String getLatestCommit() {
        return this.latestCommitTag;
    }

    public String toString() {
        if (this.buildString != null) {
            return this.buildString;
        }
        if (this.version != null) {
            return this.version.toString();
        }
        return "QuPath build info (unknown version)";
    }
}

