/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.awt.image.BufferedImage;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.panes.AnnotationPane;
import qupath.lib.gui.panes.ImageDetailsPane;
import qupath.lib.gui.panes.ObjectDescriptionPane;
import qupath.lib.gui.panes.PathObjectHierarchyView;
import qupath.lib.gui.panes.ProjectBrowser;
import qupath.lib.gui.panes.SelectedMeasurementTableView;
import qupath.lib.gui.panes.WorkflowCommandLogView;
import qupath.lib.images.ImageData;

class AnalysisTabPane {
    private QuPathGUI qupath;
    private static StringProperty titleProject = QuPathResources.getLocalizedResourceManager().createProperty("AnalysisPane.projectTab");
    private static StringProperty titleImage = QuPathResources.getLocalizedResourceManager().createProperty("AnalysisPane.imageTab");
    private static StringProperty titleAnnotations = QuPathResources.getLocalizedResourceManager().createProperty("AnalysisPane.annotationsTab");
    private static StringProperty titleHierarchy = QuPathResources.getLocalizedResourceManager().createProperty("AnalysisPane.hierarchyTab");
    private static StringProperty titleWorkflow = QuPathResources.getLocalizedResourceManager().createProperty("AnalysisPane.workflowTab");
    private static StringProperty titleHistory = QuPathResources.getLocalizedResourceManager().createProperty("AnalysisPane.historyTab");
    private static StringProperty titleMeasurements = QuPathResources.getLocalizedResourceManager().createProperty("AnalysisPane.measurementsTab");
    private static StringProperty titleDescription = QuPathResources.getLocalizedResourceManager().createProperty("AnalysisPane.descriptionTab");
    private static StringProperty textTabTooltip = QuPathResources.getLocalizedResourceManager().createProperty("AnalysisPane.switchText");
    private ProjectBrowser projectBrowser;
    private ImageDetailsPane imageDetailsPane;
    private AnnotationPane annotationPane;
    private PathObjectHierarchyView hierarchyPane;
    private WorkflowCommandLogView workflowLogView;
    private TabPane tabPane = new TabPane();

    AnalysisTabPane(QuPathGUI qupath) {
        this.qupath = qupath;
        this.createPanes();
        this.createAndInitializeTabPane();
        this.addTabsForPanes();
        this.makeTabsUndockable();
    }

    private void createAndInitializeTabPane() {
        this.tabPane = new TabPane();
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.tabPane.setTabDragPolicy(TabPane.TabDragPolicy.REORDER);
    }

    private void createPanes() {
        this.projectBrowser = this.createProjectBrowser();
        this.imageDetailsPane = this.createImageDetailsPane();
        this.annotationPane = this.createAnnotationPane();
        this.hierarchyPane = this.createHierarchyPane();
        this.workflowLogView = this.createWorkflowCommandLogView();
    }

    private void addTabsForPanes() {
        this.tabPane.getTabs().add((Object)AnalysisTabPane.createTab(titleProject, (Node)this.projectBrowser.getPane()));
        this.tabPane.getTabs().add((Object)AnalysisTabPane.createTab(titleImage, (Node)this.imageDetailsPane.getPane()));
        Tab tabAnnotations = AnalysisTabPane.createTab(titleAnnotations);
        SplitPane splitAnnotations = new SplitPane();
        splitAnnotations.setOrientation(Orientation.VERTICAL);
        BooleanBinding annotationTabVisible = Bindings.createBooleanBinding(() -> tabAnnotations.getTabPane() == null || tabAnnotations.isSelected(), (Observable[])new Observable[]{tabAnnotations.tabPaneProperty(), tabAnnotations.selectedProperty()});
        this.annotationPane.disableUpdatesProperty().bind((ObservableValue)annotationTabVisible.not());
        TabPane tabAnnotationsMeasurements = this.createMeasurementsAndDescriptionsPane((ObservableBooleanValue)annotationTabVisible);
        splitAnnotations.getItems().addAll((Object[])new Node[]{this.annotationPane.getPane(), tabAnnotationsMeasurements});
        tabAnnotations.setContent((Node)splitAnnotations);
        this.tabPane.getTabs().add((Object)tabAnnotations);
        Tab tabHierarchy = AnalysisTabPane.createTab(titleHierarchy);
        BooleanBinding hierarchyTabVisible = Bindings.createBooleanBinding(() -> tabHierarchy.getTabPane() == null || tabHierarchy.isSelected(), (Observable[])new Observable[]{tabHierarchy.tabPaneProperty(), tabHierarchy.selectedProperty()});
        this.hierarchyPane.disableUpdatesProperty().bind((ObservableValue)hierarchyTabVisible.not());
        TabPane tabHierarchyMeasurements = this.createMeasurementsAndDescriptionsPane((ObservableBooleanValue)hierarchyTabVisible);
        SplitPane splitHierarchy = new SplitPane();
        splitHierarchy.setOrientation(Orientation.VERTICAL);
        splitHierarchy.getItems().addAll((Object[])new Node[]{this.hierarchyPane.getPane(), tabHierarchyMeasurements});
        tabHierarchy.setContent((Node)splitHierarchy);
        this.tabPane.getTabs().add((Object)tabHierarchy);
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> {
            if (tabAnnotations.getTabPane() != null && tabHierarchy.getTabPane() != null) {
                if (o == tabHierarchy) {
                    splitHierarchy.setDividerPosition(0, splitAnnotations.getDividerPositions()[0]);
                } else if (o == tabAnnotations) {
                    splitAnnotations.setDividerPosition(0, splitHierarchy.getDividerPositions()[0]);
                }
            }
        });
        TitledPane titledLog = new TitledPane((String)titleHistory.get(), (Node)this.workflowLogView.getPane());
        titledLog.textProperty().bind((ObservableValue)titleHistory);
        titledLog.setCollapsible(false);
        titledLog.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        BorderPane pane = new BorderPane((Node)titledLog);
        this.tabPane.getTabs().add((Object)AnalysisTabPane.createTab(titleWorkflow, (Node)pane));
    }

    private void makeTabsUndockable() {
        for (Tab tab : this.tabPane.getTabs()) {
            FXUtils.makeTabUndockable((Tab)tab);
            Tooltip tooltip = new Tooltip();
            tooltip.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.format((String)textTabTooltip.get(), tab.getText()), (Observable[])new Observable[]{tab.textProperty(), textTabTooltip}));
            tab.setTooltip(tooltip);
        }
    }

    private ImageDetailsPane createImageDetailsPane() {
        return new ImageDetailsPane((ObservableValue<ImageData<BufferedImage>>)this.qupath.imageDataProperty());
    }

    private ProjectBrowser createProjectBrowser() {
        return new ProjectBrowser(this.qupath);
    }

    private AnnotationPane createAnnotationPane() {
        return new AnnotationPane(this.qupath, (ObservableValue<ImageData<BufferedImage>>)this.qupath.imageDataProperty());
    }

    private PathObjectHierarchyView createHierarchyPane() {
        return new PathObjectHierarchyView(this.qupath, (ObservableValue<ImageData<BufferedImage>>)this.qupath.imageDataProperty());
    }

    private WorkflowCommandLogView createWorkflowCommandLogView() {
        return new WorkflowCommandLogView(this.qupath);
    }

    TabPane getTabPane() {
        return this.tabPane;
    }

    ProjectBrowser getProjectBrowser() {
        return this.projectBrowser;
    }

    private static Tab createTab(StringProperty title) {
        return AnalysisTabPane.createTab(title, null);
    }

    private static Tab createTab(StringProperty title, Node content) {
        Tab tab = new Tab();
        tab.textProperty().bind((ObservableValue)title);
        if (content != null) {
            tab.setContent(content);
        }
        return tab;
    }

    private TabPane createMeasurementsAndDescriptionsPane(ObservableBooleanValue visible) {
        TabPane tabpaneObjectsShared = new TabPane();
        SelectedMeasurementTableView objectMeasurementsTable = new SelectedMeasurementTableView((ObservableValue<ImageData<BufferedImage>>)this.qupath.imageDataProperty());
        tabpaneObjectsShared.setSide(Side.BOTTOM);
        Tab tabSharedTable = AnalysisTabPane.createTab(titleMeasurements, (Node)objectMeasurementsTable.getPane());
        tabpaneObjectsShared.getTabs().add((Object)tabSharedTable);
        Pane descriptionPane = ObjectDescriptionPane.createPane(this.qupath.imageDataProperty(), true);
        Tab tabSharedDescription = AnalysisTabPane.createTab(titleDescription, (Node)descriptionPane);
        tabpaneObjectsShared.getTabs().add((Object)tabSharedDescription);
        tabpaneObjectsShared.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        if (visible != null) {
            objectMeasurementsTable.getPane().visibleProperty().bind((ObservableValue)visible);
            descriptionPane.visibleProperty().bind((ObservableValue)visible);
        }
        return tabpaneObjectsShared;
    }
}

