/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display.settings;

import java.util.Collections;
import java.util.List;
import qupath.lib.display.settings.ChannelSettings;

public class ImageDisplaySettings {
    private static String DEFAULT_NAME = "Untitled";
    private String name;
    private double gamma = 1.0;
    private boolean invertBackground = false;
    private List<ChannelSettings> channels;

    public static ImageDisplaySettings create(String name, double gamma, boolean invertBackground, List<ChannelSettings> channels) {
        ImageDisplaySettings settings = new ImageDisplaySettings();
        settings.name = name;
        settings.gamma = gamma;
        settings.invertBackground = invertBackground;
        settings.channels = channels;
        return settings;
    }

    public String getName() {
        return this.name == null ? DEFAULT_NAME : this.name;
    }

    public double getGamma() {
        return this.gamma;
    }

    public boolean invertBackground() {
        return this.invertBackground;
    }

    public List<ChannelSettings> getChannels() {
        return this.channels == null ? Collections.emptyList() : Collections.unmodifiableList(this.channels);
    }
}

