/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display.settings;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.DirectServerChannelInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.display.settings.ChannelColor;
import qupath.lib.display.settings.ChannelSettings;
import qupath.lib.display.settings.ImageDisplaySettings;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.io.GsonTools;
import qupath.lib.projects.Project;
import qupath.lib.projects.ResourceManager;

public class DisplaySettingUtils {
    private static Logger logger = LoggerFactory.getLogger(DisplaySettingUtils.class);

    public static ImageDisplaySettings displayToSettings(ImageDisplay display, String name) {
        ArrayList<ChannelSettings> channels = new ArrayList<ChannelSettings>();
        ArrayList<ChannelDisplayInfo> available = new ArrayList<ChannelDisplayInfo>((Collection<ChannelDisplayInfo>)display.availableChannels());
        HashSet<ChannelDisplayInfo> selected = new HashSet<ChannelDisplayInfo>((Collection<ChannelDisplayInfo>)display.selectedChannels());
        for (ChannelDisplayInfo channel : available) {
            channels.add(DisplaySettingUtils.asChannelSettings(channel, selected.contains(channel)));
        }
        return ImageDisplaySettings.create(name, PathPrefs.viewerGammaProperty().get(), display.useInvertedBackground(), channels);
    }

    public static boolean settingsCompatibleWithDisplay(ImageDisplay display, ImageDisplaySettings settings) {
        if (display == null || settings == null || display.availableChannels().size() != settings.getChannels().size()) {
            return false;
        }
        Set names = display.availableChannels().stream().map(ChannelDisplayInfo::getName).collect(Collectors.toSet());
        Set namesSettings = settings.getChannels().stream().map(ChannelSettings::getName).collect(Collectors.toSet());
        return names.equals(namesSettings);
    }

    public static boolean applySettingsToDisplay(ImageDisplay display, ImageDisplaySettings settings) {
        ImageServer server;
        if (settings == null || !DisplaySettingUtils.settingsCompatibleWithDisplay(display, settings)) {
            return false;
        }
        display.setUseInvertedBackground(settings.invertBackground());
        ArrayList<ChannelDisplayInfo> available = new ArrayList<ChannelDisplayInfo>((Collection<ChannelDisplayInfo>)display.availableChannels());
        ArrayList<ImageChannel> directChannels = new ArrayList<ImageChannel>();
        for (ChannelDisplayInfo channel : available) {
            ChannelSettings channelSettings = settings.getChannels().stream().filter(s -> s.getName().equals(channel.getName())).findFirst().orElse(null);
            if (channelSettings == null) continue;
            ChannelColor color = channelSettings.getColor();
            if (color != null && channel instanceof DirectServerChannelInfo) {
                DirectServerChannelInfo info = (DirectServerChannelInfo)channel;
                info.setLUTColor(color.getRed(), color.getGreen(), color.getBlue());
                directChannels.add(ImageChannel.getInstance((String)info.getOriginalChannelName(), (Integer)ColorTools.packRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue())));
            }
            display.setMinMaxDisplay(channel, channelSettings.getMinDisplay(), channelSettings.getMaxDisplay());
            display.setChannelSelected(channel, channelSettings.isShowing());
        }
        display.setUseInvertedBackground(settings.invertBackground());
        ImageData<BufferedImage> imageData = display.getImageData();
        ImageServer imageServer = server = imageData == null ? null : imageData.getServer();
        if (server != null && server.nChannels() == directChannels.size() && !directChannels.equals(server.getMetadata().getChannels())) {
            server.setMetadata(new ImageServerMetadata.Builder(server.getMetadata()).channels(directChannels).build());
        }
        return true;
    }

    private static ChannelSettings asChannelSettings(ChannelDisplayInfo info, boolean isShowing) {
        Integer rgb = info.getColor();
        return ChannelSettings.create(info.getName(), info.getMinDisplay(), info.getMaxDisplay(), rgb == null ? null : ChannelColor.fromPackedARGB(rgb), isShowing);
    }

    private static boolean isDisplaySettings(JsonElement element) {
        if (!element.isJsonObject()) {
            return false;
        }
        JsonObject obj = element.getAsJsonObject();
        return obj.has("name") && obj.get("name").isJsonPrimitive() && obj.has("channels") && obj.get("channels").isJsonArray() && obj.has("gamma") && obj.has("invertBackground");
    }

    public static Optional<ImageDisplaySettings> parseDisplaySettings(JsonElement element) {
        if (DisplaySettingUtils.isDisplaySettings(element)) {
            Gson gson = GsonTools.getInstance();
            try {
                ImageDisplaySettings settings = (ImageDisplaySettings)gson.fromJson(element, ImageDisplaySettings.class);
                return Optional.of(settings);
            }
            catch (JsonSyntaxException e) {
                logger.debug("Unable to parse display settings", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public static ImageDisplaySettings parseDisplaySettings(Path path) throws IOException {
        ImageDisplaySettings imageDisplaySettings;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                Gson gson = GsonTools.getInstance();
                imageDisplaySettings = (ImageDisplaySettings)gson.fromJson((Reader)reader, ImageDisplaySettings.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException e) {
                    throw new IOException(e);
                }
            }
            reader.close();
        }
        return imageDisplaySettings;
    }

    public static ResourceManager.Manager<ImageDisplaySettings> getResourcesForProject(Project<?> project) {
        return project.getResources("resources/display", ImageDisplaySettings.class, ".json");
    }
}

