/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display.settings;

public class ChannelColor {
    private int red;
    private int green;
    private int blue;

    public static ChannelColor fromRGB(int red, int green, int blue) throws IllegalArgumentException {
        ChannelColor color = new ChannelColor();
        color.red = ChannelColor.checkValid(red);
        color.green = ChannelColor.checkValid(green);
        color.blue = ChannelColor.checkValid(blue);
        return color;
    }

    private static int checkValid(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Value must be in the range 0 to 255");
        }
        return value;
    }

    public static ChannelColor fromPackedARGB(int argb) {
        ChannelColor color = new ChannelColor();
        color.red = argb >> 16 & 0xFF;
        color.green = argb >> 8 & 0xFF;
        color.blue = argb & 0xFF;
        return color;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }
}

