/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.awt.image.BufferedImage;
import qupath.lib.color.ColorTransformer;
import qupath.lib.common.ColorTools;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.display.RGBDirectChannelInfo;
import qupath.lib.images.ImageData;

class RGBNormalizedChannelInfo
extends RGBDirectChannelInfo {
    public RGBNormalizedChannelInfo(ImageData<BufferedImage> imageData) {
        super(imageData);
    }

    @Override
    public String getName() {
        return "Normalized OD colors";
    }

    @Override
    public int getRGB(BufferedImage img, int x, int y, ChannelDisplayMode mode) {
        return ColorTransformer.getODNormalizedColor((int)img.getRGB(x, y), (double)0.1, (float)0.0f, (float)1.0f);
    }

    @Override
    public int[] getRGB(BufferedImage img, int[] rgb, ChannelDisplayMode mode) {
        int[] buffer = RGBNormalizedChannelInfo.getRGBIntBuffer(img);
        if (buffer == null) {
            rgb = img.getRGB(0, 0, img.getWidth(), img.getHeight(), rgb, 0, img.getWidth());
            buffer = rgb;
        } else if (rgb == null) {
            rgb = new int[img.getWidth() * img.getHeight()];
        }
        float offset = this.getOffset();
        float scale = this.getScaleToByte();
        ColorTransformer.transformRGB((int[])buffer, (int[])rgb, (ColorTransformer.ColorTransformMethod)ColorTransformer.ColorTransformMethod.OD_Normalized, (float)offset, (float)scale, (boolean)false);
        if (mode.invertColors()) {
            int ind = 0;
            int white = ColorTools.WHITE & 0xFFFFFF;
            int black = ColorTools.BLACK & 0xFFFFFF;
            for (int v : rgb) {
                if (v != black && v != white) {
                    rgb[ind] = ColorTools.packRGB((int)(255 - ColorTools.red((int)v)), (int)(255 - ColorTools.green((int)v)), (int)(255 - ColorTools.blue((int)v)));
                }
                ++ind;
            }
        }
        return rgb;
    }

    @Override
    public boolean doesSomething() {
        return true;
    }

    @Override
    public boolean isAdditive() {
        return false;
    }

    @Override
    public Integer getColor() {
        return null;
    }
}

