/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.awt.image.BufferedImage;
import qupath.lib.common.ColorTools;
import qupath.lib.display.AbstractChannelInfo;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.images.ImageData;

class RGBDirectChannelInfo
extends AbstractChannelInfo {
    public RGBDirectChannelInfo(ImageData<BufferedImage> imageData) {
        super(imageData);
    }

    @Override
    public String getName() {
        return "Original";
    }

    @Override
    public String getValueAsString(BufferedImage img, int x, int y) {
        int rgb = this.getRGB(img, x, y, ChannelDisplayMode.COLOR);
        return ColorTools.red((int)rgb) + ", " + ColorTools.green((int)rgb) + ", " + ColorTools.blue((int)rgb);
    }

    @Override
    public int getRGB(BufferedImage img, int x, int y, ChannelDisplayMode mode) {
        return img.getRGB(x, y);
    }

    static int[] getRGBIntBuffer(BufferedImage img) {
        int type = img.getType();
        if (type == 1 || type == 2 || type == 3) {
            return (int[])img.getRaster().getDataElements(0, 0, img.getWidth(), img.getHeight(), null);
        }
        return null;
    }

    @Override
    public int[] getRGB(BufferedImage img, int[] rgb, ChannelDisplayMode mode) {
        int[] buffer = RGBDirectChannelInfo.getRGBIntBuffer(img);
        if (buffer == null) {
            rgb = img.getRGB(0, 0, img.getWidth(), img.getHeight(), rgb, 0, img.getWidth());
            buffer = rgb;
        }
        float offset = this.getOffset();
        float scale = this.getScaleToByte();
        return RGBDirectChannelInfo.transformRGB(buffer, rgb, mode, offset, scale);
    }

    static int[] transformRGB(int[] rgbInput, int[] rgbOutput, ChannelDisplayMode mode, float offset, float scale) {
        boolean doGrayscale;
        if (rgbOutput == null || rgbOutput.length < rgbInput.length) {
            rgbOutput = new int[rgbInput.length];
        }
        boolean doInvert = mode == ChannelDisplayMode.INVERTED_COLOR || mode == ChannelDisplayMode.INVERTED_GRAYSCALE;
        boolean bl = doGrayscale = mode == ChannelDisplayMode.GRAYSCALE || mode == ChannelDisplayMode.INVERTED_GRAYSCALE;
        if (offset != 0.0f || scale != 1.0f || doInvert || doGrayscale) {
            int ind = 0;
            for (int v : rgbInput) {
                if (doGrayscale) {
                    double r = ((float)ColorTools.red((int)v) - offset) * scale;
                    double g = ((float)ColorTools.green((int)v) - offset) * scale;
                    b = ((float)ColorTools.blue((int)v) - offset) * scale;
                    int value = ColorTools.do8BitRangeCheck((double)(0.299 * r + 0.587 * g + 0.114 * b));
                    rgbOutput[ind] = ColorTools.packRGB((int)value, (int)value, (int)value);
                } else if (doInvert) {
                    double r = ((float)ColorTools.red((int)v) - offset) * scale;
                    double g = ((float)ColorTools.green((int)v) - offset) * scale;
                    b = ((float)ColorTools.blue((int)v) - offset) * scale;
                    int r2 = ColorTools.do8BitRangeCheck((double)((g + b) / 2.0));
                    int g2 = ColorTools.do8BitRangeCheck((double)((r + b) / 2.0));
                    int b2 = ColorTools.do8BitRangeCheck((double)((r + g) / 2.0));
                    rgbOutput[ind] = (r2 << 16) + (g2 << 8) + b2;
                } else {
                    int r = ColorTools.do8BitRangeCheck((float)(((float)ColorTools.red((int)v) - offset) * scale));
                    int g = ColorTools.do8BitRangeCheck((float)(((float)ColorTools.green((int)v) - offset) * scale));
                    int b = ColorTools.do8BitRangeCheck((float)(((float)ColorTools.blue((int)v) - offset) * scale));
                    rgbOutput[ind] = (r << 16) + (g << 8) + b;
                }
                ++ind;
            }
        } else if (rgbInput != rgbOutput) {
            System.arraycopy(rgbInput, 0, rgbOutput, 0, rgbOutput.length);
        }
        return rgbOutput;
    }

    @Override
    public void updateRGBAdditive(BufferedImage img, int[] rgb, ChannelDisplayMode mode) {
        throw new UnsupportedOperationException(String.valueOf(this) + " does not support additive display");
    }

    @Override
    public boolean doesSomething() {
        return this.isBrightnessContrastRescaled();
    }

    @Override
    public boolean isAdditive() {
        return false;
    }

    @Override
    public Integer getColor() {
        return null;
    }
}

