/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import qupath.lib.color.ColorTransformer;
import qupath.lib.common.ColorTools;
import qupath.lib.display.AbstractSingleChannelInfo;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.display.RGBDirectChannelInfo;
import qupath.lib.images.ImageData;

class RBGColorTransformInfo
extends AbstractSingleChannelInfo {
    private ColorTransformer.ColorTransformMethod method;
    private transient ColorModel colorModel;
    private transient ColorModel colorModelInverted = null;
    private boolean isMutable;
    private transient Integer color = null;

    public RBGColorTransformInfo(ImageData<BufferedImage> imageData, ColorTransformer.ColorTransformMethod method, boolean isMutable) {
        super(imageData);
        this.method = method;
        this.isMutable = isMutable;
        this.setMinMaxAllowed(0.0f, ColorTransformer.getDefaultTransformedMax((ColorTransformer.ColorTransformMethod)method));
        this.setMinDisplay(0.0f);
        this.setMaxDisplay(this.getMaxAllowed());
        this.colorModel = ColorTransformer.getDefaultColorModel((ColorTransformer.ColorTransformMethod)method);
        if (this.colorModel != null) {
            this.color = this.colorModel.getRGB(255);
        }
        if (this.colorModel instanceof IndexColorModel) {
            this.colorModelInverted = RBGColorTransformInfo.invertColorModel((IndexColorModel)this.colorModel);
        }
    }

    private static IndexColorModel invertColorModel(IndexColorModel cm) {
        int n = cm.getMapSize();
        int bits = cm.getPixelSize();
        if (bits > 8) {
            throw new IllegalArgumentException("Unable to invert color model with " + bits + " bits per pixel");
        }
        byte[] rbi = new byte[n];
        byte[] gbi = new byte[n];
        byte[] bbi = new byte[n];
        for (int i = 0; i < n; ++i) {
            int r = cm.getRed(i);
            int g = cm.getGreen(i);
            int b = cm.getBlue(i);
            rbi[i] = (byte)ColorTools.do8BitRangeCheck((double)((double)(255 - r) / 255.0 * (double)i));
            gbi[i] = (byte)ColorTools.do8BitRangeCheck((double)((double)(255 - g) / 255.0 * (double)i));
            bbi[i] = (byte)ColorTools.do8BitRangeCheck((double)((double)(255 - b) / 255.0 * (double)i));
        }
        return new IndexColorModel(bits, n, rbi, gbi, bbi);
    }

    @Override
    public String getName() {
        return this.method.toString();
    }

    @Override
    public float getValue(BufferedImage img, int x, int y) {
        int rgb = img.getRGB(x, y);
        return ColorTransformer.getPixelValue((int)rgb, (ColorTransformer.ColorTransformMethod)this.method);
    }

    @Override
    public synchronized float[] getValues(BufferedImage img, int x, int y, int w, int h, float[] array) {
        int[] buffer = RGBDirectChannelInfo.getRGBIntBuffer(img);
        if (buffer == null) {
            buffer = img.getRGB(x, y, w, h, buffer, 0, w);
        }
        return ColorTransformer.getSimpleTransformedPixels((int[])buffer, (ColorTransformer.ColorTransformMethod)this.method, (float[])array);
    }

    @Override
    protected ColorModel getColorModel(ChannelDisplayMode mode) {
        switch (mode) {
            case INVERTED_GRAYSCALE: 
            case GRAYSCALE: {
                return CM_GRAYSCALE;
            }
            case INVERTED_COLOR: {
                return this.colorModelInverted;
            }
        }
        return this.colorModel;
    }

    @Override
    public boolean doesSomething() {
        return true;
    }

    @Override
    public boolean isAdditive() {
        switch (this.method) {
            case Red: 
            case Green: 
            case Blue: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Integer getColor() {
        return this.color;
    }

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public ColorTransformer.ColorTransformMethod getMethod() {
        return this.method;
    }
}

