/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.util.Objects;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.DirectServerChannelInfo;

class JsonHelperChannelInfo {
    private String name;
    private Class<?> cls;
    private Float minDisplay;
    private Float maxDisplay;
    private Integer color;
    private Boolean selected;

    JsonHelperChannelInfo() {
    }

    boolean matches(ChannelDisplayInfo info) {
        if (this.name == null) {
            return false;
        }
        return this.name.equals(info.getName()) && (this.cls == null || this.cls.equals(info.getClass()));
    }

    boolean isSelected() {
        return this.selected != null && this.selected != false;
    }

    boolean updateInfo(ChannelDisplayInfo info) {
        DirectServerChannelInfo directInfo;
        if (!this.matches(info)) {
            return false;
        }
        boolean changes = false;
        if (info instanceof ChannelDisplayInfo.ModifiableChannelDisplayInfo) {
            ChannelDisplayInfo.ModifiableChannelDisplayInfo modifiableInfo = (ChannelDisplayInfo.ModifiableChannelDisplayInfo)info;
            if (this.minDisplay != null && this.minDisplay.floatValue() != modifiableInfo.getMinDisplay()) {
                modifiableInfo.setMinDisplay(this.minDisplay.floatValue());
                changes = true;
            }
            if (this.maxDisplay != null && this.maxDisplay.floatValue() != modifiableInfo.getMaxDisplay()) {
                modifiableInfo.setMaxDisplay(this.maxDisplay.floatValue());
                changes = true;
            }
        }
        if (this.color != null && info instanceof DirectServerChannelInfo && !Objects.equals(this.color, (directInfo = (DirectServerChannelInfo)info).getColor())) {
            directInfo.setLUTColor(this.color);
            changes = true;
        }
        return changes;
    }
}

