/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.stats.Histogram;
import qupath.lib.common.ColorTools;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.display.ChannelManager;
import qupath.lib.display.DirectServerChannelInfo;
import qupath.lib.display.HistogramManager;
import qupath.lib.display.JsonHelperChannelInfo;
import qupath.lib.display.RGBDirectChannelInfo;
import qupath.lib.gui.images.stores.AbstractImageRenderer;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServerProvider;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class ImageDisplay
extends AbstractImageRenderer {
    private static final Logger logger = LoggerFactory.getLogger(ImageDisplay.class);
    private static final String PROPERTY_DISPLAY = ImageDisplay.class.getName();
    private final BooleanProperty useGrayscaleLuts = new SimpleBooleanProperty();
    private final BooleanProperty useInvertedBackground = new SimpleBooleanProperty(false);
    private ImageData<BufferedImage> imageData;
    private ChannelManager channelManager = null;
    private final ObservableList<ChannelDisplayInfo> availableChannels = FXCollections.observableArrayList();
    private final ObservableList<ChannelDisplayInfo> availableChannelsReadOnly = FXCollections.unmodifiableObservableList(this.availableChannels);
    private final ObservableList<ChannelDisplayInfo> selectedChannels = FXCollections.observableArrayList();
    private final ObservableList<ChannelDisplayInfo> selectedChannelsReadOnly = FXCollections.unmodifiableObservableList(this.selectedChannels);
    private ChannelDisplayInfo lastSelectedChannel = null;
    private final AtomicLong eventCount = new AtomicLong(0L);
    private final LongProperty eventCountProperty = new SimpleLongProperty(this.eventCount.get());
    private final ObjectBinding<ChannelDisplayMode> displayMode = Bindings.createObjectBinding(this::calculateDisplayMode, (Observable[])new Observable[]{this.useGrayscaleLutProperty(), this.useInvertedBackgroundProperty()});
    private static final Map<String, HistogramManager> cachedHistograms = Collections.synchronizedMap(new HashMap());
    private HistogramManager histogramManager = null;
    private static final Comparator<RegionRequest> regionComparator = Comparator.comparing(RegionRequest::getPath).thenComparingInt(ImageRegion::getZ).thenComparingInt(ImageRegion::getT).thenComparingInt(ImageRegion::getX).thenComparingInt(ImageRegion::getY).thenComparingInt(ImageRegion::getWidth).thenComparingInt(ImageRegion::getHeight).thenComparingDouble(RegionRequest::getDownsample);
    private Map<RegionRequest, BufferedImage> imagesForHistograms = new TreeMap<RegionRequest, BufferedImage>(regionComparator);
    private static final BooleanProperty showAllRGBTransforms = PathPrefs.createPersistentPreference("showAllRGBTransforms", true);
    private final transient Set<String> beforeGrayscaleChannels = new HashSet<String>();
    private final transient ObjectProperty<ChannelDisplayInfo> switchToGrayscaleChannel = new SimpleObjectProperty();
    private boolean settingImageData = false;

    public static ImageDisplay create(ImageData<BufferedImage> imageData) throws IOException {
        ImageDisplay display = new ImageDisplay();
        if (imageData != null) {
            display.setImageData(imageData, false);
        }
        return display;
    }

    public ImageDisplay() {
        this.useGrayscaleLuts.addListener(this::handleUseGrayscaleLutsChange);
        this.useInvertedBackground.addListener(this::handleInvertedBackgroundChange);
        this.selectedChannels.addListener(this::handleSelectedChannelsChange);
    }

    private void handleInvertedBackgroundChange(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        this.saveChannelColorProperties();
    }

    private void handleSelectedChannelsChange(ListChangeListener.Change<? extends ChannelDisplayInfo> change) {
        if (change.getList().contains(null)) {
            logger.warn("Null channel selected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageData(ImageData<BufferedImage> imageData, boolean retainDisplaySettings) throws IOException {
        if (this.imageData == imageData) {
            return;
        }
        this.settingImageData = true;
        try {
            if (retainDisplaySettings && this.imageData != null && imageData != null) {
                ImageServer lastServer = this.imageData.getServer();
                ImageServer nextServer = imageData.getServer();
                boolean bl = retainDisplaySettings = lastServer.nChannels() == nextServer.nChannels() && lastServer.getPixelType() == nextServer.getPixelType();
                if (retainDisplaySettings) {
                    for (int c = 0; c < lastServer.nChannels(); ++c) {
                        if (lastServer.getChannel(c).getName().equals(nextServer.getChannel(c).getName())) continue;
                        retainDisplaySettings = false;
                    }
                }
            }
            String lastDisplayJSON = retainDisplaySettings ? this.toJSON() : null;
            this.imageData = imageData;
            this.imagesForHistograms = imageData == null ? Collections.emptyMap() : this.getImagesForHistogram((ImageServer<BufferedImage>)imageData.getServer());
            this.channelManager = imageData != null ? new ChannelManager(imageData) : null;
            this.updateChannelOptions(true);
            this.updateHistogramMap();
            if (imageData != null) {
                this.loadChannelColorProperties();
                if (lastDisplayJSON != null && !lastDisplayJSON.isEmpty()) {
                    this.updateFromJSON(lastDisplayJSON);
                }
            }
        }
        finally {
            this.settingImageData = false;
            this.incrementEventCount();
        }
    }

    private void incrementEventCount() {
        this.eventCountProperty.set(this.eventCount.incrementAndGet());
    }

    public ImageData<BufferedImage> getImageData() {
        return this.imageData;
    }

    public BooleanProperty useGrayscaleLutProperty() {
        return this.useGrayscaleLuts;
    }

    public boolean useGrayscaleLuts() {
        return this.useGrayscaleLuts.get();
    }

    public void setUseGrayscaleLuts(boolean useGrayscaleLuts) {
        this.useGrayscaleLuts.set(useGrayscaleLuts);
    }

    private void handleUseGrayscaleLutsChange(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            this.selectedChannels.stream().map(ChannelDisplayInfo::getName).forEach(this.beforeGrayscaleChannels::add);
            ChannelDisplayInfo switchToGrayscale = (ChannelDisplayInfo)this.switchToGrayscaleChannel.get();
            if (switchToGrayscale != null) {
                if (!this.availableChannelsReadOnly.contains((Object)switchToGrayscale)) {
                    String switchToGrayscaleChannelName = switchToGrayscale.getName();
                    switchToGrayscale = this.availableChannelsReadOnly.stream().filter(c -> Objects.equals(c.getName(), switchToGrayscaleChannelName)).findFirst().orElse(null);
                }
                if (switchToGrayscale != null) {
                    this.setChannelSelected(switchToGrayscale, true);
                }
            }
            if (this.lastSelectedChannel != null) {
                this.setChannelSelected(this.lastSelectedChannel, true);
            } else if (!this.selectedChannels.isEmpty()) {
                this.setChannelSelected((ChannelDisplayInfo)this.selectedChannels.getFirst(), true);
            } else if (!this.availableChannelsReadOnly.isEmpty()) {
                this.setChannelSelected((ChannelDisplayInfo)this.availableChannelsReadOnly.getFirst(), true);
            }
        } else {
            List<ChannelDisplayInfo> channelsToSelect;
            if (!this.beforeGrayscaleChannels.isEmpty() && !(channelsToSelect = this.availableChannels().stream().filter(c -> this.beforeGrayscaleChannels.contains(c.getName())).toList()).isEmpty()) {
                this.selectedChannels.setAll(channelsToSelect);
            }
            this.beforeGrayscaleChannels.clear();
        }
        this.saveChannelColorProperties();
    }

    public BooleanProperty useInvertedBackgroundProperty() {
        return this.useInvertedBackground;
    }

    public boolean useInvertedBackground() {
        return this.useInvertedBackground.get();
    }

    public ObjectBinding<ChannelDisplayMode> displayMode() {
        return this.displayMode;
    }

    private ChannelDisplayMode calculateDisplayMode() {
        if (this.useGrayscaleLuts()) {
            if (this.useInvertedBackground()) {
                return ChannelDisplayMode.INVERTED_GRAYSCALE;
            }
            return ChannelDisplayMode.GRAYSCALE;
        }
        if (this.useInvertedBackground()) {
            return ChannelDisplayMode.INVERTED_COLOR;
        }
        return ChannelDisplayMode.COLOR;
    }

    public void setUseInvertedBackground(boolean useInvertedBackground) {
        this.useInvertedBackground.set(useInvertedBackground);
    }

    public boolean useColorLUTs() {
        return !this.useGrayscaleLuts();
    }

    @Override
    public long getLastChangeTimestamp() {
        return this.eventCountProperty.get();
    }

    public LongProperty eventCountProperty() {
        return this.eventCountProperty;
    }

    public void refreshChannelOptions() {
        this.updateChannelOptions(false);
    }

    public ObjectProperty<ChannelDisplayInfo> switchToGrayscaleChannelProperty() {
        return this.switchToGrayscaleChannel;
    }

    public void setSwitchToGrayscaleChannel(ChannelDisplayInfo channel) {
        this.switchToGrayscaleChannel.set((Object)channel);
    }

    public ChannelDisplayInfo getSwitchToGrayscaleChannel() {
        return (ChannelDisplayInfo)this.switchToGrayscaleChannel.get();
    }

    private void updateChannelOptions(boolean serverChanged) {
        ChannelDisplayInfo switchToGrayscale;
        ImageServerMetadata metadata;
        logger.trace("Updating channel options (serverChanged={})", (Object)serverChanged);
        ImageServerMetadata imageServerMetadata = metadata = this.imageData == null ? null : this.imageData.getServerMetadata();
        if (metadata == null || this.channelManager == null) {
            this.selectedChannels.clear();
            this.availableChannels.clear();
            if (!this.switchToGrayscaleChannel.isBound()) {
                this.switchToGrayscaleChannel.set(null);
            }
            return;
        }
        List<ChannelDisplayInfo> tempChannelOptions = this.channelManager.getAvailableChannels(showAllRGBTransforms.get());
        ArrayList<ChannelDisplayInfo> tempSelectedChannels = this.selectedChannels.stream().filter(tempChannelOptions::contains).collect(Collectors.toCollection(ArrayList::new));
        if (serverChanged || tempSelectedChannels.isEmpty()) {
            tempSelectedChannels = new ArrayList<ChannelDisplayInfo>();
            if (tempChannelOptions.getFirst() instanceof RGBDirectChannelInfo || !this.useColorLUTs()) {
                tempSelectedChannels.add(tempChannelOptions.getFirst());
            } else if (this.useColorLUTs()) {
                tempSelectedChannels.addAll(tempChannelOptions.stream().filter(c -> c instanceof DirectServerChannelInfo).toList());
            }
        }
        if (!this.availableChannels.equals(tempChannelOptions)) {
            this.availableChannels.setAll(tempChannelOptions);
        }
        if (!this.selectedChannels.equals(tempSelectedChannels)) {
            this.selectedChannels.setAll(tempSelectedChannels);
        }
        this.ensureChannelColorsUpdated(this.imageData.getServerMetadata());
        if (!this.switchToGrayscaleChannel.isBound() && (switchToGrayscale = (ChannelDisplayInfo)this.switchToGrayscaleChannel.get()) != null && !this.availableChannels.contains((Object)switchToGrayscale)) {
            this.switchToGrayscaleChannel.set((Object)this.availableChannels.stream().filter(c -> Objects.equals(c.getName(), switchToGrayscale.getName())).findFirst().orElse(null));
        }
    }

    private void ensureChannelColorsUpdated(ImageServerMetadata metadata) {
        boolean colorsUpdated = false;
        for (ChannelDisplayInfo option : this.availableChannels) {
            if (!(option instanceof DirectServerChannelInfo)) continue;
            DirectServerChannelInfo directChannel = (DirectServerChannelInfo)option;
            ImageChannel channel = metadata.getChannel(directChannel.getChannel());
            if (Objects.equals(option.getColor(), channel.getColor())) continue;
            directChannel.setLUTColor(channel.getColor());
            colorsUpdated = true;
        }
        if (colorsUpdated) {
            this.saveChannelColorProperties();
        }
    }

    private boolean loadChannelColorProperties() {
        if (this.imageData == null) {
            return false;
        }
        Object property = this.imageData.getProperty(PROPERTY_DISPLAY);
        if (property instanceof String) {
            String json = (String)property;
            try {
                this.updateFromJSON(json);
                return true;
            }
            catch (Exception e) {
                logger.warn("Unable to parse display settings from {}", property);
            }
        }
        int n = 0;
        for (ChannelDisplayInfo info : this.availableChannels) {
            Integer colorInt;
            if (!(info instanceof DirectServerChannelInfo)) continue;
            DirectServerChannelInfo multiInfo = (DirectServerChannelInfo)info;
            Integer colorOld = multiInfo.getColor();
            Object colorNew = this.imageData.getProperty("COLOR_CHANNEL:" + info.getName());
            if (!(colorNew instanceof Integer) || !(colorInt = (Integer)colorNew).equals(colorOld)) continue;
            multiInfo.setLUTColor(colorInt);
            ++n;
        }
        if (n == 1) {
            logger.info("Loaded color channel info for one channel");
        } else if (n > 1) {
            logger.info("Loaded color channel info for {} channels", (Object)n);
        }
        return n > 0;
    }

    public void setMinMaxDisplay(ChannelDisplayInfo info, float minDisplay, float maxDisplay) {
        this.setMinMaxDisplay(info, minDisplay, maxDisplay, true);
    }

    private void setMinMaxDisplay(ChannelDisplayInfo info, float minDisplay, float maxDisplay, boolean fireUpdate) {
        if (info instanceof ChannelDisplayInfo.ModifiableChannelDisplayInfo) {
            ChannelDisplayInfo.ModifiableChannelDisplayInfo modifiableInfo = (ChannelDisplayInfo.ModifiableChannelDisplayInfo)info;
            if (modifiableInfo.getMinDisplay() == minDisplay && modifiableInfo.getMaxDisplay() == maxDisplay) {
                return;
            }
            modifiableInfo.setMinDisplay(minDisplay);
            modifiableInfo.setMaxDisplay(maxDisplay);
        }
        if (fireUpdate && this.availableChannels.contains((Object)info)) {
            this.saveChannelColorProperties();
        }
    }

    public void saveChannelColorProperties() {
        if (this.settingImageData) {
            return;
        }
        if (this.imageData == null) {
            logger.warn("Cannot save color channel properties - no ImageData available");
            return;
        }
        this.imageData.setProperty(PROPERTY_DISPLAY, (Object)this.toJSON(false));
        this.incrementEventCount();
    }

    public ObservableList<ChannelDisplayInfo> selectedChannels() {
        return this.selectedChannelsReadOnly;
    }

    public ObservableList<ChannelDisplayInfo> availableChannels() {
        return this.availableChannelsReadOnly;
    }

    public void setChannelSelected(ChannelDisplayInfo channel, boolean selected) {
        ArrayList<ChannelDisplayInfo> tempSelectedChannels = new ArrayList<ChannelDisplayInfo>((Collection<ChannelDisplayInfo>)this.selectedChannels);
        if (selected) {
            if (!this.useColorLUTs() || !channel.isAdditive() || !tempSelectedChannels.isEmpty() && !((ChannelDisplayInfo)tempSelectedChannels.getFirst()).isAdditive()) {
                tempSelectedChannels.clear();
            }
            if (!tempSelectedChannels.contains(channel)) {
                tempSelectedChannels.add(channel);
            }
            this.lastSelectedChannel = channel;
        } else {
            tempSelectedChannels.remove(channel);
            this.lastSelectedChannel = null;
        }
        if (tempSelectedChannels.isEmpty() && this.imageData.isBrightfield()) {
            channel = (ChannelDisplayInfo)this.availableChannels.getFirst();
            tempSelectedChannels.add(channel);
            this.lastSelectedChannel = channel;
        }
        if (this.lastSelectedChannel == null && !tempSelectedChannels.isEmpty()) {
            this.lastSelectedChannel = (ChannelDisplayInfo)tempSelectedChannels.getFirst();
        }
        this.selectedChannels.setAll(tempSelectedChannels);
        this.saveChannelColorProperties();
    }

    @Override
    public BufferedImage applyTransforms(BufferedImage imgInput, BufferedImage imgOutput) {
        return ImageDisplay.applyTransforms(imgInput, imgOutput, this.selectedChannels, (ChannelDisplayMode)((Object)this.displayMode().getValue()));
    }

    public static BufferedImage applyTransforms(BufferedImage imgInput, BufferedImage imgOutput, List<? extends ChannelDisplayInfo> selectedChannels, ChannelDisplayMode mode) {
        boolean isGrayscale;
        int width = imgInput.getWidth();
        int height = imgInput.getHeight();
        if (imgOutput == null || imgOutput.getWidth() != width || imgOutput.getHeight() != height) {
            imgOutput = new BufferedImage(width, height, 1);
        }
        if (mode == null) {
            mode = ChannelDisplayMode.COLOR;
        }
        boolean invertBackground = mode.invertColors();
        boolean bl = isGrayscale = mode == ChannelDisplayMode.GRAYSCALE || mode == ChannelDisplayMode.INVERTED_GRAYSCALE;
        if (!(selectedChannels.size() != 1 || selectedChannels.getFirst() != null && selectedChannels.getFirst().doesSomething() || invertBackground || isGrayscale)) {
            if (imgInput == imgOutput) {
                return imgOutput;
            }
            Graphics2D g2d = imgOutput.createGraphics();
            g2d.drawImage((Image)imgInput, 0, 0, null);
            g2d.dispose();
            return imgOutput;
        }
        boolean firstChannel = true;
        int[] pixels = selectedChannels.size() <= 1 ? null : new int[imgInput.getWidth() * imgInput.getHeight()];
        try {
            for (ChannelDisplayInfo info : (ChannelDisplayInfo[])selectedChannels.toArray(ChannelDisplayInfo[]::new)) {
                if (firstChannel) {
                    pixels = info.getRGB(imgInput, pixels, mode);
                    firstChannel = false;
                    continue;
                }
                info.updateRGBAdditive(imgInput, pixels, mode);
            }
        }
        catch (Exception e) {
            logger.error("Error extracting pixels for display", (Throwable)e);
        }
        if (pixels == null) {
            pixels = new int[imgOutput.getWidth() * imgOutput.getHeight()];
        }
        if (mode.invertColors()) {
            ImageDisplay.invertRGB(pixels);
        }
        imgOutput.getRaster().setDataElements(0, 0, imgOutput.getWidth(), imgOutput.getHeight(), pixels);
        return imgOutput;
    }

    private static void invertRGB(int[] pixels) {
        for (int i = 0; i < pixels.length; ++i) {
            int val = pixels[i];
            int r = ColorTools.red((int)val);
            int g = ColorTools.green((int)val);
            int b = ColorTools.blue((int)val);
            pixels[i] = ColorTools.packRGB((int)(255 - r), (int)(255 - g), (int)(255 - b));
        }
    }

    public String getTransformedValueAsString(BufferedImage img, int x, int y) {
        if (this.selectedChannels.isEmpty() || this.selectedChannels.getFirst() == null) {
            return "";
        }
        if (this.selectedChannels.size() == 1) {
            return ((ChannelDisplayInfo)this.selectedChannels.getFirst()).getValueAsString(img, x, y);
        }
        return this.availableChannels.stream().filter(arg_0 -> this.selectedChannels.contains(arg_0)).map(c -> c.getValueAsString(img, x, y)).collect(Collectors.joining(","));
    }

    private void updateHistogramMap() {
        ImageServer server;
        ImageServer imageServer = server = this.imageData == null ? null : this.imageData.getServer();
        if (server == null) {
            this.histogramManager = null;
            return;
        }
        this.histogramManager = cachedHistograms.get(server.getPath());
        if (this.histogramManager == null) {
            this.histogramManager = new HistogramManager();
            this.histogramManager.updateChannels((ImageServer<BufferedImage>)server, (Collection<? extends ChannelDisplayInfo>)this.availableChannels, this.getImagesForHistograms());
            if (server.getPixelType() == PixelType.UINT8) {
                this.availableChannels.parallelStream().filter(c -> !(c instanceof DirectServerChannelInfo)).forEach(this::autoSetDisplayRangeWithoutUpdate);
                if (!server.isRGB()) {
                    this.availableChannels.parallelStream().filter(c -> c instanceof DirectServerChannelInfo).forEach(c -> this.autoSetDisplayRange((ChannelDisplayInfo)c, 0.0));
                }
            } else {
                this.availableChannels.parallelStream().forEach(this::autoSetDisplayRangeWithoutUpdate);
            }
            cachedHistograms.put(server.getPath(), this.histogramManager);
        } else {
            this.availableChannels.parallelStream().forEach(this::autoSetDisplayRangeWithoutUpdate);
        }
    }

    private Map<RegionRequest, BufferedImage> getImagesForHistogram(ImageServer<BufferedImage> server) throws IOException {
        if (server == null) {
            return Collections.emptyMap();
        }
        TreeMap<RegionRequest, BufferedImage> map = new TreeMap<RegionRequest, BufferedImage>(regionComparator);
        double downsample = server.getDownsampleForResolution(server.nResolutions() - 1);
        RegionRequest request = RegionRequest.createInstance((String)server.getPath(), (double)downsample, (int)0, (int)0, (int)server.getWidth(), (int)server.getHeight(), (int)(server.nZSlices() / 2), (int)(server.nTimepoints() / 2));
        map.put(request, (BufferedImage)server.readRegion(request));
        return map;
    }

    private void autoSetDisplayRange(ChannelDisplayInfo info, Histogram histogram, double saturation, boolean fireUpdate) {
        double countMax;
        if (histogram == null) {
            if (!(info instanceof RGBDirectChannelInfo)) {
                logger.warn("Cannot set display range for {} - no histogram found", (Object)info);
            }
            return;
        }
        if (saturation <= 0.0 || saturation >= 1.0) {
            this.setMinMaxDisplay(info, (float)histogram.getEdgeMin(), (float)histogram.getEdgeMax());
            return;
        }
        long countSum = histogram.getCountSum();
        int nBins = histogram.nBins();
        int ind = 0;
        if (nBins > 2) {
            long lastCount;
            long firstCount = histogram.getCountsForBin(0);
            if (firstCount > histogram.getCountsForBin(1)) {
                countSum -= histogram.getCountsForBin(0);
                ind = 1;
            }
            if ((lastCount = histogram.getCountsForBin(nBins - 1)) > histogram.getCountsForBin(nBins - 2)) {
                countSum -= lastCount;
                --nBins;
            }
        }
        double count = countMax = (double)countSum * saturation;
        double minDisplay = histogram.getEdgeMin();
        while (ind < histogram.nBins()) {
            double nextCount = histogram.getCountsForBin(ind);
            if (count < nextCount) {
                minDisplay = histogram.getBinLeftEdge(ind) + count / nextCount * histogram.getBinWidth(ind);
                break;
            }
            count -= nextCount;
            ++ind;
        }
        count = countMax;
        double maxDisplay = histogram.getEdgeMax();
        for (ind = histogram.nBins() - 1; ind >= 0; --ind) {
            double nextCount = histogram.getCountsForBin(ind);
            if (count < nextCount) {
                maxDisplay = histogram.getBinRightEdge(ind) - count / nextCount * histogram.getBinWidth(ind);
                break;
            }
            count -= nextCount;
        }
        logger.debug(String.format("Display range for {}: %.3f - %.3f (saturation %.3f)", minDisplay, maxDisplay, saturation), (Object)info.getName());
        this.setMinMaxDisplay(info, (float)minDisplay, (float)maxDisplay, fireUpdate);
    }

    private static double getDefaultSaturationProportion() {
        return PathPrefs.autoBrightnessContrastSaturationPercentProperty().get() / 100.0;
    }

    private void autoSetDisplayRangeWithoutUpdate(ChannelDisplayInfo info) {
        this.autoSetDisplayRange(info, this.getHistogram(info), ImageDisplay.getDefaultSaturationProportion(), false);
    }

    public void autoSetDisplayRange(ChannelDisplayInfo info) {
        this.autoSetDisplayRange(info, this.getHistogram(info), ImageDisplay.getDefaultSaturationProportion(), true);
    }

    public void autoSetDisplayRange(ChannelDisplayInfo info, double saturation) {
        this.autoSetDisplayRange(info, this.getHistogram(info), saturation, true);
    }

    private ImageServer<BufferedImage> getServer() {
        return this.imageData == null ? null : this.imageData.getServer();
    }

    public Histogram getHistogram(ChannelDisplayInfo channel) {
        if (channel == null || this.histogramManager == null) {
            return null;
        }
        return this.histogramManager.getHistogram(this.getServer(), channel, this.getImagesForHistograms());
    }

    private Map<RegionRequest, BufferedImage> getImagesForHistograms() {
        ImageServer<BufferedImage> server = this.getServer();
        if (server == null || server.nZSlices() * server.nTimepoints() == this.imagesForHistograms.size()) {
            return this.imagesForHistograms;
        }
        TreeMap<RegionRequest, BufferedImage> images = new TreeMap<RegionRequest, BufferedImage>(regionComparator);
        int level = server.nResolutions() - 1;
        long nPixelsCached = 0L;
        for (TileRequest tile : server.getTileRequestManager().getTileRequestsForLevel(level)) {
            BufferedImage img = (BufferedImage)server.getCachedTile(tile);
            if (img == null) continue;
            nPixelsCached += (long)img.getWidth() * (long)img.getHeight();
            images.put(tile.getRegionRequest(), img);
        }
        if (images.isEmpty()) {
            double downsample = server.getDownsampleForResolution(server.nResolutions() - 1);
            Map cache = ImageServerProvider.getCache(BufferedImage.class);
            cache.entrySet().stream().filter(e -> ((RegionRequest)e.getKey()).getPath().equals(server.getPath()) && ((RegionRequest)e.getKey()).getDownsample() == downsample).forEach(e -> images.put((RegionRequest)e.getKey(), (BufferedImage)e.getValue()));
        }
        long nPixelsBackup = 0L;
        for (BufferedImage img : this.imagesForHistograms.values()) {
            nPixelsBackup += (long)img.getWidth() * (long)img.getHeight();
        }
        return nPixelsBackup >= nPixelsCached ? this.imagesForHistograms : images;
    }

    private String toJSON() {
        return this.toJSON(false);
    }

    public String toJSON(boolean prettyPrint) {
        if (this.imageData == null) {
            return null;
        }
        JsonArray array = new JsonArray();
        for (ChannelDisplayInfo info : this.availableChannels) {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", info.getName());
            obj.addProperty("class", info.getClass().getName());
            obj.addProperty("minDisplay", (Number)Float.valueOf(info.getMinDisplay()));
            obj.addProperty("maxDisplay", (Number)Float.valueOf(info.getMaxDisplay()));
            obj.addProperty("color", (Number)info.getColor());
            obj.addProperty("selected", Boolean.valueOf(this.selectedChannels.contains((Object)info)));
            array.add((JsonElement)obj);
        }
        if (prettyPrint) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson((JsonElement)array);
        }
        return array.toString();
    }

    public boolean isCompatible(ImageDisplay display) {
        ObservableList<ChannelDisplayInfo> available = this.availableChannels();
        ObservableList<ChannelDisplayInfo> other = display.availableChannels();
        if (available.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < available.size(); ++i) {
            if (!Objects.equals(((ChannelDisplayInfo)available.get(i)).getClass(), ((ChannelDisplayInfo)other.get(i)).getClass())) {
                return false;
            }
            if (Objects.equals(((ChannelDisplayInfo)available.get(i)).getName(), ((ChannelDisplayInfo)other.get(i)).getName())) continue;
            return false;
        }
        return true;
    }

    public boolean updateFromDisplay(ImageDisplay display) {
        if (this == display) {
            return false;
        }
        if (this.isCompatible(display)) {
            this.useGrayscaleLuts.set(display.useGrayscaleLuts());
            this.useInvertedBackground.set(display.useInvertedBackground());
            if (this.updateFromJSON(display.toJSON())) {
                this.saveChannelColorProperties();
            }
            return true;
        }
        return false;
    }

    private boolean updateFromJSON(String json) {
        Gson gson = new Gson();
        Type type = new TypeToken<List<JsonHelperChannelInfo>>(this){}.getType();
        List helperList = (List)gson.fromJson(json, type);
        ArrayList<ChannelDisplayInfo> newSelectedChannels = new ArrayList<ChannelDisplayInfo>();
        boolean changes = false;
        for (JsonHelperChannelInfo helper : helperList) {
            for (ChannelDisplayInfo info : this.availableChannels) {
                if (!helper.matches(info)) continue;
                if (helper.updateInfo(info)) {
                    changes = true;
                }
                if (!helper.isSelected()) continue;
                newSelectedChannels.add(info);
            }
        }
        if (!newSelectedChannels.equals(this.selectedChannels)) {
            this.selectedChannels.setAll(newSelectedChannels);
            changes = true;
        }
        return changes;
    }
}

