/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.stats.ArrayWrappers;
import qupath.lib.analysis.stats.Histogram;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.SingleChannelDisplayInfo;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.regions.RegionRequest;

class HistogramManager {
    private static final Logger logger = LoggerFactory.getLogger(HistogramManager.class);
    private static final int NUM_BINS = 1024;
    private static final long TARGET_HISTOGRAM_N_PIXELS = 10000000L;
    private final Map<String, HistogramForRegions> map = new ConcurrentHashMap<String, HistogramForRegions>();

    HistogramManager() {
    }

    private String getKey(ChannelDisplayInfo channel) {
        return channel.getClass().getName() + "::" + channel.getName();
    }

    void updateChannels(ImageServer<BufferedImage> server, Collection<? extends ChannelDisplayInfo> channels, Map<RegionRequest, BufferedImage> imgList) {
        ArrayList<SingleChannelDisplayInfo> channelsToProcess = new ArrayList<SingleChannelDisplayInfo>();
        float serverMin = server.getMetadata().getMinValue().floatValue();
        float serverMax = server.getMetadata().getMaxValue().floatValue();
        for (ChannelDisplayInfo channelDisplayInfo : channels) {
            ChannelDisplayInfo.ModifiableChannelDisplayInfo modifiableChannel;
            HistogramForRegions histogramForRegions = this.map.getOrDefault(this.getKey(channelDisplayInfo), null);
            if (histogramForRegions != null && histogramForRegions.histogram() != null && histogramForRegions.sameRegions(imgList.keySet())) {
                if (!(channelDisplayInfo instanceof ChannelDisplayInfo.ModifiableChannelDisplayInfo)) continue;
                modifiableChannel = (ChannelDisplayInfo.ModifiableChannelDisplayInfo)channelDisplayInfo;
                Histogram histogram = histogramForRegions.histogram();
                modifiableChannel.setMinMaxAllowed((float)Math.min(0.0, histogram.getMinValue()), (float)histogram.getMaxValue());
                continue;
            }
            if (channelDisplayInfo instanceof SingleChannelDisplayInfo) {
                SingleChannelDisplayInfo singleChannel = (SingleChannelDisplayInfo)channelDisplayInfo;
                channelsToProcess.add(singleChannel);
                if (!(channelDisplayInfo instanceof ChannelDisplayInfo.ModifiableChannelDisplayInfo)) continue;
                modifiableChannel = (ChannelDisplayInfo.ModifiableChannelDisplayInfo)channelDisplayInfo;
                modifiableChannel.setMinMaxAllowed(serverMin, serverMax);
                continue;
            }
            this.map.put(this.getKey(channelDisplayInfo), new HistogramForRegions(null, imgList.keySet()));
        }
        if (channelsToProcess.isEmpty() || imgList.isEmpty()) {
            return;
        }
        logger.debug("Building {} histograms for {}", (Object)channelsToProcess.size(), (Object)server.getPath());
        long startTime = System.currentTimeMillis();
        long nPixels = HistogramManager.countPixels(imgList.values());
        int stride = (int)Math.max(Math.ceil((double)nPixels / 1.0E7), 1.0);
        for (SingleChannelDisplayInfo channel : channelsToProcess) {
            Histogram histogram = this.createHistogram(channel, imgList, stride, true);
            this.map.put(this.getKey(channel), new HistogramForRegions(histogram, imgList.keySet()));
        }
        long endTime = System.currentTimeMillis();
        logger.debug("Histograms built in {} ms", (Object)(endTime - startTime));
    }

    private Histogram createHistogram(SingleChannelDisplayInfo channel, Map<RegionRequest, BufferedImage> images, int stride, boolean permitMinMaxUpdate) {
        ArrayList<ArrayWrappers.ArrayWrapper> wrappers = new ArrayList<ArrayWrappers.ArrayWrapper>();
        double minValue = Double.POSITIVE_INFINITY;
        double maxValue = Double.NEGATIVE_INFINITY;
        long size = 0L;
        double downsample = 1.0;
        for (Map.Entry<RegionRequest, BufferedImage> entry : images.entrySet()) {
            downsample = Math.max(entry.getKey().getDownsample(), 1.0);
            BufferedImage img = entry.getValue();
            float[] vals = channel.getValues(img, 0, 0, img.getWidth(), img.getHeight(), null);
            if ((size += (long)vals.length) >= Integer.MAX_VALUE) break;
            if (stride == 1) {
                wrappers.add(ArrayWrappers.makeFloatArrayWrapper((float[])vals));
            } else {
                wrappers.add(ArrayWrappers.makeFloatArrayWrapper((float[])HistogramManager.subsample(vals, stride)));
            }
            for (float val : vals) {
                if ((double)val < minValue) {
                    minValue = val;
                }
                if (!((double)val > maxValue)) continue;
                maxValue = val;
            }
        }
        Histogram histogram = new Histogram(ArrayWrappers.concatenate(wrappers), 1024, minValue, maxValue);
        if (permitMinMaxUpdate && channel instanceof ChannelDisplayInfo.ModifiableChannelDisplayInfo) {
            float scale;
            ChannelDisplayInfo.ModifiableChannelDisplayInfo modifiableChannelDisplayInfo = (ChannelDisplayInfo.ModifiableChannelDisplayInfo)((Object)channel);
            float f = scale = downsample < 2.0 ? 1.0f : 1.5f;
            if (!histogram.isInteger() || Math.max(Math.abs(channel.getMaxAllowed()), Math.abs(channel.getMinAllowed())) > 4096.0f) {
                modifiableChannelDisplayInfo.setMinMaxAllowed((float)Math.min(0.0, minValue) * scale, (float)Math.max(0.0, maxValue) * scale);
            }
        }
        return histogram;
    }

    private static long countPixels(Collection<? extends BufferedImage> images) {
        long nPixels = 0L;
        for (BufferedImage bufferedImage : images) {
            nPixels += (long)bufferedImage.getWidth() * (long)bufferedImage.getHeight();
        }
        return nPixels;
    }

    Histogram getHistogram(ImageServer<BufferedImage> server, ChannelDisplayInfo channel, Map<RegionRequest, BufferedImage> images) {
        SingleChannelDisplayInfo singleChannel;
        String key = this.getKey(channel);
        if (channel instanceof SingleChannelDisplayInfo && (singleChannel = (SingleChannelDisplayInfo)channel).isMutable()) {
            this.map.remove(key);
        }
        this.updateChannels(server, Collections.singletonList(channel), images);
        HistogramForRegions histogramForRegions = this.map.getOrDefault(key, null);
        return histogramForRegions == null ? null : histogramForRegions.histogram();
    }

    private static float[] subsample(float[] values, int stride) {
        if (stride <= 1) {
            return values;
        }
        float[] arr2 = new float[values.length / stride];
        for (int i = 0; i < arr2.length; ++i) {
            arr2[i] = values[i * stride];
        }
        return arr2;
    }

    private record HistogramForRegions(Histogram histogram, Set<RegionRequest> regions) {
        private HistogramForRegions(Histogram histogram, Set<RegionRequest> regions) {
            this.histogram = histogram;
            this.regions = Set.copyOf(regions);
        }

        boolean sameRegions(Set<RegionRequest> regions) {
            return this.regions.equals(regions);
        }
    }
}

