/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import qupath.lib.common.ColorTools;
import qupath.lib.display.AbstractSingleChannelInfo;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.images.ImageData;

public class DirectServerChannelInfo
extends AbstractSingleChannelInfo {
    private int channel;
    private transient ColorModel cm;
    private transient ColorModel cmInverted;
    private transient int[] rgbLUT;
    private int rgb;

    public DirectServerChannelInfo(ImageData<BufferedImage> imageData, int channel) {
        super(imageData);
        this.channel = channel;
        this.setLUTColor(imageData.getServer().getChannel(channel).getColor());
    }

    public int getChannel() {
        return this.channel;
    }

    @Override
    public String getName() {
        String channelName;
        String name = "Channel " + (this.channel + 1);
        ImageData<BufferedImage> imageData = this.getImageData();
        String string = channelName = imageData == null ? null : imageData.getServer().getChannel(this.channel).getName();
        if (channelName == null) {
            return name;
        }
        String postfix = " (C" + (this.channel + 1) + ")";
        if (channelName.contains(name) || channelName.endsWith(postfix)) {
            return channelName;
        }
        return channelName + postfix;
    }

    public String getOriginalChannelName() {
        ImageData<BufferedImage> imageData = this.getImageData();
        return imageData == null ? null : imageData.getServer().getChannel(this.channel).getName();
    }

    void setLUTColor(int rgb) {
        this.setLUTColor(ColorTools.red((int)rgb), ColorTools.green((int)rgb), ColorTools.blue((int)rgb));
    }

    @Override
    protected ColorModel getColorModel(ChannelDisplayMode mode) {
        switch (mode) {
            case INVERTED_GRAYSCALE: 
            case GRAYSCALE: {
                return CM_GRAYSCALE;
            }
            case INVERTED_COLOR: {
                return this.cmInverted;
            }
        }
        return this.cm;
    }

    public void setLUTColor(int r, int g, int b) {
        this.rgbLUT = new int[256];
        byte[] rb = new byte[256];
        byte[] gb = new byte[256];
        byte[] bb = new byte[256];
        byte[] rbi = new byte[256];
        byte[] gbi = new byte[256];
        byte[] bbi = new byte[256];
        for (int i = 0; i < 256; ++i) {
            this.rgbLUT[i] = ColorTools.packRGB((int)ColorTools.do8BitRangeCheck((double)((double)r / 255.0 * (double)i)), (int)ColorTools.do8BitRangeCheck((double)((double)g / 255.0 * (double)i)), (int)ColorTools.do8BitRangeCheck((double)((double)b / 255.0 * (double)i)));
            rb[i] = (byte)ColorTools.do8BitRangeCheck((double)((double)r / 255.0 * (double)i));
            gb[i] = (byte)ColorTools.do8BitRangeCheck((double)((double)g / 255.0 * (double)i));
            bb[i] = (byte)ColorTools.do8BitRangeCheck((double)((double)b / 255.0 * (double)i));
            rbi[i] = (byte)ColorTools.do8BitRangeCheck((double)((double)(255 - r) / 255.0 * (double)i));
            gbi[i] = (byte)ColorTools.do8BitRangeCheck((double)((double)(255 - g) / 255.0 * (double)i));
            bbi[i] = (byte)ColorTools.do8BitRangeCheck((double)((double)(255 - b) / 255.0 * (double)i));
        }
        this.cm = new IndexColorModel(8, 256, rb, gb, bb);
        this.cmInverted = new IndexColorModel(8, 256, rbi, gbi, bbi);
        this.rgb = ColorTools.packRGB((int)r, (int)g, (int)b);
    }

    @Override
    public float getValue(BufferedImage img, int x, int y) {
        return img.getRaster().getSampleFloat(x, y, this.channel);
    }

    @Override
    public float[] getValues(BufferedImage img, int x, int y, int w, int h, float[] array) {
        if (array == null || array.length < w * h) {
            array = new float[w * h];
        }
        float[] samples = img.getRaster().getSamples(x, y, w, h, this.channel, array);
        return samples;
    }

    @Override
    public boolean doesSomething() {
        return true;
    }

    @Override
    public boolean isAdditive() {
        return true;
    }

    @Override
    public Integer getColor() {
        return this.rgb;
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

