/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.util.Objects;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.color.ColorDeconvolutionHelper;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.color.ColorTransformer;
import qupath.lib.color.StainVector;
import qupath.lib.common.ColorTools;
import qupath.lib.display.AbstractSingleChannelInfo;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.display.RGBDirectChannelInfo;
import qupath.lib.images.ImageData;

class ColorDeconvolutionInfo
extends AbstractSingleChannelInfo {
    private transient int stainNumber;
    private transient ColorDeconvolutionStains stains;
    private transient ColorModel colorModel = null;
    private transient ColorModel colorModelInverted = null;
    private transient Integer color;
    private ColorTransformer.ColorTransformMethod method;

    public ColorDeconvolutionInfo(ImageData<BufferedImage> imageData, ColorTransformer.ColorTransformMethod method) {
        super(imageData);
        this.method = method;
        switch (method) {
            case Stain_1: {
                this.stainNumber = 1;
                break;
            }
            case Stain_2: {
                this.stainNumber = 2;
                break;
            }
            case Stain_3: {
                this.stainNumber = 3;
                break;
            }
            default: {
                this.stainNumber = -1;
            }
        }
        this.setMinMaxAllowed(0.0f, 3.0f);
        this.setMinDisplay(0.0f);
        this.setMaxDisplay(1.5f);
    }

    final void ensureStainsUpdated() {
        ImageData<BufferedImage> imageData = this.getImageData();
        this.stains = imageData == null ? null : imageData.getColorDeconvolutionStains();
        Integer newColor = null;
        boolean createColorModel = false;
        if (this.stainNumber < 0) {
            newColor = ColorTools.packRGB((int)255, (int)255, (int)255);
            if (!Objects.equals(newColor, this.color)) {
                this.colorModel = ColorTransformer.getDefaultColorModel((ColorTransformer.ColorTransformMethod)this.method);
                createColorModel = true;
            }
        } else if (this.stains != null && !Objects.equals(newColor = Integer.valueOf(this.stains.getStain(this.stainNumber).getColor()), this.color)) {
            this.colorModel = ColorToolsAwt.getIndexColorModel((StainVector)this.stains.getStain(this.stainNumber), (boolean)true);
            createColorModel = true;
        }
        this.color = newColor;
        if (createColorModel && this.colorModel instanceof IndexColorModel) {
            StainVector s = this.stains.getStain(this.stainNumber);
            int c = s.getColor();
            this.colorModelInverted = ColorToolsAwt.createIndexColorModel((int)(255 - ColorTools.red((int)c)), (int)(255 - ColorTools.green((int)c)), (int)(255 - ColorTools.blue((int)c)), (boolean)true);
        }
    }

    private static boolean isRGB(BufferedImage img) {
        return BufferedImageTools.is8bitColorType((int)img.getType());
    }

    @Override
    public float getValue(BufferedImage img, int x, int y) {
        this.ensureStainsUpdated();
        if (this.stains == null) {
            return 0.0f;
        }
        if (ColorDeconvolutionInfo.isRGB(img)) {
            return this.getValueRGB(img, x, y);
        }
        float r = img.getRaster().getSampleFloat(x, y, 0);
        float g = img.getRaster().getSampleFloat(x, y, 1);
        float b = img.getRaster().getSampleFloat(x, y, 2);
        if (this.method == ColorTransformer.ColorTransformMethod.Optical_density_sum) {
            return r + g + b;
        }
        double[][] invMat = this.stains.getMatrixInverse();
        return (float)((double)r * invMat[0][this.stainNumber - 1] + (double)g * invMat[1][this.stainNumber - 1] + (double)b * invMat[2][this.stainNumber - 1]);
    }

    private float getValueRGB(BufferedImage img, int x, int y) {
        int rgb = img.getRGB(x, y);
        if (this.method == null) {
            return ColorTransformer.colorDeconvolveRGBPixel((int)rgb, (ColorDeconvolutionStains)this.stains, (int)(this.stainNumber - 1));
        }
        if (this.method == ColorTransformer.ColorTransformMethod.Optical_density_sum) {
            int r = ColorTools.red((int)rgb);
            int g = ColorTools.green((int)rgb);
            int b = ColorTools.blue((int)rgb);
            return (float)(ColorDeconvolutionHelper.makeOD((double)r, (double)this.stains.getMaxRed()) + ColorDeconvolutionHelper.makeOD((double)g, (double)this.stains.getMaxGreen()) + ColorDeconvolutionHelper.makeOD((double)b, (double)this.stains.getMaxBlue()));
        }
        return ColorTransformer.getPixelValue((int)rgb, (ColorTransformer.ColorTransformMethod)this.method, (ColorDeconvolutionStains)this.stains);
    }

    @Override
    public synchronized float[] getValues(BufferedImage img, int x, int y, int w, int h, float[] array) {
        this.ensureStainsUpdated();
        if (this.stains == null) {
            if (array == null) {
                return new float[w * h];
            }
            return array;
        }
        if (ColorDeconvolutionInfo.isRGB(img)) {
            return this.getValuesRGB(img, x, y, w, h, array);
        }
        if (this.method == ColorTransformer.ColorTransformMethod.Optical_density_sum) {
            float[] r = ColorDeconvolutionHelper.getOpticalDensities((Raster)img.getRaster(), (int)0, (double)this.stains.getMaxRed(), (float[])array);
            float[] g = ColorDeconvolutionHelper.getOpticalDensities((Raster)img.getRaster(), (int)1, (double)this.stains.getMaxGreen(), null);
            float[] b = ColorDeconvolutionHelper.getOpticalDensities((Raster)img.getRaster(), (int)2, (double)this.stains.getMaxBlue(), null);
            array = r;
            for (int i = 0; i < array.length; ++i) {
                array[i] = r[i] + g[i] + b[i];
            }
            return array;
        }
        return ColorDeconvolutionHelper.colorDeconvolve((BufferedImage)img, (ColorDeconvolutionStains)this.stains, (int)(this.stainNumber - 1), (float[])array);
    }

    private float[] getValuesRGB(BufferedImage img, int x, int y, int w, int h, float[] array) {
        int[] buffer = RGBDirectChannelInfo.getRGBIntBuffer(img);
        if (buffer == null) {
            buffer = img.getRGB(x, y, w, h, null, 0, w);
        }
        return ColorTransformer.getTransformedPixels((int[])buffer, (ColorTransformer.ColorTransformMethod)this.method, (float[])array, (ColorDeconvolutionStains)this.stains);
    }

    @Override
    protected ColorModel getColorModel(ChannelDisplayMode mode) {
        switch (mode) {
            case GRAYSCALE: 
            case INVERTED_GRAYSCALE: {
                return CM_GRAYSCALE_INVERTED;
            }
            case INVERTED_COLOR: {
                return this.colorModelInverted;
            }
        }
        return this.colorModel;
    }

    @Override
    public String getName() {
        this.ensureStainsUpdated();
        if (this.stainNumber > 0) {
            if (this.stains == null) {
                return "Stain " + this.stainNumber + " (missing)";
            }
            return this.stains.getStain(this.stainNumber).getName();
        }
        if (this.method != null) {
            return this.method.toString();
        }
        return "Unknown color deconvolution transform";
    }

    @Override
    public boolean doesSomething() {
        return true;
    }

    @Override
    public boolean isAdditive() {
        return false;
    }

    @Override
    public Integer getColor() {
        if (this.color == null) {
            this.ensureStainsUpdated();
        }
        return this.color;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public ColorTransformer.ColorTransformMethod getMethod() {
        return this.method;
    }
}

