/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import qupath.lib.color.ColorTransformer;
import qupath.lib.display.AdditiveChannelInfo;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ColorDeconvolutionInfo;
import qupath.lib.display.DirectServerChannelInfo;
import qupath.lib.display.RBGColorTransformInfo;
import qupath.lib.display.RGBDirectChannelInfo;
import qupath.lib.display.RGBNormalizedChannelInfo;
import qupath.lib.images.ImageData;

class ChannelManager {
    private final RgbChannels rgbChannels;
    private final DirectChannels directChannels;

    ChannelManager(ImageData<BufferedImage> imageData) {
        Objects.requireNonNull(imageData);
        if (imageData.getServerMetadata().isRGB()) {
            this.rgbChannels = new RgbChannels(imageData);
            this.directChannels = null;
        } else {
            this.directChannels = new DirectChannels(imageData);
            this.rgbChannels = null;
        }
    }

    List<ChannelDisplayInfo> getAvailableChannels(boolean includeAllTransforms) {
        if (this.rgbChannels != null) {
            return this.rgbChannels.getAvailableRgbChannels(includeAllTransforms);
        }
        return this.directChannels.getAvailableChannels();
    }

    private static class RgbChannels {
        private final ImageData<BufferedImage> imageData;
        private final RGBDirectChannelInfo rgbDirectChannelInfo;
        private final RGBNormalizedChannelInfo rgbNormalizedChannelInfo;
        private final List<ChannelDisplayInfo> rgbDirectChannels = new ArrayList<ChannelDisplayInfo>();
        private final List<ChannelDisplayInfo> rgbSplitChannels = new ArrayList<ChannelDisplayInfo>();
        private final List<ChannelDisplayInfo> rgbHsvChannels = new ArrayList<ChannelDisplayInfo>();
        private final List<ChannelDisplayInfo> rgbBrightfieldChannels = new ArrayList<ChannelDisplayInfo>();
        private final List<ChannelDisplayInfo> rgbChromaticityChannels = new ArrayList<ChannelDisplayInfo>();

        private RgbChannels(ImageData<BufferedImage> imageData) {
            this.imageData = imageData;
            this.rgbDirectChannelInfo = new RGBDirectChannelInfo(imageData);
            this.rgbNormalizedChannelInfo = new RGBNormalizedChannelInfo(imageData);
            this.rgbSplitChannels.add(new RBGColorTransformInfo(imageData, ColorTransformer.ColorTransformMethod.Red, false));
            this.rgbSplitChannels.add(new RBGColorTransformInfo(imageData, ColorTransformer.ColorTransformMethod.Green, false));
            this.rgbSplitChannels.add(new RBGColorTransformInfo(imageData, ColorTransformer.ColorTransformMethod.Blue, false));
            this.rgbDirectChannels.add(new DirectServerChannelInfo(imageData, 0));
            this.rgbDirectChannels.add(new DirectServerChannelInfo(imageData, 1));
            this.rgbDirectChannels.add(new DirectServerChannelInfo(imageData, 2));
            this.rgbHsvChannels.add(new RBGColorTransformInfo(imageData, ColorTransformer.ColorTransformMethod.Hue, false));
            this.rgbHsvChannels.add(new RBGColorTransformInfo(imageData, ColorTransformer.ColorTransformMethod.Saturation, false));
            this.rgbHsvChannels.add(new RBGColorTransformInfo(imageData, ColorTransformer.ColorTransformMethod.RGB_mean, false));
            this.rgbBrightfieldChannels.add(new ColorDeconvolutionInfo(imageData, ColorTransformer.ColorTransformMethod.Stain_1));
            this.rgbBrightfieldChannels.add(new ColorDeconvolutionInfo(imageData, ColorTransformer.ColorTransformMethod.Stain_2));
            this.rgbBrightfieldChannels.add(new ColorDeconvolutionInfo(imageData, ColorTransformer.ColorTransformMethod.Stain_3));
            this.rgbBrightfieldChannels.add(new ColorDeconvolutionInfo(imageData, ColorTransformer.ColorTransformMethod.Optical_density_sum));
            this.rgbChromaticityChannels.add(new RBGColorTransformInfo(imageData, ColorTransformer.ColorTransformMethod.Red_chromaticity, false));
            this.rgbChromaticityChannels.add(new RBGColorTransformInfo(imageData, ColorTransformer.ColorTransformMethod.Green_chromaticity, false));
            this.rgbChromaticityChannels.add(new RBGColorTransformInfo(imageData, ColorTransformer.ColorTransformMethod.Blue_chromaticity, false));
        }

        private List<ChannelDisplayInfo> getAvailableRgbChannels(boolean includeAllTransforms) {
            ArrayList<ChannelDisplayInfo> tempChannelOptions = new ArrayList<ChannelDisplayInfo>();
            if (this.imageData.isFluorescence()) {
                tempChannelOptions.addAll(this.rgbDirectChannels);
            } else {
                tempChannelOptions.add(this.rgbDirectChannelInfo);
                if (this.imageData.isBrightfield()) {
                    tempChannelOptions.addAll(this.rgbBrightfieldChannels);
                    tempChannelOptions.add(this.rgbNormalizedChannelInfo);
                }
                tempChannelOptions.addAll(this.rgbSplitChannels);
                if (includeAllTransforms) {
                    tempChannelOptions.addAll(this.rgbHsvChannels);
                    tempChannelOptions.addAll(this.rgbChromaticityChannels);
                }
            }
            return tempChannelOptions;
        }
    }

    private static class DirectChannels {
        private final ImageData<BufferedImage> imageData;
        private final List<DirectServerChannelInfo> availableChannels = new ArrayList<DirectServerChannelInfo>();
        private final List<ChannelDisplayInfo> brightfieldChannels = new ArrayList<ChannelDisplayInfo>();

        private DirectChannels(ImageData<BufferedImage> imageData) {
            this.imageData = imageData;
            List channels = imageData.getServerMetadata().getChannels();
            for (int c = 0; c < channels.size(); ++c) {
                this.availableChannels.add(new DirectServerChannelInfo(imageData, c));
            }
            if (imageData.getServerMetadata().getChannels().size() == 3) {
                this.brightfieldChannels.add(new AdditiveChannelInfo(imageData, this.availableChannels));
                this.brightfieldChannels.add(new ColorDeconvolutionInfo(imageData, ColorTransformer.ColorTransformMethod.Stain_1));
                this.brightfieldChannels.add(new ColorDeconvolutionInfo(imageData, ColorTransformer.ColorTransformMethod.Stain_2));
                this.brightfieldChannels.add(new ColorDeconvolutionInfo(imageData, ColorTransformer.ColorTransformMethod.Stain_3));
                this.brightfieldChannels.add(new ColorDeconvolutionInfo(imageData, ColorTransformer.ColorTransformMethod.Optical_density_sum));
            }
        }

        private List<ChannelDisplayInfo> getAvailableChannels() {
            if (this.imageData.isBrightfield()) {
                ArrayList<ChannelDisplayInfo> list = new ArrayList<ChannelDisplayInfo>(this.brightfieldChannels);
                list.addAll(this.availableChannels);
                return list;
            }
            return List.copyOf(this.availableChannels);
        }
    }
}

