/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.awt.image.BufferedImage;
import java.util.List;
import java.util.stream.Collectors;
import qupath.lib.common.ColorTools;
import qupath.lib.display.AbstractChannelInfo;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.display.DirectServerChannelInfo;
import qupath.lib.display.RGBDirectChannelInfo;
import qupath.lib.images.ImageData;

public class AdditiveChannelInfo
extends AbstractChannelInfo {
    private final List<DirectServerChannelInfo> channels;

    public AdditiveChannelInfo(ImageData<BufferedImage> imageData, List<DirectServerChannelInfo> channels) {
        super(imageData);
        this.channels = channels == null ? List.of() : List.copyOf(channels);
        this.setMinMaxAllowed(0.0f, 255.0f);
        this.setClipToAllowed(true);
    }

    @Override
    public String getName() {
        return "Original (composite)";
    }

    @Override
    public String getValueAsString(BufferedImage img, int x, int y) {
        return this.channels.stream().map(c -> c.getValueAsString(img, x, y)).collect(Collectors.joining(", "));
    }

    @Override
    public int getRGB(BufferedImage img, int x, int y, ChannelDisplayMode mode) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (DirectServerChannelInfo channel : this.channels) {
            int val = channel.getRGB(img, x, y, mode);
            r += ColorTools.red((int)val);
            g += ColorTools.green((int)val);
            b += ColorTools.blue((int)val);
        }
        return (AdditiveChannelInfo.do8BitRangeCheck(r) << 16) + (AdditiveChannelInfo.do8BitRangeCheck(g) << 8) + AdditiveChannelInfo.do8BitRangeCheck(b);
    }

    @Override
    public int[] getRGB(BufferedImage img, int[] rgb, ChannelDisplayMode mode) {
        if (rgb == null) {
            rgb = new int[img.getWidth() * img.getHeight()];
        }
        for (DirectServerChannelInfo c : this.channels) {
            c.updateRGBAdditive(img, rgb, ChannelDisplayMode.COLOR);
        }
        return RGBDirectChannelInfo.transformRGB(rgb, rgb, mode, this.getOffset(), this.getScaleToByte());
    }

    @Override
    public void updateRGBAdditive(BufferedImage img, int[] rgb, ChannelDisplayMode mode) {
        throw new UnsupportedOperationException(String.valueOf(this) + " does not support additive display");
    }

    @Override
    public boolean doesSomething() {
        return !this.channels.isEmpty();
    }

    @Override
    public boolean isAdditive() {
        return false;
    }

    @Override
    public Integer getColor() {
        return null;
    }

    public List<DirectServerChannelInfo> getChannels() {
        return this.channels;
    }
}

