/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.text.DecimalFormat;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.color.ColorTransformer;
import qupath.lib.common.ColorTools;
import qupath.lib.display.AbstractChannelInfo;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.display.SingleChannelDisplayInfo;
import qupath.lib.images.ImageData;

abstract class AbstractSingleChannelInfo
extends AbstractChannelInfo
implements SingleChannelDisplayInfo {
    protected static final DecimalFormat df = new DecimalFormat("#.##");
    protected static final IndexColorModel CM_GRAYSCALE = ColorToolsAwt.createIndexColorModel((int)255, (int)255, (int)255, (boolean)false);
    protected static final IndexColorModel CM_GRAYSCALE_INVERTED = ColorToolsAwt.createIndexColorModel((int)0, (int)0, (int)0, (boolean)true);

    AbstractSingleChannelInfo(ImageData<BufferedImage> imageData) {
        super(imageData);
    }

    protected abstract ColorModel getColorModel(ChannelDisplayMode var1);

    public int getRGB(float value, ChannelDisplayMode mode) {
        return ColorTransformer.makeScaledRGBwithRangeCheck((float)value, (float)this.minDisplay, (float)(255.0f / (this.maxDisplay - this.minDisplay)), (ColorModel)this.getColorModel(mode));
    }

    private void updateRGBAdditive(float[] values, int[] rgb, ChannelDisplayMode mode) {
        int n = Math.min(values.length, rgb.length);
        for (int i = 0; i < n; ++i) {
            rgb[i] = this.updateRGBAdditive(values[i], rgb[i], mode);
        }
    }

    private int[] getRGB(float[] values, int[] rgb, ChannelDisplayMode mode) {
        int n = values.length;
        if (rgb == null) {
            rgb = new int[values.length];
        } else if (rgb.length < n) {
            n = rgb.length;
        }
        for (int i = 0; i < n; ++i) {
            rgb[i] = this.getRGB(values[i], mode);
        }
        return rgb;
    }

    @Override
    public int getRGB(BufferedImage img, int x, int y, ChannelDisplayMode mode) {
        return this.getRGB(this.getValue(img, x, y), mode);
    }

    private int updateRGBAdditive(float value, int rgb, ChannelDisplayMode mode) {
        if (this.maxDisplay == this.minDisplay) {
            return rgb;
        }
        int rgbNew = this.getRGB(value, mode);
        if (rgb == 0) {
            return rgbNew;
        }
        if (rgbNew == 0) {
            return rgb;
        }
        int r2 = ((rgbNew & ColorTools.MASK_RED) >> 16) + ((rgb & ColorTools.MASK_RED) >> 16);
        int g2 = ((rgbNew & ColorTools.MASK_GREEN) >> 8) + ((rgb & ColorTools.MASK_GREEN) >> 8);
        int b2 = (rgbNew & ColorTools.MASK_BLUE) + (rgb & ColorTools.MASK_BLUE);
        return (AbstractSingleChannelInfo.do8BitRangeCheck(r2) << 16) + (AbstractSingleChannelInfo.do8BitRangeCheck(g2) << 8) + AbstractSingleChannelInfo.do8BitRangeCheck(b2);
    }

    @Override
    public String getValueAsString(BufferedImage img, int x, int y) {
        return df.format(this.getValue(img, x, y));
    }

    @Override
    public int[] getRGB(BufferedImage img, int[] rgb, ChannelDisplayMode mode) {
        float[] values = this.getValues(img, 0, 0, img.getWidth(), img.getHeight(), null);
        int[] result = this.getRGB(values, rgb, mode);
        return result;
    }

    @Override
    public void updateRGBAdditive(BufferedImage img, int[] rgb, ChannelDisplayMode mode) {
        if (!this.isAdditive()) {
            throw new UnsupportedOperationException(String.valueOf(this) + " does not support additive display");
        }
        float[] values = this.getValues(img, 0, 0, img.getWidth(), img.getHeight(), null);
        this.updateRGBAdditive(values, rgb, mode);
    }
}

