/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.display;

import java.awt.image.BufferedImage;
import qupath.lib.common.ColorTools;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;

abstract class AbstractChannelInfo
implements ChannelDisplayInfo.ModifiableChannelDisplayInfo {
    private transient ImageData<BufferedImage> imageData;
    protected float minAllowed;
    protected float maxAllowed;
    protected float minDisplay;
    protected float maxDisplay;
    protected boolean clipToAllowed = false;

    AbstractChannelInfo(ImageData<BufferedImage> imageData) {
        this.imageData = imageData;
        this.minAllowed = 0.0f;
        this.maxAllowed = (float)Math.pow(2.0, imageData.getServer().getPixelType().getBitsPerPixel()) - 1.0f;
        this.minDisplay = 0.0f;
        this.maxDisplay = this.maxAllowed;
    }

    protected ImageData<BufferedImage> getImageData() {
        return this.imageData;
    }

    protected ImageServer<BufferedImage> getImageServer() {
        return this.imageData.getServer();
    }

    boolean doClipToAllowed() {
        return this.clipToAllowed;
    }

    void setClipToAllowed(boolean clipToAllowed) {
        this.clipToAllowed = clipToAllowed;
        if (clipToAllowed) {
            this.minDisplay = Math.min(Math.max(this.minDisplay, this.minAllowed), this.maxAllowed);
            this.maxDisplay = Math.min(Math.max(this.maxDisplay, this.minAllowed), this.maxAllowed);
        }
    }

    @Override
    public void setMinMaxAllowed(float minAllowed, float maxAllowed) {
        this.minAllowed = minAllowed;
        this.maxAllowed = maxAllowed;
        if (this.maxAllowed <= minAllowed) {
            this.maxAllowed = minAllowed + 1.0f;
        }
        this.setMinDisplay(this.minDisplay);
        this.setMaxDisplay(this.maxDisplay);
    }

    @Override
    public boolean isBrightnessContrastRescaled() {
        return this.minAllowed != this.minDisplay || this.maxAllowed != this.maxDisplay;
    }

    @Override
    public void setMinDisplay(float minDisplay) {
        this.minDisplay = this.clipToAllowed ? Math.max(this.minAllowed, minDisplay) : minDisplay;
    }

    @Override
    public void setMaxDisplay(float maxDisplay) {
        this.maxDisplay = this.clipToAllowed ? Math.min(this.maxAllowed, maxDisplay) : maxDisplay;
    }

    @Override
    public float getMinAllowed() {
        return this.minAllowed;
    }

    @Override
    public float getMaxAllowed() {
        return this.maxAllowed;
    }

    @Override
    public float getMinDisplay() {
        return this.minDisplay;
    }

    @Override
    public float getMaxDisplay() {
        return this.maxDisplay;
    }

    static final int do8BitRangeCheck(float v) {
        return v < 0.0f ? 0 : (v > 255.0f ? 255 : (int)v);
    }

    static final int do8BitRangeCheck(int v) {
        return v < 0 ? 0 : (v > 255 ? 255 : v);
    }

    @Override
    public int updateRGBAdditive(BufferedImage img, int x, int y, int rgb, ChannelDisplayMode mode) {
        int rgbNew = this.getRGB(img, x, y, mode);
        if (rgb == 0) {
            return rgbNew;
        }
        int r2 = ((rgbNew & ColorTools.MASK_RED) >> 16) + ((rgb & ColorTools.MASK_RED) >> 16);
        int g2 = ((rgbNew & ColorTools.MASK_GREEN) >> 8) + ((rgb & ColorTools.MASK_GREEN) >> 8);
        int b2 = (rgbNew & ColorTools.MASK_BLUE) + (rgb & ColorTools.MASK_BLUE);
        return (AbstractChannelInfo.do8BitRangeCheck(r2) << 16) + (AbstractChannelInfo.do8BitRangeCheck(g2) << 8) + AbstractChannelInfo.do8BitRangeCheck(b2);
    }

    public String toString() {
        return this.getName();
    }

    float getOffset() {
        return this.getMinDisplay();
    }

    float getScaleToByte() {
        return 255.0f / (this.getMaxDisplay() - this.getMinDisplay());
    }
}

