/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.DeltavisionReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.IMetadata;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.meta.MetadataConverter;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.MetadataRoot;
import ome.xml.meta.MetadataStore;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public class CellWorxReader
extends FormatReader {
    protected static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private boolean[][] fieldMap;
    protected String[][][] wellFiles;
    private String[][] logFiles;
    protected int fieldCount = 0;
    protected boolean doChannels = false;
    private String plateLogFile;
    private String zMapFile;
    private String lastFile;
    private IFormatReader lastReader;
    private OMEXMLService service;
    private HashMap<Integer, Timestamp> timestamps = new HashMap();
    protected String[] directoryList;
    protected boolean subdirectories = false;
    protected String[] wavelengths = null;
    protected int nTimepoints = 1;
    protected int zSteps = 1;
    protected int wellCount = 0;

    public CellWorxReader() {
        super("CellWorx", new String[]{"pnl", "htd", "log"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .htd file plus one or more .pnl files and optionally one or more .log files";
        this.suffixNecessary = true;
    }

    public CellWorxReader(String name, String[] extensions) {
        super(name, extensions);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(String name, boolean open) {
        if (!CellWorxReader.checkSuffix((String)name, (String)"htd") && !CellWorxReader.checkSuffix((String)name, (String)"log")) {
            return super.isThisType(name, open);
        }
        if (!open) {
            return false;
        }
        if (CellWorxReader.checkSuffix((String)name, (String)"htd")) {
            String plate = this.getPlateName(name);
            try {
                String plateData = DataTools.readFile(name);
                String[] lines = plateData.split("\n");
                int xWells = 0;
                int yWells = 0;
                for (String line : lines) {
                    int split = line.indexOf("\",");
                    if (split < 1) continue;
                    String key = line.substring(1, split).trim();
                    String value = line.substring(split + 2).trim();
                    if (key.equals("XWells")) {
                        xWells = Integer.parseInt(value);
                        continue;
                    }
                    if (key.equals("YWells")) {
                        yWells = Integer.parseInt(value);
                        continue;
                    }
                    if (!key.startsWith("WellsSelection")) continue;
                    int row = Integer.parseInt(key.substring(14)) - 1;
                    String[] mapping = value.split(",");
                    for (int col = 0; col < xWells; ++col) {
                        String base;
                        Location pnl;
                        if (!Boolean.parseBoolean(mapping[col].trim()) || !(pnl = new Location((base = plate + FormatTools.getWellName((int)row, (int)col)) + ".pnl")).exists()) continue;
                        return this.isThisType(pnl.getAbsolutePath(), open);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.debug("Could not check file type", (Throwable)e);
                return false;
            }
        }
        return this.foundHTDFile(name);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        int col;
        int row;
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.currentId);
        if (this.plateLogFile != null && new Location(this.plateLogFile).exists()) {
            files.add(this.plateLogFile);
        }
        if (this.zMapFile != null) {
            files.add(this.zMapFile);
        }
        if (new Location(this.logFiles[row = this.getWellRow(this.getSeries())][col = this.getWellColumn(this.getSeries())]).exists()) {
            files.add(this.logFiles[row][col]);
        }
        if (!noPixels && new Location(this.wellFiles[row][col][0]).exists()) {
            files.add(this.wellFiles[row][col][0]);
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int fieldIndex = this.getSeries() % this.fieldCount;
        String file2 = this.getFile(this.getSeries(), no);
        LOGGER.trace("Series {} plane {} using file = {}", new Object[]{this.getSeries(), no, file2});
        if (file2 == null) {
            Arrays.fill(buf, this.getFillColor());
            return buf;
        }
        if (this.lastFile == null || this.lastReader == null || !file2.equals(this.lastFile) || this.lastReader.getCurrentFile() == null) {
            if (this.lastReader != null) {
                this.lastReader.close();
            }
            try {
                this.lastReader = this.getReader(file2, false);
            }
            catch (IOException e) {
                LOGGER.debug("", (Throwable)e);
                return buf;
            }
            this.lastFile = file2;
        }
        int planeIndex = no;
        if (this.lastReader.getSeriesCount() == this.fieldCount && this.fieldCount > 1) {
            this.lastReader.setSeries(fieldIndex);
        } else if (this.lastReader.getImageCount() == this.getSizeZ()) {
            int[] zct = this.getZCTCoords(no);
            planeIndex = zct[0];
        } else {
            planeIndex = 0;
        }
        LOGGER.trace("  file series = {}, planeIndex = {}", (Object)this.lastReader.getSeries(), (Object)planeIndex);
        this.lastReader.openBytes(planeIndex, buf, x, y, w, h);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.fieldMap = null;
            this.wellFiles = null;
            this.logFiles = null;
            this.fieldCount = 0;
            this.plateLogFile = null;
            this.zMapFile = null;
            this.lastFile = null;
            if (this.lastReader != null) {
                this.lastReader.close();
            }
            this.lastReader = null;
            this.doChannels = false;
            this.service = null;
            this.timestamps.clear();
            this.directoryList = null;
            this.subdirectories = false;
            this.wavelengths = null;
            this.nTimepoints = 1;
            this.zSteps = 1;
            this.wellCount = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (!CellWorxReader.checkSuffix((String)id, (String)"htd")) {
            LOGGER.info("Searching for .htd file");
            String base = new Location(id).getAbsolutePath();
            base = base.substring(0, base.lastIndexOf("_"));
            id = base + ".HTD";
            if (!new Location(id).exists()) {
                Location parent = new Location(id).getAbsoluteFile().getParentFile();
                for (String f : this.directoryList = parent.list(true)) {
                    if (!CellWorxReader.checkSuffix((String)f, (String)"htd")) continue;
                    id = new Location(parent, f).getAbsolutePath();
                    LOGGER.info("Found .htd file {}", (Object)f);
                    break;
                }
            }
        }
        super.initFile(id);
        this.parseHTD();
        this.findPixelsFiles();
        this.plateLogFile = this.getPlateName(this.currentId) + "scan.log";
        this.populateMetadata();
    }

    protected void populateMetadata() throws FormatException, IOException {
        OMEXMLMetadata convertMetadata;
        String serialNumber = null;
        if (this.plateLogFile != null && new Location(this.plateLogFile).exists()) {
            String[] f;
            for (String line : f = DataTools.readFile(this.plateLogFile).split("\n")) {
                if (line.trim().startsWith("Z Map File")) {
                    String file2 = line.substring(line.indexOf(58) + 1);
                    file2 = file2.substring(file2.lastIndexOf("/") + 1).trim();
                    String parent = new Location(this.currentId).getAbsoluteFile().getParent();
                    this.zMapFile = new Location(parent, file2).getAbsolutePath();
                    continue;
                }
                if (!line.trim().startsWith("Scanner SN")) continue;
                serialNumber = line.substring(line.indexOf(58) + 1).trim();
            }
        }
        int seriesCount = this.fieldCount * this.wellCount;
        int planeIndex = 0;
        int seriesIndex = 0;
        String file3 = this.getFile(seriesIndex, planeIndex);
        while (!new Location(file3).exists()) {
            if (planeIndex < this.zSteps * this.nTimepoints * this.wavelengths.length) {
                ++planeIndex;
            } else {
                if (seriesIndex >= seriesCount - 1) break;
                planeIndex = 0;
                ++seriesIndex;
            }
            file3 = this.getFile(seriesIndex, planeIndex);
        }
        IFormatReader reader = this.getReader(file3, true);
        this.core.clear();
        for (int i = 0; i < seriesCount; ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            this.setSeries(i);
            ms.littleEndian = reader.isLittleEndian();
            ms.sizeX = reader.getSizeX();
            ms.sizeY = reader.getSizeY();
            ms.pixelType = reader.getPixelType();
            ms.sizeZ = this.zSteps;
            ms.sizeT = this.nTimepoints;
            ms.sizeC = this.wavelengths.length;
            ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            ms.dimensionOrder = "XYCZT";
            ms.rgb = false;
            ms.interleaved = reader.isInterleaved();
        }
        OMEXMLMetadata readerMetadata = (OMEXMLMetadata)reader.getMetadataStore();
        OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)readerMetadata.getRoot();
        Instrument instrument = root.getInstrument(0);
        List images = root.copyImageList();
        OMEXMLMetadataRoot convertRoot = new OMEXMLMetadataRoot();
        convertRoot.addInstrument(instrument);
        for (int i = 0; i < this.core.size() / images.size(); ++i) {
            for (Image img : images) {
                convertRoot.addImage(img);
            }
        }
        try {
            convertMetadata = this.service.createOMEXMLMetadata();
        }
        catch (ServiceException exc) {
            throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
        }
        convertMetadata.setRoot((MetadataRoot)convertRoot);
        reader.close();
        for (int c = 1; c < this.wavelengths.length; ++c) {
            seriesIndex = 0;
            planeIndex = c;
            file3 = this.getFile(seriesIndex, planeIndex);
            while (!new Location(file3).exists()) {
                if (planeIndex < this.zSteps * this.nTimepoints * (this.wavelengths.length - 1)) {
                    planeIndex += this.zSteps * this.nTimepoints;
                } else {
                    if (seriesIndex >= seriesCount - 1) break;
                    planeIndex = c;
                    ++seriesIndex;
                }
                file3 = this.getFile(seriesIndex, planeIndex);
            }
            reader = this.getReader(file3, true);
            OMEXMLMetadata channelMetadata = (OMEXMLMetadata)reader.getMetadataStore();
            OMEXMLMetadataRoot channelRoot = (OMEXMLMetadataRoot)channelMetadata.getRoot();
            reader.close();
            for (int i = 0; i < convertRoot.sizeOfImageList(); ++i) {
                MetadataConverter.convertChannels((MetadataRetrieve)channelMetadata, (int)0, (int)0, (MetadataStore)convertMetadata, (int)i, (int)c, (boolean)false);
            }
        }
        loci.formats.meta.MetadataStore store = this.makeFilterMetadata();
        MetadataConverter.convertMetadata((MetadataRetrieve)convertMetadata, (MetadataStore)store);
        MetadataTools.populatePixels((loci.formats.meta.MetadataStore)store, (IFormatReader)this, (boolean)true);
        MetadataLevel metadataLevel = this.metadataOptions.getMetadataLevel();
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            this.setSeries(s);
            if (metadataLevel != MetadataLevel.MINIMUM) {
                String firstFile = null;
                for (int plane = 0; !(firstFile != null && new Location(firstFile).exists() || plane >= this.getImageCount()); ++plane) {
                    firstFile = this.getFile(s, plane);
                }
                if (firstFile == null || !new Location(firstFile).exists()) continue;
                try (IFormatReader helper = this.getReader(firstFile, true);){
                    IMetadata meta = (IMetadata)helper.getMetadataStore();
                    int readerSeries = s % helper.getSeriesCount();
                    Length posX = meta.getPlanePositionX(readerSeries, 0);
                    Length posY = meta.getPlanePositionY(readerSeries, 0);
                    Length posZ = meta.getPlanePositionZ(readerSeries, 0);
                    for (int p = 0; p < this.getImageCount(); ++p) {
                        if (posX != null) {
                            store.setPlanePositionX(posX, s, p);
                        }
                        if (posY != null) {
                            store.setPlanePositionY(posY, s, p);
                        }
                        if (posZ == null) continue;
                        store.setPlanePositionZ(posZ, s, p);
                    }
                    continue;
                }
            }
            for (int p = 0; p < this.getImageCount(); ++p) {
                store.setPlanePositionX(null, s, p);
                store.setPlanePositionY(null, s, p);
                store.setPlanePositionZ(null, s, p);
            }
        }
        this.setSeries(0);
        String plateID = MetadataTools.createLSID((String)"Plate", (int[])new int[]{0});
        Location plate = new Location(this.currentId).getAbsoluteFile();
        store.setPlateID(plateID, 0);
        String plateName = plate.getName();
        if (plateName.indexOf(46) > 0) {
            plateName = plateName.substring(0, plateName.lastIndexOf(46));
        }
        store.setPlateName(plateName, 0);
        store.setPlateRows(new PositiveInteger(Integer.valueOf(this.wellFiles.length)), 0);
        store.setPlateColumns(new PositiveInteger(Integer.valueOf(this.wellFiles[0].length)), 0);
        for (int i = 0; i < this.core.size(); ++i) {
            store.setImageID(MetadataTools.createLSID((String)"Image", (int[])new int[]{i}), i);
        }
        String plateAcqID = MetadataTools.createLSID((String)"PlateAcquisition", (int[])new int[]{0, 0});
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        PositiveInteger fieldCount = FormatTools.getMaxFieldCount((Integer)(this.fieldMap.length * this.fieldMap[0].length));
        if (fieldCount != null) {
            store.setPlateAcquisitionMaximumFieldCount(fieldCount, 0, 0);
        }
        int nextImage = 0;
        for (int row = 0; row < this.wellFiles.length; ++row) {
            for (int col = 0; col < this.wellFiles[row].length; ++col) {
                int wellIndex = row * this.wellFiles[row].length + col;
                String wellID = MetadataTools.createLSID((String)"Well", (int[])new int[]{0, wellIndex});
                store.setWellID(wellID, 0, wellIndex);
                store.setWellColumn(new NonNegativeInteger(Integer.valueOf(col)), 0, wellIndex);
                store.setWellRow(new NonNegativeInteger(Integer.valueOf(row)), 0, wellIndex);
                int fieldIndex = 0;
                for (int fieldRow = 0; fieldRow < this.fieldMap.length; ++fieldRow) {
                    for (int fieldCol = 0; fieldCol < this.fieldMap[fieldRow].length; ++fieldCol) {
                        if (!this.fieldMap[fieldRow][fieldCol] || this.wellFiles[row][col] == null) continue;
                        String wellSampleID = MetadataTools.createLSID((String)"WellSample", (int[])new int[]{0, wellIndex, fieldIndex});
                        store.setWellSampleID(wellSampleID, 0, wellIndex, fieldIndex);
                        String imageID = MetadataTools.createLSID((String)"Image", (int[])new int[]{nextImage});
                        store.setWellSampleImageRef(imageID, 0, wellIndex, fieldIndex);
                        store.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(nextImage)), 0, wellIndex, fieldIndex);
                        store.setPlateAcquisitionWellSampleRef(wellSampleID, 0, 0, nextImage);
                        String well = FormatTools.getWellName((int)row, (int)col);
                        store.setImageName("Well " + well + " Field #" + (fieldIndex + 1), nextImage);
                        ++nextImage;
                        ++fieldIndex;
                    }
                }
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (serialNumber != null) {
                store.setMicroscopeSerialNumber(serialNumber, 0);
            }
            for (int well = 0; well < this.wellCount; ++well) {
                this.parseWellLogFile(well, store);
            }
            if (this.timestamps.size() > 0) {
                store.setPlateAcquisitionStartTime(this.timestamps.get(0), 0, 0);
                store.setPlateAcquisitionEndTime(this.timestamps.get(this.timestamps.size() - 1), 0, 0);
            }
            for (int i = 0; i < this.core.size(); ++i) {
                for (int c = 0; c < this.getSizeC(); ++c) {
                    if (c >= this.wavelengths.length || this.wavelengths[c] == null) continue;
                    store.setChannelName(this.wavelengths[c], i, c);
                }
            }
        }
    }

    protected void parseHTD() throws FormatException, IOException {
        String[] lines;
        if (this.directoryList == null) {
            Location rootDir = new Location(this.currentId).getAbsoluteFile().getParentFile();
            this.directoryList = rootDir.list(true);
            Arrays.sort(this.directoryList);
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            this.service = factory.getInstance(OMEXMLService.class);
        }
        catch (DependencyException exc) {
            throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
        }
        int xWells = 0;
        int yWells = 0;
        int xFields = 0;
        int yFields = 0;
        String plateData = DataTools.readFile(this.currentId);
        for (String line : lines = plateData.split("\n")) {
            int col;
            String[] mapping;
            int row;
            int split = line.indexOf("\",");
            if (split < 1) continue;
            String key = line.substring(1, split).trim();
            String value = line.substring(split + 2).trim();
            if (key.equals("XWells")) {
                xWells = Integer.parseInt(value);
                continue;
            }
            if (key.equals("YWells")) {
                yWells = Integer.parseInt(value);
                this.wellFiles = new String[yWells][xWells][];
                this.logFiles = new String[yWells][xWells];
                continue;
            }
            if (key.startsWith("WellsSelection")) {
                row = Integer.parseInt(key.substring(14)) - 1;
                mapping = value.split(",");
                for (col = 0; col < xWells; ++col) {
                    if (!Boolean.parseBoolean(mapping[col].trim())) continue;
                    this.wellFiles[row][col] = new String[1];
                }
                continue;
            }
            if (key.equals("XSites")) {
                xFields = Integer.parseInt(value);
                continue;
            }
            if (key.equals("YSites")) {
                yFields = Integer.parseInt(value);
                if (this.fieldMap != null) continue;
                this.fieldMap = new boolean[yFields][xFields];
                continue;
            }
            if (key.equals("Sites")) {
                if (!value.equalsIgnoreCase("false")) continue;
                this.fieldMap = new boolean[][]{{true}};
                continue;
            }
            if (key.equals("TimePoints")) {
                this.nTimepoints = Integer.parseInt(value);
                continue;
            }
            if (key.equals("ZSteps")) {
                this.zSteps = Integer.parseInt(value);
                continue;
            }
            if (key.startsWith("SiteSelection")) {
                row = Integer.parseInt(key.substring(13)) - 1;
                mapping = value.split(",");
                for (col = 0; col < xFields; ++col) {
                    this.fieldMap[row][col] = Boolean.parseBoolean(mapping[col].trim());
                }
                continue;
            }
            if (key.equals("Waves")) {
                this.doChannels = Boolean.parseBoolean(value.toLowerCase());
                continue;
            }
            if (key.equals("NWavelengths")) {
                this.wavelengths = new String[Integer.parseInt(value)];
                continue;
            }
            if (!key.startsWith("WaveName")) continue;
            int index = Integer.parseInt(key.substring(8)) - 1;
            this.wavelengths[index] = value.replaceAll("\"", "");
        }
        if (xFields == 1 && yFields == 1) {
            this.fieldMap[0][0] = true;
        }
        for (int row = 0; row < this.fieldMap.length; ++row) {
            for (int col = 0; col < this.fieldMap[row].length; ++col) {
                if (!this.fieldMap[row][col]) continue;
                ++this.fieldCount;
            }
        }
    }

    protected String getPlateName(String id) {
        String plateName = new Location(id).getAbsolutePath();
        plateName = plateName.substring(0, plateName.lastIndexOf(".")) + "_";
        return plateName;
    }

    protected void findPixelsFiles() throws FormatException {
        String plateName = this.getPlateName(this.currentId);
        for (int row = 0; row < this.wellFiles.length; ++row) {
            for (int col = 0; col < this.wellFiles[row].length; ++col) {
                if (this.wellFiles[row][col] == null) continue;
                ++this.wellCount;
                String base = plateName + FormatTools.getWellName((int)row, (int)col);
                this.wellFiles[row][col][0] = base + ".pnl";
                this.logFiles[row][col] = base + "_scan.log";
            }
        }
    }

    private int getWell(int seriesIndex) {
        int wellIndex = seriesIndex / this.fieldCount;
        int counter = -1;
        for (int row = 0; row < this.wellFiles.length; ++row) {
            for (int col = 0; col < this.wellFiles[row].length; ++col) {
                if (this.wellFiles[row][col] != null) {
                    ++counter;
                }
                if (counter != wellIndex) continue;
                return row * this.wellFiles[row].length + col;
            }
        }
        return -1;
    }

    protected int getWellRow(int seriesIndex) {
        int well = this.getWell(seriesIndex);
        return well / this.wellFiles[0].length;
    }

    protected int getWellColumn(int seriesIndex) {
        int well = this.getWell(seriesIndex);
        return well % this.wellFiles[0].length;
    }

    private String getFile(int seriesIndex, int no) {
        int row = this.getWellRow(seriesIndex);
        int col = this.getWellColumn(seriesIndex);
        int field = seriesIndex % this.fieldCount;
        if (this.wellFiles[row][col].length == 0) {
            return this.wellFiles[row][col][0];
        }
        int imageCount = this.wellFiles[row][col].length / this.fieldCount;
        if (field * imageCount + no < this.wellFiles[row][col].length) {
            if (this.subdirectories && this.getDimensionOrder() != null) {
                int[] coords = this.getZCTCoords(no);
                int planeIndex = coords[1];
                planeIndex += this.getSizeC() * field;
                planeIndex += this.getSizeC() * this.fieldCount * coords[0];
                return this.wellFiles[row][col][planeIndex += this.getSizeC() * this.fieldCount * this.getSizeZ() * coords[2]];
            }
            return this.wellFiles[row][col][field * imageCount + no];
        }
        if (field < this.wellFiles[row][col].length) {
            return this.wellFiles[row][col][field];
        }
        if (imageCount == 0 && this.wellFiles[row][col].length == 1) {
            return this.wellFiles[row][col][0];
        }
        return null;
    }

    protected void parseWellLogFile(int wellIndex, loci.formats.meta.MetadataStore store) throws IOException {
        String[] lines;
        int seriesIndex = wellIndex * this.fieldCount;
        int row = this.getWellRow(seriesIndex);
        int col = this.getWellColumn(seriesIndex);
        int well = row * this.wellFiles[0].length + col;
        String logFile = this.logFiles[row][col];
        if (!new Location(logFile).exists()) {
            return;
        }
        LOGGER.debug("Parsing log file for well {}", (Object)FormatTools.getWellName((int)row, (int)col));
        int oldSeries = this.getSeries();
        this.setSeries(seriesIndex);
        String data = DataTools.readFile(logFile);
        for (String line : lines = data.split("\n")) {
            String[] tokens;
            int end;
            int separator = (line = line.trim()).indexOf(58);
            if (separator < 0) continue;
            String key = line.substring(0, separator).trim();
            String value = line.substring(separator + 1).trim();
            this.addSeriesMeta(key, value);
            if (key.equals("Date")) {
                String date = DateTools.formatDate(value, DATE_FORMAT);
                for (int field = 0; field < this.fieldCount; ++field) {
                    if (date == null) continue;
                    int imageIndex = seriesIndex + field;
                    this.timestamps.put(imageIndex, new Timestamp(date));
                    store.setImageAcquisitionDate(this.timestamps.get(imageIndex), imageIndex);
                }
                continue;
            }
            if (key.equals("Scan Origin")) {
                String[] axes = value.split(",");
                Double posX = Double.parseDouble(axes[0]);
                Double posY = Double.parseDouble(axes[1]);
                for (int fieldRow = 0; fieldRow < this.fieldMap.length; ++fieldRow) {
                    for (int fieldCol = 0; fieldCol < this.fieldMap[fieldRow].length; ++fieldCol) {
                        if (!this.fieldMap[fieldRow][fieldCol] || this.wellFiles[row][col] == null) continue;
                        int field = fieldRow * this.fieldMap[fieldRow].length + fieldCol;
                        Length px = new Length((Number)posX, UNITS.REFERENCEFRAME);
                        Length py = new Length((Number)posY, UNITS.REFERENCEFRAME);
                        store.setWellSamplePositionX(px, 0, well, field);
                        store.setWellSamplePositionY(py, 0, well, field);
                        this.addGlobalMetaList("X position for position", axes[0]);
                        this.addGlobalMetaList("Y position for position", axes[1]);
                    }
                }
                continue;
            }
            if (key.equals("Scan Area")) {
                int s = value.indexOf(120);
                if (s <= 0) continue;
                end = value.indexOf(" ", s + 2);
                Double xSize = Double.parseDouble(value.substring(0, s).trim());
                Double ySize = Double.parseDouble(value.substring(s + 1, end).trim());
                Length x = FormatTools.getPhysicalSizeX((Double)(xSize / (double)this.getSizeX()));
                Length y = FormatTools.getPhysicalSizeY((Double)(ySize / (double)this.getSizeY()));
                for (int field = 0; field < this.fieldCount; ++field) {
                    int index = seriesIndex + field;
                    if (x != null) {
                        store.setPixelsPhysicalSizeX(x, index);
                    }
                    if (y == null) continue;
                    store.setPixelsPhysicalSizeY(y, index);
                }
                continue;
            }
            if (!key.startsWith("Channel")) continue;
            int start = key.indexOf(32) + 1;
            end = key.indexOf(" ", start);
            if (end < 0) {
                end = key.length();
            }
            int index = Integer.parseInt(key.substring(start, end)) - 1;
            for (String token : tokens = value.split(",")) {
                int slash;
                if ((token = token.trim()).startsWith("gain")) {
                    String instrumentID = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
                    Double gain = Double.parseDouble(token.replaceAll("gain ", ""));
                    String detectorID = MetadataTools.createLSID((String)"Detector", (int[])new int[]{0, 0});
                    store.setInstrumentID(instrumentID, 0);
                    store.setDetectorID(detectorID, 0, 0);
                    for (int field = 0; field < this.fieldCount; ++field) {
                        store.setImageInstrumentRef(instrumentID, seriesIndex + field);
                        store.setDetectorSettingsGain(gain, seriesIndex + field, index);
                        store.setDetectorSettingsID(detectorID, seriesIndex + field, index);
                    }
                    continue;
                }
                if (!token.startsWith("EX") || (slash = token.indexOf(47)) <= 0) continue;
                String ex = token.substring(0, slash).trim();
                String em = token.substring(slash + 1).trim();
                if (ex.indexOf(32) > 0) {
                    ex = ex.substring(ex.indexOf(32) + 1);
                }
                if (em.indexOf(32) > 0 && (em = em.substring(em.indexOf(32) + 1)).indexOf(32) > 0) {
                    em = em.substring(0, em.indexOf(32));
                }
                Double emission = Double.parseDouble(em);
                Double excitation = Double.parseDouble(ex);
                Length exWave = FormatTools.getExcitationWavelength((Double)excitation);
                Length emWave = FormatTools.getEmissionWavelength((Double)emission);
                for (int field = 0; field < this.fieldCount; ++field) {
                    if (exWave != null) {
                        store.setChannelExcitationWavelength(exWave, seriesIndex + field, index);
                    }
                    if (emWave == null) continue;
                    store.setChannelEmissionWavelength(emWave, seriesIndex + field, index);
                }
            }
        }
        this.setSeries(oldSeries);
    }

    protected IFormatReader getReader(String file2, boolean omexml) throws FormatException, IOException {
        DeltavisionReader pnl = new DeltavisionReader();
        this.initReader((IFormatReader)pnl, file2, omexml);
        return pnl;
    }

    protected void initReader(IFormatReader reader, String file2, boolean omexml) throws FormatException, IOException {
        if (omexml) {
            OMEXMLMetadata metadata;
            try {
                metadata = this.service.createOMEXMLMetadata();
            }
            catch (ServiceException exc) {
                throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
            }
            reader.setMetadataStore((loci.formats.meta.MetadataStore)metadata);
        }
        reader.setId(file2);
    }

    protected boolean foundHTDFile(String name) {
        Location current = new Location(name).getAbsoluteFile();
        Location parent = current.getParentFile();
        String htdName = current.getName();
        while (htdName.indexOf(95) > 0) {
            if (!new Location(parent, (htdName = htdName.substring(0, htdName.lastIndexOf("_"))) + ".htd").exists() && !new Location(parent, htdName + ".HTD").exists()) continue;
            return CellWorxReader.checkSuffix((String)name, (String)"log") || this.isGroupFiles();
        }
        return false;
    }
}

