/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.logviewer.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ui.logviewer.api.listener.LoggerListener;
import qupath.ui.logviewer.api.manager.LoggerManager;
import qupath.ui.logviewer.logging.logback.LogbackAppender;

public class LogbackManager
implements LoggerManager {
    private static final Logger slf4jLogger = LoggerFactory.getLogger(LogbackManager.class);
    private static final ch.qos.logback.classic.Logger logbackRootLogger = LogbackManager.getRootLogger();
    private static final Map<LoggerListener, Appender<ILoggingEvent>> appenders = new HashMap<LoggerListener, Appender<ILoggingEvent>>();

    public void addListener(LoggerListener listener) {
        if (!appenders.containsKey(listener)) {
            if (logbackRootLogger != null) {
                LogbackAppender appender = new LogbackAppender(listener);
                appender.setName("LogViewer");
                appender.setContext((Context)logbackRootLogger.getLoggerContext());
                appender.start();
                appenders.put(listener, (Appender<ILoggingEvent>)appender);
                logbackRootLogger.addAppender((Appender)appender);
            } else {
                slf4jLogger.warn("Cannot add appender to root logger using logback!");
            }
        }
    }

    public void removeListener(LoggerListener listener) {
        if (logbackRootLogger != null && appenders.containsKey(listener)) {
            Appender<ILoggingEvent> appender = appenders.remove(listener);
            logbackRootLogger.detachAppender(appender);
        }
    }

    public void setRootLogLevel(org.slf4j.event.Level level) {
        if (logbackRootLogger != null) {
            logbackRootLogger.setLevel(Level.convertAnSLF4JLevel((org.slf4j.event.Level)level));
        }
    }

    public org.slf4j.event.Level getRootLogLevel() {
        return logbackRootLogger == null ? null : LogbackManager.toSlf4JLevel(logbackRootLogger.getLevel());
    }

    public boolean isFrameworkActive() {
        return LoggerFactory.getILoggerFactory() instanceof LoggerContext;
    }

    static org.slf4j.event.Level toSlf4JLevel(Level level) {
        return switch (level.toInt()) {
            case Integer.MIN_VALUE, 5000 -> org.slf4j.event.Level.TRACE;
            case 10000 -> org.slf4j.event.Level.DEBUG;
            case 20000 -> org.slf4j.event.Level.INFO;
            case 30000 -> org.slf4j.event.Level.WARN;
            case 40000, Integer.MAX_VALUE -> org.slf4j.event.Level.ERROR;
            default -> null;
        };
    }

    static ch.qos.logback.classic.Logger getRootLogger() {
        LoggerContext context = LogbackManager.getLoggerContext();
        return context == null ? null : context.getLogger("ROOT");
    }

    static LoggerContext getLoggerContext() {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        if (iLoggerFactory instanceof LoggerContext) {
            LoggerContext context = (LoggerContext)iLoggerFactory;
            return context;
        }
        return null;
    }
}

