/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.CellListManager;
import org.fxmisc.flowless.CellPositioner;
import org.fxmisc.flowless.EndOffEnd;
import org.fxmisc.flowless.HorizontalHelper;
import org.fxmisc.flowless.MinDistanceTo;
import org.fxmisc.flowless.Navigator;
import org.fxmisc.flowless.OrientationHelper;
import org.fxmisc.flowless.SizeTracker;
import org.fxmisc.flowless.StartOffStart;
import org.fxmisc.flowless.VerticalHelper;
import org.fxmisc.flowless.VirtualFlowHit;
import org.fxmisc.flowless.Virtualized;
import org.reactfx.collection.MemoizationList;
import org.reactfx.util.Lists;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class VirtualFlow<T, C extends Cell<T, ?>>
extends Region
implements Virtualized {
    private final ObservableList<T> items;
    private final OrientationHelper orientation;
    private final CellListManager<T, C> cellListManager;
    private final SizeTracker sizeTracker;
    private final CellPositioner<T, C> cellPositioner;
    private final Navigator<T, C> navigator;
    private final StyleableObjectProperty<Gravity> gravity = new StyleableObjectProperty<Gravity>(){

        public Object getBean() {
            return VirtualFlow.this;
        }

        public String getName() {
            return "gravity";
        }

        public CssMetaData<? extends Styleable, Gravity> getCssMetaData() {
            return GRAVITY;
        }
    };
    private final Var<Double> breadthOffset0 = Var.newSimpleVar((Object)0.0);
    private final Var<Double> breadthOffset = this.breadthOffset0.asVar(this::setBreadthOffset);
    private final Var<Double> lengthOffsetEstimate;
    private static final CssMetaData<VirtualFlow, Gravity> GRAVITY = new CssMetaData<VirtualFlow, Gravity>("-flowless-gravity", StyleConverter.getEnumConverter(Gravity.class), Gravity.FRONT){

        public boolean isSettable(VirtualFlow virtualFlow) {
            return !virtualFlow.gravity.isBound();
        }

        public StyleableProperty<Gravity> getStyleableProperty(VirtualFlow virtualFlow) {
            return virtualFlow.gravity;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public static <T, C extends Cell<T, ?>> VirtualFlow<T, C> createHorizontal(ObservableList<T> items, Function<? super T, ? extends C> cellFactory) {
        return VirtualFlow.createHorizontal(items, cellFactory, Gravity.FRONT);
    }

    public static <T, C extends Cell<T, ?>> VirtualFlow<T, C> createHorizontal(ObservableList<T> items, Function<? super T, ? extends C> cellFactory, Gravity gravity) {
        return new VirtualFlow<T, C>(items, cellFactory, new HorizontalHelper(), gravity);
    }

    public static <T, C extends Cell<T, ?>> VirtualFlow<T, C> createVertical(ObservableList<T> items, Function<? super T, ? extends C> cellFactory) {
        return VirtualFlow.createVertical(items, cellFactory, Gravity.FRONT);
    }

    public static <T, C extends Cell<T, ?>> VirtualFlow<T, C> createVertical(ObservableList<T> items, Function<? super T, ? extends C> cellFactory, Gravity gravity) {
        return new VirtualFlow<T, C>(items, cellFactory, new VerticalHelper(), gravity);
    }

    public Var<Double> breadthOffsetProperty() {
        return this.breadthOffset;
    }

    public Val<Double> totalBreadthEstimateProperty() {
        return this.sizeTracker.maxCellBreadthProperty();
    }

    public Var<Double> lengthOffsetEstimateProperty() {
        return this.lengthOffsetEstimate;
    }

    private VirtualFlow(ObservableList<T> items, Function<? super T, ? extends C> cellFactory, OrientationHelper orientation, Gravity gravity) {
        this.getStyleClass().add((Object)"virtual-flow");
        this.items = items;
        this.orientation = orientation;
        this.cellListManager = new CellListManager<T, C>((Node)this, items, cellFactory);
        this.gravity.set((Object)gravity);
        MemoizationList<C> cells = this.cellListManager.getLazyCellList();
        this.sizeTracker = new SizeTracker(orientation, (ObservableObjectValue<Bounds>)this.layoutBoundsProperty(), cells);
        this.cellPositioner = new CellPositioner<T, C>(this.cellListManager, orientation, this.sizeTracker);
        this.navigator = new Navigator<T, C>(this.cellListManager, this.cellPositioner, orientation, (ObjectProperty<Gravity>)this.gravity, this.sizeTracker);
        this.getChildren().add(this.navigator);
        this.clipProperty().bind((ObservableValue)Val.map((ObservableValue)this.layoutBoundsProperty(), b -> new Rectangle(b.getWidth(), b.getHeight())));
        this.lengthOffsetEstimate = this.sizeTracker.lengthOffsetEstimateProperty().asVar(this::setLengthOffset);
        this.addEventHandler(ScrollEvent.ANY, se -> {
            this.scrollXBy(-se.getDeltaX());
            this.scrollYBy(-se.getDeltaY());
            se.consume();
        });
    }

    public void dispose() {
        this.navigator.dispose();
        this.sizeTracker.dispose();
        this.cellListManager.dispose();
    }

    public C getCell(int itemIndex) {
        Lists.checkIndex((int)itemIndex, (int)this.items.size());
        return this.cellPositioner.getSizedCell(itemIndex);
    }

    public Optional<C> getCellIfVisible(int itemIndex) {
        this.layout();
        return this.cellPositioner.getCellIfVisible(itemIndex);
    }

    public ObservableList<C> visibleCells() {
        this.layout();
        return this.cellListManager.getLazyCellList().memoizedItems();
    }

    public Val<Double> totalLengthEstimateProperty() {
        return this.sizeTracker.totalLengthEstimateProperty();
    }

    public Bounds cellToViewport(C cell, Bounds bounds) {
        return cell.getNode().localToParent(bounds);
    }

    public Point2D cellToViewport(C cell, Point2D point) {
        return cell.getNode().localToParent(point);
    }

    public Point2D cellToViewport(C cell, double x, double y) {
        return cell.getNode().localToParent(x, y);
    }

    protected void layoutChildren() {
        double oldLayoutBreadth;
        do {
            oldLayoutBreadth = this.sizeTracker.getCellLayoutBreadth();
            this.orientation.resize((Node)this.navigator, oldLayoutBreadth, this.sizeTracker.getViewportLength());
            this.navigator.layout();
        } while (oldLayoutBreadth != this.sizeTracker.getCellLayoutBreadth());
        double viewBreadth = this.orientation.breadth((Node)this);
        double navigatorBreadth = this.orientation.breadth((Node)this.navigator);
        double totalBreadth = (Double)this.breadthOffset0.getValue();
        double breadthDifference = navigatorBreadth - totalBreadth;
        if (breadthDifference < viewBreadth) {
            double adjustment = viewBreadth - breadthDifference;
            this.orientation.relocate((Node)this.navigator, -(totalBreadth - adjustment), 0.0);
            this.breadthOffset0.setValue((Object)(totalBreadth - adjustment));
        } else {
            this.orientation.relocate((Node)this.navigator, -((Double)this.breadthOffset0.getValue()).doubleValue(), 0.0);
        }
    }

    protected final double computePrefWidth(double height) {
        switch (this.getContentBias()) {
            case HORIZONTAL: {
                return this.computePrefBreadth();
            }
            case VERTICAL: {
                return this.computePrefLength(height);
            }
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    protected final double computePrefHeight(double width) {
        switch (this.getContentBias()) {
            case HORIZONTAL: {
                return this.computePrefLength(width);
            }
            case VERTICAL: {
                return this.computePrefBreadth();
            }
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    private double computePrefBreadth() {
        return 100.0;
    }

    private double computePrefLength(double breadth) {
        return 100.0;
    }

    public final Orientation getContentBias() {
        return this.orientation.getContentBias();
    }

    void scrollLength(double deltaLength) {
        this.setLengthOffset((Double)this.lengthOffsetEstimate.getValue() + deltaLength);
    }

    void scrollBreadth(double deltaBreadth) {
        this.setBreadthOffset((Double)this.breadthOffset0.getValue() + deltaBreadth);
    }

    @Override
    public void scrollXBy(double deltaX) {
        this.orientation.scrollHorizontallyBy(this, deltaX);
    }

    @Override
    public void scrollYBy(double deltaY) {
        this.orientation.scrollVerticallyBy(this, deltaY);
    }

    @Override
    public void scrollXToPixel(double pixel) {
        this.orientation.scrollHorizontallyToPixel(this, pixel);
    }

    @Override
    public void scrollYToPixel(double pixel) {
        this.orientation.scrollVerticallyToPixel(this, pixel);
    }

    @Override
    public Val<Double> totalWidthEstimateProperty() {
        return this.orientation.widthEstimateProperty(this);
    }

    @Override
    public Val<Double> totalHeightEstimateProperty() {
        return this.orientation.heightEstimateProperty(this);
    }

    @Override
    public Var<Double> estimatedScrollXProperty() {
        return this.orientation.estimatedScrollXProperty(this);
    }

    @Override
    public Var<Double> estimatedScrollYProperty() {
        return this.orientation.estimatedScrollYProperty(this);
    }

    public VirtualFlowHit<C> hit(double x, double y) {
        double bOff = this.orientation.getX(x, y);
        double lOff = this.orientation.getY(x, y);
        bOff += ((Double)this.breadthOffset0.getValue()).doubleValue();
        if (this.items.isEmpty()) {
            return this.orientation.hitAfterCells(bOff, lOff);
        }
        this.layout();
        int firstVisible = this.getFirstVisibleIndex();
        firstVisible = this.navigator.fillBackwardFrom0(firstVisible, lOff);
        C firstCell = this.cellPositioner.getVisibleCell(firstVisible);
        int lastVisible = this.getLastVisibleIndex();
        lastVisible = this.navigator.fillForwardFrom0(lastVisible, lOff);
        C lastCell = this.cellPositioner.getVisibleCell(lastVisible);
        if (lOff < this.orientation.minY((Cell<?, ?>)firstCell)) {
            return this.orientation.hitBeforeCells(bOff, lOff - this.orientation.minY((Cell<?, ?>)firstCell));
        }
        if (lOff >= this.orientation.maxY((Cell<?, ?>)lastCell)) {
            return this.orientation.hitAfterCells(bOff, lOff - this.orientation.maxY((Cell<?, ?>)lastCell));
        }
        for (int i = firstVisible; i <= lastVisible; ++i) {
            C cell = this.cellPositioner.getVisibleCell(i);
            if (!(lOff < this.orientation.maxY((Cell<?, ?>)cell))) continue;
            return this.orientation.cellHit(i, cell, bOff, lOff - this.orientation.minY((Cell<?, ?>)cell));
        }
        throw new AssertionError((Object)"unreachable code");
    }

    public void show(double viewportOffset) {
        if (viewportOffset < 0.0) {
            this.navigator.scrollCurrentPositionBy(viewportOffset);
        } else if (viewportOffset > this.sizeTracker.getViewportLength()) {
            this.navigator.scrollCurrentPositionBy(viewportOffset - this.sizeTracker.getViewportLength());
        }
    }

    public void show(int itemIdx) {
        this.navigator.setTargetPosition(new MinDistanceTo(itemIdx));
    }

    public void showAsFirst(int itemIdx) {
        this.navigator.setTargetPosition(new StartOffStart(itemIdx, 0.0));
    }

    public void showAsLast(int itemIdx) {
        this.navigator.setTargetPosition(new EndOffEnd(itemIdx, 0.0));
    }

    public void showAtOffset(int itemIdx, double offset) {
        this.navigator.setTargetPosition(new StartOffStart(itemIdx, offset));
    }

    public void show(int itemIndex, Bounds region) {
        this.navigator.showLengthRegion(itemIndex, this.orientation.minY(region), this.orientation.maxY(region));
        this.showBreadthRegion(this.orientation.minX(region), this.orientation.maxX(region));
    }

    public int getFirstVisibleIndex() {
        return this.navigator.getFirstVisibleIndex();
    }

    public int getLastVisibleIndex() {
        return this.navigator.getLastVisibleIndex();
    }

    private void showBreadthRegion(double fromX, double toX) {
        double bOff = (Double)this.breadthOffset0.getValue();
        double spaceBefore = fromX - bOff;
        double spaceAfter = this.sizeTracker.getViewportBreadth() - toX + bOff;
        if (spaceBefore < 0.0 && spaceAfter > 0.0) {
            double shift = Math.min(-spaceBefore, spaceAfter);
            this.setBreadthOffset(bOff - shift);
        } else if (spaceAfter < 0.0 && spaceBefore > 0.0) {
            double shift = Math.max(spaceAfter, -spaceBefore);
            this.setBreadthOffset(bOff - shift);
        }
    }

    void setLengthOffset(double pixels) {
        double diff;
        double total = (Double)this.totalLengthEstimateProperty().getOrElse((Object)0.0);
        double length = this.sizeTracker.getViewportLength();
        double max = Math.max(total - length, 0.0);
        double current = Math.round((Double)this.lengthOffsetEstimate.getValue());
        if (pixels > max) {
            pixels = max;
        }
        if (pixels < 0.0) {
            pixels = 0.0;
        }
        if ((diff = pixels - current) != 0.0) {
            if (Math.abs(diff) <= length) {
                this.navigator.scrollCurrentPositionBy(diff);
            } else {
                this.jumpToAbsolutePosition(pixels);
            }
        }
    }

    void setBreadthOffset(double pixels) {
        double total = (Double)this.totalBreadthEstimateProperty().getValue();
        double breadth = this.sizeTracker.getViewportBreadth();
        double max = Math.max(total - breadth, 0.0);
        double current = (Double)this.breadthOffset0.getValue();
        if (pixels > max) {
            pixels = max;
        }
        if (pixels < 0.0) {
            pixels = 0.0;
        }
        if (pixels != current) {
            this.breadthOffset0.setValue((Object)pixels);
            this.requestLayout();
        }
    }

    private void jumpToAbsolutePosition(double pixels) {
        if (this.items.isEmpty()) {
            return;
        }
        double avgLen = this.sizeTracker.getAverageLengthEstimate().orElse(0.0);
        if (avgLen == 0.0) {
            return;
        }
        int first = (int)Math.floor(pixels / avgLen);
        double firstOffset = -(pixels % avgLen);
        if (first < this.items.size()) {
            this.navigator.setTargetPosition(new StartOffStart(first, firstOffset));
        } else {
            this.navigator.setTargetPosition(new EndOffEnd(this.items.size() - 1, 0.0));
        }
    }

    public ObjectProperty<Gravity> gravityProperty() {
        return this.gravity;
    }

    public Gravity getGravity() {
        return (Gravity)((Object)this.gravity.get());
    }

    public void setGravity(Gravity gravity) {
        this.gravity.set((Object)gravity);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return VirtualFlow.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<VirtualFlow, Gravity>> styleables = new ArrayList<CssMetaData<VirtualFlow, Gravity>>(Region.getClassCssMetaData());
        styleables.add(GRAVITY);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    public static enum Gravity {
        FRONT,
        REAR;

    }
}

