/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.util.NoSuchElementException;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.control.IndexRange;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.HorizontalHelper;
import org.fxmisc.flowless.OrientationHelper;
import org.reactfx.Subscription;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.MemoizationList;
import org.reactfx.value.Val;
import org.reactfx.value.ValBase;

final class SizeTracker {
    private final OrientationHelper orientation;
    private final ObservableObjectValue<Bounds> viewportBounds;
    private final MemoizationList<? extends Cell<?, ?>> cells;
    private final MemoizationList<Double> breadths;
    private final Val<Double> maxKnownMinBreadth;
    private final Val<Double> breadthForCells;
    private final MemoizationList<Double> lengths;
    private final Val<Double> averageLengthEstimate;
    private final Val<Double> totalLengthEstimate;
    private final Val<Double> lengthOffsetEstimate;
    private final Subscription subscription;

    public SizeTracker(OrientationHelper orientation, ObservableObjectValue<Bounds> viewportBounds, MemoizationList<? extends Cell<?, ?>> lazyCells) {
        this.orientation = orientation;
        this.viewportBounds = viewportBounds;
        this.cells = lazyCells;
        this.breadths = lazyCells.map(orientation::minBreadth).memoize();
        this.maxKnownMinBreadth = this.breadths.memoizedItems().reduce(Math::max).orElseConst((Object)0.0);
        this.breadthForCells = Val.combine(this.maxKnownMinBreadth, viewportBounds, (a, b) -> Math.max(a, orientation.breadth((Bounds)b)));
        Val lengthFn = (orientation instanceof HorizontalHelper ? this.breadthForCells : SizeTracker.avoidFalseInvalidations(this.breadthForCells)).map(breadth -> cell -> orientation.prefLength((Cell<?, ?>)cell, (double)breadth));
        this.lengths = this.cells.mapDynamic((ObservableValue)lengthFn).memoize();
        LiveList knownLengths = this.lengths.memoizedItems();
        Val sumOfKnownLengths = knownLengths.reduce((a, b) -> a + b).orElseConst((Object)0.0);
        Val knownLengthCount = knownLengths.sizeProperty();
        this.averageLengthEstimate = Val.create(() -> {
            for (int i = 0; i < this.cells.getMemoizedCount(); ++i) {
                try {
                    int j = this.cells.indexOfMemoizedItem(i);
                    this.lengths.force(j, j + 1);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            int count = (Integer)knownLengthCount.getValue();
            return count == 0 ? null : Double.valueOf((Double)sumOfKnownLengths.getValue() / (double)count);
        }, (Observable[])new Observable[]{sumOfKnownLengths, knownLengthCount});
        this.totalLengthEstimate = Val.combine(this.averageLengthEstimate, (ObservableValue)this.cells.sizeProperty(), (avg, n) -> (double)n.intValue() * avg);
        Val firstVisibleIndex = Val.create(() -> this.cells.getMemoizedCount() == 0 ? null : Integer.valueOf(this.cells.indexOfMemoizedItem(0)), (Observable[])new Observable[]{this.cells, this.cells.memoizedItems()});
        Val knownLengthCountBeforeFirstVisibleCell = Val.create(() -> firstVisibleIndex.getOpt().map(i -> this.lengths.getMemoizedCountBefore(Math.min(i, this.lengths.size()))).orElse(0), (Observable[])new Observable[]{this.lengths, firstVisibleIndex});
        Val totalKnownLengthBeforeFirstVisibleCell = knownLengths.reduceRange((ObservableValue)knownLengthCountBeforeFirstVisibleCell.map(n -> new IndexRange(0, n.intValue())), (a, b) -> a + b).orElseConst((Object)0.0);
        Val unknownLengthEstimateBeforeFirstVisibleCell = Val.combine((ObservableValue)firstVisibleIndex.orElseConst((Object)0), (ObservableValue)knownLengthCountBeforeFirstVisibleCell, this.averageLengthEstimate, (firstIdx, knownCnt, avgLen) -> (double)(firstIdx - knownCnt) * avgLen);
        Val firstCellMinY = this.cells.memoizedItems().collapse(visCells -> visCells.isEmpty() ? null : (Cell)visCells.get(0)).flatMap(orientation::minYProperty);
        this.lengthOffsetEstimate = Val.combine((ObservableValue)totalKnownLengthBeforeFirstVisibleCell, (ObservableValue)unknownLengthEstimateBeforeFirstVisibleCell, (ObservableValue)firstCellMinY, (a, b, minY) -> Math.round(a + b - minY)).orElseConst((Object)0.0);
        this.subscription = Subscription.multi((Subscription[])new Subscription[]{this.totalLengthEstimate.pin(), this.lengthOffsetEstimate.pin()});
    }

    private static <T> Val<T> avoidFalseInvalidations(final Val<T> src) {
        return new ValBase<T>(){

            protected Subscription connect() {
                return src.observeChanges((obs, oldVal, newVal) -> this.invalidate());
            }

            protected T computeValue() {
                return src.getValue();
            }
        };
    }

    public void dispose() {
        this.subscription.unsubscribe();
    }

    public Val<Double> maxCellBreadthProperty() {
        return this.maxKnownMinBreadth;
    }

    public double getViewportBreadth() {
        return this.orientation.breadth((Bounds)this.viewportBounds.get());
    }

    public double getViewportLength() {
        return this.orientation.length((Bounds)this.viewportBounds.get());
    }

    public Val<Double> averageLengthEstimateProperty() {
        return this.averageLengthEstimate;
    }

    public Optional<Double> getAverageLengthEstimate() {
        return this.averageLengthEstimate.getOpt();
    }

    public Val<Double> totalLengthEstimateProperty() {
        return this.totalLengthEstimate;
    }

    public Val<Double> lengthOffsetEstimateProperty() {
        return this.lengthOffsetEstimate;
    }

    public double breadthFor(int itemIndex) {
        assert (this.cells.isMemoized(itemIndex));
        this.breadths.force(itemIndex, itemIndex + 1);
        return (Double)this.breadthForCells.getValue();
    }

    public void forgetSizeOf(int itemIndex) {
        this.breadths.forget(itemIndex, itemIndex + 1);
        this.lengths.forget(itemIndex, itemIndex + 1);
    }

    public double lengthFor(int itemIndex) {
        return (Double)this.lengths.get(itemIndex);
    }

    public double getCellLayoutBreadth() {
        return (Double)this.breadthForCells.getValue();
    }
}

