/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;

public class TypeConverter {
    private static final int BYTE = 0;
    private static final int SHORT = 1;
    private static final int FLOAT = 2;
    private static final int RGB = 3;
    private ImageProcessor ip;
    private int type;
    boolean doScaling = true;
    int width;
    int height;

    public TypeConverter(ImageProcessor ip, boolean doScaling) {
        this.ip = ip;
        this.doScaling = doScaling;
        this.type = ip instanceof ByteProcessor ? 0 : (ip instanceof ShortProcessor ? 1 : (ip instanceof FloatProcessor ? 2 : 3));
        this.width = ip.getWidth();
        this.height = ip.getHeight();
    }

    public ImageProcessor convertToByte() {
        switch (this.type) {
            case 0: {
                return this.ip;
            }
            case 1: {
                return this.convertShortToByte();
            }
            case 2: {
                return this.convertFloatToByte();
            }
            case 3: {
                return this.convertRGBToByte();
            }
        }
        return null;
    }

    ByteProcessor convertShortToByte() {
        int size = this.width * this.height;
        short[] pixels16 = (short[])this.ip.getPixels();
        byte[] pixels8 = new byte[size];
        if (this.doScaling) {
            int min = (int)this.ip.getMin();
            int max = (int)this.ip.getMax();
            double scale = 256.0 / (double)(max - min + 1);
            for (int i = 0; i < size; ++i) {
                int value = (pixels16[i] & 0xFFFF) - min;
                if (value < 0) {
                    value = 0;
                }
                if ((value = (int)((double)value * scale + 0.5)) > 255) {
                    value = 255;
                }
                pixels8[i] = (byte)value;
            }
            return new ByteProcessor(this.width, this.height, pixels8, this.ip.getCurrentColorModel());
        }
        for (int i = 0; i < size; ++i) {
            int value = pixels16[i] & 0xFFFF;
            if (value > 255) {
                value = 255;
            }
            pixels8[i] = (byte)value;
        }
        return new ByteProcessor(this.width, this.height, pixels8, this.ip.getColorModel());
    }

    ByteProcessor convertFloatToByte() {
        if (this.doScaling) {
            byte[] pixels8 = this.ip.create8BitImage();
            ByteProcessor bp = new ByteProcessor(this.ip.getWidth(), this.ip.getHeight(), pixels8);
            bp.setColorModel(this.ip.getColorModel());
            return bp;
        }
        ByteProcessor bp = new ByteProcessor(this.width, this.height);
        bp.setPixels(0, (FloatProcessor)this.ip);
        bp.setColorModel(this.ip.getColorModel());
        bp.resetMinAndMax();
        return bp;
    }

    ByteProcessor convertRGBToByte() {
        if (this.ip.getNChannels() == 1 && this.doScaling) {
            byte[] pixels8 = this.ip.create8BitImage();
            ByteProcessor bp = new ByteProcessor(this.ip.getWidth(), this.ip.getHeight(), pixels8);
            bp.setColorModel(this.ip.getColorModel());
            return bp;
        }
        int[] pixels32 = (int[])this.ip.getPixels();
        double[] w = ColorProcessor.getWeightingFactors();
        if (((ColorProcessor)this.ip).getRGBWeights() != null) {
            w = ((ColorProcessor)this.ip).getRGBWeights();
        }
        double rw = w[0];
        double gw = w[1];
        double bw = w[2];
        byte[] pixels8 = new byte[this.width * this.height];
        for (int i = 0; i < this.width * this.height; ++i) {
            int c = pixels32[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            pixels8[i] = (byte)((double)r * rw + (double)g * gw + (double)b * bw + 0.5);
        }
        return new ByteProcessor(this.width, this.height, pixels8, null);
    }

    FloatProcessor convertRGBToFloat() {
        int[] pixels = (int[])this.ip.getPixels();
        double[] w = ColorProcessor.getWeightingFactors();
        if (((ColorProcessor)this.ip).getRGBWeights() != null) {
            w = ((ColorProcessor)this.ip).getRGBWeights();
        }
        double rw = w[0];
        double gw = w[1];
        double bw = w[2];
        float[] pixels32 = new float[this.width * this.height];
        for (int i = 0; i < this.width * this.height; ++i) {
            int c = pixels[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            pixels32[i] = (float)((double)r * rw + (double)g * gw + (double)b * bw);
        }
        return new FloatProcessor(this.width, this.height, pixels32);
    }

    public ImageProcessor convertToShort() {
        switch (this.type) {
            case 0: {
                return this.convertByteToShort();
            }
            case 1: {
                return this.ip;
            }
            case 2: {
                return this.convertFloatToShort();
            }
            case 3: {
                this.ip = this.convertRGBToByte();
                return this.convertByteToShort();
            }
        }
        return null;
    }

    ShortProcessor convertByteToShort() {
        byte[] pixels8 = (byte[])this.ip.getPixels();
        short[] pixels16 = new short[this.width * this.height];
        boolean j = false;
        for (int i = 0; i < this.width * this.height; ++i) {
            pixels16[i] = (short)(pixels8[i] & 0xFF);
        }
        return new ShortProcessor(this.width, this.height, pixels16, this.ip.getColorModel());
    }

    ShortProcessor convertFloatToShort() {
        float[] pixels32 = (float[])this.ip.getPixels();
        short[] pixels16 = new short[this.width * this.height];
        double min = this.ip.getMin();
        double max = this.ip.getMax();
        double scale = max - min == 0.0 ? 1.0 : 65535.0 / (max - min);
        boolean j = false;
        for (int i = 0; i < this.width * this.height; ++i) {
            double value = this.doScaling ? ((double)pixels32[i] - min) * scale : (double)pixels32[i];
            if (value < 0.0) {
                value = 0.0;
            }
            if (value > 65535.0) {
                value = 65535.0;
            }
            pixels16[i] = (short)(value + 0.5);
        }
        return new ShortProcessor(this.width, this.height, pixels16, this.ip.getColorModel());
    }

    public ImageProcessor convertToFloat(float[] ctable) {
        switch (this.type) {
            case 0: {
                return this.convertByteToFloat(ctable);
            }
            case 1: {
                return this.convertShortToFloat(ctable);
            }
            case 2: {
                return this.ip;
            }
            case 3: {
                return this.convertRGBToFloat();
            }
        }
        return null;
    }

    FloatProcessor convertByteToFloat(float[] cTable) {
        int i;
        int n = this.width * this.height;
        byte[] pixels8 = (byte[])this.ip.getPixels();
        float[] pixels32 = new float[n];
        if (cTable != null && cTable.length == 256) {
            for (i = 0; i < n; ++i) {
                pixels32[i] = cTable[pixels8[i] & 0xFF];
            }
        } else {
            for (i = 0; i < n; ++i) {
                pixels32[i] = pixels8[i] & 0xFF;
            }
        }
        ColorModel cm = this.ip.getColorModel();
        return new FloatProcessor(this.width, this.height, pixels32, cm);
    }

    FloatProcessor convertShortToFloat(float[] cTable) {
        int i;
        short[] pixels16 = (short[])this.ip.getPixels();
        float[] pixels32 = new float[this.width * this.height];
        if (cTable != null && cTable.length == 65536) {
            for (i = 0; i < this.width * this.height; ++i) {
                pixels32[i] = cTable[pixels16[i] & 0xFFFF];
            }
        } else {
            for (i = 0; i < this.width * this.height; ++i) {
                pixels32[i] = pixels16[i] & 0xFFFF;
            }
        }
        ColorModel cm = this.ip.getColorModel();
        return new FloatProcessor(this.width, this.height, pixels32, cm);
    }

    public ImageProcessor convertToRGB() {
        if (this.type == 3) {
            return this.ip;
        }
        ImageProcessor ip2 = this.ip.convertToByte(this.doScaling);
        return new ColorProcessor(ip2.createImage());
    }
}

