/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.Arrow;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.plugin.Binner;
import ij.plugin.Colors;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.ImageMath;
import ij.process.AutoThresholder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import ij.process.PolygonFiller;
import ij.process.ShortProcessor;
import ij.process.TypeConverter;
import ij.util.Java2;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Random;

public abstract class ImageProcessor
implements Cloneable {
    public static final int BLACK = -16777216;
    public static final double NO_THRESHOLD = -808080.0;
    public static final int LEFT_JUSTIFY = 0;
    public static final int CENTER_JUSTIFY = 1;
    public static final int RIGHT_JUSTIFY = 2;
    public static final int ISODATA = 0;
    public static final int ISODATA2 = 1;
    public static final int UPDATE_RED = 1;
    public static final int UPDATE_GREEN = 2;
    public static final int UPDATE_BLUE = 3;
    public static final int SET_FIRST_CHANNEL = 4;
    public static final int SUM_PROJECTION = 5;
    public static final int MAX_PROJECTION = 6;
    public static final int MIN_PROJECTION = 7;
    public static final int INVERT_PROJECTION = 8;
    public static final int NEAREST_NEIGHBOR = 0;
    public static final int NONE = 0;
    public static final int BILINEAR = 1;
    public static final int BICUBIC = 2;
    public static final int BLUR_MORE = 0;
    public static final int FIND_EDGES = 1;
    public static final int MEDIAN_FILTER = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;
    public static final int CONVOLVE = 5;
    public static final int RED_LUT = 0;
    public static final int BLACK_AND_WHITE_LUT = 1;
    public static final int NO_LUT_UPDATE = 2;
    public static final int OVER_UNDER_LUT = 3;
    static final int INVERT = 0;
    static final int FILL = 1;
    static final int ADD = 2;
    static final int MULT = 3;
    static final int AND = 4;
    static final int OR = 5;
    static final int XOR = 6;
    static final int GAMMA = 7;
    static final int LOG = 8;
    static final int MINIMUM = 9;
    static final int MAXIMUM = 10;
    static final int SQR = 11;
    static final int SQRT = 12;
    static final int EXP = 13;
    static final int ABS = 14;
    static final int SET = 15;
    static final String WRONG_LENGTH = "width*height!=pixels.length";
    int fgColor = 0;
    protected int lineWidth = 1;
    protected int cx;
    protected int cy;
    protected Font font = IJ.font12;
    protected FontMetrics fontMetrics;
    protected boolean antialiasedText;
    protected boolean boldFont;
    private static String[] interpolationMethods;
    private static int overRed;
    private static int overGreen;
    private static int overBlue;
    private static int underRed;
    private static int underGreen;
    private static int underBlue;
    private static boolean useBicubic;
    private int sliceNumber;
    private Overlay overlay;
    private boolean noReset;
    private boolean histogram16;
    private boolean addOne;
    private boolean fillColorSet;
    ProgressBar progressBar;
    protected int width;
    protected int snapshotWidth;
    protected int height;
    protected int snapshotHeight;
    protected int roiX;
    protected int roiY;
    protected int roiWidth;
    protected int roiHeight;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    boolean snapshotCopyMode;
    ImageProcessor mask;
    protected ColorModel baseCM;
    protected ColorModel cm;
    protected byte[] rLUT1;
    protected byte[] gLUT1;
    protected byte[] bLUT1;
    protected byte[] rLUT2;
    protected byte[] gLUT2;
    protected byte[] bLUT2;
    protected boolean interpolate;
    protected int interpolationMethod = 0;
    protected double minThreshold = -808080.0;
    protected double maxThreshold = -808080.0;
    protected int histogramSize = 256;
    protected double histogramMin;
    protected double histogramMax;
    protected float[] cTable;
    protected boolean lutAnimation;
    protected MemoryImageSource source;
    protected Image img;
    protected boolean newPixels;
    protected Color drawingColor = Color.black;
    protected int clipXMin;
    protected int clipXMax;
    protected int clipYMin;
    protected int clipYMax;
    protected int justification = 0;
    protected int lutUpdateMode;
    protected WritableRaster raster;
    protected BufferedImage image;
    protected BufferedImage fmImage;
    protected Graphics2D fmGraphics;
    protected ColorModel cm2;
    protected SampleModel sampleModel;
    protected static IndexColorModel defaultColorModel;
    protected boolean minMaxSet;
    protected static double seed;
    protected static Random rnd;
    protected boolean inversionTested = false;
    protected boolean invertedLut;
    private ImageProcessor dotMask;
    static final double a = 0.5;
    private byte[] bytes;
    private int[] reds;
    private int[] greens;
    private int[] blues;

    protected void showProgress(double percentDone) {
        if (this.progressBar != null) {
            this.progressBar.show(percentDone);
        }
    }

    protected void hideProgress() {
        this.showProgress(1.0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBitDepth() {
        Object pixels = this.getPixels();
        if (pixels == null) {
            return 0;
        }
        if (pixels instanceof byte[]) {
            return 8;
        }
        if (pixels instanceof short[]) {
            return 16;
        }
        if (pixels instanceof int[]) {
            return 24;
        }
        if (pixels instanceof float[]) {
            return 32;
        }
        return 0;
    }

    public ColorModel getColorModel() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.baseCM != null) {
            return this.baseCM;
        }
        return this.cm;
    }

    private IndexColorModel getIndexColorModel() {
        ColorModel cm2 = this.baseCM;
        if (cm2 == null) {
            cm2 = this.cm;
        }
        if (cm2 != null && cm2 instanceof IndexColorModel) {
            return (IndexColorModel)cm2;
        }
        return null;
    }

    public ColorModel getCurrentColorModel() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        return this.cm;
    }

    public void setColorModel(ColorModel cm) {
        if (cm != null && !(cm instanceof IndexColorModel)) {
            throw new IllegalArgumentException("IndexColorModel required");
        }
        if (cm != null && cm instanceof LUT) {
            cm = ((LUT)cm).getColorModel();
        }
        this.cm = cm;
        this.baseCM = null;
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.inversionTested = false;
        this.minThreshold = -808080.0;
    }

    public LUT getLut() {
        ColorModel cm2 = this.getColorModel();
        if (cm2 != null && cm2 instanceof IndexColorModel) {
            return new LUT((IndexColorModel)cm2, this.getMin(), this.getMax());
        }
        return null;
    }

    public void setLut(LUT lut) {
        if (lut == null) {
            this.setColorModel(null);
        } else {
            this.setColorModel(lut.getColorModel());
            if (lut.min != 0.0 || lut.max != 0.0) {
                this.setMinAndMax(lut.min, lut.max);
            }
        }
    }

    protected void makeDefaultColorModel() {
        this.cm = this.getDefaultColorModel();
    }

    public void invertLut() {
        IndexColorModel icm = (IndexColorModel)this.getColorModel();
        int mapSize = icm.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        byte[] reds2 = new byte[mapSize];
        byte[] greens2 = new byte[mapSize];
        byte[] blues2 = new byte[mapSize];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        for (int i = 0; i < mapSize; ++i) {
            reds2[i] = (byte)(reds[mapSize - i - 1] & 0xFF);
            greens2[i] = (byte)(greens[mapSize - i - 1] & 0xFF);
            blues2[i] = (byte)(blues[mapSize - i - 1] & 0xFF);
        }
        IndexColorModel cm = new IndexColorModel(8, mapSize, reds2, greens2, blues2);
        double min = this.getMin();
        double max = this.getMax();
        this.setColorModel(cm);
        this.setMinAndMax(min, max);
    }

    public int getBestIndex(Color c) {
        IndexColorModel icm;
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.minThreshold != -808080.0) {
            double saveMin = this.getMinThreshold();
            double saveMax = this.getMaxThreshold();
            this.resetThreshold();
            icm = (IndexColorModel)this.cm;
            this.setThreshold(saveMin, saveMax, this.lutUpdateMode);
        } else {
            icm = (IndexColorModel)this.cm;
        }
        int mapSize = icm.getMapSize();
        byte[] rLUT = new byte[mapSize];
        byte[] gLUT = new byte[mapSize];
        byte[] bLUT = new byte[mapSize];
        icm.getReds(rLUT);
        icm.getGreens(gLUT);
        icm.getBlues(bLUT);
        int minDistance = Integer.MAX_VALUE;
        int minIndex = 0;
        int r1 = c.getRed();
        int g1 = c.getGreen();
        int b1 = c.getBlue();
        if ((r1 != g1 || g1 != b1 || r1 != b1) && icm == defaultColorModel) {
            double[] w = ColorProcessor.getWeightingFactors();
            r1 = (int)Math.round((double)(3 * r1) * w[0]);
            g1 = (int)Math.round((double)(3 * g1) * w[1]);
            b1 = (int)Math.round((double)(3 * b1) * w[2]);
        }
        for (int i = 0; i < mapSize; ++i) {
            int r2 = rLUT[i] & 0xFF;
            int g2 = gLUT[i] & 0xFF;
            int b2 = bLUT[i] & 0xFF;
            int distance = (r2 - r1) * (r2 - r1) + (g2 - g1) * (g2 - g1) + (b2 - b1) * (b2 - b1);
            if (distance < minDistance) {
                minDistance = distance;
                minIndex = i;
            }
            if ((double)minDistance == 0.0) break;
        }
        return minIndex;
    }

    public boolean isInvertedLut() {
        if (this.inversionTested) {
            return this.invertedLut;
        }
        IndexColorModel icm = this.getIndexColorModel();
        if (icm == null) {
            return false;
        }
        boolean hasAscendingStep = false;
        for (int i = 1; i < 255; ++i) {
            int v2;
            int v1 = icm.getRed(i - 1) + icm.getGreen(i - 1) + icm.getBlue(i - 1);
            if (v1 >= (v2 = icm.getRed(i) + icm.getGreen(i) + icm.getBlue(i))) continue;
            hasAscendingStep = true;
            break;
        }
        this.invertedLut = !hasAscendingStep;
        this.inversionTested = true;
        return this.invertedLut;
    }

    public boolean isGrayscale() {
        return !this.isColorLut();
    }

    public boolean isColorLut() {
        IndexColorModel icm = this.getIndexColorModel();
        if (icm == null) {
            return false;
        }
        int mapSize = icm.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        boolean isColor = false;
        for (int i = 0; i < mapSize; ++i) {
            if (reds[i] == greens[i] && greens[i] == blues[i]) continue;
            isColor = true;
            break;
        }
        return isColor;
    }

    public boolean isPseudoColorLut() {
        boolean isPseudoColor;
        IndexColorModel icm = this.getIndexColorModel();
        if (icm == null) {
            return false;
        }
        if (this.getMinThreshold() != -808080.0) {
            return true;
        }
        int mapSize = icm.getMapSize();
        if (mapSize != 256) {
            return false;
        }
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        int r2 = reds[0] & 0xFF;
        int g2 = greens[0] & 0xFF;
        int b2 = blues[0] & 0xFF;
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < mapSize; ++i) {
            int r = reds[i] & 0xFF;
            int g = greens[i] & 0xFF;
            int b = blues[i] & 0xFF;
            int d = r - r2;
            sum += (double)d;
            sum2 += (double)(d * d);
            d = g - g2;
            sum += (double)d;
            sum2 += (double)(d * d);
            d = b - b2;
            sum += (double)d;
            sum2 += (double)(d * d);
            r2 = r;
            g2 = g;
            b2 = b;
        }
        double stdDev = (768.0 * sum2 - sum * sum) / 768.0;
        stdDev = stdDev > 0.0 ? Math.sqrt(stdDev / 767.0) : 0.0;
        boolean bl = isPseudoColor = stdDev < 20.0;
        if ((int)stdDev == 67) {
            isPseudoColor = true;
        }
        return isPseudoColor;
    }

    public boolean isDefaultLut() {
        IndexColorModel icm;
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if ((icm = this.getIndexColorModel()) == null) {
            return false;
        }
        int mapSize = icm.getMapSize();
        if (mapSize != 256) {
            return false;
        }
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        boolean isDefault = true;
        for (int i = 0; i < mapSize; ++i) {
            if ((reds[i] & 0xFF) == i && (greens[i] & 0xFF) == i && (blues[i] & 0xFF) == i) continue;
            isDefault = false;
            break;
        }
        return isDefault;
    }

    public abstract void setColor(Color var1);

    public void setColor(String color) {
        this.setColor(Colors.decode(color, Color.white));
    }

    public void setBackgroundColor(Color color) {
    }

    public void setColor(int value) {
        this.setValue(value);
    }

    public void setColor(double value) {
        this.setValue(value);
    }

    public abstract void setValue(double var1);

    public abstract double getForegroundValue();

    public boolean fillValueSet() {
        return this.fillColorSet;
    }

    public abstract void setBackgroundValue(double var1);

    public abstract double getBackgroundValue();

    public void setGlobalForegroundColor() {
        double value = Toolbar.getForegroundValue();
        if (Double.isNaN(value)) {
            this.setColor(Toolbar.getForegroundColor());
        } else {
            this.setValue(value);
        }
    }

    public void setGlobalBackgroundColor() {
        double value = Toolbar.getBackgroundValue();
        if (Double.isNaN(value)) {
            this.setColor(Toolbar.getBackgroundColor());
        } else {
            this.setValue(value);
        }
    }

    public abstract double getMin();

    public abstract double getMax();

    public abstract void setMinAndMax(double var1, double var3);

    public void resetMinAndMax() {
    }

    public void setThreshold(double minThreshold, double maxThreshold) {
        this.setThreshold(minThreshold, maxThreshold, 2);
    }

    public void setThreshold(double minThreshold, double maxThreshold, int lutUpdate) {
        if (this instanceof ColorProcessor) {
            return;
        }
        this.minThreshold = minThreshold;
        this.maxThreshold = maxThreshold;
        this.lutUpdateMode = lutUpdate;
        if (minThreshold == -808080.0) {
            this.resetThreshold();
            return;
        }
        if (lutUpdate == 2) {
            return;
        }
        if (this.rLUT1 == null) {
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            this.baseCM = this.cm;
            IndexColorModel m = (IndexColorModel)this.cm;
            this.rLUT1 = new byte[256];
            this.gLUT1 = new byte[256];
            this.bLUT1 = new byte[256];
            m.getReds(this.rLUT1);
            m.getGreens(this.gLUT1);
            m.getBlues(this.bLUT1);
            this.rLUT2 = new byte[256];
            this.gLUT2 = new byte[256];
            this.bLUT2 = new byte[256];
        }
        int t1 = (int)minThreshold;
        int t2 = (int)maxThreshold;
        if (lutUpdate == 0) {
            for (int i = 0; i < 256; ++i) {
                if (i >= t1 && i <= t2) {
                    this.rLUT2[i] = -1;
                    this.gLUT2[i] = 0;
                    this.bLUT2[i] = 0;
                    continue;
                }
                this.rLUT2[i] = this.rLUT1[i];
                this.gLUT2[i] = this.gLUT1[i];
                this.bLUT2[i] = this.bLUT1[i];
            }
        } else if (lutUpdate == 1) {
            int foreground = Prefs.blackBackground ? -1 : 0;
            byte background = (byte)(255 - foreground);
            for (int i = 0; i < 256; ++i) {
                if (i >= t1 && i <= t2) {
                    this.rLUT2[i] = foreground;
                    this.gLUT2[i] = foreground;
                    this.bLUT2[i] = foreground;
                    continue;
                }
                this.rLUT2[i] = background;
                this.gLUT2[i] = background;
                this.bLUT2[i] = background;
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                if (i >= t1 && i <= t2) {
                    this.rLUT2[i] = this.rLUT1[i];
                    this.gLUT2[i] = this.gLUT1[i];
                    this.bLUT2[i] = this.bLUT1[i];
                    continue;
                }
                if (i > t2) {
                    this.rLUT2[i] = (byte)overRed;
                    this.gLUT2[i] = (byte)overGreen;
                    this.bLUT2[i] = (byte)overBlue;
                    continue;
                }
                this.rLUT2[i] = (byte)underRed;
                this.gLUT2[i] = (byte)underGreen;
                this.bLUT2[i] = (byte)underBlue;
            }
        }
        this.cm = new IndexColorModel(8, 256, this.rLUT2, this.gLUT2, this.bLUT2);
    }

    public void setAutoThreshold(String method) {
        int index;
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        boolean darkBackground = method.contains("dark");
        this.noReset = method.contains("no-reset");
        this.histogram16 = method.contains("16") && this.getBitDepth() == 16;
        this.addOne = !method.contains("16");
        int lut = 0;
        if (method.contains("b&w")) {
            lut = 1;
        }
        if (method.contains("over")) {
            lut = 3;
        }
        if (method.contains("no-lut")) {
            lut = 2;
        }
        if ((index = method.indexOf(" ")) != -1) {
            method = method.substring(0, index);
        }
        this.setAutoThreshold(method, darkBackground, lut);
        this.noReset = false;
    }

    public void setAutoThreshold(String mString, boolean darkBackground, int lutUpdate) {
        AutoThresholder.Method m = null;
        try {
            m = AutoThresholder.Method.valueOf(AutoThresholder.Method.class, mString);
        }
        catch (Exception e) {
            m = null;
        }
        if (m == null) {
            throw new IllegalArgumentException("Invalid method (\"" + mString + "\")");
        }
        this.setAutoThreshold(m, darkBackground, lutUpdate);
    }

    public void setAutoThreshold(AutoThresholder.Method method, boolean darkBackground) {
        this.setAutoThreshold(method, darkBackground, 0);
    }

    public void setAutoThreshold(AutoThresholder.Method method, boolean darkBackground, int lutUpdate) {
        double upper;
        double lower;
        if (method == null || this instanceof ColorProcessor) {
            return;
        }
        double min = 0.0;
        double max = 0.0;
        boolean notByteData = !(this instanceof ByteProcessor);
        ImageProcessor ip2 = this;
        if (notByteData && !this.histogram16) {
            ImageProcessor mask = ip2.getMask();
            Rectangle rect = ip2.getRoi();
            if (!this.noReset || lutUpdate == 3) {
                ip2.resetMinAndMax();
            }
            this.noReset = false;
            min = ip2.getMin();
            max = ip2.getMax();
            ip2 = ip2.convertToByte(true);
            ip2.setMask(mask);
            ip2.setRoi(rect);
        }
        ImageStatistics stats = ip2.getStats();
        AutoThresholder thresholder = new AutoThresholder();
        thresholder.setBilevelSubractOne(this.addOne);
        int[] histogram = stats.histogram;
        if (this.histogram16 && stats.histogram16 != null) {
            histogram = stats.histogram16;
        }
        int threshold = thresholder.getThreshold(method, histogram);
        double tmax = 255.0;
        if (histogram.length > 256) {
            tmax = 65535.0;
        }
        if (darkBackground) {
            if (this.isInvertedLut()) {
                lower = 0.0;
                upper = threshold;
            } else {
                lower = threshold + (this.addOne ? 1 : 0);
                upper = tmax;
            }
        } else if (this.isInvertedLut()) {
            lower = threshold + (this.addOne ? 1 : 0);
            upper = tmax;
        } else {
            lower = 0.0;
            upper = threshold;
        }
        if (this.histogram16) {
            this.setThreshold(lower, upper, lutUpdate);
        } else {
            if (lower > 255.0) {
                lower = 255.0;
            }
            this.scaleAndSetThreshold(lower, upper, lutUpdate);
        }
    }

    public void setAutoThreshold(int method, int lutUpdate) {
        double upper;
        double lower;
        if (method < 0 || method > 1) {
            throw new IllegalArgumentException("Invalid thresholding method");
        }
        if (this instanceof ColorProcessor) {
            return;
        }
        boolean notByteData = !(this instanceof ByteProcessor);
        ImageProcessor ip2 = this;
        if (notByteData) {
            ImageProcessor mask = ip2.getMask();
            Rectangle rect = ip2.getRoi();
            this.resetMinAndMax();
            ip2 = this.convertToByte(true);
            ip2.setMask(mask);
            ip2.setRoi(rect);
        }
        ImageStatistics stats = ip2.getStats();
        int[] histogram = stats.histogram;
        int originalModeCount = histogram[stats.mode];
        if (method == 1) {
            int maxCount2 = 0;
            for (int i = 0; i < stats.nBins; ++i) {
                if (histogram[i] <= maxCount2 || i == stats.mode) continue;
                maxCount2 = histogram[i];
            }
            int hmax = stats.maxCount;
            if (hmax > maxCount2 * 2 && maxCount2 != 0) {
                histogram[stats.mode] = hmax = (int)((double)maxCount2 * 1.5);
            }
        }
        int threshold = ip2.getAutoThreshold(stats.histogram);
        histogram[stats.mode] = originalModeCount;
        float[] hist = new float[256];
        for (int i = 0; i < 256; ++i) {
            hist[i] = stats.histogram[i];
        }
        FloatProcessor fp = new FloatProcessor(256, 1, hist, null);
        GaussianBlur gb = new GaussianBlur();
        gb.blur1Direction(fp, 2.0, 0.01, true, 0);
        float maxCount = 0.0f;
        float sum = 0.0f;
        int mode = 0;
        for (int i = 0; i < 256; ++i) {
            float count = hist[i];
            sum += count;
            if (!(count > maxCount)) continue;
            maxCount = count;
            mode = i;
        }
        double avg = (double)sum / 256.0;
        if ((double)maxCount / avg > 1.5) {
            if (stats.max - (double)mode > (double)mode - stats.min) {
                lower = threshold;
                upper = 255.0;
            } else {
                lower = 0.0;
                upper = threshold;
            }
        } else if (this.isInvertedLut()) {
            lower = threshold;
            upper = 255.0;
        } else {
            lower = 0.0;
            upper = threshold;
        }
        this.scaleAndSetThreshold(lower, upper, lutUpdate);
    }

    public void scaleAndSetThreshold(double lower, double upper, int lutUpdate) {
        int bitDepth = this.getBitDepth();
        if (bitDepth != 8 && lower != -808080.0) {
            double min = this.getMin();
            double max = this.getMax();
            if (max > min) {
                if (lower == 0.0) {
                    if (bitDepth == 32) {
                        lower = Math.min(min, -1.0E30);
                    }
                } else {
                    lower = min + lower / 255.0 * (max - min);
                }
                if (upper == 255.0) {
                    if (bitDepth == 16) {
                        upper = 65535.0;
                    } else if (bitDepth == 32) {
                        upper = Math.max(max, 1.0E30);
                    }
                } else {
                    upper = min + upper / 255.0 * (max - min);
                }
            } else {
                lower = upper = min;
            }
        }
        this.setThreshold(lower, upper, lutUpdate);
    }

    public void resetThreshold() {
        this.minThreshold = -808080.0;
        if (this.baseCM != null) {
            this.cm = this.baseCM;
            this.baseCM = null;
        }
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.inversionTested = false;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public boolean isThreshold() {
        return this.getMinThreshold() != -808080.0;
    }

    public int getLutUpdateMode() {
        return this.lutUpdateMode;
    }

    public void setBinaryThreshold() {
        if (!(this instanceof ByteProcessor)) {
            return;
        }
        double t1 = 255.0;
        double t2 = 255.0;
        boolean invertedLut = this.isInvertedLut();
        if (invertedLut && Prefs.blackBackground || !invertedLut && !Prefs.blackBackground) {
            t1 = 0.0;
            t2 = 0.0;
        }
        this.setThreshold(t1, t2, 2);
    }

    public void resetBinaryThreshold() {
        if (this.minThreshold == this.maxThreshold && this.lutUpdateMode == 2) {
            this.resetThreshold();
        }
    }

    public void setRoi(Rectangle roi) {
        if (roi == null) {
            this.resetRoi();
        } else {
            this.setRoi(roi.x, roi.y, roi.width, roi.height);
        }
    }

    public void setRoi(int x, int y, int rwidth, int rheight) {
        if (x < 0 || y < 0 || x + rwidth > this.width || y + rheight > this.height) {
            Rectangle r1 = new Rectangle(x, y, rwidth, rheight);
            Rectangle r2 = r1.intersection(new Rectangle(0, 0, this.width, this.height));
            if (r2.width <= 0 || r2.height <= 0) {
                this.roiX = 0;
                this.roiY = 0;
                this.roiWidth = 0;
                this.roiHeight = 0;
                this.xMin = 0;
                this.xMax = 0;
                this.yMin = 0;
                this.yMax = 0;
                this.mask = null;
                return;
            }
            if (this.mask != null && this.mask.getWidth() == rwidth && this.mask.getHeight() == rheight) {
                Rectangle r3 = new Rectangle(0, 0, r2.width, r2.height);
                if (x < 0) {
                    r3.x = -x;
                }
                if (y < 0) {
                    r3.y = -y;
                }
                this.mask.setRoi(r3);
                if (this.mask != null) {
                    this.mask = this.mask.crop();
                }
            }
            this.roiX = r2.x;
            this.roiY = r2.y;
            this.roiWidth = r2.width;
            this.roiHeight = r2.height;
        } else {
            this.roiX = x;
            this.roiY = y;
            this.roiWidth = rwidth;
            this.roiHeight = rheight;
        }
        if (this.mask != null && (this.mask.getWidth() != this.roiWidth || this.mask.getHeight() != this.roiHeight)) {
            this.mask = null;
        }
        this.xMin = Math.max(this.roiX, 1);
        this.xMax = Math.min(this.roiX + this.roiWidth - 1, this.width - 2);
        this.yMin = Math.max(this.roiY, 1);
        this.yMax = Math.min(this.roiY + this.roiHeight - 1, this.height - 2);
    }

    public void setRoi(Roi roi) {
        if (roi == null) {
            this.resetRoi();
        } else if (roi instanceof PointRoi && roi.size() == 1) {
            this.setMask(null);
            Polygon p = roi.getPolygon();
            this.setRoi(p.xpoints[0], p.ypoints[0], 1, 1);
        } else {
            this.setMask(roi.getMask());
            this.setRoi(roi.getBounds());
        }
    }

    public void setRoi(Polygon roi) {
        if (roi == null) {
            this.resetRoi();
            return;
        }
        Rectangle bounds = roi.getBounds();
        int i = 0;
        while (i < roi.npoints) {
            int n = i;
            roi.xpoints[n] = roi.xpoints[n] - bounds.x;
            int n2 = i++;
            roi.ypoints[n2] = roi.ypoints[n2] - bounds.y;
        }
        PolygonFiller pf = new PolygonFiller();
        pf.setPolygon(roi.xpoints, roi.ypoints, roi.npoints);
        ImageProcessor mask = pf.getMask(bounds.width, bounds.height);
        this.setMask(mask);
        this.setRoi(bounds);
        int i2 = 0;
        while (i2 < roi.npoints) {
            int n = i2;
            roi.xpoints[n] = roi.xpoints[n] + bounds.x;
            int n3 = i2++;
            roi.ypoints[n3] = roi.ypoints[n3] + bounds.y;
        }
    }

    public void resetRoi() {
        this.roiX = 0;
        this.roiY = 0;
        this.roiWidth = this.width;
        this.roiHeight = this.height;
        this.xMin = 1;
        this.xMax = this.width - 2;
        this.yMin = 1;
        this.yMax = this.height - 2;
        this.mask = null;
        this.clipXMin = 0;
        this.clipXMax = this.width - 1;
        this.clipYMin = 0;
        this.clipYMax = this.height - 1;
    }

    public Rectangle getRoi() {
        return new Rectangle(this.roiX, this.roiY, this.roiWidth, this.roiHeight);
    }

    public void setMask(ImageProcessor mask) {
        this.mask = mask;
    }

    public ImageProcessor getMask() {
        return this.mask;
    }

    public byte[] getMaskArray() {
        return this.mask != null ? (byte[])this.mask.getPixels() : null;
    }

    public void setProgressBar(ProgressBar pb) {
        this.progressBar = pb;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
        this.interpolationMethod = interpolate ? (useBicubic ? 2 : 1) : 0;
    }

    public void setInterpolationMethod(int method) {
        if (method < 0 || method > 2) {
            throw new IllegalArgumentException("Invalid interpolation method");
        }
        this.interpolationMethod = method;
        this.interpolate = method != 0;
    }

    public int getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public static String[] getInterpolationMethods() {
        if (interpolationMethods == null) {
            interpolationMethods = new String[]{"None", "Bilinear", "Bicubic"};
        }
        return interpolationMethods;
    }

    public boolean getInterpolate() {
        return this.interpolate;
    }

    public boolean isKillable() {
        return false;
    }

    private void process(int op, double value) {
        double SCALE = 255.0 / Math.log(255.0);
        int[] lut = new int[256];
        for (int i = 0; i < 256; ++i) {
            int v;
            switch (op) {
                case 0: {
                    v = 255 - i;
                    break;
                }
                case 1: {
                    v = this.fgColor;
                    break;
                }
                case 15: {
                    v = (int)value;
                    break;
                }
                case 2: {
                    v = i + (int)value;
                    break;
                }
                case 3: {
                    v = (int)Math.round((double)i * value);
                    break;
                }
                case 4: {
                    v = i & (int)value;
                    break;
                }
                case 5: {
                    v = i | (int)value;
                    break;
                }
                case 6: {
                    v = i ^ (int)value;
                    break;
                }
                case 7: {
                    v = (int)(Math.exp(Math.log((double)i / 255.0) * value) * 255.0);
                    break;
                }
                case 8: {
                    if (i == 0) {
                        v = 0;
                        break;
                    }
                    v = (int)(Math.log(i) * SCALE);
                    break;
                }
                case 13: {
                    v = (int)Math.exp((double)i / SCALE);
                    break;
                }
                case 11: {
                    v = i * i;
                    break;
                }
                case 12: {
                    v = (int)Math.sqrt(i);
                    break;
                }
                case 9: {
                    if ((double)i < value) {
                        v = (int)value;
                        break;
                    }
                    v = i;
                    break;
                }
                case 10: {
                    if ((double)i > value) {
                        v = (int)value;
                        break;
                    }
                    v = i;
                    break;
                }
                default: {
                    v = i;
                }
            }
            if (v < 0) {
                v = 0;
            }
            if (v > 255) {
                v = 255;
            }
            lut[i] = v;
        }
        this.applyTable(lut);
    }

    public double[] getLine(double x1, double y1, double x2, double y2) {
        double yinc;
        double dx = x2 - x1;
        double dy = y2 - y1;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        double xinc = n > 0 ? dx / (double)n : 0.0;
        double d = yinc = n > 0 ? dy / (double)n : 0.0;
        if (!(xinc == 0.0 && n == this.height || yinc == 0.0 && n == this.width)) {
            ++n;
        }
        double[] data = new double[n];
        double rx = x1;
        double ry = y1;
        if (this.interpolate) {
            for (int i = 0; i < n; ++i) {
                data[i] = this.getInterpolatedValue(rx, ry);
                rx += xinc;
                ry += yinc;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                data[i] = this.getPixelValue((int)Math.round(rx), (int)Math.round(ry));
                rx += xinc;
                ry += yinc;
            }
        }
        return data;
    }

    public void getRow(int x, int y, int[] data, int length) {
        for (int i = 0; i < length; ++i) {
            data[i] = this.getPixel(x++, y);
        }
    }

    public float[] getRow(int x, int y, float[] data, int length) {
        if (data == null) {
            data = new float[length];
        }
        for (int i = 0; i < length; ++i) {
            data[i] = this.getf(x++, y);
        }
        return data;
    }

    public void getColumn(int x, int y, int[] data, int length) {
        for (int i = 0; i < length; ++i) {
            data[i] = this.getPixel(x, y++);
        }
    }

    public float[] getColumn(int x, int y, float[] data, int length) {
        if (data == null) {
            data = new float[length];
        }
        for (int i = 0; i < length; ++i) {
            data[i] = this.getf(x, y++);
        }
        return data;
    }

    public void putRow(int x, int y, int[] data, int length) {
        for (int i = 0; i < length; ++i) {
            this.putPixel(x++, y, data[i]);
        }
    }

    public void putRow(int x, int y, float[] data, int length) {
        for (int i = 0; i < length; ++i) {
            this.setf(x++, y, data[i]);
        }
    }

    public void putColumn(int x, int y, int[] data, int length) {
        for (int i = 0; i < length; ++i) {
            this.putPixel(x, y++, data[i]);
        }
    }

    public void putColumn(int x, int y, float[] data, int length) {
        for (int i = 0; i < length; ++i) {
            this.setf(x, y++, data[i]);
        }
    }

    public void moveTo(int x, int y) {
        this.cx = x;
        this.cy = y;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
        if (this.lineWidth < 1) {
            this.lineWidth = 1;
        }
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void lineTo(int x2, int y2) {
        int xMin = this.clipXMin - this.lineWidth / 2 - 1;
        int xMax = this.clipXMax + this.lineWidth / 2 + 1;
        int yMin = this.clipYMin - this.lineWidth / 2 - 1;
        int yMax = this.clipYMax + this.lineWidth / 2 + 1;
        int dx = x2 - this.cx;
        int dy = y2 - this.cy;
        int absdx = dx >= 0 ? dx : -dx;
        int absdy = dy >= 0 ? dy : -dy;
        int n = absdy > absdx ? absdy : absdx;
        double xinc = dx != 0 ? (double)dx / (double)n : 0.0;
        double yinc = dy != 0 ? (double)dy / (double)n : 0.0;
        double x = this.cx;
        double y = this.cy;
        this.cx = x2;
        this.cy = y2;
        int i1 = 0;
        if (dx > 0) {
            i1 = Math.max(i1, (int)(((double)xMin - x) / xinc));
        } else if (dx < 0) {
            i1 = Math.max(i1, (int)(((double)xMax - x) / xinc));
        } else if (x < (double)xMin || x > (double)xMax) {
            return;
        }
        if (dy > 0) {
            i1 = Math.max(i1, (int)(((double)yMin - y) / yinc));
        } else if (dy < 0) {
            i1 = Math.max(i1, (int)(((double)yMax - y) / yinc));
        } else if (y < (double)yMin || y > (double)yMax) {
            return;
        }
        int i2 = n;
        if (dx > 0) {
            i2 = Math.min(i2, (int)(((double)xMax - x) / xinc));
        } else if (dx < 0) {
            i2 = Math.min(i2, (int)(((double)xMin - x) / xinc));
        }
        if (dy > 0) {
            i2 = Math.min(i2, (int)(((double)yMax - y) / yinc));
        } else if (dy < 0) {
            i2 = Math.min(i2, (int)(((double)yMin - y) / yinc));
        }
        x += (double)i1 * xinc;
        y += (double)i1 * yinc;
        for (int i = i1; i <= i2; ++i) {
            if (this.lineWidth == 1) {
                this.drawPixel((int)Math.round(x), (int)Math.round(y));
            } else if (this.lineWidth == 2) {
                this.drawDot2((int)Math.round(x), (int)Math.round(y));
            } else {
                this.drawDot((int)Math.round(x), (int)Math.round(y));
            }
            x += xinc;
            y += yinc;
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.moveTo(x1, y1);
        this.lineTo(x2, y2);
    }

    public void drawLine4(int x1, int y1, int x2, int y2) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sgnX = x1 < x2 ? 1 : -1;
        int sgnY = y1 < y2 ? 1 : -1;
        int e = 0;
        for (int i = 0; i < dx + dy; ++i) {
            this.putPixel(x1, y1, this.fgColor);
            int e1 = e + dy;
            int e2 = e - dx;
            if (Math.abs(e1) < Math.abs(e2)) {
                x1 += sgnX;
                e = e1;
                continue;
            }
            y1 += sgnY;
            e = e2;
        }
        this.putPixel(x2, y2, this.fgColor);
    }

    public void drawRect(int x, int y, int width, int height) {
        if (width < 1 || height < 1) {
            return;
        }
        if (this.lineWidth == 1) {
            this.moveTo(x, y);
            this.lineTo(x + width - 1, y);
            this.lineTo(x + width - 1, y + height - 1);
            this.lineTo(x, y + height - 1);
            this.lineTo(x, y);
        } else {
            this.moveTo(x, y);
            this.lineTo(x + width, y);
            this.lineTo(x + width, y + height);
            this.lineTo(x, y + height);
            this.lineTo(x, y);
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        this.setRoi(x, y, width, height);
        this.fill();
        this.resetRoi();
    }

    public void drawOval(int x, int y, int width, int height) {
        if ((long)width * (long)height > 4L * (long)this.width * (long)this.height) {
            return;
        }
        OvalRoi oval = new OvalRoi(x, y, width, height);
        this.drawPolygon(oval.getPolygon());
    }

    public void fillOval(int x, int y, int width, int height) {
        if ((long)width * (long)height > 4L * (long)this.width * (long)this.height) {
            return;
        }
        OvalRoi oval = new OvalRoi(x, y, width, height);
        this.fillPolygon(oval.getPolygon());
    }

    public void drawPolygon(Polygon p) {
        this.moveTo(p.xpoints[0], p.ypoints[0]);
        for (int i = 0; i < p.npoints; ++i) {
            this.lineTo(p.xpoints[i], p.ypoints[i]);
        }
        this.lineTo(p.xpoints[0], p.ypoints[0]);
    }

    public void fillPolygon(Polygon p) {
        this.setRoi(p);
        this.fill(this.getMask());
        this.resetRoi();
    }

    public void drawDot2(int x, int y) {
        this.drawPixel(x, y);
        this.drawPixel(x - 1, y);
        this.drawPixel(x, y - 1);
        this.drawPixel(x - 1, y - 1);
    }

    public void drawDot(int xcenter, int ycenter) {
        double r = (double)this.lineWidth / 2.0;
        int xmin = (int)((double)xcenter - r + 0.5);
        int ymin = (int)((double)ycenter - r + 0.5);
        int xmax = xmin + this.lineWidth;
        int ymax = ymin + this.lineWidth;
        if (xmin < this.clipXMin || ymin < this.clipYMin || xmax > this.clipXMax || ymax > this.clipYMax) {
            double r2 = r * r;
            double xoffset = (double)xmin + (r -= 0.5);
            double yoffset = (double)ymin + r;
            for (int y = ymin; y < ymax; ++y) {
                for (int x = xmin; x < xmax; ++x) {
                    double xx = (double)x - xoffset;
                    double yy = (double)y - yoffset;
                    if (!(xx * xx + yy * yy <= r2)) continue;
                    this.drawPixel(x, y);
                }
            }
        } else {
            if (this.dotMask == null || this.lineWidth != this.dotMask.getWidth()) {
                OvalRoi oval = new OvalRoi(0, 0, this.lineWidth, this.lineWidth);
                this.dotMask = oval.getMask();
            }
            this.setRoi(xmin, ymin, this.lineWidth, this.lineWidth);
            this.fill(this.dotMask);
            this.roiX = 0;
            this.roiY = 0;
            this.roiWidth = this.width;
            this.roiHeight = this.height;
            this.xMin = 1;
            this.xMax = this.width - 2;
            this.yMin = 1;
            this.yMax = this.height - 2;
            this.mask = null;
        }
    }

    private void setupFontMetrics() {
        if (this.fontMetrics == null) {
            if (IJ.font12 == this.font && IJ.isMacOSX()) {
                this.antialiasedText = true;
            }
            if (this instanceof ShortProcessor || this instanceof FloatProcessor) {
                this.antialiasedText = false;
            }
            this.fmImage = new BufferedImage(1, 1, 1);
            this.fmGraphics = (Graphics2D)this.fmImage.getGraphics();
            this.fmGraphics.setFont(this.font);
            Java2.setAntialiasedText(this.fmGraphics, this.antialiasedText);
            this.fontMetrics = this.fmGraphics.getFontMetrics(this.font);
        }
    }

    public void drawString(String s) {
        if (s == null || s.equals("")) {
            return;
        }
        this.setupFontMetrics();
        if (s.indexOf("\n") == -1) {
            this.drawString2(s);
        } else {
            String[] s2 = Tools.split(s, "\n");
            for (int i = 0; i < s2.length; ++i) {
                this.drawString2(s2[i]);
            }
        }
    }

    private void drawString2(String s) {
        int w = this.getStringWidth(s);
        int cxx = this.cx;
        if (this.justification == 1) {
            cxx -= w / 2;
        } else if (this.justification == 2) {
            cxx -= w;
        }
        int h = this.fontMetrics.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = (Graphics2D)((Image)bi).getGraphics();
        FontMetrics metrics = g.getFontMetrics(this.font);
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        g.setFont(this.font);
        if (this.antialiasedText && cxx >= 0 && this.cy - h >= 0) {
            Java2.setAntialiasedText(g, true);
            this.setRoi(cxx, this.cy - h, w, h);
            ImageProcessor ip = this.crop();
            this.resetRoi();
            if (ip.getWidth() == 0 || ip.getHeight() == 0) {
                return;
            }
            g.drawImage(ip.createImage(), 0, 0, null);
            g.setColor(this.drawingColor);
            g.drawString(s, 0, h - descent);
            g.dispose();
            ip = new ColorProcessor(bi);
            if (this instanceof ByteProcessor) {
                ip = ip.convertToByte(false);
                if (this.isInvertedLut()) {
                    ip.invert();
                }
            }
            this.insert(ip, cxx, this.cy - h);
            this.cy += h;
            return;
        }
        Java2.setAntialiasedText(g, false);
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.black);
        g.drawString(s, 0, h - descent);
        g.dispose();
        ColorProcessor ip = new ColorProcessor(bi);
        ImageProcessor textMask = ip.convertToByte(false);
        byte[] mpixels = (byte[])textMask.getPixels();
        textMask.invert();
        if (cxx < this.width && this.cy - h < this.height) {
            this.setMask(textMask);
            this.setRoi(cxx, this.cy - h, w, h);
            this.fill(this.getMask());
        }
        this.resetRoi();
        this.cy += h;
    }

    public void drawString(String s, int x, int y) {
        this.moveTo(x, y);
        this.drawString(s);
    }

    public void drawString(String s, int x, int y, Color background) {
        Color foreground = this.drawingColor;
        FontMetrics metrics = this.getFontMetrics();
        int w = 0;
        int h = metrics.getAscent() + metrics.getDescent();
        int y2 = y;
        if (s.indexOf("\n") != -1) {
            String[] s2 = Tools.split(s, "\n");
            for (int i = 0; i < s2.length; ++i) {
                int w2 = this.getStringWidth(s2[i]);
                if (w2 <= w) continue;
                w = w2;
            }
            int h2 = metrics.getHeight();
            y2 += h2 * (s2.length - 1);
            h += h2 * (s2.length - 1);
        } else {
            w = this.getStringWidth(s);
        }
        int x2 = x;
        if (this.justification == 1) {
            x2 -= w / 2;
        } else if (this.justification == 2) {
            x2 -= w;
        }
        this.setColor(background);
        this.setRoi(x2, y2 - h, w, h);
        this.fill();
        this.resetRoi();
        this.setColor(foreground);
        this.drawString(s, x, y);
    }

    public void setJustification(int justification) {
        if (justification < 0 || justification > 2) {
            justification = 0;
        }
        this.justification = justification;
    }

    public void setFont(Font font) {
        this.font = font;
        this.boldFont = font.isBold();
        if (font.getSize() >= 14 || IJ.isMacOSX()) {
            this.antialiasedText = true;
        }
        this.fontMetrics = null;
        this.setupFontMetrics();
        this.fmGraphics.setFont(font);
        this.fontMetrics = this.fmGraphics.getFontMetrics(font);
    }

    public void setFontSize(int size) {
        this.setFont(this.font.deriveFont(this.font.getStyle(), size));
    }

    public void setAntialiasedText(boolean antialiasedText) {
        this.antialiasedText = antialiasedText && (this instanceof ByteProcessor && this.getMin() == 0.0 && this.getMax() == 255.0 || this instanceof ColorProcessor);
        this.fontMetrics = null;
    }

    public int getStringWidth(String s) {
        Rectangle rect = this.getStringBounds(s);
        return (int)Math.max(this.fontMetrics.getStringBounds(s, this.fmGraphics).getWidth(), ((RectangularShape)rect).getX() + ((RectangularShape)rect).getWidth());
    }

    public Rectangle getStringBounds(String s) {
        this.setupFontMetrics();
        GlyphVector gv = this.font.createGlyphVector(this.fmGraphics.getFontRenderContext(), s);
        Rectangle rect = gv.getPixelBounds(null, 0.0f, -this.fontMetrics.getDescent());
        return new Rectangle((int)((RectangularShape)rect).getX(), (int)((RectangularShape)rect).getY(), (int)((RectangularShape)rect).getWidth(), (int)((RectangularShape)rect).getHeight());
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        this.setupFontMetrics();
        return this.fontMetrics;
    }

    public void smooth() {
        if (this.width > 1) {
            this.filter(0);
        }
    }

    public void sharpen() {
        if (this.width > 1) {
            int[] kernel = new int[]{-1, -1, -1, -1, 12, -1, -1, -1, -1};
            this.convolve3x3(kernel);
        }
    }

    public void findEdges() {
        if (this.width > 1) {
            this.filter(1);
        }
    }

    public abstract void flipVertical();

    public void flipHorizontal() {
        int[] col1 = new int[this.roiHeight];
        int[] col2 = new int[this.roiHeight];
        for (int x = 0; x < this.roiWidth / 2; ++x) {
            this.getColumn(this.roiX + x, this.roiY, col1, this.roiHeight);
            this.getColumn(this.roiX + this.roiWidth - x - 1, this.roiY, col2, this.roiHeight);
            this.putColumn(this.roiX + x, this.roiY, col2, this.roiHeight);
            this.putColumn(this.roiX + this.roiWidth - x - 1, this.roiY, col1, this.roiHeight);
        }
    }

    public ImageProcessor rotateRight() {
        int width2 = this.height;
        int height2 = this.width;
        ImageProcessor ip2 = this.createProcessor(width2, height2);
        int[] arow = new int[this.width];
        for (int row = 0; row < this.height; ++row) {
            this.getRow(0, row, arow, this.width);
            ip2.putColumn(width2 - row - 1, 0, arow, height2);
        }
        return ip2;
    }

    public ImageProcessor rotateLeft() {
        int width2 = this.height;
        int height2 = this.width;
        ImageProcessor ip2 = this.createProcessor(width2, height2);
        int[] arow = new int[this.width];
        int[] arow2 = new int[this.width];
        for (int row = 0; row < this.height; ++row) {
            this.getRow(0, row, arow, this.width);
            for (int i = 0; i < this.width; ++i) {
                arow2[i] = arow[this.width - i - 1];
            }
            ip2.putColumn(row, 0, arow2, height2);
        }
        return ip2;
    }

    public void insert(ImageProcessor ip, int xloc, int yloc) {
        this.copyBits(ip, xloc, yloc, 0);
    }

    public String toString() {
        return "ip[width=" + this.width + ", height=" + this.height + ", bits=" + this.getBitDepth() + ", min=" + this.getMin() + ", max=" + this.getMax() + "]";
    }

    public void fill() {
        this.process(1, 0.0);
    }

    public abstract void fill(ImageProcessor var1);

    public void fill(Roi roi) {
        if (roi != null && roi.isLine()) {
            if (roi instanceof Line && roi.getStrokeWidth() > 1.0f && !(roi instanceof Arrow)) {
                this.fillPolygon(roi.getPolygon());
            } else {
                roi.drawPixels(this);
            }
            return;
        }
        ImageProcessor m = this.getMask();
        Rectangle r = this.getRoi();
        this.setRoi(roi);
        this.fill(this.getMask());
        this.setMask(m);
        this.setRoi(r);
    }

    public void fillOutside(Roi roi) {
        if (roi == null || !roi.isArea()) {
            return;
        }
        ImageProcessor m = this.getMask();
        Rectangle r = this.getRoi();
        ShapeRoi s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
        ShapeRoi s2 = new ShapeRoi(new Roi(0, 0, this.width, this.height));
        this.setRoi(s2.xor(s1));
        this.fill(this.getMask());
        this.setMask(m);
        this.setRoi(r);
    }

    public void draw(Roi roi) {
        roi.drawPixels(this);
    }

    public void drawRoi(Roi roi) {
        Image img = this.createImage();
        Graphics g = img.getGraphics();
        ImagePlus imp = roi.getImage();
        if (imp != null) {
            roi.setImage(null);
            roi.drawOverlay(g);
            roi.setImage(imp);
        } else {
            roi.drawOverlay(g);
        }
    }

    public void drawOverlay(Overlay overlay) {
        Roi[] rois = overlay.toArray();
        for (int i = 0; i < rois.length; ++i) {
            this.drawRoi(rois[i]);
        }
    }

    public void setCalibrationTable(float[] cTable) {
        this.cTable = cTable;
    }

    public float[] getCalibrationTable() {
        return this.cTable;
    }

    public void setHistogramSize(int size) {
        this.histogramSize = size;
        if (this.histogramSize < 1) {
            this.histogramSize = 1;
        }
    }

    public int getHistogramSize() {
        return this.histogramSize;
    }

    public void setHistogramRange(double histMin, double histMax) {
        if (histMin > histMax) {
            histMin = 0.0;
            histMax = 0.0;
        }
        this.histogramMin = histMin;
        this.histogramMax = histMax;
    }

    public double getHistogramMin() {
        return this.histogramMin;
    }

    public double getHistogramMax() {
        return this.histogramMax;
    }

    public abstract Object getPixels();

    public abstract Object getPixelsCopy();

    public abstract int getPixel(int var1, int var2);

    public abstract int get(int var1, int var2);

    public abstract int get(int var1);

    public abstract void set(int var1, int var2, int var3);

    public abstract void set(int var1, int var2);

    public abstract float getf(int var1, int var2);

    public abstract float getf(int var1);

    public abstract void setf(int var1, int var2, float var3);

    public abstract void setf(int var1, float var2);

    public int getPixelCount() {
        return this.width * this.height;
    }

    public int[][] getIntArray() {
        int[][] a = new int[this.width][this.height];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                a[x][y] = this.get(x, y);
            }
        }
        return a;
    }

    public void setIntArray(int[][] a) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.set(x, y, a[x][y]);
            }
        }
    }

    public float[][] getFloatArray() {
        float[][] a = new float[this.width][this.height];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                a[x][y] = this.getf(x, y);
            }
        }
        return a;
    }

    public void setFloatArray(float[][] a) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.setf(x, y, a[x][y]);
            }
        }
    }

    public void getNeighborhood(int x, int y, double[][] arr) {
        int nx = arr.length;
        int ny = arr[0].length;
        int nx2 = (nx - 1) / 2;
        int ny2 = (ny - 1) / 2;
        if (x >= nx2 && y >= ny2 && x < this.width - nx2 - 1 && y < this.height - ny2 - 1) {
            int index = (y - ny2) * this.width + (x - nx2);
            for (int y2 = 0; y2 < ny; ++y2) {
                for (int x2 = 0; x2 < nx; ++x2) {
                    arr[x2][y2] = this.getf(index++);
                }
                index += this.width - nx;
            }
        } else {
            for (int y2 = 0; y2 < ny; ++y2) {
                for (int x2 = 0; x2 < nx; ++x2) {
                    arr[x2][y2] = this.getPixelValue(x2, y2);
                }
            }
        }
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        if (iArray == null) {
            iArray = new int[]{this.getPixel(x, y)};
        }
        return iArray;
    }

    public void putPixel(int x, int y, int[] iArray) {
        this.putPixel(x, y, iArray[0]);
    }

    public abstract double getInterpolatedPixel(double var1, double var3);

    public abstract int getPixelInterpolated(double var1, double var3);

    public final double getInterpolatedValue(double x, double y) {
        if (useBicubic) {
            return this.getBicubicInterpolatedPixel(x, y, this);
        }
        if (x < 0.0 || x >= (double)this.width - 1.0 || y < 0.0 || y >= (double)this.height - 1.0) {
            if (x < -1.0 || x >= (double)this.width || y < -1.0 || y >= (double)this.height) {
                return 0.0;
            }
            return this.getInterpolatedEdgeValue(x, y);
        }
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        if (xFraction < 0.0) {
            xFraction = 0.0;
        }
        if (yFraction < 0.0) {
            yFraction = 0.0;
        }
        double lowerLeft = this.getPixelValue(xbase, ybase);
        double lowerRight = this.getPixelValue(xbase + 1, ybase);
        double upperRight = this.getPixelValue(xbase + 1, ybase + 1);
        double upperLeft = this.getPixelValue(xbase, ybase + 1);
        double upperAverage = upperLeft + xFraction * (upperRight - upperLeft);
        double lowerAverage = lowerLeft + xFraction * (lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    public double getBicubicInterpolatedPixel(double x0, double y0, ImageProcessor ip2) {
        int u0 = (int)Math.floor(x0);
        int v0 = (int)Math.floor(y0);
        if (u0 <= 0 || u0 >= this.width - 2 || v0 <= 0 || v0 >= this.height - 2) {
            return ip2.getBilinearInterpolatedPixel(x0, y0);
        }
        double q = 0.0;
        for (int j = 0; j <= 3; ++j) {
            int v = v0 - 1 + j;
            double p = 0.0;
            for (int i = 0; i <= 3; ++i) {
                int u = u0 - 1 + i;
                p += (double)ip2.get(u, v) * ImageProcessor.cubic(x0 - (double)u);
            }
            q += p * ImageProcessor.cubic(y0 - (double)v);
        }
        return q;
    }

    final double getBilinearInterpolatedPixel(double x, double y) {
        if (x >= -1.0 && x < (double)this.width && y >= -1.0 && y < (double)this.height) {
            int method = this.interpolationMethod;
            this.interpolationMethod = 1;
            double value = this.getInterpolatedPixel(x, y);
            this.interpolationMethod = method;
            return value;
        }
        return this.getBackgroundValue();
    }

    public static final double cubic(double x) {
        if (x < 0.0) {
            x = -x;
        }
        double z = 0.0;
        if (x < 1.0) {
            z = x * x * (x * 1.5 + -2.5) + 1.0;
        } else if (x < 2.0) {
            z = -0.5 * x * x * x + 2.5 * x * x - 4.0 * x + 2.0;
        }
        return z;
    }

    private final double getInterpolatedEdgeValue(double x, double y) {
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        if (xFraction < 0.0) {
            xFraction = 0.0;
        }
        if (yFraction < 0.0) {
            yFraction = 0.0;
        }
        double lowerLeft = this.getEdgeValue(xbase, ybase);
        double lowerRight = this.getEdgeValue(xbase + 1, ybase);
        double upperRight = this.getEdgeValue(xbase + 1, ybase + 1);
        double upperLeft = this.getEdgeValue(xbase, ybase + 1);
        double upperAverage = upperLeft + xFraction * (upperRight - upperLeft);
        double lowerAverage = lowerLeft + xFraction * (lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    private float getEdgeValue(int x, int y) {
        if (x <= 0) {
            x = 0;
        }
        if (x >= this.width) {
            x = this.width - 1;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= this.height) {
            y = this.height - 1;
        }
        return this.getPixelValue(x, y);
    }

    public abstract void putPixel(int var1, int var2, int var3);

    public double getValue(int x, int y) {
        return this.getPixelValue(x, y);
    }

    public abstract float getPixelValue(int var1, int var2);

    public abstract void putPixelValue(int var1, int var2, double var3);

    public abstract void drawPixel(int var1, int var2);

    public abstract void setPixels(Object var1);

    public abstract void copyBits(ImageProcessor var1, int var2, int var3, int var4);

    public abstract void applyTable(int[] var1);

    public void invert() {
        this.process(0, 0.0);
    }

    public void add(int value) {
        this.process(2, value);
    }

    public void add(double value) {
        this.process(2, value);
    }

    public void subtract(double value) {
        this.add(-value);
    }

    public void multiply(double value) {
        this.process(3, value);
    }

    public void set(double value) {
        this.process(15, value);
    }

    public void and(int value) {
        this.process(4, value);
    }

    public void or(int value) {
        this.process(5, value);
    }

    public void xor(int value) {
        this.process(6, value);
    }

    public void gamma(double value) {
        this.process(7, value);
    }

    public void log() {
        this.process(8, 0.0);
    }

    public void ln() {
        this.log();
    }

    public void exp() {
        this.process(13, 0.0);
    }

    public void sqr() {
        this.process(11, 0.0);
    }

    public void sqrt() {
        this.process(12, 0.0);
    }

    public void abs() {
    }

    public void min(double value) {
        this.process(9, value);
    }

    public void max(double value) {
        this.process(10, value);
    }

    public abstract Image createImage();

    public BufferedImage getBufferedImage() {
        BufferedImage bi = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.drawImage(this.createImage(), 0, 0, null);
        return bi;
    }

    public abstract ImageProcessor createProcessor(int var1, int var2);

    public abstract void snapshot();

    public abstract void reset();

    public abstract void swapPixelArrays();

    public abstract void reset(ImageProcessor var1);

    public abstract void setSnapshotPixels(Object var1);

    public abstract Object getSnapshotPixels();

    public abstract void convolve3x3(int[] var1);

    public abstract void filter(int var1);

    public abstract void medianFilter();

    public abstract void noise(double var1);

    public abstract ImageProcessor crop();

    public void threshold(int level1, int level2) {
    }

    public abstract void threshold(int var1);

    public abstract ImageProcessor duplicate();

    public abstract void scale(double var1, double var3);

    public abstract ImageProcessor resize(int var1, int var2);

    public ImageProcessor resize(int dstWidth) {
        return this.resize(dstWidth, (int)((double)dstWidth * ((double)this.roiHeight / (double)this.roiWidth)));
    }

    public ImageProcessor resize(int dstWidth, int dstHeight, boolean useAverging) {
        boolean showProgress;
        Rectangle r = this.getRoi();
        int rWidth = r.width;
        int rHeight = r.height;
        if (dstWidth >= rWidth && dstHeight >= rHeight || !useAverging) {
            return this.resize(dstWidth, dstHeight);
        }
        ImageProcessor ip2 = this.createProcessor(dstWidth, dstHeight);
        FloatProcessor fp = null;
        int channels = this.getNChannels();
        boolean showStatus = this.getProgressIncrement(this.width, this.height) > 0;
        boolean bl = showProgress = showStatus && channels > 1;
        if (showProgress) {
            this.showProgress(0.15);
        }
        for (int channelNumber = 0; channelNumber < channels; ++channelNumber) {
            fp = this.toFloat(channelNumber, fp);
            fp.setInterpolationMethod(this.interpolationMethod);
            fp.setRoi(this.getRoi());
            String msg = showStatus ? " (" + (channelNumber + 1) + "/" + channels + ")" : null;
            FloatProcessor fp2 = fp.downsize(dstWidth, dstHeight, msg);
            ip2.setPixels(channelNumber, fp2);
            if (!showProgress) continue;
            this.showProgress(0.4 + 0.25 * (double)channelNumber);
        }
        if (showProgress) {
            this.showProgress(1.0);
        }
        return ip2;
    }

    protected ImageProcessor resizeLinearly(int width2, int height2) {
        boolean rotate;
        int bitDepth = this.getBitDepth();
        ImageProcessor ip1 = this;
        boolean bl = rotate = this.width == 1;
        if (rotate) {
            ip1 = ip1.rotateLeft();
            int w2 = width2;
            width2 = height2;
            height2 = w2;
        }
        ip1 = ip1.convertToFloat();
        int width1 = ip1.getWidth();
        int height1 = ip1.getHeight();
        ImageProcessor ip2 = ip1.createProcessor(width2, height2);
        double scale = (double)(width1 - 1) / (double)(width2 - 1);
        float[] data1 = new float[width1];
        float[] data2 = new float[width2];
        ip1.getRow(0, 0, data1, width1);
        for (int x = 0; x < width2; ++x) {
            int x1 = (int)((double)x * scale);
            int x2 = x1 + 1;
            if (x2 == width1) {
                x2 = width1 - 1;
            }
            double fraction = (double)x * scale - (double)x1;
            data2[x] = (float)((1.0 - fraction) * (double)data1[x1] + fraction * (double)data1[x2]);
        }
        for (int y = 0; y < height2; ++y) {
            ip2.putRow(0, y, data2, width2);
        }
        if (bitDepth == 8) {
            ip2 = ip2.convertToByte(false);
        } else if (bitDepth == 16) {
            ip2 = ip2.convertToShort(false);
        }
        if (rotate) {
            ip2 = ip2.rotateRight();
        }
        return ip2;
    }

    public ImageProcessor bin(int shrinkFactor) {
        return new Binner().shrink(this, shrinkFactor, shrinkFactor, 0);
    }

    public abstract void rotate(double var1);

    public void translate(double xOffset, double yOffset) {
        boolean integerOffsets;
        ImageProcessor ip2 = this.duplicate();
        ip2.setBackgroundValue(0.0);
        boolean bl = integerOffsets = xOffset == (double)((int)xOffset) && yOffset == (double)((int)yOffset);
        if (integerOffsets || this.interpolationMethod == 0) {
            for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
                for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                    this.putPixel(x, y, ip2.getPixel(x - (int)xOffset, y - (int)yOffset));
                }
            }
        } else if (this.interpolationMethod == 2 && this instanceof ColorProcessor) {
            ((ColorProcessor)this).filterRGB(9, xOffset, yOffset);
        } else {
            for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
                for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                    this.putPixel(x, y, ip2.getPixelInterpolated((double)x - xOffset, (double)y - yOffset));
                }
            }
        }
    }

    public void translate(int xOffset, int yOffset, boolean eraseBackground) {
        this.translate(xOffset, yOffset);
    }

    public abstract int[] getHistogram();

    public int[] getHistogram(int nBins) {
        ImageProcessor ip = (this instanceof ByteProcessor || this instanceof ColorProcessor) && nBins != 256 ? this.convertToShort(false) : this;
        ip.setHistogramSize(nBins);
        ip.setHistogramRange(0.0, 0.0);
        ImageStatistics stats = ImageStatistics.getStatistics(ip);
        ip.setHistogramSize(256);
        return stats.histogram;
    }

    public abstract void erode();

    public abstract void dilate();

    public void setLutAnimation(boolean lutAnimation) {
        this.lutAnimation = lutAnimation;
    }

    void resetPixels(Object pixels) {
        if (pixels == null && this.img != null) {
            this.img.flush();
            this.img = null;
        }
    }

    public ImageProcessor convertToByte(boolean doScaling) {
        TypeConverter tc = new TypeConverter(this, doScaling);
        return tc.convertToByte();
    }

    public ImageProcessor convertToShort(boolean doScaling) {
        TypeConverter tc = new TypeConverter(this, doScaling);
        return tc.convertToShort();
    }

    public ImageProcessor convertToFloat() {
        TypeConverter tc = new TypeConverter(this, false);
        return tc.convertToFloat(this.cTable);
    }

    public ImageProcessor convertToRGB() {
        TypeConverter tc = new TypeConverter(this, true);
        return tc.convertToRGB();
    }

    public ByteProcessor convertToByteProcessor() {
        return this.convertToByteProcessor(true);
    }

    public ByteProcessor convertToByteProcessor(boolean scale) {
        ByteProcessor bp = this instanceof ByteProcessor ? (ByteProcessor)this.duplicate() : (ByteProcessor)this.convertToByte(scale);
        return bp;
    }

    public ShortProcessor convertToShortProcessor() {
        return this.convertToShortProcessor(true);
    }

    public ShortProcessor convertToShortProcessor(boolean scale) {
        ShortProcessor sp = this instanceof ShortProcessor ? (ShortProcessor)this.duplicate() : (ShortProcessor)this.convertToShort(scale);
        return sp;
    }

    public FloatProcessor convertToFloatProcessor() {
        FloatProcessor fp = this instanceof FloatProcessor ? (FloatProcessor)this.duplicate() : (FloatProcessor)this.convertToFloat();
        return fp;
    }

    public ColorProcessor convertToColorProcessor() {
        ColorProcessor cp = this instanceof ColorProcessor ? (ColorProcessor)this.duplicate() : (ColorProcessor)this.convertToRGB();
        return cp;
    }

    public abstract void convolve(float[] var1, int var2, int var3);

    public void autoThreshold() {
        this.threshold(this.getAutoThreshold());
    }

    public int getAutoThreshold() {
        return this.getAutoThreshold(this.getHistogram());
    }

    public int getAutoThreshold(int[] histogram) {
        double sum4;
        double sum3;
        double sum2;
        double sum1;
        double result;
        int max;
        int min;
        int maxValue = histogram.length - 1;
        int count0 = histogram[0];
        histogram[0] = 0;
        int countMax = histogram[maxValue];
        histogram[maxValue] = 0;
        for (min = 0; histogram[min] == 0 && min < maxValue; ++min) {
        }
        for (max = maxValue; histogram[max] == 0 && max > 0; --max) {
        }
        if (min >= max) {
            histogram[0] = count0;
            histogram[maxValue] = countMax;
            int level = histogram.length / 2;
            return level;
        }
        int movingIndex = min;
        int inc = Math.max(max / 40, 1);
        do {
            int i;
            sum4 = 0.0;
            sum3 = 0.0;
            sum2 = 0.0;
            sum1 = 0.0;
            for (i = min; i <= movingIndex; ++i) {
                sum1 += (double)i * (double)histogram[i];
                sum2 += (double)histogram[i];
            }
            for (i = movingIndex + 1; i <= max; ++i) {
                sum3 += (double)i * (double)histogram[i];
                sum4 += (double)histogram[i];
            }
        } while ((double)(++movingIndex + 1) <= (result = (sum1 / sum2 + sum3 / sum4) / 2.0) && movingIndex < max - 1);
        histogram[0] = count0;
        histogram[maxValue] = countMax;
        int level = (int)Math.round(result);
        return level;
    }

    public void setClipRect(Rectangle clipRect) {
        if (clipRect == null) {
            this.clipXMin = 0;
            this.clipXMax = this.width - 1;
            this.clipYMin = 0;
            this.clipYMax = this.height - 1;
        } else {
            this.clipXMin = clipRect.x;
            this.clipXMax = clipRect.x + clipRect.width - 1;
            this.clipYMin = clipRect.y;
            this.clipYMax = clipRect.y + clipRect.height - 1;
            if (this.clipXMin < 0) {
                this.clipXMin = 0;
            }
            if (this.clipXMax >= this.width) {
                this.clipXMax = this.width - 1;
            }
            if (this.clipYMin < 0) {
                this.clipYMin = 0;
            }
            if (this.clipYMax >= this.height) {
                this.clipYMax = this.height - 1;
            }
        }
    }

    protected String maskSizeError(ImageProcessor mask) {
        return "Mask size (" + mask.getWidth() + "x" + mask.getHeight() + ") != ROI size (" + this.roiWidth + "x" + this.roiHeight + ")";
    }

    protected SampleModel getIndexSampleModel() {
        if (this.sampleModel == null) {
            IndexColorModel icm = this.getDefaultColorModel();
            WritableRaster wr = icm.createCompatibleWritableRaster(1, 1);
            this.sampleModel = wr.getSampleModel();
            this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.width, this.height);
        }
        return this.sampleModel;
    }

    public IndexColorModel getDefaultColorModel() {
        if (defaultColorModel == null) {
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            for (int i = 0; i < 256; ++i) {
                r[i] = (byte)i;
                g[i] = (byte)i;
                b[i] = (byte)i;
            }
            defaultColorModel = new IndexColorModel(8, 256, r, g, b);
        }
        return defaultColorModel;
    }

    public void setSnapshotCopyMode(boolean b) {
        this.snapshotCopyMode = b;
    }

    public int getNChannels() {
        return 1;
    }

    public abstract FloatProcessor toFloat(int var1, FloatProcessor var2);

    public abstract void setPixels(int var1, FloatProcessor var2);

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return 255.0;
    }

    public void updateComposite(int[] rgbPixels, int mode) {
        int size = this.width * this.height;
        if (this.bytes == null || !this.lutAnimation) {
            this.bytes = this.create8BitImage();
        }
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.reds == null || this.cm != this.cm2) {
            this.updateLutBytes();
        }
        switch (mode) {
            case 1: {
                for (int i = 0; i < size; ++i) {
                    rgbPixels[i] = rgbPixels[i] & 0xFF00FFFF | this.reds[this.bytes[i] & 0xFF];
                }
                break;
            }
            case 2: {
                for (int i = 0; i < size; ++i) {
                    rgbPixels[i] = rgbPixels[i] & 0xFFFF00FF | this.greens[this.bytes[i] & 0xFF];
                }
                break;
            }
            case 3: {
                for (int i = 0; i < size; ++i) {
                    rgbPixels[i] = rgbPixels[i] & 0xFFFFFF00 | this.blues[this.bytes[i] & 0xFF];
                }
                break;
            }
            case 4: {
                for (int i = 0; i < size; ++i) {
                    int index = this.bytes[i] & 0xFF;
                    rgbPixels[i] = this.reds[index] | this.greens[index] | this.blues[index];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < size; ++i) {
                    int pixel = rgbPixels[i];
                    int redValue = (pixel & 0xFF0000) + this.reds[this.bytes[i] & 0xFF];
                    int greenValue = (pixel & 0xFF00) + this.greens[this.bytes[i] & 0xFF];
                    int blueValue = (pixel & 0xFF) + this.blues[this.bytes[i] & 0xFF];
                    if (redValue > 0xFF0000) {
                        redValue = 0xFF0000;
                    }
                    if (greenValue > 65280) {
                        greenValue = 65280;
                    }
                    if (blueValue > 255) {
                        blueValue = 255;
                    }
                    rgbPixels[i] = redValue | greenValue | blueValue;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < size; ++i) {
                    int blueValue;
                    int greenValue;
                    int index = this.bytes[i] & 0xFF;
                    int redValue = this.reds[index] & 0xFF0000;
                    int pixel = rgbPixels[i];
                    if (redValue > (pixel & 0xFF0000)) {
                        rgbPixels[i] = rgbPixels[i] & 0xFF00FFFF | redValue;
                    }
                    if ((greenValue = this.greens[index] & 0xFF00) > (pixel & 0xFF00)) {
                        rgbPixels[i] = rgbPixels[i] & 0xFFFF00FF | greenValue;
                    }
                    if ((blueValue = this.blues[index] & 0xFF) <= (pixel & 0xFF)) continue;
                    rgbPixels[i] = rgbPixels[i] & 0xFFFFFF00 | blueValue;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < size; ++i) {
                    int blueValue;
                    int greenValue;
                    int index = this.bytes[i] & 0xFF;
                    int redValue = this.reds[index] & 0xFF0000;
                    int pixel = rgbPixels[i];
                    if (redValue < (pixel & 0xFF0000)) {
                        rgbPixels[i] = rgbPixels[i] & 0xFF00FFFF | redValue;
                    }
                    if ((greenValue = this.greens[index] & 0xFF00) < (pixel & 0xFF00)) {
                        rgbPixels[i] = rgbPixels[i] & 0xFFFF00FF | greenValue;
                    }
                    if ((blueValue = this.blues[index] & 0xFF) >= (pixel & 0xFF)) continue;
                    rgbPixels[i] = rgbPixels[i] & 0xFFFFFF00 | blueValue;
                }
                break;
            }
        }
        this.lutAnimation = false;
    }

    byte[] create8BitImage() {
        return null;
    }

    void updateLutBytes() {
        int i;
        IndexColorModel icm = (IndexColorModel)this.cm;
        int mapSize = icm.getMapSize();
        if (this.reds == null || this.reds.length != mapSize) {
            this.reds = new int[mapSize];
            this.greens = new int[mapSize];
            this.blues = new int[mapSize];
        }
        byte[] tmp = new byte[mapSize];
        icm.getReds(tmp);
        for (i = 0; i < mapSize; ++i) {
            this.reds[i] = (tmp[i] & 0xFF) << 16;
        }
        icm.getGreens(tmp);
        for (i = 0; i < mapSize; ++i) {
            this.greens[i] = (tmp[i] & 0xFF) << 8;
        }
        icm.getBlues(tmp);
        for (i = 0; i < mapSize; ++i) {
            this.blues[i] = tmp[i] & 0xFF;
        }
        this.cm2 = this.cm;
    }

    public static void setOverColor(int red, int green, int blue) {
        overRed = red;
        overGreen = green;
        overBlue = blue;
    }

    public static void setUnderColor(int red, int green, int blue) {
        underRed = red;
        underGreen = green;
        underBlue = blue;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isSigned16Bit() {
        return false;
    }

    public static void setUseBicubic(boolean b) {
        useBicubic = b;
    }

    public ImageStatistics getStats() {
        return ImageStatistics.getStatistics(this);
    }

    public ImageStatistics getStatistics() {
        return ImageStatistics.getStatistics(this, 1043199, null);
    }

    public void blurGaussian(double sigma) {
        this.resetRoi();
        GaussianBlur gb = new GaussianBlur();
        gb.showProgress(false);
        gb.blurGaussian(this, sigma);
    }

    public void applyMacro(String macro) {
        ImageMath.applyMacro(this, macro, false);
    }

    public int getSliceNumber() {
        if (this.sliceNumber < 1) {
            return 1;
        }
        return this.sliceNumber;
    }

    public void setSliceNumber(int slice) {
        this.sliceNumber = slice;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setOverlay(Overlay overlay) {
        this.overlay = overlay;
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    protected int getProgressIncrement(int w, int h) {
        boolean isBig;
        if (this.progressBar == null) {
            return 0;
        }
        int inc = 0;
        int threshold = 15000000;
        if (this.interpolationMethod == 2) {
            threshold = 5000000;
        }
        boolean bl = isBig = w * h > threshold;
        if (isBig && (inc = h / 30) < 1) {
            inc = 1;
        }
        return inc;
    }

    public static void setRandomSeed(double randomSeed) {
        seed = randomSeed;
    }

    public ByteProcessor createMask() {
        return null;
    }

    protected static IndexColorModel getThresholdColorModel(byte[] reds, byte[] greens, byte[] blues) {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        System.arraycopy(reds, 0, r, 0, 255);
        System.arraycopy(greens, 0, g, 0, 255);
        System.arraycopy(blues, 0, b, 0, 255);
        r[255] = -1;
        return new IndexColorModel(8, 256, r, g, b);
    }

    public void fillColorSet(boolean set) {
        this.fillColorSet = set;
    }

    static {
        overGreen = 255;
        underBlue = 255;
        seed = Double.NaN;
    }
}

