/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ColorChooser;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.MessageDialog;
import ij.gui.Overlay;
import ij.gui.Plot;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.RoiDecoder;
import ij.io.RoiEncoder;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Colors;
import ij.plugin.MacroInstaller;
import ij.plugin.OverlayCommands;
import ij.plugin.OverlayLabels;
import ij.plugin.RoiRotator;
import ij.plugin.RoiScaler;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Filler;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RoiManager
extends PlugInFrame
implements ActionListener,
ItemListener,
MouseListener,
MouseWheelListener,
ListSelectionListener,
Iterable<Roi> {
    public static final String LOC_KEY = "manager.loc";
    private static final String MULTI_CROP_DIR = "multi-crop.dir";
    private static final int BUTTONS = 11;
    private static final int DRAW = 0;
    private static final int FILL = 1;
    private static final int LABEL = 2;
    private static final int SHOW_ALL = 0;
    private static final int SHOW_NONE = 1;
    private static final int LABELS = 2;
    private static final int NO_LABELS = 3;
    private static final int MENU = 0;
    private static final int COMMAND = 1;
    private static final int CHANNEL = 0;
    private static final int SLICE = 1;
    private static final int FRAME = 2;
    private static final int SHOW_DIALOG = 3;
    private static int rows = 15;
    private static int lastNonShiftClick = -1;
    private static boolean allowMultipleSelections = true;
    private static String moreButtonLabel = "More \u00bb";
    private Panel panel;
    private static Frame instance;
    private static int colorIndex;
    private JList list;
    private DefaultListModel listModel;
    private ArrayList rois = new ArrayList();
    private boolean canceled;
    private boolean macro;
    private boolean ignoreInterrupts;
    private PopupMenu pm;
    private Button moreButton;
    private Button colorButton;
    private Checkbox showAllCheckbox = new Checkbox("Show All", false);
    private Checkbox labelsCheckbox = new Checkbox("Labels", false);
    private Overlay overlayTemplate;
    private static boolean measureAll;
    private static boolean onePerSlice;
    private static boolean restoreCentered;
    private int prevID;
    private boolean noUpdateMode;
    private int defaultLineWidth = 1;
    private Color defaultColor;
    private boolean firstTime = true;
    private boolean appendResults;
    private static ResultsTable mmResults;
    private static ResultsTable mmResults2;
    private int imageID;
    private boolean allowRecording;
    private boolean recordShowAll = true;
    private boolean allowDuplicates;
    private double translateX = 10.0;
    private double translateY = 10.0;
    private static String errorMessage;
    private boolean multiCropShow = true;
    private boolean multiCropSave;
    private int multiCropFormatIndex;
    private static double angle;
    private static double xscale;
    private static double yscale;
    private static boolean scaleCentered;
    private static boolean channel;
    private static boolean slice;
    private static boolean frame;

    public RoiManager() {
        super("ROI Manager");
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        if (IJ.isMacro() && Interpreter.getBatchModeRoiManager() != null) {
            this.list = new JList();
            this.listModel = new DefaultListModel();
            this.list.setModel(this.listModel);
            return;
        }
        instance = this;
        this.list = new JList();
        errorMessage = null;
        this.showWindow();
    }

    public RoiManager(boolean b) {
        super("ROI Manager");
        this.list = new JList();
        this.listModel = new DefaultListModel();
        this.list.setModel(this.listModel);
        errorMessage = null;
    }

    void showWindow() {
        ImageJ ij = IJ.getInstance();
        this.addKeyListener(ij);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        WindowManager.addWindow(this);
        this.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.list.setModel(this.listModel);
        GUI.scale(this.list);
        this.list.setPrototypeCellValue("0000-0000-0000 ");
        this.list.addListSelectionListener(this);
        this.list.addKeyListener(ij);
        this.list.addMouseListener(this);
        this.list.addMouseWheelListener(this);
        if (IJ.isLinux()) {
            this.list.setBackground(Color.white);
        }
        JScrollPane scrollPane = new JScrollPane(this.list, 22, 31);
        this.add("Center", scrollPane);
        this.panel = new Panel();
        int nButtons = 11;
        this.panel.setLayout(new GridLayout(nButtons, 1, 5, 0));
        this.addButton("Add [t]");
        this.addButton("Update");
        this.addButton("Delete");
        this.addButton("Rename...");
        this.addButton("Measure");
        this.addButton("Deselect");
        this.addButton("Properties...");
        this.addButton("Flatten [F]");
        this.addButton(moreButtonLabel);
        this.showAllCheckbox.addItemListener(this);
        this.panel.add(this.showAllCheckbox);
        this.labelsCheckbox.addItemListener(this);
        this.panel.add(this.labelsCheckbox);
        this.add("East", this.panel);
        this.addPopupMenu();
        GUI.scale(this);
        this.pack();
        Dimension size = this.getSize();
        if (size.width > 270) {
            this.setSize(size.width - 40, size.height);
        }
        this.list.remove(0);
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.centerOnImageJScreen(this);
        }
        this.show();
    }

    void addButton(String label) {
        Button b = new Button(label);
        b.addActionListener(this);
        b.addKeyListener(IJ.getInstance());
        b.addMouseListener(this);
        if (label.equals(moreButtonLabel)) {
            this.moreButton = b;
        }
        this.panel.add(b);
    }

    void addPopupMenu() {
        this.pm = new PopupMenu();
        GUI.scalePopupMenu(this.pm);
        this.addPopupItem("Open...");
        this.addPopupItem("Save...");
        this.addPopupItem("Fill");
        this.addPopupItem("Draw");
        this.addPopupItem("AND");
        this.addPopupItem("OR (Combine)");
        this.addPopupItem("XOR");
        this.addPopupItem("Split");
        this.addPopupItem("Add Particles");
        this.addPopupItem("Multi Measure");
        this.addPopupItem("Multi Plot");
        this.addPopupItem("Multi Crop");
        this.addPopupItem("Sort");
        this.addPopupItem("Specify...");
        this.addPopupItem("Remove Positions...");
        this.addPopupItem("Labels...");
        this.addPopupItem("List");
        this.addPopupItem("Interpolate ROIs");
        this.addPopupItem("Scale...");
        this.addPopupItem("Rotate...");
        this.addPopupItem("Translate...");
        this.addPopupItem("ROI Manager Action");
        this.addPopupItem("Help");
        this.addPopupItem("Options...");
        this.add(this.pm);
    }

    void addPopupItem(String s) {
        MenuItem mi = new MenuItem(s);
        mi.addActionListener(this);
        this.pm.add(mi);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String label = e.getActionCommand();
        if (label == null) {
            return;
        }
        String command = label;
        this.allowRecording = true;
        if (command.equals("Add [t]")) {
            this.runCommand("add");
        } else if (command.equals("Update")) {
            this.update(true);
        } else if (command.equals("Delete")) {
            this.delete(false);
        } else if (command.equals("Rename...")) {
            this.rename(null);
        } else if (command.equals("Properties...")) {
            this.setProperties(null, -1, null);
        } else if (command.equals("Flatten [F]")) {
            this.flatten();
        } else if (command.equals("Measure")) {
            this.measure(this.getImage());
        } else if (command.equals("Open...")) {
            this.open(null);
        } else if (command.equals("Save...")) {
            Thread t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    RoiManager.this.save(null);
                }
            });
            t1.start();
        } else if (command.equals("Fill")) {
            this.drawOrFill(1);
        } else if (command.equals("Draw")) {
            this.drawOrFill(0);
        } else if (command.equals("Deselect")) {
            this.deselect();
        } else if (command.equals(moreButtonLabel)) {
            Point ploc = this.panel.getLocation();
            Point bloc = this.moreButton.getLocation();
            this.pm.show(this, ploc.x, bloc.y);
        } else if (command.equals("OR (Combine)")) {
            new MacroRunner("roiManager(\"Combine\");");
            if (Recorder.record) {
                Recorder.record("roiManager", "Combine");
            }
        } else if (command.equals("Split")) {
            this.split();
        } else if (command.equals("AND")) {
            this.and();
        } else if (command.equals("XOR")) {
            this.xor();
        } else if (command.equals("Add Particles")) {
            this.addParticles();
        } else if (command.equals("Multi Measure")) {
            this.multiMeasure("");
        } else if (command.equals("Multi Plot")) {
            this.multiPlot();
        } else if (command.equals("Multi Crop")) {
            this.multiCrop();
        } else if (command.equals("Sort")) {
            this.sort();
        } else if (command.equals("Specify...")) {
            this.specify();
        } else if (command.equals("Remove Positions...")) {
            this.removePositions(3);
        } else if (command.equals("Labels...")) {
            this.labels();
        } else if (command.equals("List")) {
            this.listRois();
        } else if (command.equals("Interpolate ROIs")) {
            this.interpolateRois();
        } else if (command.equals("Scale...")) {
            this.scale();
        } else if (command.equals("Rotate...")) {
            this.rotate();
        } else if (command.equals("Translate...")) {
            this.translate();
        } else if (command.equals("Help")) {
            this.help();
        } else if (command.equals("Options...")) {
            this.options();
        } else if (command.equals("\"Show All\" Color...")) {
            this.setShowAllColor();
        } else if (command.equals("ROI Manager Action")) {
            IJ.run(command);
        }
        this.allowRecording = false;
    }

    private void interpolateRois() {
        IJ.runPlugIn("ij.plugin.RoiInterpolator", "");
        if (this.record()) {
            Recorder.record("roiManager", "Interpolate ROIs");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        boolean showAllMode = this.showAllCheckbox.getState();
        if (source == this.showAllCheckbox) {
            if (this.firstTime && this.okToSet()) {
                this.labelsCheckbox.setState(true);
            }
            this.showAll(this.showAllCheckbox.getState() ? 0 : 1);
            if (Recorder.record && this.recordShowAll) {
                if (showAllMode) {
                    Recorder.record("roiManager", "Show All");
                } else {
                    Recorder.record("roiManager", "Show None");
                }
            }
            this.recordShowAll = true;
            this.firstTime = false;
            return;
        }
        if (source == this.labelsCheckbox) {
            if (this.firstTime && this.okToSet()) {
                this.showAllCheckbox.setState(true);
            }
            boolean editState = this.labelsCheckbox.getState();
            boolean showAllState = this.showAllCheckbox.getState();
            if (!showAllState && !editState) {
                this.showAll(1);
            } else {
                this.showAll(editState ? 2 : 3);
                if (Recorder.record) {
                    if (editState) {
                        Recorder.record("roiManager", "Show All with labels");
                    } else if (showAllState) {
                        Recorder.record("roiManager", "Show All without labels");
                    }
                }
                if (editState && !showAllState && this.okToSet()) {
                    this.showAllCheckbox.setState(true);
                    this.recordShowAll = false;
                }
            }
            this.firstTime = false;
            return;
        }
    }

    private boolean okToSet() {
        return false;
    }

    void add(boolean shiftKeyDown, boolean altKeyDown) {
        if (shiftKeyDown) {
            this.addAndDraw(altKeyDown);
        } else if (altKeyDown) {
            this.addRoi(true);
        } else {
            this.addRoi(false);
        }
    }

    public void addRoi(Roi roi) {
        this.allowDuplicates = true;
        this.addRoi(roi, false, null, -1);
    }

    boolean addRoi(boolean promptForName) {
        return this.addRoi(null, promptForName, null, -1);
    }

    boolean addRoi(Roi roi, boolean promptForName, Color color, int lineWidth) {
        boolean hasPosition;
        String label;
        Roi roi2;
        int saveCurrentSlice;
        ImagePlus imp;
        if (this.listModel == null) {
            IJ.log("<<Error: Uninitialized RoiManager>>");
        }
        ImagePlus imagePlus = imp = roi == null ? this.getImage() : WindowManager.getCurrentImage();
        if (roi == null) {
            if (imp == null) {
                return false;
            }
            roi = imp.getRoi();
            if (roi == null) {
                this.error("The active image does not have a selection.");
                return false;
            }
        }
        if (roi instanceof PolygonRoi && ((PolygonRoi)roi).getNCoordinates() == 0) {
            return false;
        }
        if (color == null && roi.getStrokeColor() != null) {
            color = roi.getStrokeColor();
        } else if (color == null && this.defaultColor != null) {
            color = this.defaultColor;
        }
        if (lineWidth < 0) {
            int sw = (int)roi.getStrokeWidth();
            int n = lineWidth = sw > 1 ? sw : this.defaultLineWidth;
        }
        if (lineWidth > 100) {
            lineWidth = 1;
        }
        int n = this.getCount();
        int n2 = saveCurrentSlice = imp != null ? imp.getCurrentSlice() : 0;
        if (n > 0 && !IJ.isMacro() && imp != null && !this.allowDuplicates && (roi2 = (Roi)this.rois.get(n - 1)) != null) {
            label = (String)this.listModel.getElementAt(n - 1);
            int slice2 = this.getSliceNumber(roi2, label);
            if (roi.equals(roi2) && (slice2 == -1 || slice2 == imp.getCurrentSlice()) && imp.getID() == this.prevID && !Interpreter.isBatchMode()) {
                return false;
            }
        }
        this.allowDuplicates = false;
        this.prevID = imp != null ? imp.getID() : 0;
        String name = roi.getName();
        if (this.isStandardName(name)) {
            name = null;
        }
        String string = label = name != null ? name : this.getLabel(imp, roi, -1);
        if (promptForName) {
            label = this.promptForName(label);
        }
        if (label == null) {
            return false;
        }
        this.listModel.addElement(label);
        roi.setName(label);
        Roi roiCopy = (Roi)roi.clone();
        boolean bl = hasPosition = roiCopy.getPosition() > 0 || roiCopy.getPosition() == -2 || roiCopy.hasHyperStackPosition();
        if (!hasPosition && imp != null && imp.getStackSize() > 1) {
            roiCopy.setPosition(imp);
        }
        if (lineWidth > 1) {
            roiCopy.setStrokeWidth(lineWidth);
        }
        if (color != null) {
            roiCopy.setStrokeColor(color);
        }
        this.rois.add(roiCopy);
        this.updateShowAll();
        if (this.record()) {
            this.recordAdd(this.defaultColor, this.defaultLineWidth);
        }
        return true;
    }

    void recordAdd(Color color, int lineWidth) {
        if (Recorder.scriptMode()) {
            Recorder.recordCall("rm.addRoi(roi);");
        } else if (color != null && lineWidth == 1) {
            Recorder.recordString("roiManager(\"Add\", \"" + this.getHex(color) + "\");\n");
        } else if (lineWidth > 1) {
            Recorder.recordString("roiManager(\"Add\", \"" + this.getHex(color) + "\", " + lineWidth + ");\n");
        } else {
            Recorder.record("roiManager", "Add");
        }
    }

    String getHex(Color color) {
        String hex;
        if (color == null) {
            color = ImageCanvas.getShowAllColor();
        }
        if ((hex = Integer.toHexString(color.getRGB())).length() == 8) {
            hex = hex.substring(2);
        }
        return hex;
    }

    public void add(Roi roi, int n) {
        this.add((ImagePlus)null, roi, n);
    }

    public void add(ImagePlus imp, Roi roi, int n) {
        String label;
        if (IJ.debugMode && n < 3 && roi != null) {
            IJ.log("RoiManager.add: " + n + " " + roi.getName());
        }
        if (roi == null) {
            return;
        }
        String label2 = label = roi.getName();
        if (label == null) {
            label = this.getLabel(imp, roi, n);
        } else if (n >= 0) {
            label = n + "-" + label;
        }
        if (label == null) {
            return;
        }
        this.listModel.addElement(label);
        if (label2 != null) {
            roi.setName(label2);
        } else {
            roi.setName(label);
        }
        this.rois.add((Roi)roi.clone());
    }

    public void setRoi(Roi roi, int index) {
        if (index < 0 || index >= this.rois.size()) {
            throw new IllegalArgumentException("setRoi: Index out of range");
        }
        this.rois.set(index, (Roi)roi.clone());
        this.updateShowAll();
    }

    boolean isStandardName(String name) {
        if (name == null) {
            return false;
        }
        int len = name.length();
        if (len < 9 || len > 0 && !Character.isDigit(name.charAt(0))) {
            return false;
        }
        boolean isStandard = false;
        if (len >= 14 && name.charAt(4) == '-' && name.charAt(9) == '-') {
            isStandard = true;
        } else if (len >= 17 && name.charAt(5) == '-' && name.charAt(11) == '-') {
            isStandard = true;
        } else if (len >= 9 && name.charAt(4) == '-' && Character.isDigit(name.charAt(5))) {
            isStandard = true;
        } else if (len >= 11 && name.charAt(5) == '-' && Character.isDigit(name.charAt(6))) {
            isStandard = true;
        }
        return isStandard;
    }

    String getLabel(ImagePlus imp, Roi roi, int n) {
        String ys;
        Rectangle r = roi.getBounds();
        int xc = r.x + r.width / 2;
        int yc = r.y + r.height / 2;
        if (n >= 0) {
            xc = yc;
            yc = n;
        }
        if (xc < 0) {
            xc = 0;
        }
        if (yc < 0) {
            yc = 0;
        }
        int digits = 4;
        String xs = "" + xc;
        if (xs.length() > digits) {
            digits = xs.length();
        }
        if ((ys = "" + yc).length() > digits) {
            digits = ys.length();
        }
        if (digits == 4 && imp != null && (imp.getStackSize() >= 10000 || imp.getHeight() >= 10000)) {
            digits = 5;
        }
        xs = "000000" + xc;
        ys = "000000" + yc;
        String label = ys.substring(ys.length() - digits) + "-" + xs.substring(xs.length() - digits);
        if (imp != null && imp.getStackSize() > 1) {
            int slice = imp.getCurrentSlice();
            String zs = "000000" + slice;
            label = zs.substring(zs.length() - digits) + "-" + label;
        }
        return label;
    }

    void addAndDraw(boolean altKeyDown) {
        if (altKeyDown ? !this.addRoi(true) : !this.addRoi(false)) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            Undo.setup(4, imp);
            IJ.run(imp, "Draw", "slice");
            Undo.setup(5, imp);
        }
        if (this.record()) {
            Recorder.record("roiManager", "Add & Draw");
        }
    }

    boolean delete(boolean replacing) {
        int count = this.getCount();
        if (count == 0) {
            return this.error("The ROI Manager is empty.");
        }
        int[] index = this.getSelectedIndexes();
        if (index.length == 0 || replacing && count > 1) {
            String msg = "Delete all items on the list?";
            if (replacing) {
                msg = "Replace items on the list?";
            }
            this.canceled = false;
            if (!IJ.isMacro() && !this.macro) {
                YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "ROI Manager", msg);
                if (d.cancelPressed()) {
                    this.canceled = true;
                    return false;
                }
                if (!d.yesPressed()) {
                    return false;
                }
            }
            index = this.getAllIndexes();
        }
        if (count == index.length && !replacing) {
            this.rois.clear();
            this.listModel.removeAllElements();
        } else {
            for (int i = count - 1; i >= 0; --i) {
                boolean delete = false;
                for (int j = 0; j < index.length; ++j) {
                    if (index[j] != i) continue;
                    delete = true;
                }
                if (!delete) continue;
                if (EventQueue.isDispatchThread()) {
                    this.rois.remove(i);
                    this.listModel.remove(i);
                    continue;
                }
                this.deleteOnEDT(i);
            }
        }
        this.updateShowAll();
        if (this.record()) {
            Recorder.record("roiManager", "Delete");
        }
        return true;
    }

    public void delete(int index) {
        int count = this.getCount();
        if (count == 0 || index >= count) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.rois.remove(index);
            this.listModel.remove(index);
        } else {
            this.deleteOnEDT(index);
        }
        this.updateShowAll();
        this.repaint();
    }

    private void deleteOnEDT(final int i) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RoiManager.this.rois.remove(i);
                    RoiManager.this.listModel.remove(i);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean update(boolean clone) {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        ImageCanvas ic = imp.getCanvas();
        boolean showingAll = ic != null && ic.getShowAllROIs();
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.error("The active image does not have a selection.");
            return false;
        }
        int index = this.list.getSelectedIndex();
        if (index < 0 && !showingAll) {
            return this.error("Exactly one item in the list must be selected.");
        }
        if (index >= 0) {
            if (clone) {
                String name = (String)this.listModel.getElementAt(index);
                Roi roi2 = (Roi)roi.clone();
                if (roi2.getPosition() != -2) {
                    roi2.setPosition(imp);
                }
                roi.setName(name);
                roi2.setName(name);
                this.rois.set(index, roi2);
            } else {
                this.rois.set(index, roi);
            }
        }
        if (this.record()) {
            Recorder.record("roiManager", "Update");
        }
        this.updateShowAll();
        return true;
    }

    boolean rename(String name2) {
        int index = this.list.getSelectedIndex();
        if (index < 0) {
            return this.error("Exactly one item in the list must be selected.");
        }
        String name = (String)this.listModel.getElementAt(index);
        if (name2 == null) {
            name2 = this.promptForName(name);
        }
        if (name2 == null) {
            return false;
        }
        if (name2.equals(name)) {
            return false;
        }
        Roi roi = (Roi)this.rois.get(index);
        roi.setName(name2);
        int position = this.getSliceNumber(name2);
        if (position > 0 && !roi.hasHyperStackPosition()) {
            roi.setPosition(position);
        }
        this.rois.set(index, roi);
        this.listModel.setElementAt(name2, index);
        this.list.setSelectedIndex(index);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && imp.getRoi() != null) {
            imp.setRoi(roi);
        }
        if (Prefs.useNamesAsLabels && this.labelsCheckbox.getState() && imp != null) {
            imp.draw();
        }
        if (this.record()) {
            Recorder.record("roiManager", "Rename", name2);
        }
        return true;
    }

    public void rename(int index, String newName) {
        if (index < 0 || index >= this.getCount()) {
            throw new IllegalArgumentException("Index out of range: " + index);
        }
        Roi roi = (Roi)this.rois.get(index);
        roi.setName(newName);
        this.listModel.setElementAt(newName, index);
    }

    String promptForName(String name) {
        GenericDialog gd = new GenericDialog("ROI Manager");
        gd.addStringField("Rename As:", name, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        return gd.getNextString();
    }

    boolean restore(ImagePlus imp, int index, boolean setSlice) {
        ImageCanvas ic;
        if (index >= this.rois.size()) {
            return false;
        }
        Roi roi = (Roi)this.rois.get(index);
        if (imp == null || roi == null) {
            return false;
        }
        if (setSlice) {
            boolean hyperstack = imp.isHyperStack();
            int position = roi.getPosition();
            if (hyperstack && roi.hasHyperStackPosition()) {
                imp.setPosition(roi.getCPosition(), roi.getZPosition(), roi.getTPosition());
            } else if (hyperstack && imp.getNSlices() == 1) {
                imp.setPosition(imp.getChannel(), 1, position);
            } else if (hyperstack) {
                imp.setPosition(imp.getChannel(), position, imp.getChannel());
            } else if (roi.getZPosition() > 0 && imp.getNSlices() == imp.getStackSize()) {
                imp.setSlice(roi.getZPosition());
            } else if (position > 0 && position <= imp.getStackSize()) {
                imp.setSlice(position);
            } else if (roi instanceof PointRoi && !Prefs.showAllPoints && !((PointRoi)roi).hasPointPosition(imp.getSlice())) {
                imp.setSlice(((PointRoi)roi).getPointPosition(0));
            } else {
                String label = (String)this.listModel.getElementAt(index);
                int n = this.getSliceNumber(roi, label);
                if (n >= 1 && n <= imp.getStackSize()) {
                    if (hyperstack) {
                        if (imp.getNSlices() > 1 && n <= imp.getNSlices()) {
                            imp.setPosition(imp.getC(), n, imp.getT());
                        } else if (imp.getNFrames() > 1 && n <= imp.getNFrames()) {
                            imp.setPosition(imp.getC(), imp.getZ(), n);
                        } else {
                            imp.setPosition(n);
                        }
                    } else {
                        imp.setSlice(n);
                    }
                }
            }
        }
        if (this.showAllCheckbox.getState() && !restoreCentered && !this.noUpdateMode) {
            roi.setImage(null);
            imp.setRoi(roi);
            return true;
        }
        Roi roi2 = (Roi)roi.clone();
        Rectangle r = roi2.getBounds();
        int width = imp.getWidth();
        int height = imp.getHeight();
        if (restoreCentered && (ic = imp.getCanvas()) != null) {
            Rectangle r1 = ic.getSrcRect();
            Rectangle r2 = roi2.getBounds();
            roi2.setLocation(r1.x + r1.width / 2 - r2.width / 2, r1.y + r1.height / 2 - r2.height / 2);
        }
        if ((r.x >= width || r.y >= height || r.x + r.width < 0 || r.y + r.height < 0) && roi2.getType() != 10) {
            roi2.setLocation((width - r.width) / 2, (height - r.height) / 2);
        }
        if (this.noUpdateMode) {
            imp.setRoi(roi2, false);
            this.noUpdateMode = false;
        } else {
            imp.setRoi(roi2, true);
        }
        return true;
    }

    private boolean restoreWithoutUpdate(ImagePlus imp, int index) {
        this.noUpdateMode = true;
        if (imp == null) {
            imp = this.getImage();
        }
        return this.restore(imp, index, false);
    }

    public int getSliceNumber(String label) {
        int slice = -1;
        if (label.length() >= 14 && label.charAt(4) == '-' && label.charAt(9) == '-') {
            slice = (int)Tools.parseDouble(label.substring(0, 4), -1.0);
        } else if (label.length() >= 17 && label.charAt(5) == '-' && label.charAt(11) == '-') {
            slice = (int)Tools.parseDouble(label.substring(0, 5), -1.0);
        } else if (label.length() >= 20 && label.charAt(6) == '-' && label.charAt(13) == '-') {
            slice = (int)Tools.parseDouble(label.substring(0, 6), -1.0);
        }
        return slice;
    }

    int getSliceNumber(Roi roi, String label) {
        int slice;
        int n = slice = roi != null ? roi.getPosition() : -1;
        if (slice == 0) {
            slice = -1;
        }
        if (slice == -1) {
            slice = this.getSliceNumber(label);
        }
        return slice;
    }

    public boolean open(String path) {
        Roi roi;
        Macro.setOptions(null);
        String name = null;
        if (path == null || path.equals("")) {
            OpenDialog od = new OpenDialog("Open Selection(s)...", "");
            String directory = od.getDirectory();
            name = od.getFileName();
            if (name == null) {
                return false;
            }
            path = directory + name;
        }
        if (Recorder.record && !IJ.macroRunning()) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("rm.open(\"" + path + "\");");
            } else {
                Recorder.record("roiManager", "Open", path);
            }
        }
        boolean ok = false;
        if (path.endsWith(".zip")) {
            Recorder.suspendRecording();
            ok = this.openZip(path);
            Recorder.resumeRecording();
            return ok;
        }
        Opener o = new Opener();
        if (name == null) {
            name = o.getName(path);
        }
        if ((roi = o.openRoi(path)) != null) {
            if (roi.getName() != null) {
                name = roi.getName();
            }
            if (name.endsWith(".roi")) {
                name = name.substring(0, name.length() - 4);
            }
            this.listModel.addElement(name);
            this.rois.add(roi);
            errorMessage = null;
            ok = true;
        } else {
            errorMessage = "Unable to open ROI at " + path;
            ok = false;
        }
        this.updateShowAll();
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean openZip(String path) {
        ZipInputStream in = null;
        ByteArrayOutputStream out = null;
        int nRois = 0;
        errorMessage = null;
        try {
            in = new ZipInputStream(new FileInputStream(path));
            byte[] buf = new byte[1024];
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.endsWith(".roi")) {
                    int len;
                    out = new ByteArrayOutputStream();
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.close();
                    byte[] bytes = out.toByteArray();
                    RoiDecoder rd = new RoiDecoder(bytes, name);
                    Roi roi = rd.getRoi();
                    if (roi != null) {
                        name = name.substring(0, name.length() - 4);
                        this.listModel.addElement(name);
                        this.rois.add(roi);
                        ++nRois;
                    }
                }
                entry = in.getNextEntry();
            }
            in.close();
        }
        catch (IOException e) {
            errorMessage = e.toString();
            this.error(errorMessage);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (nRois == 0 && errorMessage == null) {
            errorMessage = "This ZIP archive does not contain \".roi\" files: " + path;
            this.error(errorMessage);
        }
        this.updateShowAll();
        return errorMessage == null;
    }

    public boolean save(String path) {
        if (this.getCount() == 0) {
            return this.error("The selection list is empty.");
        }
        int[] indexes = this.getIndexes();
        if (indexes.length > 1) {
            return this.saveMultiple(indexes, path);
        }
        return this.saveOne(indexes, path);
    }

    boolean saveOne(int[] indexes, String path) {
        if (indexes.length == 0) {
            return this.error("The list is empty");
        }
        Roi roi = (Roi)this.rois.get(indexes[0]);
        if (path == null) {
            Macro.setOptions(null);
            String name = (String)this.listModel.getElementAt(indexes[0]);
            SaveDialog sd = new SaveDialog("Save Selection...", name, ".roi");
            String name2 = sd.getFileName();
            if (name2 == null) {
                return false;
            }
            String dir = sd.getDirectory();
            if (!name2.endsWith(".roi")) {
                name2 = name2 + ".roi";
            }
            String newName = name2.substring(0, name2.length() - 4);
            this.rois.set(indexes[0], roi);
            roi.setName(newName);
            this.listModel.setElementAt(newName, indexes[0]);
            path = dir + name2;
        }
        RoiEncoder re = new RoiEncoder(path);
        errorMessage = null;
        try {
            re.write(roi);
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
            IJ.error("ROI Manager", errorMessage);
        }
        if (Recorder.record && !IJ.isMacro()) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("rm.save(\"" + path + "\");");
            } else {
                Recorder.record("roiManager", "Save", path);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveMultiple(int[] indexes, String path) {
        Macro.setOptions(null);
        if (path == null || path.equals("")) {
            SaveDialog sd = new SaveDialog("Save ROIs...", "RoiSet", ".zip");
            String name = sd.getFileName();
            if (name == null) {
                return false;
            }
            if (!name.endsWith(".zip") && !name.endsWith(".ZIP")) {
                name = name + ".zip";
            }
            String dir = sd.getDirectory();
            path = dir + name;
        }
        FilterOutputStream out = null;
        IJ.showStatus("Saving " + indexes.length + " ROIs  to " + path);
        long t0 = System.currentTimeMillis();
        String[] names = new String[this.listModel.size()];
        for (int i = 0; i < this.listModel.size(); ++i) {
            names[i] = (String)this.listModel.getElementAt(i);
        }
        errorMessage = null;
        try {
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            out = new DataOutputStream(new BufferedOutputStream(zos));
            RoiEncoder re = new RoiEncoder(out);
            for (int i = 0; i < indexes.length; ++i) {
                IJ.showProgress(i, indexes.length);
                Roi roi = (Roi)this.rois.get(indexes[i]);
                String label = (String)this.listModel.getElementAt(indexes[i]);
                if (IJ.debugMode) {
                    IJ.log("saveMultiple: " + i + "  " + label + "  " + roi);
                }
                if (roi == null) continue;
                if (!label.endsWith(".roi")) {
                    label = label + ".roi";
                }
                try {
                    zos.putNextEntry(new ZipEntry(label));
                }
                catch (ZipException e) {
                    label = this.getUniqueName(names, indexes[i]);
                    if (!label.endsWith(".roi")) {
                        label = label + ".roi";
                    }
                    zos.putNextEntry(new ZipEntry(label));
                }
                re.write(roi);
                ((DataOutputStream)out).flush();
            }
            out.close();
        }
        catch (IOException e) {
            errorMessage = "" + e;
            this.error(errorMessage);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        double time = (double)(System.currentTimeMillis() - t0) / 1000.0;
        IJ.showProgress(1.0);
        IJ.showStatus(IJ.d2s(time, 3) + " seconds, " + indexes.length + " ROIs, " + path);
        if (Recorder.record && !IJ.isMacro()) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("rm.save(\"" + path + "\");");
            } else {
                Recorder.record("roiManager", "Save", path);
            }
        }
        return true;
    }

    String getUniqueName(String[] names, int index) {
        String name = names[index];
        int n = 1;
        int index2 = this.getIndex(names, index, name);
        while (index2 != -1) {
            index2 = this.getIndex(names, index, name);
            if (index2 != -1) {
                int lastDash = name.lastIndexOf("-");
                if (lastDash != -1 && name.length() - lastDash < 5) {
                    name = name.substring(0, lastDash);
                }
                name = name + "-" + n;
                ++n;
            }
            index2 = this.getIndex(names, index, name);
        }
        names[index] = name;
        return name;
    }

    private int getIndex(String[] names, int index, String name) {
        int index2 = -1;
        for (int i = 0; i < names.length; ++i) {
            if (i == index || !names[i].equals(name)) continue;
            return i;
        }
        return index2;
    }

    private void listRois() {
        Roi[] list = this.getRoisAsArray();
        OverlayCommands.listRois(list);
        if (this.record()) {
            Recorder.record("roiManager", "List");
        }
    }

    boolean measure(ImagePlus imp) {
        if (imp == null) {
            return false;
        }
        int[] indexes = this.getIndexes();
        if (indexes.length == 0) {
            return false;
        }
        boolean allSliceOne = true;
        if (imp.getStackSize() > 1) {
            for (int i = 0; i < indexes.length; ++i) {
                String label;
                Roi roi = (Roi)this.rois.get(indexes[i]);
                if (this.getSliceNumber(roi, label = (String)this.listModel.getElementAt(indexes[i])) <= 1 && !roi.hasHyperStackPosition()) continue;
                allSliceOne = false;
                break;
            }
        }
        if (!allSliceOne && !imp.lock()) {
            return false;
        }
        int measurements = Analyzer.getMeasurements();
        if (imp.getStackSize() > 1) {
            Analyzer.setMeasurements(measurements | 0x100000);
        }
        int currentSlice = imp.getCurrentSlice();
        Analyzer.setMeasurements(measurements & 0xFFBFFFFF);
        for (int i = 0; i < indexes.length; ++i) {
            this.noUpdateMode = true;
            if (!this.restore(imp, indexes[i], !allSliceOne)) break;
            IJ.run(imp, "Measure", "");
        }
        Analyzer.setMeasurements(measurements);
        imp.setSlice(currentSlice);
        if (indexes.length > 1) {
            imp.deleteRoi();
        }
        if (this.record()) {
            Recorder.record("roiManager", "Measure");
        }
        if (!allSliceOne) {
            imp.unlock();
        }
        return true;
    }

    public ResultsTable multiMeasure(ImagePlus imp) {
        Roi[] rois = this.getSelectedRoisAsArray();
        ResultsTable rt = RoiManager.multiMeasure(imp, rois, false);
        imp.deleteRoi();
        return rt;
    }

    boolean multiMeasure(String cmd) {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        int[] indexes = this.getIndexes();
        if (indexes.length == 0) {
            this.error("Multi-measure: no selection");
            return false;
        }
        if (!imp.lock()) {
            return false;
        }
        int measurements = Analyzer.getMeasurements();
        int nSlices = imp.getStackSize();
        if (cmd != null) {
            boolean bl = this.appendResults = cmd.contains("append");
        }
        if (IJ.isMacro()) {
            if (cmd.startsWith("multi-measure")) {
                measureAll = cmd.contains(" measure") && nSlices > 1;
                onePerSlice = cmd.contains(" one");
                this.appendResults = cmd.contains(" append");
            } else {
                if (nSlices > 1) {
                    measureAll = true;
                }
                onePerSlice = true;
            }
        } else {
            GenericDialog gd = new GenericDialog("Multi Measure");
            if (nSlices > 1) {
                gd.addCheckbox("Measure all " + nSlices + " slices", measureAll);
            }
            gd.addCheckbox("One row per slice", onePerSlice);
            gd.addCheckbox("Append results", this.appendResults);
            int columns = this.getColumnCount(imp, measurements) * indexes.length;
            String str = nSlices == 1 ? "this option" : "both options";
            gd.setInsets(10, 25, 0);
            gd.addMessage("Enabling " + str + " will result\nin a table with " + columns + " columns.");
            gd.showDialog();
            if (gd.wasCanceled()) {
                imp.unlock();
                return false;
            }
            if (nSlices > 1) {
                measureAll = gd.getNextBoolean();
            }
            onePerSlice = gd.getNextBoolean();
            this.appendResults = gd.getNextBoolean();
        }
        if (!measureAll) {
            nSlices = 1;
        }
        int currentSlice = imp.getCurrentSlice();
        if (!onePerSlice) {
            int measurements2 = nSlices > 1 ? measurements | 0x100000 : measurements;
            ResultsTable rt = new ResultsTable();
            rt.showRowNumbers(true);
            if (this.appendResults && mmResults2 != null) {
                rt = mmResults2;
            }
            Analyzer analyzer = new Analyzer(imp, measurements2, rt);
            analyzer.disableReset(true);
            for (int slice = 1; slice <= nSlices; ++slice) {
                if (nSlices > 1) {
                    imp.setSliceWithoutUpdate(slice);
                }
                for (int i = 0; i < indexes.length && this.restoreWithoutUpdate(imp, indexes[i]); ++i) {
                    analyzer.measure();
                }
            }
            mmResults2 = (ResultsTable)rt.clone();
            rt.show("Results");
            if (nSlices > 1) {
                imp.setSlice(currentSlice);
            }
        } else {
            Roi[] rois = this.getSelectedRoisAsArray();
            if ("".equals(cmd)) {
                MultiMeasureRunner mmr = new MultiMeasureRunner();
                mmr.multiMeasure(imp, rois, this.appendResults);
            } else {
                ResultsTable rtMulti = RoiManager.multiMeasure(imp, rois, this.appendResults);
                mmResults = (ResultsTable)rtMulti.clone();
                rtMulti.show("Results");
                imp.setSlice(currentSlice);
                if (indexes.length > 1) {
                    IJ.run("Select None");
                }
            }
        }
        if (this.record()) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("rt = rm.multiMeasure(imp);");
                Recorder.recordCall("rt.show(\"Results\");");
            } else if ((nSlices == 1 || measureAll) && onePerSlice && !this.appendResults) {
                Recorder.record("roiManager", "Multi Measure");
            } else {
                String options = "";
                if (measureAll) {
                    options = options + " measure_all";
                }
                if (onePerSlice) {
                    options = options + " one";
                }
                if (this.appendResults) {
                    options = options + " append";
                }
                Recorder.record("roiManager", "multi-measure" + options);
            }
        }
        imp.unlock();
        return true;
    }

    public static ResultsTable multiMeasure(ImagePlus imp, Roi[] rois, boolean appendResults) {
        int nSlices = imp.getStackSize();
        Analyzer aSys = new Analyzer(imp);
        ResultsTable rtSys = Analyzer.getResultsTable();
        ResultsTable rtMulti = new ResultsTable();
        rtMulti.showRowNumbers(true);
        if (appendResults && mmResults != null) {
            rtMulti = mmResults;
        }
        rtSys.reset();
        int currentSlice = imp.getCurrentSlice();
        for (int slice = 1; slice <= nSlices; ++slice) {
            int sliceUse = slice;
            if (nSlices == 1) {
                sliceUse = currentSlice;
            }
            imp.setSliceWithoutUpdate(sliceUse);
            rtMulti.incrementCounter();
            if ((Analyzer.getMeasurements() & 0x400) != 0) {
                rtMulti.addLabel("Label", imp.getTitle());
            }
            int roiIndex = 0;
            for (int i = 0; i < rois.length; ++i) {
                imp.setRoi(rois[i]);
                ++roiIndex;
                aSys.measure();
                for (int j = 0; j <= rtSys.getLastColumn(); ++j) {
                    String name;
                    float[] col = rtSys.getColumn(j);
                    String head = rtSys.getColumnHeading(j);
                    String suffix = "" + roiIndex;
                    Roi roi = imp.getRoi();
                    if (!(roi == null || (name = roi.getName()) == null || name.length() <= 0 || name.length() >= 9 && Character.isDigit(name.charAt(0)))) {
                        suffix = "(" + name + ")";
                    }
                    if (head == null || col == null || head.equals("Slice")) continue;
                    rtMulti.addValue(head + suffix, (double)rtSys.getValue(j, rtSys.getCounter() - 1));
                }
            }
            if (nSlices <= 1) continue;
            IJ.showProgress(slice, nSlices);
        }
        return rtMulti;
    }

    int getColumnCount(ImagePlus imp, int measurements) {
        ImageStatistics stats = imp.getStatistics(measurements);
        ResultsTable rt = new ResultsTable();
        rt.showRowNumbers(true);
        Analyzer analyzer = new Analyzer(imp, measurements, rt);
        analyzer.saveResults(stats, null);
        int count = 0;
        for (int i = 0; i <= rt.getLastColumn(); ++i) {
            float[] col = rt.getColumn(i);
            String head = rt.getColumnHeading(i);
            if (head == null || col == null) continue;
            ++count;
        }
        return count;
    }

    void multiPlot() {
        Roi roi;
        boolean freeYScale;
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        int[] indexes = this.getIndexes();
        int n = indexes.length;
        if (n == 0) {
            return;
        }
        if (!imp.lock()) {
            return;
        }
        Color[] colors = new Color[]{Color.blue, Color.green, Color.magenta, Color.red, Color.cyan, Color.yellow};
        if (n > colors.length) {
            colors = new Color[n];
            double c = 0.0;
            double inc = 150.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                colors[i] = new Color((int)c, (int)c, (int)c);
                c += inc;
            }
        }
        int currentSlice = imp.getCurrentSlice();
        double[][] x = new double[n][];
        double[][] y = new double[n][];
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        double fixedMin = ProfilePlot.getFixedMin();
        double fixedMax = ProfilePlot.getFixedMax();
        boolean bl = freeYScale = fixedMin == 0.0 && fixedMax == 0.0;
        if (!freeYScale) {
            minY = fixedMin;
            maxY = fixedMax;
        }
        int maxX = 0;
        Calibration cal = imp.getCalibration();
        double xinc = cal.pixelWidth;
        for (int i = 0; i < indexes.length && this.restore(this.getImage(), indexes[i], true) && (roi = imp.getRoi()) != null; ++i) {
            if (roi.isArea() && roi.getType() != 0) {
                IJ.run(imp, "Area to Line", "");
            }
            ProfilePlot pp = new ProfilePlot(imp, Prefs.verticalProfile || IJ.altKeyDown());
            y[i] = pp.getProfile();
            if (y[i] == null) break;
            if (y[i].length > maxX) {
                maxX = y[i].length;
            }
            if (freeYScale) {
                double[] a = Tools.getMinMax(y[i]);
                if (a[0] < minY) {
                    minY = a[0];
                }
                if (a[1] > maxY) {
                    maxY = a[1];
                }
            }
            double[] xx = new double[y[i].length];
            for (int j = 0; j < xx.length; ++j) {
                xx[j] = (double)j * xinc;
            }
            x[i] = xx;
        }
        String xlabel = "Distance (" + cal.getUnits() + ")";
        Plot plot = new Plot("Profiles", xlabel, "Value", x[0], y[0]);
        plot.setLimits(0.0, (double)maxX * xinc, minY, maxY);
        for (int i = 1; i < indexes.length; ++i) {
            plot.setColor(colors[i]);
            if (x[i] == null) continue;
            plot.addPoints(x[i], y[i], 2);
        }
        plot.setColor(colors[0]);
        if (x[0] != null) {
            plot.show();
        }
        imp.setSlice(currentSlice);
        if (indexes.length > 1) {
            IJ.run("Select None");
        }
        if (this.record()) {
            Recorder.record("roiManager", "Multi Plot");
        }
        imp.unlock();
    }

    private void multiCrop() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        int[] indexes = this.getIndexes();
        int n = indexes.length;
        String directory = Prefs.get(MULTI_CROP_DIR, IJ.getDir("downloads") + "stack/");
        String[] formats = new String[]{"tif", "png", "jpg"};
        GenericDialog gd = new GenericDialog("Multi Crop");
        gd.setInsets(5, 0, 0);
        gd.addDirectoryField("Dir:", directory);
        gd.setInsets(2, 70, 10);
        gd.addMessage("drag and drop target", IJ.font10, Color.darkGray);
        gd.addChoice("Format:", formats, formats[this.multiCropFormatIndex]);
        gd.addCheckbox("Show " + n + " cropped images:", this.multiCropShow);
        gd.addCheckbox("Save " + n + " cropped images:", this.multiCropSave);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        directory = gd.getNextString();
        directory = IJ.addSeparator(directory);
        Prefs.set(MULTI_CROP_DIR, directory);
        this.multiCropFormatIndex = gd.getNextChoiceIndex();
        String format = formats[this.multiCropFormatIndex];
        this.multiCropShow = gd.getNextBoolean();
        this.multiCropSave = gd.getNextBoolean();
        String options = "";
        if (this.multiCropShow) {
            options = options + " show";
        }
        if (this.multiCropSave) {
            options = options + " save";
            options = options + " " + format;
        }
        if (this.record()) {
            String dir = Recorder.fixPath(directory);
            if (Recorder.scriptMode()) {
                Recorder.recordCall("rm.multiCrop(\"" + dir + "\", \"" + options + "\");");
            } else {
                Recorder.record("RoiManager.multiCrop", dir, options);
            }
        }
        this.multiCrop(directory, options);
    }

    public void multiCrop(String directory, String options) {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        Roi roiOrig = imp.getRoi();
        Roi[] rois = this.getSelectedRoisAsArray();
        ImagePlus[] images = imp.crop(rois);
        if (options == null) {
            options = "";
        }
        if (options.contains("show")) {
            ImageStack stack = ImageStack.create(images);
            ImagePlus imgStack = new ImagePlus("CROPPED_" + this.getTitle(), stack);
            Overlay overlay = Overlay.createStackOverlay(rois);
            imgStack.setOverlay(overlay);
            imgStack.show();
            if (roiOrig == null) {
                imp.deleteRoi();
            }
        }
        if (options.contains("save")) {
            String format = "tif";
            if (options.contains("png")) {
                format = "png";
            }
            if (options.contains("jpg")) {
                format = "jpg";
            }
            for (int i = 0; i < images.length; ++i) {
                Rectangle bounds = rois[i].getBounds();
                String title = IJ.pad(bounds.x, 4) + "-" + IJ.pad(bounds.y, 4);
                String path = directory + title + "." + format;
                IJ.saveAs(images[i], format, path);
            }
        }
    }

    public void setGroup(int group) {
        int[] indexes;
        for (int i : indexes = this.getIndexes()) {
            Roi roi = this.getRoi(i);
            roi.setGroup(group);
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.draw();
        }
    }

    public void setPosition(int position) {
        int[] indexes;
        for (int i : indexes = this.getIndexes()) {
            Roi roi = this.getRoi(i);
            roi.setPosition(position);
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.draw();
        }
    }

    public void setPosition(int c, int z, int t) {
        int[] indexes;
        for (int i : indexes = this.getIndexes()) {
            Roi roi = this.getRoi(i);
            roi.setPosition(c, z, t);
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.draw();
        }
    }

    public static void setGroup(String group) {
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            return;
        }
        int groupInt = (int)Tools.parseDouble(group, 0.0);
        if (groupInt > 0) {
            rm.setGroup(groupInt);
        }
    }

    boolean drawOrFill(int mode) {
        int[] indexes = this.getIndexes();
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return false;
        }
        if (!imp.lock()) {
            return false;
        }
        imp.deleteRoi();
        ImageProcessor ip = imp.getProcessor();
        ip.setColor(Toolbar.getForegroundColor());
        ip.snapshot();
        Undo.setup(1, imp);
        Filler filler = mode == 2 ? new Filler() : null;
        int slice = imp.getCurrentSlice();
        block5: for (int i = 0; i < indexes.length; ++i) {
            String name;
            int slice2;
            Roi roi = (Roi)this.rois.get(indexes[i]);
            int type = roi.getType();
            if (roi == null) continue;
            if (mode == 1 && (type == 6 || type == 7 || type == 8)) {
                mode = 0;
            }
            if ((slice2 = this.getSliceNumber(roi, name = (String)this.listModel.getElementAt(indexes[i]))) >= 1 && slice2 <= imp.getStackSize()) {
                imp.setSlice(slice2);
                ip = imp.getProcessor();
                ip.setColor(Toolbar.getForegroundColor());
                if (slice2 != slice) {
                    Undo.reset();
                }
            }
            switch (mode) {
                case 0: {
                    roi.drawPixels(ip);
                    continue block5;
                }
                case 1: {
                    ip.fill(roi);
                    continue block5;
                }
                case 2: {
                    roi.drawPixels(ip);
                    filler.drawLabel(imp, ip, i + 1, roi.getBounds());
                }
            }
        }
        if (this.record() && (mode == 0 || mode == 1)) {
            Recorder.record("roiManager", mode == 0 ? "Draw" : "Fill");
        }
        if (this.showAllCheckbox.getState()) {
            this.runCommand("show none");
        }
        imp.updateAndDraw();
        imp.unlock();
        return true;
    }

    void setProperties(Color color, int lineWidth, Color fillColor) {
        boolean showingAll;
        Roi roi;
        boolean showDialog = color == null && lineWidth == -1 && fillColor == null;
        int[] indexes = this.getIndexes();
        int n = indexes.length;
        if (n == 0) {
            return;
        }
        Roi rpRoi = null;
        String rpName = null;
        Font font = null;
        int justification = 0;
        String roiText = null;
        double opacity = -1.0;
        int pointType = -1;
        int pointSize = -1;
        int group = -1;
        int position = -1;
        if (showDialog) {
            rpRoi = (Roi)this.rois.get(indexes[0]);
            if (n == 1) {
                fillColor = rpRoi.getFillColor();
                rpName = rpRoi.getName();
            }
            if (rpRoi.getStrokeColor() == null && rpRoi.getFillColor() == null) {
                rpRoi.setStrokeColor(Roi.getColor());
            }
            rpRoi = (Roi)rpRoi.clone();
            if (n > 1) {
                rpRoi.setName("range: " + (indexes[0] + 1) + "-" + (indexes[n - 1] + 1));
            }
            rpRoi.setFillColor(fillColor);
            RoiProperties rp = new RoiProperties("Properties ", rpRoi);
            if (!rp.showDialog()) {
                return;
            }
            this.defaultLineWidth = lineWidth = (int)rpRoi.getStrokeWidth();
            color = rpRoi.getStrokeColor();
            fillColor = rpRoi.getFillColor();
            group = rpRoi.getGroup();
            position = rpRoi.getPosition();
            this.defaultColor = color;
            if (rpRoi instanceof TextRoi) {
                font = ((TextRoi)rpRoi).getCurrentFont();
                justification = ((TextRoi)rpRoi).getJustification();
                roiText = ((TextRoi)rpRoi).getText();
            }
            if (rpRoi instanceof ImageRoi) {
                opacity = ((ImageRoi)rpRoi).getOpacity();
            }
            if (rpRoi instanceof PointRoi) {
                pointType = ((PointRoi)rpRoi).getPointType();
                pointSize = ((PointRoi)rpRoi).getSize();
            }
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (n == this.getCount() && n > 1 && !IJ.isMacro() && imp != null && imp.getWindow() != null) {
            GenericDialog gd = new GenericDialog("ROI Manager");
            gd.addMessage("Apply changes to all " + n + " selections?");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
        }
        for (int i = 0; i < n; ++i) {
            roi = (Roi)this.rois.get(indexes[i]);
            if (roi == null) continue;
            if (color != null) {
                roi.setStrokeColor(color);
            }
            if (lineWidth >= 0) {
                roi.setStrokeWidth(lineWidth);
            }
            roi.setFillColor(fillColor);
            if (group >= 0) {
                roi.setGroup(group);
            }
            if (rpRoi != null) {
                if (rpRoi.hasHyperStackPosition()) {
                    roi.setPosition(rpRoi.getCPosition(), rpRoi.getZPosition(), rpRoi.getTPosition());
                } else {
                    roi.setPosition(rpRoi.getPosition());
                }
            }
            if (roi instanceof TextRoi && showDialog) {
                roi.setImage(imp);
                if (font != null) {
                    ((TextRoi)roi).setCurrentFont(font);
                }
                ((TextRoi)roi).setJustification(justification);
                if (n == 1) {
                    ((TextRoi)roi).setText(roiText);
                }
                roi.setImage(null);
            }
            if (roi instanceof ImageRoi && opacity != -1.0) {
                ((ImageRoi)roi).setOpacity(opacity);
            }
            if (!(roi instanceof PointRoi)) continue;
            if (pointType != -1) {
                ((PointRoi)roi).setPointType(pointType);
            }
            if (pointSize == -1) continue;
            ((PointRoi)roi).setSize(pointSize);
        }
        if (rpRoi != null && rpName != null && !rpRoi.getName().equals(rpName)) {
            this.rename(rpRoi.getName());
        }
        ImageCanvas ic = imp != null ? imp.getCanvas() : null;
        roi = imp != null ? imp.getRoi() : null;
        boolean bl = showingAll = ic != null && ic.getShowAllROIs();
        if (!(roi == null || n != 1 && showingAll)) {
            if (lineWidth >= 0) {
                roi.setStrokeWidth(lineWidth);
            }
            if (color != null) {
                roi.setStrokeColor(color);
            }
            if (group >= 0) {
                roi.setGroup(group);
            }
            if (fillColor != null) {
                roi.setFillColor(fillColor);
            }
            if (roi != null && roi instanceof TextRoi) {
                ((TextRoi)roi).setCurrentFont(font);
                ((TextRoi)roi).setJustification(justification);
                ((TextRoi)roi).setText(roiText);
            }
            if (roi != null && roi instanceof ImageRoi && opacity != -1.0) {
                ((ImageRoi)roi).setOpacity(opacity);
            }
        }
        if (lineWidth > 1 && !showingAll && roi == null) {
            this.showAll(0);
            showingAll = true;
        }
        if (imp != null) {
            imp.draw();
        }
        if (this.record()) {
            if (group >= 0) {
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("rm.setGroup(" + group + ");");
                } else {
                    Recorder.record("RoiManager.setGroup", group);
                }
            }
            if (position >= 0) {
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("rm.setPosition(" + position + ");");
                } else {
                    Recorder.record("RoiManager.setPosition", position);
                }
            }
            if (fillColor != null) {
                Recorder.record("roiManager", "Set Fill Color", Colors.colorToString(fillColor));
            } else {
                if (group == 0) {
                    Recorder.record("roiManager", "Set Color", Colors.colorToString(color != null ? color : Color.red));
                }
                Recorder.record("roiManager", "Set Line Width", lineWidth);
            }
        }
    }

    void flatten() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        if (ic != null && ic.getShowAllList() == null && imp.getOverlay() == null && imp.getRoi() == null) {
            this.error("Image does not have an overlay or ROI");
        } else {
            IJ.doCommand("Flatten");
        }
    }

    public boolean getDrawLabels() {
        return this.labelsCheckbox.getState();
    }

    private void combine() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        Roi[] rois = this.getSelectedRoisAsArray();
        if (rois.length == 1 && !IJ.isMacro()) {
            this.error("More than one item must be selected, or none");
            return;
        }
        if (this.countPointRois(rois) == rois.length) {
            this.combinePoints(imp, rois);
        } else {
            this.combineRois(imp, rois);
        }
    }

    private int countPointRois(Roi[] rois) {
        int nPointRois = 0;
        for (Roi roi : rois) {
            if (roi.getType() != 10) continue;
            ++nPointRois;
        }
        return nPointRois;
    }

    private void combineRois(ImagePlus imp, Roi[] rois) {
        if (rois.length == 1) {
            Roi roi2 = (Roi)rois[0].clone();
            roi2.setPosition(0);
            roi2.setGroup(0);
            imp.setRoi(roi2);
            return;
        }
        IJ.resetEscape();
        ShapeRoi s1 = null;
        ShapeRoi s2 = null;
        for (int i = 0; i < rois.length; ++i) {
            IJ.showProgress(i, rois.length - 1);
            if (IJ.escapePressed()) {
                IJ.showProgress(1.0);
                return;
            }
            Roi roi = rois[i];
            if (!roi.isArea() && roi.getType() != 10) {
                roi = Roi.convertLineToArea(roi);
            }
            if (s1 == null) {
                s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi.clone() : new ShapeRoi(roi);
                if (s1 != null) continue;
                return;
            }
            s2 = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
            if (s2 == null) continue;
            s1.or(s2);
        }
        if (s1 != null) {
            imp.setRoi(s1.trySimplify());
        }
    }

    void combinePoints(ImagePlus imp, Roi[] rois) {
        int n = rois.length;
        FloatPolygon fp = new FloatPolygon();
        for (int r = 0; r < n; ++r) {
            FloatPolygon fpi = rois[r].getFloatPolygon();
            for (int i = 0; i < fpi.npoints; ++i) {
                fp.addPoint(fpi.xpoints[i], fpi.ypoints[i]);
            }
        }
        imp.setRoi(new PointRoi(fp));
    }

    void and() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        Roi[] rois = this.getSelectedRoisAsArray();
        if (rois.length == 1) {
            this.error("More than one item must be selected, or none");
            return;
        }
        int nPointRois = this.countPointRois(rois);
        ShapeRoi s1 = null;
        PointRoi pointRoi = null;
        for (Roi roi : rois) {
            if (roi == null) continue;
            if (s1 == null) {
                if (nPointRois == 1 && roi.getType() == 10) {
                    pointRoi = (PointRoi)roi;
                    continue;
                }
                s1 = roi instanceof ShapeRoi ? (ShapeRoi)roi.clone() : new ShapeRoi(roi);
                if (s1 != null) continue;
                continue;
            }
            if (nPointRois == 1 && roi.getType() == 10) {
                pointRoi = (PointRoi)roi;
                continue;
            }
            ShapeRoi s2 = null;
            s2 = roi instanceof ShapeRoi ? (ShapeRoi)roi.clone() : new ShapeRoi(roi);
            if (s2 == null) continue;
            s1.and(s2);
        }
        if (s1 == null) {
            return;
        }
        if (pointRoi != null) {
            imp.setRoi(pointRoi.containedPoints(s1));
        } else {
            imp.setRoi(s1.trySimplify());
        }
        if (this.record()) {
            Recorder.record("roiManager", "AND");
        }
    }

    void xor() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        Roi[] rois = this.getSelectedRoisAsArray();
        if (rois.length == 1) {
            this.error("More than one item must be selected, or none");
            return;
        }
        Roi roi2 = Roi.xor(this.getSelectedRoisAsArray());
        if (roi2 != null) {
            imp.setRoi(roi2);
        }
        if (this.record()) {
            Recorder.record("roiManager", "XOR");
        }
    }

    void addParticles() {
        String err = IJ.runMacroFile("ij.jar:AddParticles", null);
        if (err != null && err.length() > 0) {
            this.error(err);
        }
    }

    void sort() {
        int n = this.listModel.size();
        if (n == 0) {
            return;
        }
        String[] labels = new String[n];
        for (int i = 0; i < n; ++i) {
            labels[i] = (String)this.listModel.get(i);
        }
        int[] indices = Tools.rank(labels);
        Roi[] rois2 = this.getRoisAsArray();
        this.listModel.removeAllElements();
        this.rois.clear();
        for (int i = 0; i < labels.length; ++i) {
            this.listModel.addElement(labels[indices[i]]);
            this.rois.add(rois2[indices[i]]);
        }
        if (this.record()) {
            Recorder.record("roiManager", "Sort");
        }
    }

    void specify() {
        try {
            IJ.run("Specify...");
        }
        catch (Exception e) {
            return;
        }
        this.runCommand("add");
    }

    private void removePositions(int position) {
        int[] indexes = this.getIndexes();
        if (indexes.length == 0) {
            return;
        }
        boolean removeChannels = position == 0;
        boolean removeFrames = position == 2;
        boolean removeSlices = !removeChannels && !removeFrames;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (position == 3) {
            if (imp != null && !imp.isHyperStack()) {
                channel = false;
                slice = true;
                frame = false;
            }
            if (imp != null && imp.isHyperStack()) {
                frame = false;
                slice = false;
                channel = false;
                if (imp.getNSlices() > 1) {
                    slice = true;
                }
                if (imp.getNFrames() > 1 && imp.getNSlices() == 1) {
                    frame = true;
                }
            }
            Font font = new Font("SansSerif", 1, 12);
            GenericDialog gd = new GenericDialog("Remove");
            gd.setInsets(5, 15, 0);
            gd.addMessage("Remove positions for:      ", font);
            gd.setInsets(6, 25, 0);
            gd.addCheckbox("Channels c:", channel);
            gd.setInsets(0, 25, 0);
            gd.addCheckbox("Slices z:", slice);
            gd.setInsets(0, 25, 0);
            gd.addCheckbox("Frames t:", frame);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            removeChannels = gd.getNextBoolean();
            removeSlices = gd.getNextBoolean();
            removeFrames = gd.getNextBoolean();
        }
        if (!(removeChannels || removeSlices || removeFrames)) {
            slice = true;
            return;
        }
        for (int i = 0; i < indexes.length; ++i) {
            int index = indexes[i];
            Roi roi = (Roi)this.rois.get(index);
            String name = (String)this.listModel.getElementAt(index);
            int n = this.getSliceNumber(name);
            if (n > 0) {
                String name2 = name.substring(5, name.length());
                roi.setName(name2);
                this.rois.set(index, roi);
                this.listModel.setElementAt(name2, index);
            }
            int c = roi.getCPosition();
            int z = roi.getZPosition();
            int t = roi.getTPosition();
            if (roi.hasHyperStackPosition()) {
                if (removeChannels) {
                    c = 0;
                }
                if (removeSlices) {
                    z = 0;
                }
                if (removeFrames) {
                    t = 0;
                }
                roi.setPosition(c, z, t);
                continue;
            }
            if (!removeSlices) continue;
            roi.setPosition(0);
        }
        if (imp != null) {
            imp.draw();
        }
        if (this.record()) {
            if (removeChannels) {
                Recorder.record("roiManager", "Remove Channel Info");
            }
            if (removeSlices) {
                Recorder.record("roiManager", "Remove Slice Info");
            }
            if (removeFrames) {
                Recorder.record("roiManager", "Remove Frame Info");
            }
        }
    }

    private void help() {
        String macro = "run('URL...', 'url=http://imagej.net/ij/docs/menus/analyze.html#manager');";
        new MacroRunner(macro);
    }

    private void labels() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            this.showAllCheckbox.setState(true);
            this.labelsCheckbox.setState(true);
            this.showAll(2);
        }
        try {
            IJ.run("Labels...");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Overlay defaultOverlay = OverlayLabels.createOverlay();
        Prefs.useNamesAsLabels = defaultOverlay.getDrawNames();
    }

    private void options() {
        Color c = ImageCanvas.getShowAllColor();
        GenericDialog gd = new GenericDialog("Options");
        gd.addCheckbox("Associate \"Show All\" ROIs with slices", Prefs.showAllSliceOnly);
        gd.addCheckbox("Restore ROIs centered", restoreCentered);
        gd.addCheckbox("Use ROI names as labels", Prefs.useNamesAsLabels);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (c != ImageCanvas.getShowAllColor()) {
                ImageCanvas.setShowAllColor(c);
            }
            return;
        }
        Prefs.showAllSliceOnly = gd.getNextBoolean();
        restoreCentered = gd.getNextBoolean();
        Prefs.useNamesAsLabels = gd.getNextBoolean();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            ImageCanvas ic;
            Overlay overlay = imp.getOverlay();
            if (overlay == null && (ic = imp.getCanvas()) != null) {
                overlay = ic.getShowAllList();
            }
            if (overlay != null) {
                overlay.drawNames(Prefs.useNamesAsLabels);
                this.setOverlay(imp, overlay);
            } else {
                imp.draw();
            }
        }
        if (this.record()) {
            if (Recorder.scriptMode()) {
                Recorder.recordString("Prefs.showAllSliceOnly = " + Prefs.showAllSliceOnly + ";\n");
                Recorder.recordString("RoiManager.restoreCentered(" + restoreCentered + ");\n");
                Recorder.recordString("Prefs.useNamesAsLabels = " + Prefs.useNamesAsLabels + ";\n");
            } else {
                Recorder.recordString("RoiManager.associateROIsWithSlices(" + Prefs.showAllSliceOnly + ");\n");
                Recorder.recordString("RoiManager.restoreCentered(" + restoreCentered + ");\n");
                Recorder.recordString("RoiManager.useNamesAsLabels(" + Prefs.useNamesAsLabels + ");\n");
            }
        }
    }

    Panel makeButtonPanel(GenericDialog gd) {
        Panel panel = new Panel();
        this.colorButton = new Button("\"Show All\" Color...");
        this.colorButton.addActionListener(this);
        panel.add(this.colorButton);
        return panel;
    }

    void setShowAllColor() {
        ColorChooser cc = new ColorChooser("\"Show All\" Color", ImageCanvas.getShowAllColor(), false);
        ImageCanvas.setShowAllColor(cc.getColor());
    }

    void split() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null || roi.getType() != 9) {
            this.error("Image with composite selection required");
            return;
        }
        Recorder.suspendRecording();
        Roi[] rois = ((ShapeRoi)roi).getRois();
        for (int i = 0; i < rois.length; ++i) {
            imp.setRoi(rois[i]);
            this.addRoi(false);
        }
        Recorder.resumeRecording();
        if (this.record()) {
            Recorder.record("roiManager", "Split");
        }
    }

    void showAll(int mode) {
        boolean showAll;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        boolean bl = showAll = mode == 0;
        if (showAll) {
            this.imageID = imp.getID();
        }
        if (mode == 2 || mode == 3) {
            showAll = true;
        }
        if (showAll) {
            imp.deleteRoi();
        }
        if (mode == 1) {
            this.removeOverlay(imp);
            this.imageID = 0;
        } else if (this.getCount() > 0) {
            Roi[] rois = this.getRoisAsArray();
            Overlay overlay = this.newOverlay();
            for (int i = 0; i < rois.length; ++i) {
                overlay.add(rois[i]);
            }
            this.setOverlay(imp, overlay);
        }
    }

    void updateShowAll() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        if (this.showAllCheckbox.getState()) {
            if (this.getCount() > 0) {
                Roi[] rois = this.getRoisAsArray();
                Overlay overlay = this.newOverlay();
                for (int i = 0; i < rois.length; ++i) {
                    overlay.add(rois[i]);
                }
                this.setOverlay(imp, overlay);
            } else {
                this.removeOverlay(imp);
            }
        } else {
            this.removeOverlay(imp);
        }
    }

    int[] getAllIndexes() {
        int count = this.getCount();
        int[] indexes = new int[count];
        for (int i = 0; i < count; ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    ImagePlus getImage() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.error("There are no images open.");
            return null;
        }
        return imp;
    }

    boolean error(String msg) {
        new MessageDialog((Frame)this, "ROI Manager", msg);
        Macro.abort();
        return false;
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            instance = null;
        }
        if (!IJ.isMacro()) {
            this.ignoreInterrupts = false;
        }
    }

    public static RoiManager getRoiManager() {
        if (instance != null) {
            return (RoiManager)instance;
        }
        return new RoiManager();
    }

    public static RoiManager getInstance() {
        if (instance == null && IJ.isMacro()) {
            return Interpreter.getBatchModeRoiManager();
        }
        return (RoiManager)instance;
    }

    public static RoiManager getRawInstance() {
        return (RoiManager)instance;
    }

    public static RoiManager getInstance2() {
        RoiManager rm = RoiManager.getInstance();
        if (rm == null && IJ.isMacro()) {
            rm = Interpreter.getBatchModeRoiManager();
        }
        return rm;
    }

    public Hashtable getROIs() {
        Roi[] rois = this.getRoisAsArray();
        Hashtable<String, Roi> ht = new Hashtable<String, Roi>();
        for (int i = 0; i < rois.length; ++i) {
            ht.put((String)this.listModel.getElementAt(i), rois[i]);
        }
        return ht;
    }

    public List getList() {
        List awtList = new List();
        for (int i = 0; i < this.getCount(); ++i) {
            awtList.add((String)this.listModel.getElementAt(i));
        }
        int index = this.getSelectedIndex();
        if (index >= 0) {
            awtList.select(index);
        }
        return awtList;
    }

    public int getCount() {
        return this.listModel != null ? this.listModel.getSize() : 0;
    }

    public int selected() {
        return this.getSelectedIndexes().length;
    }

    public int getRoiIndex(Roi roi) {
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            Roi roi2 = (Roi)this.rois.get(i);
            if (roi != roi2) continue;
            return i;
        }
        return -1;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public Roi getRoi(int index) {
        if (index < 0 || index >= this.getCount()) {
            return null;
        }
        return (Roi)this.rois.get(index);
    }

    public synchronized Roi[] getRoisAsArray() {
        Roi[] array = new Roi[this.rois.size()];
        return this.rois.toArray(array);
    }

    public Roi[] getSelectedRoisAsArray() {
        int[] indexes = this.getIndexes();
        int n = indexes.length;
        Roi[] array = new Roi[n];
        for (int i = 0; i < n; ++i) {
            array[i] = (Roi)this.rois.get(indexes[i]);
        }
        return array;
    }

    public String getName(int index) {
        if (index >= 0 && index < this.getCount()) {
            return (String)this.listModel.getElementAt(index);
        }
        return null;
    }

    public int getIndex(String name) {
        Roi[] rois = this.getRoisAsArray();
        for (int i = 0; i < rois.length; ++i) {
            if (!name.equals(rois[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public static String getName(String index) {
        int i = (int)Tools.parseDouble(index, -1.0);
        RoiManager instance = RoiManager.getInstance2();
        if (instance != null && i >= 0 && i < instance.getCount()) {
            return (String)instance.listModel.getElementAt(i);
        }
        return "null";
    }

    public boolean runCommand(String cmd) {
        cmd = cmd.toLowerCase();
        this.macro = true;
        boolean ok = true;
        if (cmd.equals("add")) {
            boolean shift = IJ.shiftKeyDown();
            boolean alt = IJ.altKeyDown();
            if (Interpreter.isBatchMode()) {
                shift = false;
                alt = false;
            }
            this.add(shift, alt);
            if (IJ.isJava18() && IJ.isMacOSX()) {
                this.repaint();
            }
        } else if (cmd.equals("add & draw")) {
            this.addAndDraw(false);
        } else if (cmd.equals("update")) {
            this.update(true);
        } else if (cmd.equals("update2")) {
            this.update(false);
        } else if (cmd.equals("delete")) {
            this.delete(false);
        } else if (cmd.equals("measure")) {
            if (EventQueue.isDispatchThread()) {
                this.measure(this.getImage());
            } else {
                try {
                    final ImagePlus imp = this.getImage();
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            RoiManager.this.measure(imp);
                        }
                    });
                }
                catch (Exception exception) {}
            }
        } else if (cmd.equals("draw")) {
            this.drawOrFill(0);
        } else if (cmd.equals("fill")) {
            this.drawOrFill(1);
        } else if (cmd.equals("label")) {
            this.drawOrFill(2);
        } else if (cmd.equals("and")) {
            this.and();
        } else if (cmd.equals("or") || cmd.equals("combine")) {
            this.combine();
        } else if (cmd.equals("xor")) {
            this.xor();
        } else if (cmd.equals("split")) {
            this.split();
        } else if (cmd.equals("sort")) {
            this.sort();
        } else if (cmd.startsWith("multi measure") || cmd.startsWith("multi-measure")) {
            this.multiMeasure(cmd);
        } else if (cmd.equals("multi plot")) {
            this.multiPlot();
        } else if (cmd.equals("show all")) {
            if (WindowManager.getCurrentImage() != null) {
                this.showAll(0);
                this.showAllCheckbox.setState(true);
            }
        } else if (cmd.equals("show none")) {
            if (WindowManager.getCurrentImage() != null) {
                this.showAll(1);
                this.showAllCheckbox.setState(false);
            }
        } else if (cmd.equals("show all with labels")) {
            this.labelsCheckbox.setState(true);
            this.showAll(2);
            this.showAllCheckbox.setState(true);
            if (Interpreter.isBatchMode()) {
                IJ.wait(250);
            }
        } else if (cmd.equals("show all without labels")) {
            this.showAllCheckbox.setState(true);
            this.labelsCheckbox.setState(false);
            this.showAll(3);
            if (Interpreter.isBatchMode()) {
                IJ.wait(250);
            }
        } else if (cmd.equals("deselect") || cmd.indexOf("all") != -1) {
            if (IJ.isMacOSX()) {
                this.ignoreInterrupts = true;
            }
            this.deselect();
            IJ.wait(50);
        } else if (cmd.equals("reset")) {
            this.reset();
        } else if (!cmd.equals("debug")) {
            if (cmd.equals("enable interrupts")) {
                this.ignoreInterrupts = false;
            } else if (cmd.equals("remove channel info")) {
                this.removePositions(0);
            } else if (cmd.equals("remove slice info")) {
                this.removePositions(1);
            } else if (cmd.equals("remove frame info")) {
                this.removePositions(2);
            } else if (cmd.equals("list")) {
                this.listRois();
            } else if (cmd.equals("interpolate rois")) {
                this.interpolateRois();
            } else {
                ok = false;
            }
        }
        this.macro = false;
        return ok;
    }

    public boolean runCommand(ImagePlus imp, String cmd) {
        WindowManager.setTempCurrentImage(imp);
        boolean ok = this.runCommand(cmd);
        WindowManager.setTempCurrentImage(null);
        return ok;
    }

    public boolean runCommand(String cmd, String name) {
        cmd = cmd.toLowerCase();
        this.macro = true;
        if (cmd.equals("open")) {
            boolean ok = this.open(Opener.makeFullPath(name));
            this.macro = false;
            return ok;
        }
        if (cmd.equals("save")) {
            boolean ok = false;
            ok = name != null && name.endsWith(".roi") ? this.saveOne(this.getIndexes(), name) : this.save(name, false);
            return ok;
        }
        if (cmd.equals("save selected")) {
            if (name != null && name.endsWith(".roi")) {
                return this.saveOne(this.getIndexes(), name);
            }
            return this.save(name, true);
        }
        if (cmd.equals("rename")) {
            this.rename(name);
            this.macro = false;
            return true;
        }
        if (cmd.equals("set color")) {
            Color color = Colors.decode(name, Color.cyan);
            this.setProperties(color, -1, null);
            this.macro = false;
            return true;
        }
        if (cmd.equals("set fill color")) {
            Color fillColor = Colors.decode(name, Color.cyan);
            this.setProperties(null, -1, fillColor);
            this.macro = false;
            return true;
        }
        if (cmd.equals("set line width")) {
            int lineWidth = (int)Tools.parseDouble(name, 0.0);
            if (lineWidth >= 0) {
                this.setProperties(null, lineWidth, null);
            }
            this.macro = false;
            return true;
        }
        if (cmd.equals("associate")) {
            Prefs.showAllSliceOnly = name.equals("true");
            this.macro = false;
            return true;
        }
        if (cmd.equals("centered")) {
            restoreCentered = name.equals("true");
            this.macro = false;
            return true;
        }
        if (cmd.equals("usenames")) {
            ImagePlus imp;
            Prefs.useNamesAsLabels = name.equals("true");
            this.macro = false;
            if (this.labelsCheckbox.getState() && (imp = WindowManager.getCurrentImage()) != null) {
                imp.draw();
            }
            return true;
        }
        return false;
    }

    public void reset() {
        if (IJ.isMacOSX() && IJ.isMacro()) {
            this.ignoreInterrupts = true;
        }
        if (this.listModel != null) {
            this.listModel.removeAllElements();
        }
        this.overlayTemplate = null;
        this.rois.clear();
        this.updateShowAll();
    }

    private void scale() {
        GenericDialog gd = new GenericDialog("Scale");
        gd.addNumericField("X scale factor:", xscale, 2, 4, "");
        gd.addNumericField("Y scale factor:", yscale, 2, 4, "");
        gd.addCheckbox("Centered", scaleCentered);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        xscale = gd.getNextNumber();
        yscale = gd.getNextNumber();
        scaleCentered = gd.getNextBoolean();
        this.scale(xscale, yscale, scaleCentered);
        if (this.record()) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("rm.scale(" + xscale + ", " + yscale + ", " + scaleCentered + ");");
            } else {
                Recorder.recordString("RoiManager.scale(" + xscale + ", " + yscale + ", " + scaleCentered + ");\n");
            }
        }
    }

    public void scale(double xscale, double yscale, boolean centered) {
        int[] indexes = this.getIndexes();
        for (int i = 0; i < indexes.length; ++i) {
            Roi roi = (Roi)this.rois.get(indexes[i]);
            Roi roi2 = RoiScaler.scale(roi, xscale, yscale, centered);
            this.rois.set(indexes[i], roi2);
        }
        this.updateShowAll();
    }

    private void rotate() {
        double xcenter = Double.NaN;
        double ycenter = Double.NaN;
        GenericDialog gd = new GenericDialog("Rotate");
        gd.addNumericField("Angle:", angle, 2, 5, "degrees");
        gd.addCheckbox("Rotate around image center", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        angle = gd.getNextNumber();
        if (angle == 0.0) {
            return;
        }
        boolean rotateAroundImageCenter = gd.getNextBoolean();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && rotateAroundImageCenter) {
            xcenter = (double)imp.getWidth() / 2.0;
            ycenter = (double)imp.getHeight() / 2.0;
        }
        this.rotate(angle, xcenter, ycenter);
        if (this.record()) {
            if (Recorder.scriptMode()) {
                if (Double.isNaN(xcenter)) {
                    Recorder.recordCall("rm.rotate(" + angle + ");");
                } else {
                    Recorder.recordCall("rm.rotate(" + angle + ", " + xcenter + ", " + ycenter + ");");
                }
            } else if (Double.isNaN(xcenter)) {
                Recorder.recordString("RoiManager.rotate(" + angle + ");\n");
            } else {
                Recorder.recordString("RoiManager.rotate(" + angle + ", " + xcenter + ", " + ycenter + ");\n");
            }
        }
    }

    public void rotate(double angle) {
        this.rotate(angle, Double.NaN, Double.NaN);
    }

    public void rotate(double angle, double xcenter, double ycenter) {
        boolean useRoiCenter = Double.isNaN(xcenter);
        int[] indexes = this.getIndexes();
        for (int i = 0; i < indexes.length; ++i) {
            Roi roi = (Roi)this.rois.get(indexes[i]);
            if (useRoiCenter) {
                FloatPolygon center = roi.getRotationCenter();
                xcenter = center.xpoints[0];
                ycenter = center.ypoints[0];
            }
            Roi roi2 = RoiRotator.rotate(roi, angle, xcenter, ycenter);
            this.rois.set(indexes[i], roi2);
        }
        this.updateShowAll();
    }

    private void translate() {
        GenericDialog gd = new GenericDialog("Translate");
        gd.addNumericField("X offset (pixels): ", this.translateX, 0);
        gd.addNumericField("Y offset (pixels): ", this.translateY, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.translateX = gd.getNextNumber();
        this.translateY = gd.getNextNumber();
        this.translate(this.translateX, this.translateY);
        if (this.record()) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("rm.translate(" + this.translateX + ", " + this.translateY + ");");
            } else {
                Recorder.record("RoiManager.translate", (int)this.translateX, (int)this.translateY);
            }
        }
    }

    public void translate(double dx, double dy) {
        Roi[] rois = this.getSelectedRoisAsArray();
        for (int i = 0; i < rois.length; ++i) {
            rois[i].translate(dx, dy);
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.draw();
        }
    }

    private boolean save(String name, boolean saveSelected) {
        errorMessage = null;
        if (!name.endsWith(".zip") && !name.equals("")) {
            errorMessage = "Name must end with '.zip'";
            return this.error(errorMessage);
        }
        if (this.getCount() == 0) {
            return this.error("The list is empty");
        }
        int[] indexes = null;
        indexes = saveSelected ? this.getIndexes() : this.getAllIndexes();
        boolean ok = false;
        ok = name.equals("") ? this.saveMultiple(indexes, null) : this.saveMultiple(indexes, name);
        this.macro = false;
        return ok;
    }

    public boolean runCommand(String cmd, String hexColor, double lineWidth) {
        if (hexColor == null && lineWidth == 1.0 && IJ.altKeyDown() && !Interpreter.isBatchMode()) {
            this.addRoi(true);
        } else {
            Color color = hexColor != null ? Colors.decode(hexColor, Color.cyan) : null;
            this.addRoi(null, false, color, (int)Math.round(lineWidth));
        }
        return true;
    }

    public void select(int index) {
        this.select(null, index);
    }

    public void select(ImagePlus imp, int index) {
        this.deselect();
        if (index < 0) {
            return;
        }
        this.list.setSelectedIndex(index);
        if (imp == null) {
            imp = WindowManager.getCurrentImage();
        }
        if (imp != null) {
            this.restore(imp, index, true);
        }
    }

    public void selectAndMakeVisible(ImagePlus imp, int index) {
        this.select(imp, index);
        this.list.ensureIndexIsVisible(index);
        this.repaint();
    }

    public void select(int index, boolean shiftKeyDown, boolean altKeyDown) {
        ImagePlus imp;
        if (!shiftKeyDown && !altKeyDown) {
            this.select(index);
        }
        if ((imp = IJ.getImage()) == null) {
            return;
        }
        Roi previousRoi = imp.getRoi();
        if (previousRoi == null) {
            this.select(index);
            return;
        }
        Roi.setPreviousRoi(previousRoi);
        Roi roi = (Roi)this.rois.get(index);
        if (roi != null) {
            roi.setImage(imp);
            roi.update(shiftKeyDown, altKeyDown);
        }
    }

    public void selectGroup(int group) {
        ArrayList<Integer> listSelected = new ArrayList<Integer>();
        for (int i = 0; i < this.getCount(); ++i) {
            Roi roi = this.getRoi(i);
            if (roi.getGroup() != group) continue;
            listSelected.add(i);
        }
        int[] selected = new int[listSelected.size()];
        for (int j = 0; j < listSelected.size(); ++j) {
            selected[j] = (Integer)listSelected.get(j);
        }
        this.setSelectedIndexes(selected);
    }

    public void selectPosition(int c, int z, int t) {
        ArrayList<Integer> listSelected = new ArrayList<Integer>();
        for (int i = 0; i < this.getCount(); ++i) {
            Roi roi = this.getRoi(i);
            int c2 = roi.getCPosition();
            int z2 = roi.getZPosition();
            int t2 = roi.getTPosition();
            if (!(c != 0 && c == c2 || z != 0 && z == z2) && (t == 0 || t != t2)) continue;
            listSelected.add(i);
        }
        int[] selected = new int[listSelected.size()];
        for (int j = 0; j < listSelected.size(); ++j) {
            selected[j] = (Integer)listSelected.get(j);
        }
        this.setSelectedIndexes(selected);
    }

    public static void selectGroup(String group) {
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            return;
        }
        int groupInt = (int)Tools.parseDouble(group, 0.0);
        if (groupInt > 0) {
            rm.selectGroup(groupInt);
        }
    }

    public void deselect() {
        if (IJ.debugMode) {
            IJ.log("deselect");
        }
        this.list.clearSelection();
        if (this.record()) {
            Recorder.record("roiManager", "Deselect");
        }
    }

    public void deselect(Roi roi) {
        String label;
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 1 && this.listModel.getSize() > 0 && (label = (String)this.listModel.getElementAt(indexes[0])).equals(roi.getName())) {
            this.deselect();
            this.repaint();
        }
    }

    public void setEditMode(ImagePlus imp, boolean editMode) {
        this.showAllCheckbox.setState(editMode);
        this.labelsCheckbox.setState(editMode);
        this.showAll(editMode ? 2 : 1);
    }

    @Override
    public void close() {
        super.close();
        instance = null;
        RoiManager.resetMultiMeasureResults();
        Prefs.saveLocation(LOC_KEY, this.getLocation());
        if (!this.showAllCheckbox.getState() || IJ.macroRunning()) {
            return;
        }
        int n = this.getCount();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp.getCanvas() != null && imp.getCanvas().getShowAllList() == null) {
            return;
        }
        if (n > 0) {
            GenericDialog gd = new GenericDialog("ROI Manager");
            gd.addMessage("Save the " + n + " displayed ROIs as an overlay?");
            gd.setOKLabel("Discard");
            gd.setCancelLabel("Save as Overlay");
            gd.showDialog();
            if (gd.wasCanceled()) {
                this.moveRoisToOverlay(imp);
            } else {
                this.removeOverlay(imp);
            }
        } else {
            imp.draw();
        }
    }

    public void moveRoisToOverlay(ImagePlus imp) {
        if (imp == null) {
            return;
        }
        Roi[] rois = this.getRoisAsArray();
        int n = rois.length;
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            overlay = this.newOverlay();
        }
        for (int i = 0; i < n; ++i) {
            Roi roi = (Roi)rois[i].clone();
            overlay.add(roi);
        }
        if (this.overlayTemplate != null) {
            overlay.drawLabels(this.overlayTemplate.getDrawLabels());
        }
        imp.setOverlay(overlay);
        if (imp.getCanvas() != null) {
            this.setOverlay(imp, null);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger() || e.isMetaDown()) {
            this.pm.show(e.getComponent(), x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        RoiManager roiManager = this;
        synchronized (roiManager) {
            int index = this.list.getSelectedIndex();
            int rot = event.getWheelRotation();
            if (rot < -1) {
                rot = -1;
            }
            if (rot > 1) {
                rot = 1;
            }
            if ((index += rot) < 0) {
                index = 0;
            }
            if (index >= this.getCount()) {
                index = this.getCount();
            }
            this.select(index);
            if (IJ.isWindows()) {
                this.list.requestFocusInWindow();
            }
            if (IJ.isJava18() && IJ.isMacOSX()) {
                this.repaint();
            }
        }
    }

    public void setSelectedIndexes(int[] indexes) {
        int count = this.getCount();
        if (count == 0) {
            return;
        }
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] < 0) {
                indexes[i] = 0;
            }
            if (indexes[i] < count) continue;
            indexes[i] = count - 1;
        }
        this.list.setSelectedIndices(indexes);
    }

    public int[] getSelectedIndexes() {
        return this.list.getSelectedIndices();
    }

    public static String getIndexesAsString() {
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            return "";
        }
        String str = Arrays.toString(rm.getSelectedIndexes());
        str = str.replaceAll(",", "");
        return str.substring(1, str.length() - 1);
    }

    public int[] getIndexes() {
        int[] indexes = this.getSelectedIndexes();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        return indexes;
    }

    public boolean isSelected(int index) {
        return index >= 0 && index < this.listModel.getSize() && this.list.isSelectedIndex(index);
    }

    private Overlay newOverlay() {
        Overlay overlay = OverlayLabels.createOverlay();
        overlay.drawLabels(this.labelsCheckbox.getState());
        if (overlay.getLabelFont() == null && overlay.getLabelColor() == null) {
            overlay.setLabelColor(Color.white);
            overlay.drawBackgrounds(true);
        }
        overlay.drawNames(Prefs.useNamesAsLabels);
        if (this.overlayTemplate != null) {
            overlay.drawNames(this.overlayTemplate.getDrawNames());
            overlay.drawBackgrounds(this.overlayTemplate.getDrawBackgrounds());
            overlay.setLabelColor(this.overlayTemplate.getLabelColor());
            overlay.setLabelFont(this.overlayTemplate.getLabelFont(), this.overlayTemplate.scalableLabels());
        }
        return overlay;
    }

    private void removeOverlay(ImagePlus imp) {
        if (imp != null && imp.getCanvas() != null) {
            this.setOverlay(imp, null);
        }
    }

    private void setOverlay(ImagePlus imp, Overlay overlay) {
        if (imp == null) {
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            if (imp.getOverlay() == null) {
                imp.setOverlay(overlay);
            }
            return;
        }
        ic.setShowAllList(overlay);
        imp.draw();
    }

    private boolean record() {
        return Recorder.record && this.allowRecording && !IJ.isMacro();
    }

    private boolean recordInEvent() {
        return Recorder.record && !IJ.isMacro();
    }

    public void allowRecording(boolean allow) {
        this.allowRecording = allow;
    }

    public static void restoreCentered(boolean b) {
        restoreCentered = b;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && !e.isConsumed()) {
            e.consume();
            if (MacroInstaller.isMacroCommand("ROI Manager Action")) {
                IJ.run("ROI Manager Action");
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.getCount() == 0) {
            if (this.recordInEvent()) {
                Recorder.record("roiManager", "Deselect");
            }
            return;
        }
        int[] selected = this.list.getSelectedIndices();
        if (selected.length == 0) {
            this.imageID = 0;
            return;
        }
        if (WindowManager.getCurrentImage() != null) {
            if (selected.length == 1) {
                Roi roi;
                ImagePlus imp = this.getImage();
                if (imp != null && (roi = imp.getRoi()) != null) {
                    Roi.setPreviousRoi(roi);
                }
                this.restore(imp, selected[0], true);
                ResultsTable.selectRow(imp != null ? imp.getRoi() : null);
                int n = this.imageID = imp != null ? imp.getID() : 0;
            }
            if (this.recordInEvent()) {
                String arg = Arrays.toString(selected);
                if (!arg.startsWith("[") || !arg.endsWith("]")) {
                    return;
                }
                arg = arg.substring(1, arg.length() - 1);
                arg = arg.replace(" ", "");
                if (Recorder.scriptMode()) {
                    if (selected.length == 1) {
                        Recorder.recordCall("rm.select(" + arg + ");");
                    } else {
                        Recorder.recordCall("rm.setSelectedIndexes([" + arg + "]);");
                    }
                } else if (selected.length == 1) {
                    Recorder.recordString("roiManager(\"Select\", " + arg + ");\n");
                } else {
                    Recorder.recordString("roiManager(\"Select\", newArray(" + arg + "));\n");
                }
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && this.imageID != 0 && imp.getID() != this.imageID) {
            this.showAll(1);
            if (this.okToSet()) {
                this.showAllCheckbox.setState(false);
            }
            this.deselect();
            this.imageID = 0;
        }
    }

    public static void resetMultiMeasureResults() {
        mmResults2 = null;
        mmResults = null;
    }

    public void setOverlay(Overlay overlay) {
        if (overlay == null) {
            this.overlayTemplate = null;
            return;
        }
        this.reset();
        this.overlayTemplate = overlay.create();
        this.setEditMode(null, false);
        for (int i = 0; i < overlay.size(); ++i) {
            this.add(overlay.get(i), i + 1);
        }
        this.setEditMode(null, true);
        this.runCommand("show all");
    }

    public static String getErrorMessage() {
        return errorMessage;
    }

    @Override
    public String toString() {
        return "RoiManager[size=" + this.getCount() + ", visible=" + this.isVisible() + "]";
    }

    @Override
    public Iterator<Roi> iterator() {
        Iterator<Roi> it = new Iterator<Roi>(){
            private int index = -1;
            RoiManager rm = RoiManager.getInstance();

            @Override
            public boolean hasNext() {
                return this.index + 1 < this.rm.getCount();
            }

            @Override
            public Roi next() {
                if (this.index + 1 < this.rm.getCount()) {
                    return this.rm.getRoi(++this.index);
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }

    static {
        colorIndex = 4;
        measureAll = true;
        onePerSlice = true;
        angle = 45.0;
        xscale = 1.5;
        yscale = 1.5;
        scaleCentered = true;
        channel = false;
        slice = true;
        frame = false;
    }

    private class MultiMeasureRunner
    implements Runnable {
        private Thread thread;
        private ImagePlus imp;
        private Roi[] rois;
        private boolean appendResults;

        private MultiMeasureRunner() {
        }

        public void multiMeasure(ImagePlus imp, Roi[] rois, boolean appendResults) {
            this.imp = imp;
            this.rois = rois;
            this.appendResults = appendResults;
            this.thread = new Thread((Runnable)this, "MultiMeasure");
            this.thread.start();
        }

        @Override
        public void run() {
            int currentSlice = this.imp.getCurrentSlice();
            ResultsTable rtMulti = RoiManager.multiMeasure(this.imp, this.rois, this.appendResults);
            mmResults = (ResultsTable)rtMulti.clone();
            rtMulti.show("Results");
            this.imp.setSlice(currentSlice);
            if (this.rois.length > 1) {
                IJ.run("Select None");
            }
        }
    }
}

