/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Plot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.FloatArray;
import ij.util.Tools;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;

public class LineGraphAnalyzer
implements PlugInFilter,
Measurements {
    static final int MAX_EXTRAPOLATE = 10;
    static final int MAX_Y_JUMP = 10;
    ImagePlus imp;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    @Override
    public void run(ImageProcessor ip) {
        this.analyze(this.imp);
    }

    public void analyze(ImagePlus imp) {
        int n;
        Calibration cal = imp.getCalibration();
        boolean invertedLut = imp.isInvertedLut();
        Roi roi = imp.getRoi();
        ImageProcessor ip = imp.getProcessor();
        Rectangle rect = ip.getRoi();
        int height = ip.getHeight();
        double minThreshold = ip.getMinThreshold();
        double maxThreshold = ip.getMaxThreshold();
        if (minThreshold == -808080.0) {
            double midValue = cal.getCValue(0.5 * (ip.getMin() + ip.getMax()));
            minThreshold = invertedLut ? midValue : -3.4028234663852886E38;
            maxThreshold = invertedLut ? 3.4028234663852886E38 : midValue;
        }
        int xStart = -1;
        FloatArray xData = new FloatArray(rect.width);
        ArrayList<FloatArray> yDataAll = new ArrayList<FloatArray>(10);
        FloatArray yValuesLo = new FloatArray(10);
        FloatArray yValuesHi = new FloatArray(10);
        FloatArray curveValuesLo = new FloatArray(10);
        FloatArray curveValuesHi = new FloatArray(10);
        Extrapolator extrapolator = new Extrapolator();
        for (int x = rect.x; x < rect.x + rect.width; ++x) {
            boolean lastIsForeground = false;
            for (int y = rect.y; y < rect.y + rect.height; ++y) {
                boolean isForeground = false;
                if (roi == null || roi.contains(x, y)) {
                    float value = ip.getPixelValue(x, y);
                    boolean bl = isForeground = (double)value >= minThreshold && (double)value <= maxThreshold;
                }
                if (isForeground) {
                    if (lastIsForeground) continue;
                    yValuesLo.add(y);
                    lastIsForeground = true;
                    if (xStart >= 0) continue;
                    xStart = x;
                    continue;
                }
                if (!lastIsForeground) continue;
                yValuesHi.add(y - 1);
                lastIsForeground = false;
            }
            if (yValuesLo.size() > yValuesHi.size()) {
                yValuesHi.add(rect.y + rect.height - 1);
            }
            if (xStart >= 0) {
                float xScaled = (float)cal.getX(x);
                xData.add(xScaled);
            }
            if (yValuesLo.size() > 0) {
                int n2;
                double[] missing = new double[yDataAll.size()];
                for (int n3 = 0; n3 < yDataAll.size(); ++n3) {
                    FloatArray arr = (FloatArray)yDataAll.get(n3);
                    for (int ix = x - xStart - 1; ix >= 0 && ix >= x - xStart - 10; --ix) {
                        if (ix < arr.size() && !Float.isNaN(arr.get(ix))) continue;
                        int n4 = n3;
                        missing[n4] = missing[n4] + 1.0;
                    }
                }
                int[] ranks = Tools.rank(missing);
                for (int i = 0; i < ranks.length; ++i) {
                    n2 = ranks[i];
                    double yExtrapolated = this.extrapolated((FloatArray)yDataAll.get(n2), x - xStart, extrapolator);
                    double minDistance = Double.MAX_VALUE;
                    int jOfMinDist = -1;
                    for (int j = 0; j < yValuesLo.size(); ++j) {
                        float yValue = 0.5f * (yValuesLo.get(j) + yValuesHi.get(j));
                        double distance = Math.abs(yExtrapolated - (double)yValue);
                        double tolerance = yValuesHi.get(j) - yValuesLo.get(j) + 1.0f;
                        distance = Math.sqrt(distance * distance + tolerance * tolerance) - tolerance;
                        float overlap = Float.NaN;
                        if (!Float.isNaN(curveValuesLo.get(n2)) && (overlap = Math.min(curveValuesHi.get(n2) - yValuesLo.get(j), yValuesHi.get(j) - curveValuesLo.get(n2))) >= -1.0f) {
                            distance *= 0.2;
                        }
                        if (!(distance < minDistance) || !(distance <= 10.0) && !(overlap > -1.0f)) continue;
                        minDistance = distance;
                        jOfMinDist = j;
                    }
                    if (jOfMinDist < 0) continue;
                    this.addPoint(yDataAll, curveValuesLo, curveValuesHi, n2, x - xStart, yValuesLo.get(jOfMinDist), yValuesHi.get(jOfMinDist));
                    yValuesLo.set(jOfMinDist, Float.NaN);
                }
                for (int j = 0; j < yValuesLo.size(); ++j) {
                    if (!Float.isNaN(yValuesLo.get(j))) {
                        for (n2 = 0; n2 < yDataAll.size(); ++n2) {
                            FloatArray arr = (FloatArray)yDataAll.get(n2);
                            if (arr.size() >= x - xStart - 10) continue;
                            this.addPoint(yDataAll, curveValuesLo, curveValuesHi, n2, x - xStart, yValuesLo.get(j), yValuesHi.get(j));
                            yValuesLo.set(j, Float.NaN);
                            break;
                        }
                    }
                    if (Float.isNaN(yValuesLo.get(j))) continue;
                    this.addPoint(yDataAll, curveValuesLo, curveValuesHi, -1, x - xStart, yValuesLo.get(j), yValuesHi.get(j));
                }
                yValuesLo.clear();
                yValuesHi.clear();
            }
            for (n = 0; n < yDataAll.size(); ++n) {
                FloatArray arr = (FloatArray)yDataAll.get(n);
                if (arr.size() >= x - xStart) continue;
                curveValuesLo.set(n, Float.NaN);
            }
        }
        if (xData.size() == 0) {
            return;
        }
        int maxlen = 0;
        for (int n5 = 0; n5 < yDataAll.size(); ++n5) {
            if (((FloatArray)yDataAll.get(n5)).size() <= maxlen) continue;
            maxlen = ((FloatArray)yDataAll.get(n5)).size();
        }
        double[] points = new double[yDataAll.size()];
        for (n = 0; n < yDataAll.size(); ++n) {
            FloatArray arr = (FloatArray)yDataAll.get(n);
            for (int ix = 0; ix < arr.size(); ++ix) {
                if (Float.isNaN(arr.get(ix))) continue;
                int n6 = n;
                points[n6] = points[n6] + 1.0;
            }
        }
        int[] ranks = Tools.rank(points);
        String xLabel = "X (" + cal.getUnits() + ")";
        String yLabel = "Y (" + cal.getYUnit() + ")";
        Plot plot = new Plot(WindowManager.getUniqueName("Line Graph"), xLabel, yLabel);
        float[] xArray = xData.toArray();
        if (xArray.length > maxlen) {
            xArray = Arrays.copyOf(xArray, maxlen);
        }
        for (int i = ranks.length - 1; i >= 0; --i) {
            int n7 = ranks[i];
            float[] yArray = yDataAll.get(n7).toArray();
            for (int j = 0; j < yArray.length; ++j) {
                yArray[j] = cal.scaled() ? (float)cal.getY(yArray[j], height) : (float)(height - 1) - yArray[j];
            }
            plot.addPoints(xArray, yArray, null, 2, "y" + (ranks.length - i));
        }
        plot.setLimitsToFit(false);
        plot.show();
    }

    void addPoint(ArrayList<FloatArray> yDataAll, FloatArray curveValuesLo, FloatArray curveValuesHi, int n, int x, float yLo, float yHi) {
        if (n < 0) {
            yDataAll.add(new FloatArray());
            n = yDataAll.size() - 1;
            curveValuesLo.add(yLo);
            curveValuesHi.add(yHi);
        }
        FloatArray arr = yDataAll.get(n);
        for (int i = arr.size(); i < x; ++i) {
            arr.add(Float.NaN);
        }
        arr.add(0.5f * (yLo + yHi));
        curveValuesLo.set(n, yLo);
        curveValuesHi.set(n, yHi);
    }

    float extrapolated(FloatArray arr, int x, Extrapolator extrapolator) {
        extrapolator.clear();
        int i = 0;
        for (int ix = x - 1; ix >= 0; --ix) {
            if (ix >= arr.size()) continue;
            double y = arr.get(ix);
            if (Double.isNaN(y) && ix < x - 10 && i == 0) {
                return Float.NaN;
            }
            if (ix < x - 10) break;
            if (Double.isNaN(y)) continue;
            extrapolator.add(ix, y);
            ++i;
        }
        return (float)extrapolator.extrapolate(x);
    }

    class Extrapolator {
        int counter = 0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumX2 = 0.0;
        double firstX;
        double firstY = Double.NaN;

        Extrapolator() {
        }

        public void clear() {
            this.counter = 0;
            this.sumX = 0.0;
            this.sumY = 0.0;
            this.sumXY = 0.0;
            this.sumX2 = 0.0;
            this.firstY = Double.NaN;
        }

        public void add(double x, double y) {
            ++this.counter;
            this.sumX += x;
            this.sumY += y;
            this.sumXY += x * y;
            this.sumX2 += x * x;
            if (Double.isNaN(this.firstY)) {
                this.firstX = x;
                this.firstY = y;
            }
        }

        public double extrapolate(double x) {
            if (this.counter <= 0) {
                return Double.NaN;
            }
            double slope = (this.sumXY - this.sumX * this.sumY / (double)this.counter) / (this.sumX2 - this.sumX * this.sumX / (double)this.counter);
            if (Double.isNaN(slope) && Math.abs(x - this.firstX) <= 3.0) {
                slope = 0.0;
            }
            return this.firstY + slope * (x - this.firstX);
        }
    }
}

