/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.plugin.Animator;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;

public class AVI_Writer
implements PlugInFilter {
    public static final int NO_COMPRESSION = 0;
    public static final int JPEG_COMPRESSION = 1196444237;
    public static final int PNG_COMPRESSION = 543649392;
    private static final int FOURCC_00db = 1650733104;
    private static final int FOURCC_00dc = 1667510320;
    private static final int MAX_INDX_SIZE = 3072;
    private static final int JUNK_SIZE_THRESHOLD = 996147200;
    private int compressionIndex = 2;
    private static int jpegQuality = 90;
    private static final String[] COMPRESSION_STRINGS = new String[]{"None", "PNG", "JPEG"};
    private static final int[] COMPRESSION_TYPES = new int[]{0, 543649392, 1196444237};
    private ImagePlus imp;
    private RandomAccessFile raFile;
    private int xDim;
    private int yDim;
    private int zDim;
    private int bytesPerPixel;
    private int frameDataSize;
    private int biCompression;
    private int linePad;
    private byte[] bufferWrite;
    private BufferedImage bufferedImage;
    private RaOutputStream raOutputStream;
    private long[] sizePointers = new long[5];
    private int stackPointer;
    private int endHeadPointer;
    private long pointer2indx;
    private int nIndxEntries = 0;
    private long pointer2indxNEntriesInUse;
    private long pointer2indxNextEntry;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    @Override
    public void run(ImageProcessor ip) {
        if (!this.showDialog(this.imp)) {
            return;
        }
        SaveDialog sd = new SaveDialog("Save as AVI...", this.imp.getTitle(), ".avi");
        String fileName = sd.getFileName();
        if (fileName == null) {
            return;
        }
        String fileDir = sd.getDirectory();
        FileInfo fi = this.imp.getOriginalFileInfo();
        if (fi != null && this.imp.getStack().isVirtual() && fileDir.equals(fi.directory) && fileName.equals(fi.fileName)) {
            IJ.error("AVI Writer", "Virtual stacks cannot be saved in place.");
            return;
        }
        try {
            this.writeImage(this.imp, fileDir + fileName, COMPRESSION_TYPES[this.compressionIndex], jpegQuality);
            IJ.showStatus("");
        }
        catch (IOException e) {
            IJ.error("AVI Writer", "An error occured writing the file.\n \n" + e);
        }
        IJ.showStatus("");
    }

    private boolean showDialog(ImagePlus imp) {
        double fps;
        String options = Macro.getOptions();
        if (options != null) {
            if (!options.contains("compression=")) {
                options = "compression=JPEG " + options;
            }
            options = options.replace("compression=Uncompressed", "compression=None");
            Macro.setOptions(options);
        }
        int decimalPlaces = (double)((int)(fps = this.getFrameRate(imp))) == fps ? 0 : 1;
        GenericDialog gd = new GenericDialog("Save as AVI...");
        gd.addChoice("Compression:", COMPRESSION_STRINGS, COMPRESSION_STRINGS[this.compressionIndex]);
        gd.addNumericField("Frame Rate:", fps, decimalPlaces, 3, "fps");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.compressionIndex = gd.getNextChoiceIndex();
        fps = gd.getNextNumber();
        if (fps <= 0.5) {
            fps = 0.5;
        }
        imp.getCalibration().fps = fps;
        return true;
    }

    public void writeImage(ImagePlus imp, String path, int compression, int jpegQuality) throws IOException {
        if (compression != 0 && compression != 1196444237 && compression != 543649392) {
            throw new IllegalArgumentException("Unsupported Compression 0x" + Integer.toHexString(compression));
        }
        this.biCompression = compression;
        if (jpegQuality < 0) {
            jpegQuality = 0;
        }
        if (jpegQuality > 100) {
            jpegQuality = 100;
        }
        AVI_Writer.jpegQuality = jpegQuality;
        File file = new File(path);
        this.raFile = new RandomAccessFile(file, "rw");
        this.raFile.setLength(0L);
        imp.startTiming();
        boolean isComposite = imp.isComposite();
        boolean isHyperstack = imp.isHyperStack();
        boolean isOverlay = imp.getOverlay() != null && !imp.getHideOverlay();
        this.xDim = imp.getWidth();
        this.yDim = imp.getHeight();
        this.zDim = imp.getStackSize();
        boolean saveFrames = false;
        boolean saveSlices = false;
        boolean saveChannels = false;
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        int channel = imp.getChannel();
        int slice = imp.getSlice();
        int frame = imp.getFrame();
        if (isHyperstack || isComposite) {
            if (frames > 1) {
                saveFrames = true;
                this.zDim = frames;
            } else if (slices > 1) {
                saveSlices = true;
                this.zDim = slices;
            } else if (channels > 1) {
                saveChannels = true;
                this.zDim = channels;
            } else {
                isHyperstack = false;
            }
        }
        this.bytesPerPixel = imp.getType() == 4 || isComposite || this.biCompression == 1196444237 || isOverlay ? 3 : 1;
        boolean writeLUT = this.bytesPerPixel == 1;
        this.linePad = 0;
        int minLineLength = this.bytesPerPixel * this.xDim;
        if (this.biCompression == 0 && minLineLength % 4 != 0) {
            this.linePad = 4 - minLineLength % 4;
        }
        this.frameDataSize = (this.bytesPerPixel * this.xDim + this.linePad) * this.yDim;
        int microSecPerFrame = (int)Math.round(1.0 / this.getFrameRate(imp) * 1000000.0);
        int dwChunkId = this.biCompression == 0 ? 1650733104 : 1667510320;
        long sizeEstimate = (long)(this.bytesPerPixel * this.xDim * this.yDim) * (long)this.zDim;
        int nAvixChunksEstimate = (int)(sizeEstimate / 996147200L);
        this.endHeadPointer = 4096 + (nAvixChunksEstimate * 16 + 1000) / 1024 * 1024;
        this.writeString("RIFF");
        this.chunkSizeHere();
        this.writeString("AVI ");
        this.writeString("LIST");
        this.chunkSizeHere();
        this.writeString("hdrl");
        this.writeString("avih");
        this.writeInt(56);
        this.writeInt(microSecPerFrame);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(16);
        this.writeInt(this.zDim);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(0);
        this.writeInt(this.xDim);
        this.writeInt(this.yDim);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeString("LIST");
        this.chunkSizeHere();
        this.writeString("strl");
        this.writeString("strh");
        this.writeInt(56);
        this.writeString("vids");
        this.writeString("DIB ");
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt((int)Math.round(this.getFrameRate(imp)));
        this.writeInt(0);
        this.writeInt(this.zDim);
        this.writeInt(0);
        this.writeInt(-1);
        this.writeInt(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeString("strf");
        this.chunkSizeHere();
        this.writeInt(40);
        this.writeInt(this.xDim);
        this.writeInt(this.yDim);
        this.writeShort(1);
        this.writeShort((short)(8 * this.bytesPerPixel));
        this.writeInt(this.biCompression);
        int biSizeImage = this.biCompression == 0 ? 0 : this.xDim * this.yDim * this.bytesPerPixel;
        this.writeInt(biSizeImage);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(writeLUT ? 256 : 0);
        this.writeInt(0);
        if (writeLUT) {
            this.writeLUT(imp.getProcessor());
        }
        this.chunkEndWriteSize();
        this.writeString("strn");
        this.writeInt(16);
        this.writeString("ImageJ AVI     \u0000");
        this.pointer2indx = this.raFile.getFilePointer();
        this.writeString("indx");
        this.chunkSizeHere();
        this.writeShort(4);
        this.writeByte(0);
        this.writeByte(0);
        this.pointer2indxNEntriesInUse = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeInt(dwChunkId);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.pointer2indxNextEntry = this.raFile.getFilePointer();
        this.chunkEndWriteSize();
        this.writeString("JUNK");
        this.chunkSizeHere();
        this.raFile.seek(this.endHeadPointer);
        this.chunkEndWriteSize();
        this.chunkEndWriteSize();
        this.chunkEndWriteSize();
        if (this.biCompression == 0) {
            this.bufferWrite = new byte[this.frameDataSize];
        } else {
            this.raOutputStream = new RaOutputStream(this.raFile);
        }
        int[] dataChunkOffset = new int[this.zDim];
        int[] dataChunkLength = new int[this.zDim];
        int currentFilePart = 0;
        boolean writeAVI2index = false;
        int iFrame = 0;
        while (iFrame < this.zDim) {
            if (currentFilePart > 0) {
                this.writeString("RIFF");
                this.chunkSizeHere();
                this.writeString("AVIX");
            }
            this.writeString("LIST");
            this.chunkSizeHere();
            long moviPointer = this.raFile.getFilePointer();
            this.writeString("movi");
            int firstFrameInChunk = iFrame;
            while (iFrame < this.zDim) {
                if (iFrame % 10 == 0) {
                    IJ.showProgress(iFrame, this.zDim);
                    IJ.showStatus(iFrame + "/" + this.zDim);
                }
                ImageProcessor ip = null;
                if (isComposite || isHyperstack || isOverlay) {
                    if (saveFrames) {
                        imp.setPositionWithoutUpdate(channel, slice, iFrame + 1);
                    } else if (saveSlices) {
                        imp.setPositionWithoutUpdate(channel, iFrame + 1, frame);
                    } else if (saveChannels) {
                        imp.setPositionWithoutUpdate(iFrame + 1, slice, frame);
                    }
                    ImagePlus imp2 = imp;
                    if (isOverlay) {
                        if (!(saveFrames || saveSlices || saveChannels)) {
                            imp.setSliceWithoutUpdate(iFrame + 1);
                        }
                        imp2 = imp.flatten();
                    }
                    ip = new ColorProcessor(imp2.getImage());
                } else {
                    ip = this.zDim == 1 ? imp.getProcessor() : imp.getStack().getProcessor(iFrame + 1);
                }
                int chunkPointer = (int)this.raFile.getFilePointer();
                this.writeInt(dwChunkId);
                this.chunkSizeHere();
                if (this.biCompression == 0) {
                    if (this.bytesPerPixel == 1) {
                        this.writeByteFrame(ip);
                    } else {
                        this.writeRGBFrame(ip);
                    }
                } else {
                    this.writeCompressedFrame(ip);
                }
                dataChunkOffset[iFrame] = (int)((long)chunkPointer - moviPointer);
                dataChunkLength[iFrame] = (int)(this.raFile.getFilePointer() - (long)chunkPointer - 8L);
                this.chunkEndWriteSize();
                ++iFrame;
                if (this.raFile.getFilePointer() - moviPointer <= 996147200L) continue;
                break;
            }
            int nFramesInChunk = iFrame - firstFrameInChunk;
            if (iFrame < this.zDim) {
                writeAVI2index = true;
            }
            if (writeAVI2index) {
                long ix00pointer = this.raFile.getFilePointer();
                this.writeString("ix00");
                this.chunkSizeHere();
                this.writeShort(2);
                this.writeByte(0);
                this.writeByte(1);
                this.writeInt(nFramesInChunk);
                this.writeInt(dwChunkId);
                this.writeLong(moviPointer);
                this.writeInt(0);
                for (int z = firstFrameInChunk; z < iFrame; ++z) {
                    this.writeInt(dataChunkOffset[z] + 8);
                    this.writeInt(dataChunkLength[z]);
                }
                this.writeMainIndxEntry(ix00pointer, (int)(this.raFile.getFilePointer() - ix00pointer), nFramesInChunk);
                this.chunkEndWriteSize();
            }
            this.chunkEndWriteSize();
            if (currentFilePart == 0) {
                this.writeString("idx1");
                this.chunkSizeHere();
                for (int z = 0; z < iFrame; ++z) {
                    this.writeInt(dwChunkId);
                    this.writeInt(16);
                    this.writeInt(dataChunkOffset[z]);
                    this.writeInt(dataChunkLength[z]);
                }
                this.chunkEndWriteSize();
            }
            this.chunkEndWriteSize();
            ++currentFilePart;
        }
        if (!writeAVI2index) {
            this.raFile.seek(this.pointer2indx);
            this.writeString("JUNK");
            this.chunkSizeHere();
            this.raFile.seek(this.endHeadPointer);
            this.chunkEndWriteSize();
        }
        this.raFile.close();
        IJ.showProgress(1.0);
        if (isComposite || isHyperstack) {
            imp.setPosition(channel, slice, frame);
        }
    }

    private void chunkSizeHere() throws IOException {
        this.sizePointers[this.stackPointer] = this.raFile.getFilePointer();
        this.writeInt(0);
        ++this.stackPointer;
    }

    private void chunkEndWriteSize() throws IOException {
        --this.stackPointer;
        long position = this.raFile.getFilePointer();
        this.raFile.seek(this.sizePointers[this.stackPointer]);
        this.writeInt((int)(position - (this.sizePointers[this.stackPointer] + 4L)));
        this.raFile.seek((position + 1L) / 2L * 2L);
    }

    private void writeMainIndxEntry(long ix00pointer, int dwSize, int nFrames) throws IOException {
        if (this.pointer2indxNextEntry + 16L + 8L > 3072L) {
            this.raFile.close();
            throw new RuntimeException("AVI_Writer ERROR: Index Size Overflow");
        }
        long savePosition = this.raFile.getFilePointer();
        this.raFile.seek(this.pointer2indxNextEntry);
        this.writeLong(ix00pointer);
        this.writeInt(dwSize);
        this.writeInt(nFrames);
        this.pointer2indxNextEntry += 16L;
        ++this.nIndxEntries;
        this.writeString("JUNK");
        this.chunkSizeHere();
        this.raFile.seek(this.endHeadPointer);
        this.chunkEndWriteSize();
        this.raFile.seek(this.pointer2indx + 4L);
        this.writeInt((int)(this.pointer2indxNextEntry - this.pointer2indx - 8L));
        this.raFile.seek(this.pointer2indxNEntriesInUse);
        this.writeInt(this.nIndxEntries);
        this.raFile.seek(savePosition);
    }

    private void writeByteFrame(ImageProcessor ip) throws IOException {
        ip = ip.convertToByte(true);
        byte[] pixels = (byte[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        int index = 0;
        for (int y = height - 1; y >= 0; --y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                this.bufferWrite[index++] = pixels[offset++];
            }
            for (int i = 0; i < this.linePad; ++i) {
                this.bufferWrite[index++] = 0;
            }
        }
        this.raFile.write(this.bufferWrite);
    }

    private void writeRGBFrame(ImageProcessor ip) throws IOException {
        ip = ip.convertToRGB();
        int[] pixels = (int[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        int index = 0;
        for (int y = height - 1; y >= 0; --y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                int c = pixels[offset++];
                this.bufferWrite[index++] = (byte)(c & 0xFF);
                this.bufferWrite[index++] = (byte)((c & 0xFF00) >> 8);
                this.bufferWrite[index++] = (byte)((c & 0xFF0000) >> 16);
            }
            for (int i = 0; i < this.linePad; ++i) {
                this.bufferWrite[index++] = 0;
            }
        }
        this.raFile.write(this.bufferWrite);
    }

    private void writeCompressedFrame(ImageProcessor ip) throws IOException {
        if (this.biCompression == 1196444237) {
            BufferedImage bi = this.getBufferedImage(ip);
            ImageIO.write((RenderedImage)bi, "jpeg", this.raOutputStream);
        } else {
            BufferedImage bi = ip.getBufferedImage();
            ImageIO.write((RenderedImage)bi, "png", this.raOutputStream);
        }
    }

    private BufferedImage getBufferedImage(ImageProcessor ip) {
        BufferedImage bi = new BufferedImage(ip.getWidth(), ip.getHeight(), 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.drawImage(ip.createImage(), 0, 0, null);
        return bi;
    }

    private void writeLUT(ImageProcessor ip) throws IOException {
        IndexColorModel cm = (IndexColorModel)ip.getCurrentColorModel();
        int mapSize = cm.getMapSize();
        byte[] lutWrite = new byte[1024];
        for (int i = 0; i < 256; ++i) {
            if (i >= mapSize) continue;
            lutWrite[4 * i] = (byte)cm.getBlue(i);
            lutWrite[4 * i + 1] = (byte)cm.getGreen(i);
            lutWrite[4 * i + 2] = (byte)cm.getRed(i);
            lutWrite[4 * i + 3] = 0;
        }
        this.raFile.write(lutWrite);
    }

    private double getFrameRate(ImagePlus imp) {
        double rate = imp.getCalibration().fps;
        if (rate == 0.0) {
            rate = Animator.getFrameRate();
        }
        if (rate <= 0.5) {
            rate = 0.5;
        }
        return rate;
    }

    private void writeString(String s) throws IOException {
        byte[] bytes = s.getBytes("UTF8");
        this.raFile.write(bytes);
    }

    private void writeLong(long v) throws IOException {
        for (int i = 0; i < 8; ++i) {
            this.raFile.write((int)(v & 0xFFL));
            v >>>= 8;
        }
    }

    private void writeInt(int v) throws IOException {
        this.raFile.write(v & 0xFF);
        this.raFile.write(v >>> 8 & 0xFF);
        this.raFile.write(v >>> 16 & 0xFF);
        this.raFile.write(v >>> 24 & 0xFF);
    }

    private void writeShort(int v) throws IOException {
        this.raFile.write(v & 0xFF);
        this.raFile.write(v >>> 8 & 0xFF);
    }

    private void writeByte(int v) throws IOException {
        this.raFile.write(v & 0xFF);
    }

    class RaOutputStream
    extends OutputStream {
        RandomAccessFile raFile;

        RaOutputStream(RandomAccessFile raFile) {
            this.raFile = raFile;
        }

        @Override
        public void write(int b) throws IOException {
            this.raFile.writeByte(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.raFile.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.raFile.write(b, off, len);
        }
    }
}

