/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.HTMLDialog;
import ij.plugin.BatchProcessor;
import ij.plugin.LutLoader;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class CommandFinder
implements PlugIn,
ActionListener,
WindowListener,
KeyListener,
ItemListener,
MouseListener {
    private static final int TABLE_WIDTH = 640;
    private static final int TABLE_ROWS = 18;
    private int multiClickInterval;
    private long lastClickTime;
    private static JFrame frame;
    private JTextField prompt;
    private JScrollPane scrollPane;
    private JButton runButton;
    private JButton sourceButton;
    private JButton closeButton;
    private JButton commandsButton;
    private JButton helpButton;
    private JCheckBox closeCheckBox;
    private JCheckBox lutCheckBox;
    private Hashtable commandsHash;
    private String[] commands;
    private static boolean closeWhenRunning;
    private static boolean applyLUT;
    private JTable table;
    private TableModel tableModel;
    private int lastClickedRow;

    public CommandFinder() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Integer interval = (Integer)toolkit.getDesktopProperty("awt.multiClickInterval");
        this.multiClickInterval = interval == null ? 300 : interval;
    }

    protected String[] makeRow(String command, CommandAction ca) {
        String jarFile;
        String[] result = new String[this.tableModel.getColumnCount()];
        result[0] = command;
        if (ca.menuLocation != null) {
            result[1] = ca.menuLocation;
        }
        if (ca.classCommand != null) {
            result[2] = ca.classCommand;
        }
        if ((jarFile = Menus.getJarFileForMenuEntry(command)) != null) {
            result[3] = jarFile;
        }
        return result;
    }

    protected void populateList(String matchingSubstring) {
        String substring = matchingSubstring.toLowerCase();
        ArrayList<String[]> list = new ArrayList<String[]>();
        boolean count = false;
        for (int i = 0; i < this.commands.length; ++i) {
            String commandName = this.commands[i];
            String command = commandName.toLowerCase();
            CommandAction ca = (CommandAction)this.commandsHash.get(commandName);
            String menuPath = ca.menuLocation;
            if (menuPath == null) {
                menuPath = "";
            }
            menuPath = menuPath.toLowerCase();
            if (command.indexOf(substring) < 0 && menuPath.indexOf(substring) < 0) continue;
            String[] row = this.makeRow(commandName, ca);
            list.add(row);
        }
        this.tableModel.setData(list);
        this.prompt.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.runButton) {
            int row = this.table.getSelectedRow();
            if (row < 0) {
                this.error("Please select a command to run");
                return;
            }
            this.runCommand(this.tableModel.getCommand(row));
        } else if (source == this.sourceButton) {
            int row = this.table.getSelectedRow();
            if (row < 0) {
                this.error("Please select a command");
                return;
            }
            this.showSource(this.tableModel.getCommand(row));
        } else if (source == this.closeButton) {
            this.closeWindow();
        } else if (source == this.commandsButton) {
            IJ.doCommand("Commands...");
        } else if (source == this.helpButton) {
            String text = "<html>Shortcuts:<br>&emsp;&uarr; &darr;&ensp; Select items<br>&emsp;&crarr;&emsp; Open item<br>&ensp;A-Z&ensp; Alphabetic scroll<br>&emsp;&#9003;&emsp;Activate search field</html>";
            new HTMLDialog("", text);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        this.populateList(this.prompt.getText());
        applyLUT = this.lutCheckBox.isSelected();
        if (applyLUT) {
            this.prompt.setText("Lookup Tables");
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        long now = System.currentTimeMillis();
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        String value = this.tableModel.getValueAt(row, col).toString();
        IJ.showStatus(value);
        long thisClickInterval = now - this.lastClickTime;
        if (thisClickInterval < (long)this.multiClickInterval && row >= 0 && this.lastClickedRow >= 0 && row == this.lastClickedRow) {
            this.runCommand(this.tableModel.getCommand(row));
        }
        this.lastClickTime = now;
        this.lastClickedRow = row;
        if (this.lutCheckBox.isSelected()) {
            this.previewLUT();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    void showSource(String cmd) {
        int openParen;
        if (this.showMacro(cmd)) {
            return;
        }
        Hashtable table = Menus.getCommands();
        String className = (String)table.get(cmd);
        if (IJ.debugMode) {
            IJ.log("showSource: " + cmd + "   " + className);
        }
        if (className == null) {
            this.error("No source associated with this command:\n  " + cmd);
            return;
        }
        int mstart = className.indexOf("ij.plugin.Macro_Runner(\"");
        if (mstart >= 0) {
            int mend = className.indexOf("\")");
            if (mend == -1) {
                return;
            }
            String macro = className.substring(mstart + 24, mend);
            IJ.open(IJ.getDirectory("plugins") + macro);
            return;
        }
        if (className.endsWith("\")") && (openParen = className.lastIndexOf("(\"")) > 0) {
            className = className.substring(0, openParen);
        }
        if (className.startsWith("ij.")) {
            className = className.replaceAll("\\.", "/");
            IJ.runPlugIn("ij.plugin.BrowserLauncher", "http://imagej.net/ij/source/" + className + ".java");
            return;
        }
        className = IJ.getDirectory("plugins") + className.replaceAll("\\.", "/");
        String path = className + ".java";
        File f = new File(path);
        if (f.exists()) {
            IJ.open(path);
            return;
        }
        this.error("Unable to display source for this plugin:\n  " + className);
    }

    private boolean showMacro(String cmd) {
        String name = null;
        if (cmd.equals("Display LUTs")) {
            name = "ShowAllLuts.txt";
        } else if (cmd.equals("Search...")) {
            name = "Search.txt";
        }
        if (name == null) {
            return false;
        }
        String code = BatchProcessor.openMacroFromJar(name);
        if (code != null) {
            Editor ed = new Editor();
            ed.setSize(700, 600);
            ed.create(name, code);
            return true;
        }
        return false;
    }

    private void error(String msg) {
        IJ.error("Command Finder", msg);
    }

    protected void runCommand(String command) {
        IJ.showStatus("Running command " + command);
        IJ.doCommand(command);
        closeWhenRunning = this.closeCheckBox.isSelected();
        if (closeWhenRunning) {
            this.closeWindow();
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        boolean meta;
        int key = ke.getKeyCode();
        int flags = ke.getModifiers();
        int items = this.tableModel.getRowCount();
        Object source = ke.getSource();
        boolean bl = meta = (flags & 4) != 0 || (flags & 2) != 0;
        if (key == 27 || key == 87 && meta) {
            this.closeWindow();
        } else if (source == this.prompt) {
            if (key == 10 && 1 == items) {
                this.runCommand(this.tableModel.getCommand(0));
            }
            int index = -1;
            if (key == 38) {
                index = this.table.getSelectedRow() - 1;
                if (index < 0) {
                    index = items - 1;
                }
            } else if (key == 40 && (index = this.table.getSelectedRow() + 1) >= items) {
                index = Math.min(items - 1, 0);
            }
            if (index >= 0) {
                this.table.requestFocus();
                this.table.setRowSelectionInterval(index, index);
            }
        } else if (key == 8 || key == 127) {
            this.prompt.requestFocus();
        } else if (source == this.table) {
            if (key == 10) {
                ke.consume();
                int row = this.table.getSelectedRow();
                if (row >= 0) {
                    this.runCommand(this.tableModel.getCommand(row));
                }
            } else if (key == 38) {
                if (this.table.getSelectedRow() == 0) {
                    this.table.setRowSelectionInterval(this.tableModel.getRowCount() - 1, this.tableModel.getRowCount() - 1);
                }
            } else if (key == 40 && this.table.getSelectedRow() == this.tableModel.getRowCount() - 1) {
                this.table.setRowSelectionInterval(0, 0);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (this.lutCheckBox.isSelected()) {
            this.previewLUT();
        }
    }

    public void previewLUT() {
        int row = this.table.getSelectedRow();
        if (row >= 0) {
            String cmd = this.tableModel.getCommand(row);
            String mPath = (String)this.tableModel.getValueAt(row, 1);
            String cName = (String)this.tableModel.getValueAt(row, 2);
            if (mPath.indexOf("Lookup Table") > 0 && (null == cName || cName.indexOf("LutLoader") > 0)) {
                ImagePlus imp = WindowManager.getCurrentImage();
                if (null == imp) {
                    imp = IJ.createImage("LUT Preview", "8-bit ramp", 256, 32, 1);
                    imp.show();
                }
                if (imp.getBitDepth() != 24) {
                    if (imp.isComposite()) {
                        ((CompositeImage)imp).setChannelColorModel(LutLoader.getLut(cmd));
                    } else {
                        ImageProcessor ip = imp.getProcessor();
                        ip.setColorModel(LutLoader.getLut(cmd));
                        IJ.showStatus(cmd);
                    }
                    imp.updateAndDraw();
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    public void parseMenu(String path, Menu menu) {
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem m = menu.getItem(i);
            String label = m.getActionCommand();
            if (m instanceof Menu) {
                Menu subMenu = (Menu)m;
                this.parseMenu(path + ">" + label, subMenu);
                continue;
            }
            String trimmedLabel = label.trim();
            if (trimmedLabel.length() == 0 || trimmedLabel.equals("-")) continue;
            CommandAction ca = (CommandAction)this.commandsHash.get(label);
            if (ca == null) {
                this.commandsHash.put(label, new CommandAction(null, m, path));
            } else {
                ca.menuItem = m;
                ca.menuLocation = path;
            }
            CommandAction commandAction = (CommandAction)this.commandsHash.get(label);
        }
    }

    public void findAllMenuItems() {
        MenuBar menuBar = Menus.getMenuBar();
        int topLevelMenus = menuBar.getMenuCount();
        for (int i = 0; i < topLevelMenus; ++i) {
            Menu topLevelMenu = menuBar.getMenu(i);
            this.parseMenu(topLevelMenu.getLabel(), topLevelMenu);
        }
    }

    @Override
    public void run(String initialSearch) {
        Image img;
        if (frame != null) {
            if (initialSearch != null && !initialSearch.isEmpty()) {
                frame.dispose();
            } else {
                WindowManager.toFront(frame);
                return;
            }
        }
        this.commandsHash = new Hashtable();
        Hashtable realCommandsHash = (Hashtable)Menus.getCommands().clone();
        Set realCommandSet = realCommandsHash.keySet();
        for (String command : realCommandSet) {
            String trimmedCommand = command.trim();
            if (trimmedCommand.length() <= 0 || trimmedCommand.equals("-")) continue;
            this.commandsHash.put(command, new CommandAction((String)realCommandsHash.get(command), null, null));
        }
        this.findAllMenuItems();
        this.commands = this.commandsHash.keySet().toArray(new String[0]);
        Arrays.sort(this.commands);
        ImageJ imageJ = IJ.getInstance();
        frame = new JFrame("Command Finder"){

            @Override
            public void setVisible(boolean visible) {
                if (visible) {
                    WindowManager.addWindow(this);
                }
                super.setVisible(visible);
            }

            @Override
            public void dispose() {
                WindowManager.removeWindow(this);
                Prefs.set("command-finder.close", closeWhenRunning);
                frame = null;
                super.dispose();
            }
        };
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        frame.addWindowListener(this);
        if (imageJ != null && !IJ.isMacOSX() && (img = imageJ.getIconImage()) != null) {
            try {
                frame.setIconImage(img);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closeCheckBox = new JCheckBox("Close window after running command", closeWhenRunning);
        GUI.scale(this.closeCheckBox);
        this.closeCheckBox.addItemListener(this);
        this.lutCheckBox = new JCheckBox("Apply LUTs", applyLUT);
        GUI.scale(this.lutCheckBox);
        this.lutCheckBox.addItemListener(this);
        JPanel northPanel = new JPanel(new BorderLayout());
        JLabel searchLabel = new JLabel(" Search:");
        GUI.scale(searchLabel);
        northPanel.add((Component)searchLabel, "West");
        this.prompt = new JTextField("", 20);
        GUI.scale(this.prompt);
        this.prompt.getDocument().addDocumentListener(new PromptDocumentListener());
        this.prompt.addKeyListener(this);
        northPanel.add(this.prompt);
        contentPane.add((Component)northPanel, "North");
        this.tableModel = new TableModel();
        this.table = new JTable(this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.tableModel.setColumnWidths(this.table.getColumnModel());
        GUI.scale(this.table);
        Dimension dim = new Dimension(640, this.table.getRowHeight() * 18);
        this.table.setPreferredScrollableViewportSize(dim);
        this.table.addKeyListener(this);
        this.table.addMouseListener(this);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                if (evt.isControlDown() || evt.isMetaDown()) {
                    return;
                }
                int nRows = CommandFinder.this.tableModel.getRowCount();
                char ch = Character.toLowerCase(evt.getKeyChar());
                if (!Character.isLetterOrDigit(ch)) {
                    return;
                }
                int sRow = CommandFinder.this.table.getSelectedRow();
                int row = (sRow + 1) % nRows;
                while (row != sRow) {
                    String rowData = CommandFinder.this.tableModel.getValueAt(row, 0).toString();
                    char rowCh = Character.toLowerCase(rowData.charAt(0));
                    if (ch == rowCh) {
                        CommandFinder.this.table.setRowSelectionInterval(row, row);
                        CommandFinder.this.table.scrollRectToVisible(CommandFinder.this.table.getCellRect(row, 0, true));
                        break;
                    }
                    row = (row + 1) % nRows;
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table);
        if (initialSearch == null) {
            initialSearch = "";
        }
        this.prompt.setText(initialSearch);
        this.populateList(initialSearch);
        contentPane.add((Component)this.scrollPane, "Center");
        this.runButton = new JButton("Run");
        GUI.scale(this.runButton);
        this.sourceButton = new JButton("Source");
        GUI.scale(this.sourceButton);
        this.closeButton = new JButton("Close");
        GUI.scale(this.closeButton);
        this.commandsButton = new JButton("Commands");
        GUI.scale(this.commandsButton);
        this.helpButton = new JButton("Help");
        GUI.scale(this.helpButton);
        this.runButton.addActionListener(this);
        this.sourceButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.commandsButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.runButton.addKeyListener(this);
        this.sourceButton.addKeyListener(this);
        this.closeButton.addKeyListener(this);
        this.commandsButton.addKeyListener(this);
        this.helpButton.addKeyListener(this);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        JPanel optionsPanel = new JPanel(new FlowLayout(1, 0, 0));
        optionsPanel.add(this.closeCheckBox);
        optionsPanel.add(this.lutCheckBox);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.runButton);
        buttonsPanel.add(this.sourceButton);
        buttonsPanel.add(this.closeButton);
        buttonsPanel.add(this.commandsButton);
        buttonsPanel.add(this.helpButton);
        southPanel.add((Component)optionsPanel, "Center");
        southPanel.add((Component)buttonsPanel, "South");
        contentPane.add((Component)southPanel, "South");
        Rectangle screen = GUI.getMaxWindowBounds(IJ.getInstance());
        frame.pack();
        int dialogWidth = frame.getWidth();
        int dialogHeight = frame.getHeight();
        Point pos = imageJ.getLocationOnScreen();
        Dimension size = imageJ.getSize();
        int initialX = pos.x + 10;
        int initialY = pos.y + 10 + size.height;
        initialX = Math.max(screen.x, Math.min(initialX, screen.x + screen.width - dialogWidth));
        initialY = Math.max(screen.y, Math.min(initialY, screen.y + screen.height - dialogHeight));
        frame.setLocation(initialX, initialY);
        frame.setVisible(true);
        frame.toFront();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeWindow();
    }

    private void closeWindow() {
        if (frame != null) {
            frame.dispose();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (IJ.isMacOSX() && frame != null) {
            frame.setMenuBar(Menus.getMenuBar());
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    static {
        closeWhenRunning = Prefs.get("command-finder.close", false);
    }

    private class TableModel
    extends AbstractTableModel {
        protected ArrayList list = new ArrayList();
        public static final int COLUMNS = 4;

        public void setData(ArrayList list) {
            this.list = list;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Command";
                }
                case 1: {
                    return "Menu Path";
                }
                case 2: {
                    return "Class";
                }
                case 3: {
                    return "File";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= this.list.size() || column >= 4) {
                return null;
            }
            String[] strings = (String[])this.list.get(row);
            return strings[column];
        }

        public String getCommand(int row) {
            if (row < 0 || row >= this.list.size()) {
                return "";
            }
            return (String)this.getValueAt(row, 0);
        }

        public void setColumnWidths(TableColumnModel columnModel) {
            int[] widths = new int[]{170, 150, 170, 30};
            for (int i = 0; i < widths.length; ++i) {
                columnModel.getColumn(i).setPreferredWidth(widths[i]);
            }
        }
    }

    class PromptDocumentListener
    implements DocumentListener {
        PromptDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }
    }

    class CommandAction {
        String classCommand;
        MenuItem menuItem;
        String menuLocation;

        CommandAction(String classCommand, MenuItem menuItem, String menuLocation) {
            this.classCommand = classCommand;
            this.menuItem = menuItem;
            this.menuLocation = menuLocation;
        }

        public String toString() {
            return "classCommand: " + this.classCommand + ", menuItem: " + this.menuItem + ", menuLocation: " + this.menuLocation;
        }
    }
}

