/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public final class RandomAccessStream
extends InputStream {
    private static final int BLOCK_SIZE = 1024;
    private static final int BLOCK_MASK = 1023;
    private static final int BLOCK_SHIFT = 10;
    private InputStream src;
    private RandomAccessFile ras;
    private long pointer;
    private Vector data;
    private long length;
    private boolean foundEOS;

    public RandomAccessStream(InputStream inputstream) {
        this.pointer = 0L;
        this.data = new Vector();
        this.length = 0L;
        this.foundEOS = false;
        this.src = inputstream;
    }

    public RandomAccessStream(RandomAccessFile ras) {
        this.ras = ras;
    }

    public int getFilePointer() throws IOException {
        if (this.ras != null) {
            return (int)this.ras.getFilePointer();
        }
        return (int)this.pointer;
    }

    public long getLongFilePointer() throws IOException {
        if (this.ras != null) {
            return this.ras.getFilePointer();
        }
        return this.pointer;
    }

    @Override
    public int read() throws IOException {
        if (this.ras != null) {
            return this.ras.read();
        }
        long l = this.pointer + 1L;
        long l1 = this.readUntil(l);
        if (l1 >= l) {
            byte[] abyte0 = (byte[])this.data.elementAt((int)(this.pointer >> 10));
            return abyte0[(int)(this.pointer++ & 0x3FFL)] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (this.ras != null) {
            return this.ras.read(bytes, off, len);
        }
        if (off < 0 || len < 0 || off + len > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        long l = this.readUntil(this.pointer + (long)len);
        if (l <= this.pointer) {
            return -1;
        }
        byte[] abyte1 = (byte[])this.data.elementAt((int)(this.pointer >> 10));
        int k = Math.min(len, 1024 - (int)(this.pointer & 0x3FFL));
        System.arraycopy(abyte1, (int)(this.pointer & 0x3FFL), bytes, off, k);
        this.pointer += (long)k;
        return k;
    }

    public final void readFully(byte[] bytes) throws IOException {
        this.readFully(bytes, bytes.length);
    }

    public final void readFully(byte[] bytes, int len) throws IOException {
        int l;
        int read = 0;
        while ((l = this.read(bytes, read, len - read)) >= 0 && (read += l) < len) {
        }
    }

    private long readUntil(long l) throws IOException {
        int j;
        if (l < this.length) {
            return l;
        }
        if (this.foundEOS) {
            return this.length;
        }
        int i = (int)(l >> 10);
        for (int k = j = (int)(this.length >> 10); k <= i; ++k) {
            byte[] abyte0 = new byte[1024];
            this.data.addElement(abyte0);
            int i1 = 1024;
            int j1 = 0;
            while (i1 > 0) {
                int k1 = this.src.read(abyte0, j1, i1);
                if (k1 == -1) {
                    this.foundEOS = true;
                    return this.length;
                }
                j1 += k1;
                i1 -= k1;
                this.length += (long)k1;
            }
        }
        return this.length;
    }

    public void seek(long loc) throws IOException {
        if (this.ras != null) {
            this.ras.seek(loc);
            return;
        }
        this.pointer = loc < 0L ? 0L : loc;
    }

    public void seek(int loc) throws IOException {
        long lloc = (long)loc & 0xFFFFFFFFL;
        if (this.ras != null) {
            this.ras.seek(lloc);
            return;
        }
        this.pointer = lloc < 0L ? 0L : lloc;
    }

    public final int readInt() throws IOException {
        int l;
        int k;
        int j;
        int i = this.read();
        if ((i | (j = this.read()) | (k = this.read()) | (l = this.read())) < 0) {
            throw new EOFException();
        }
        return (i << 24) + (j << 16) + (k << 8) + l;
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final short readShort() throws IOException {
        int j;
        int i = this.read();
        if ((i | (j = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((i << 8) + j);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void close() throws IOException {
        if (this.ras != null) {
            this.ras.close();
        } else {
            this.data.removeAllElements();
            this.src.close();
        }
    }
}

