/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Prefs;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.ImageWriter;
import ij.io.RoiEncoder;
import ij.io.SaveDialog;
import ij.io.TextEncoder;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.JpegWriter;
import ij.plugin.Orthogonal_Views;
import ij.plugin.filter.Analyzer;
import ij.process.FHT;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.util.Tools;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileSaver {
    public static final int DEFAULT_JPEG_QUALITY = 85;
    private static int jpegQuality;
    private static int bsize;
    private static String defaultDirectory;
    private ImagePlus imp;
    private FileInfo fi;
    private String name;
    private String directory;
    private boolean saveName;

    public FileSaver(ImagePlus imp) {
        this.imp = imp;
        this.fi = imp.getFileInfo();
    }

    public boolean save() {
        boolean validName;
        FileInfo ofi = null;
        if (this.imp != null) {
            ofi = this.imp.getOriginalFileInfo();
        }
        boolean bl = validName = ofi != null && this.imp.getTitle().equals(ofi.fileName);
        if (validName && ofi.fileFormat == 2 && ofi.directory != null && !ofi.directory.equals("") && (ofi.url == null || ofi.url.equals(""))) {
            this.name = this.imp.getTitle();
            this.directory = ofi.directory;
            String path = this.directory + this.name;
            File f = new File(path);
            if (f == null || !f.exists()) {
                return this.saveAsTiff();
            }
            if (!IJ.isMacro()) {
                GenericDialog gd = new GenericDialog("Save as TIFF");
                gd.addMessage("\"" + ofi.fileName + "\" already exists.\nDo you want to replace it?");
                gd.setOKLabel("Replace");
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return false;
                }
            }
            IJ.showStatus("Saving " + path);
            if (this.imp.getStackSize() > 1) {
                IJ.saveAs(this.imp, "tif", path);
                return true;
            }
            return this.saveAsTiff(path);
        }
        return this.saveAsTiff();
    }

    String getPath(String type, String extension) {
        this.name = this.imp.getTitle();
        SaveDialog sd = new SaveDialog("Save as " + type, this.name, extension);
        this.name = sd.getFileName();
        if (this.name == null) {
            return null;
        }
        this.directory = sd.getDirectory();
        this.imp.startTiming();
        String path = this.directory + this.name;
        return path;
    }

    public boolean saveAsTiff() {
        String path = this.getPath("TIFF", ".tif");
        if (path == null) {
            return false;
        }
        if (this.fi.nImages > 1) {
            return this.saveAsTiffStack(path);
        }
        return this.saveAsTiff(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAsTiff(String path) {
        String label;
        if (this.fi.nImages > 1) {
            return this.saveAsTiffStack(path);
        }
        if (this.imp.getProperty("FHT") != null && path.contains("FFT of ")) {
            this.setupFFTSave();
        }
        this.fi.info = this.imp.getInfoProperty();
        String string = label = this.imp.hasImageStack() ? this.imp.getStack().getSliceLabel(1) : null;
        if (label != null) {
            this.fi.sliceLabels = new String[1];
            this.fi.sliceLabels[0] = label;
        }
        this.fi.description = this.getDescriptionString();
        if (this.imp.getProperty("thePlot") != null) {
            Plot plot = (Plot)this.imp.getProperty("thePlot");
            this.fi.plot = plot.toByteArray();
            ImageWindow win = this.imp.getWindow();
            if (win != null && win instanceof PlotWindow) {
                ((PlotWindow)win).hideRangeArrows();
            }
        }
        this.fi.roi = RoiEncoder.saveAsByteArray(this.imp.getRoi());
        this.fi.overlay = FileSaver.getOverlay(this.imp);
        this.fi.properties = this.imp.getPropertiesAsArray();
        FilterOutputStream out = null;
        try {
            TiffEncoder file = new TiffEncoder(this.fi);
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path), bsize));
            file.write((DataOutputStream)out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage("saveAsTiff", path, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    private void setupFFTSave() {
        FHT fht;
        Object obj = this.imp.getProperty("FHT");
        if (obj == null) {
            return;
        }
        FHT fHT = fht = obj instanceof FHT ? (FHT)obj : null;
        if (fht == null) {
            return;
        }
        if (fht.originalColorModel != null && fht.originalBitDepth != 24) {
            fht.setColorModel(fht.originalColorModel);
        }
        ImagePlus imp2 = new ImagePlus(this.imp.getTitle(), fht);
        imp2.setProperty("Info", this.imp.getProperty("Info"));
        imp2.setProperties(this.imp.getPropertiesAsArray());
        imp2.setCalibration(this.imp.getCalibration());
        this.imp = imp2;
        this.fi = this.imp.getFileInfo();
    }

    public static byte[][] getOverlay(ImagePlus imp) {
        int n;
        if (imp.getHideOverlay()) {
            return null;
        }
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            ImageCanvas ic = imp.getCanvas();
            if (ic == null) {
                return null;
            }
            overlay = ic.getShowAllList();
            if (overlay == null) {
                return null;
            }
        }
        if ((n = overlay.size()) == 0) {
            return null;
        }
        if (Orthogonal_Views.isOrthoViewsImage(imp)) {
            return null;
        }
        if (n == 1 && overlay.get(0).isCursor()) {
            return null;
        }
        byte[][] array = new byte[n][];
        for (int i = 0; i < overlay.size(); ++i) {
            Roi roi = overlay.get(i);
            if (i == 0) {
                roi.setPrototypeOverlay(overlay);
            }
            array[i] = RoiEncoder.saveAsByteArray(roi);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAsTiffStack(String path) {
        if (this.fi.nImages == 1) {
            this.error("This is not a stack");
            return false;
        }
        boolean virtualStack = this.imp.getStack().isVirtual();
        if (virtualStack) {
            this.fi.virtualStack = (VirtualStack)this.imp.getStack();
        }
        this.fi.info = this.imp.getInfoProperty();
        this.fi.description = this.getDescriptionString();
        if (virtualStack) {
            FileInfo ofi = this.imp.getOriginalFileInfo();
            if (path != null && ofi != null && path.equals(ofi.directory + ofi.fileName)) {
                this.error("TIFF virtual stacks cannot be saved in place.");
                return false;
            }
            String[] labels = null;
            ImageStack vs = this.imp.getStack();
            for (int i = 1; i <= vs.getSize(); ++i) {
                String label = vs.getSliceLabel(i);
                if (i == 1 && label == null) break;
                if (labels == null) {
                    labels = new String[vs.getSize()];
                }
                labels[i - 1] = label;
            }
            this.fi.sliceLabels = labels;
        } else {
            this.fi.sliceLabels = this.imp.getStack().getSliceLabels();
        }
        this.fi.roi = RoiEncoder.saveAsByteArray(this.imp.getRoi());
        this.fi.overlay = FileSaver.getOverlay(this.imp);
        this.fi.properties = this.imp.getPropertiesAsArray();
        if (this.imp.isComposite()) {
            this.saveDisplayRangesAndLuts(this.imp, this.fi);
        }
        FilterOutputStream out = null;
        try {
            TiffEncoder file = new TiffEncoder(this.fi);
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path), bsize));
            file.write((DataOutputStream)out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage("saveAsTiffStack", path, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize() {
        if (this.imp.getStack().isVirtual()) {
            return null;
        }
        this.fi.info = this.imp.getInfoProperty();
        this.saveName = true;
        this.fi.description = this.getDescriptionString();
        this.saveName = false;
        this.fi.sliceLabels = this.imp.getStack().getSliceLabels();
        if (this.imp.getProperty("thePlot") != null) {
            Plot plot = (Plot)this.imp.getProperty("thePlot");
            this.fi.plot = plot.toByteArray();
        }
        this.fi.roi = RoiEncoder.saveAsByteArray(this.imp.getRoi());
        this.fi.overlay = FileSaver.getOverlay(this.imp);
        if (this.imp.isComposite()) {
            this.saveDisplayRangesAndLuts(this.imp, this.fi);
        }
        ByteArrayOutputStream out = null;
        try {
            TiffEncoder encoder = new TiffEncoder(this.fi);
            out = new ByteArrayOutputStream();
            encoder.write(out);
            out.close();
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return out.toByteArray();
    }

    public void saveDisplayRangesAndLuts(ImagePlus imp, FileInfo fi) {
        LUT lut;
        int i;
        CompositeImage ci = (CompositeImage)imp;
        int channels = imp.getNChannels();
        fi.displayRanges = new double[channels * 2];
        for (i = 1; i <= channels; ++i) {
            lut = ci.getChannelLut(i);
            fi.displayRanges[(i - 1) * 2] = lut.min;
            fi.displayRanges[(i - 1) * 2 + 1] = lut.max;
        }
        if (ci.hasCustomLuts()) {
            fi.channelLuts = new byte[channels][];
            for (i = 0; i < channels; ++i) {
                lut = ci.getChannelLut(i + 1);
                byte[] bytes = lut.getBytes();
                if (bytes == null) {
                    fi.channelLuts = null;
                    break;
                }
                fi.channelLuts[i] = bytes;
            }
        }
    }

    public boolean saveAsZip() {
        String path = this.getPath("TIFF/ZIP", ".zip");
        if (path == null) {
            return false;
        }
        return this.saveAsZip(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAsZip(String path) {
        if (this.imp.getProperty("FHT") != null && path.contains("FFT of ")) {
            this.setupFFTSave();
        }
        if (!path.endsWith(".zip")) {
            path = path + ".zip";
        }
        if (this.name == null) {
            this.name = this.imp.getTitle();
        }
        if (this.name.endsWith(".zip")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        if (!this.name.endsWith(".tif")) {
            this.name = this.name + ".tif";
        }
        this.fi.description = this.getDescriptionString();
        this.fi.info = this.imp.getInfoProperty();
        this.fi.properties = this.imp.getPropertiesAsArray();
        if (this.imp.getProperty("thePlot") != null) {
            Plot plot = (Plot)this.imp.getProperty("thePlot");
            this.fi.plot = plot.toByteArray();
        }
        this.fi.roi = RoiEncoder.saveAsByteArray(this.imp.getRoi());
        this.fi.overlay = FileSaver.getOverlay(this.imp);
        this.fi.sliceLabels = this.imp.getStack().getSliceLabels();
        if (this.imp.isComposite()) {
            this.saveDisplayRangesAndLuts(this.imp, this.fi);
        }
        if (this.fi.nImages > 1 && this.imp.getStack().isVirtual()) {
            this.fi.virtualStack = (VirtualStack)this.imp.getStack();
        }
        FilterOutputStream out = null;
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(path));
            out = new DataOutputStream(new BufferedOutputStream(zos, bsize));
            zos.putNextEntry(new ZipEntry(this.name));
            TiffEncoder te = new TiffEncoder(this.fi);
            te.write((DataOutputStream)out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage("saveAsZip", path, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public static boolean okForGif(ImagePlus imp) {
        return imp.getType() != 4;
    }

    public boolean saveAsGif() {
        String path = this.getPath("GIF", ".gif");
        if (path == null) {
            return false;
        }
        return this.saveAsGif(path);
    }

    public boolean saveAsGif(String path) {
        IJ.runPlugIn(this.imp, "ij.plugin.GifWriter", path);
        this.updateImp(this.fi, 3);
        return true;
    }

    public static boolean okForJpeg(ImagePlus imp) {
        return true;
    }

    public boolean saveAsJpeg() {
        String type = "JPEG (" + FileSaver.getJpegQuality() + ")";
        String path = this.getPath(type, ".jpg");
        if (path == null) {
            return false;
        }
        return this.saveAsJpeg(path);
    }

    public boolean saveAsJpeg(String path) {
        String err = JpegWriter.save(this.imp, path, jpegQuality);
        if (err == null && this.imp.getType() != 1 && this.imp.getType() != 2) {
            this.updateImp(this.fi, 3);
        }
        return true;
    }

    public boolean saveAsBmp() {
        String path = this.getPath("BMP", ".bmp");
        if (path == null) {
            return false;
        }
        return this.saveAsBmp(path);
    }

    public boolean saveAsBmp(String path) {
        IJ.runPlugIn(this.imp, "ij.plugin.BMP_Writer", path);
        this.updateImp(this.fi, 5);
        return true;
    }

    public boolean saveAsPgm() {
        String extension = this.imp.getBitDepth() == 24 ? ".pnm" : ".pgm";
        String path = this.getPath("PGM", extension);
        if (path == null) {
            return false;
        }
        return this.saveAsPgm(path);
    }

    public boolean saveAsPgm(String path) {
        IJ.runPlugIn(this.imp, "ij.plugin.PNM_Writer", path);
        this.updateImp(this.fi, 8);
        return true;
    }

    public boolean saveAsPng() {
        String path = this.getPath("PNG", ".png");
        if (path == null) {
            return false;
        }
        return this.saveAsPng(path);
    }

    public boolean saveAsPng(String path) {
        IJ.runPlugIn(this.imp, "ij.plugin.PNG_Writer", path);
        this.updateImp(this.fi, 9);
        return true;
    }

    public boolean saveAsFits() {
        if (!FileSaver.okForFits(this.imp)) {
            return false;
        }
        String path = this.getPath("FITS", ".fits");
        if (path == null) {
            return false;
        }
        return this.saveAsFits(path);
    }

    public boolean saveAsFits(String path) {
        if (!FileSaver.okForFits(this.imp)) {
            return false;
        }
        IJ.runPlugIn(this.imp, "ij.plugin.FITS_Writer", path);
        this.updateImp(this.fi, 4);
        return true;
    }

    public static boolean okForFits(ImagePlus imp) {
        if (imp.getBitDepth() == 24) {
            IJ.error("FITS Writer", "Grayscale image required");
            return false;
        }
        return true;
    }

    public boolean saveAsRaw() {
        String path = this.getPath("Raw", ".raw");
        if (path == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsRaw(path);
        }
        return this.saveAsRawStack(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAsRaw(String path) {
        this.fi.nImages = 1;
        this.fi.intelByteOrder = Prefs.intelByteOrder;
        boolean signed16Bit = false;
        short[] pixels = null;
        int n = 0;
        OutputStream out = null;
        try {
            signed16Bit = this.imp.getCalibration().isSigned16Bit();
            if (signed16Bit) {
                pixels = (short[])this.imp.getProcessor().getPixels();
                n = this.imp.getWidth() * this.imp.getHeight();
                for (int i = 0; i < n; ++i) {
                    pixels[i] = (short)(pixels[i] - 32768);
                }
            }
            ImageWriter file = new ImageWriter(this.fi);
            out = new BufferedOutputStream(new FileOutputStream(path), bsize);
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage("saveAsRaw", path, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (signed16Bit) {
            for (int i = 0; i < n; ++i) {
                pixels[i] = (short)(pixels[i] + 32768);
            }
        }
        this.updateImp(this.fi, 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAsRawStack(String path) {
        int i2;
        short[] pixels2;
        boolean virtualStack;
        if (this.fi.nImages == 1) {
            IJ.log("This is not a stack");
            return false;
        }
        this.fi.intelByteOrder = Prefs.intelByteOrder;
        boolean signed16Bit = false;
        Object[] stack = null;
        int n = 0;
        boolean bl = virtualStack = this.imp.getStackSize() > 1 && this.imp.getStack().isVirtual();
        if (virtualStack) {
            this.fi.virtualStack = (VirtualStack)this.imp.getStack();
            if (this.imp.getProperty("AnalyzeFormat") != null) {
                this.fi.fileName = "FlipTheseImages";
            }
        }
        OutputStream out = null;
        try {
            signed16Bit = this.imp.getCalibration().isSigned16Bit();
            if (signed16Bit && !virtualStack) {
                stack = (Object[])this.fi.pixels;
                n = this.imp.getWidth() * this.imp.getHeight();
                for (int slice = 0; slice < this.fi.nImages; ++slice) {
                    pixels2 = (short[])stack[slice];
                    for (i2 = 0; i2 < n; ++i2) {
                        pixels2[i2] = (short)(pixels2[i2] - 32768);
                    }
                }
            }
            ImageWriter file = new ImageWriter(this.fi);
            out = new BufferedOutputStream(new FileOutputStream(path), bsize);
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage("saveAsRawStack", path, e);
            boolean pixels2 = false;
            return pixels2;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException i2) {}
            }
        }
        if (signed16Bit) {
            for (int slice = 0; slice < this.fi.nImages; ++slice) {
                pixels2 = (short[])stack[slice];
                for (i2 = 0; i2 < n; ++i2) {
                    pixels2[i2] = (short)(pixels2[i2] + 32768);
                }
            }
        }
        this.updateImp(this.fi, 1);
        return true;
    }

    public boolean saveAsText() {
        String path = this.getPath("Text", ".csv");
        if (path == null) {
            return false;
        }
        return this.saveAsText(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAsText(String path) {
        FilterOutputStream out = null;
        try {
            boolean scientificNotation;
            Calibration cal = this.imp.getCalibration();
            int precision = Analyzer.getPrecision();
            int measurements = Analyzer.getMeasurements();
            boolean bl = scientificNotation = (measurements & 0x200000) != 0;
            if (scientificNotation) {
                precision = -precision;
            }
            TextEncoder file = new TextEncoder(this.imp.getProcessor(), cal, precision);
            if (path.endsWith(".csv") || path.endsWith(".CSV")) {
                file.setDelimiter(",");
            }
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write((DataOutputStream)out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage("saveAsText", path, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public boolean saveAsLut() {
        if (this.imp.getType() == 4) {
            this.error("RGB Images do not have a LUT.");
            return false;
        }
        String path = this.getPath("LUT", ".lut");
        if (path == null) {
            return false;
        }
        return this.saveAsLut(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAsLut(String path) {
        LookUpTable lut = this.imp.createLut();
        int mapSize = lut.getMapSize();
        if (mapSize == 0) {
            this.error("RGB Images do not have a LUT.");
            return false;
        }
        if (mapSize < 256) {
            this.error("Cannot save LUTs with less than 256 entries.");
            return false;
        }
        byte[] reds = lut.getReds();
        byte[] greens = lut.getGreens();
        byte[] blues = lut.getBlues();
        byte[] pixels = new byte[768];
        for (int i = 0; i < 256; ++i) {
            pixels[i] = reds[i];
            pixels[i + 256] = greens[i];
            pixels[i + 512] = blues[i];
        }
        FileInfo fi = new FileInfo();
        fi.width = 768;
        fi.height = 1;
        fi.pixels = pixels;
        OutputStream out = null;
        try {
            ImageWriter file = new ImageWriter(fi);
            out = new FileOutputStream(path);
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage("saveAsLut", path, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public void updateImagePlus(String path, int fileFormat) {
        if (this.imp == null || this.fi == null) {
            return;
        }
        if (this.name == null && path != null) {
            File f = new File(path);
            this.directory = f.getParent() + File.separator;
            this.name = f.getName();
        }
        this.updateImp(this.fi, fileFormat);
    }

    private void updateImp(FileInfo fi, int fileFormat) {
        this.imp.changes = false;
        if (this.name != null) {
            fi.fileFormat = fileFormat;
            FileInfo ofi = this.imp.getOriginalFileInfo();
            if (ofi != null) {
                if (ofi.openNextName == null) {
                    fi.openNextName = ofi.fileName;
                    fi.openNextDir = ofi.directory;
                } else {
                    fi.openNextName = ofi.openNextName;
                    fi.openNextDir = ofi.openNextDir;
                }
            }
            fi.fileName = this.name;
            fi.directory = this.directory;
            fi.description = null;
            this.imp.setTitle(this.name);
            fi.imageSaved = true;
            this.imp.setFileInfo(fi);
        }
    }

    private void showErrorMessage(String title, String path, IOException e) {
        String msg = e.getMessage();
        if (msg.length() > 100) {
            msg = msg.substring(0, 100);
        }
        msg = "File saving error (IOException):\n   \"" + msg + "\"";
        IJ.error("FileSaver." + title, msg + " \n   " + path);
        IJ.showProgress(1.0);
    }

    private void error(String msg) {
        IJ.error("FileSaver", msg);
    }

    public String getDescriptionString() {
        boolean enhancedLut;
        int frames;
        int slices;
        int channels;
        Calibration cal = this.imp.getCalibration();
        StringBuffer sb = new StringBuffer(100);
        sb.append("ImageJ=1.54k\n");
        if (this.fi.nImages > 1 && this.fi.fileType != 12) {
            sb.append("images=" + this.fi.nImages + "\n");
        }
        if ((channels = this.imp.getNChannels()) > 1) {
            sb.append("channels=" + channels + "\n");
        }
        if ((slices = this.imp.getNSlices()) > 1) {
            sb.append("slices=" + slices + "\n");
        }
        if ((frames = this.imp.getNFrames()) > 1) {
            sb.append("frames=" + frames + "\n");
        }
        if (this.imp.isHyperStack()) {
            sb.append("hyperstack=true\n");
        }
        if (this.imp.isComposite()) {
            String mode = ((CompositeImage)this.imp).getModeAsString();
            sb.append("mode=" + mode + "\n");
        }
        if (this.fi.unit != null) {
            this.appendEscapedLine(sb, "unit=" + this.fi.unit);
        }
        int bitDepth = this.imp.getBitDepth();
        if (this.fi.valueUnit != null && (this.fi.calibrationFunction != 22 || bitDepth == 32)) {
            if (bitDepth != 32) {
                sb.append("cf=" + this.fi.calibrationFunction + "\n");
                if (this.fi.coefficients != null) {
                    for (int i = 0; i < this.fi.coefficients.length; ++i) {
                        sb.append("c" + i + "=" + this.fi.coefficients[i] + "\n");
                    }
                }
            }
            this.appendEscapedLine(sb, "vunit=" + this.fi.valueUnit);
            if (cal.zeroClip() && bitDepth != 32) {
                sb.append("zeroclip=true\n");
            }
        }
        if (cal.frameInterval != 0.0) {
            if ((double)((int)cal.frameInterval) == cal.frameInterval) {
                sb.append("finterval=" + (int)cal.frameInterval + "\n");
            } else {
                sb.append("finterval=" + cal.frameInterval + "\n");
            }
        }
        if (!cal.getTimeUnit().equals("sec")) {
            this.appendEscapedLine(sb, "tunit=" + cal.getTimeUnit());
        }
        if (!cal.getYUnit().equals(cal.getUnit())) {
            this.appendEscapedLine(sb, "yunit=" + cal.getYUnit());
        }
        if (!cal.getZUnit().equals(cal.getUnit())) {
            this.appendEscapedLine(sb, "zunit=" + cal.getZUnit());
        }
        if (this.fi.nImages > 1) {
            if (this.fi.pixelDepth != 1.0) {
                sb.append("spacing=" + this.fi.pixelDepth + "\n");
            }
            if (cal.fps != 0.0) {
                if ((double)((int)cal.fps) == cal.fps) {
                    sb.append("fps=" + (int)cal.fps + "\n");
                } else {
                    sb.append("fps=" + cal.fps + "\n");
                }
            }
            sb.append("loop=" + (cal.loop ? "true" : "false") + "\n");
        }
        ImageProcessor ip = this.imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        int type = this.imp.getType();
        boolean bl = enhancedLut = !(type != 0 && type != 3 || min == 0.0 && max == 255.0);
        if (enhancedLut || type == 1 || type == 2) {
            sb.append("min=" + min + "\n");
            sb.append("max=" + max + "\n");
        }
        if (cal.xOrigin != 0.0) {
            sb.append("xorigin=" + cal.xOrigin + "\n");
        }
        if (cal.yOrigin != 0.0) {
            sb.append("yorigin=" + cal.yOrigin + "\n");
        }
        if (cal.zOrigin != 0.0) {
            sb.append("zorigin=" + cal.zOrigin + "\n");
        }
        if (cal.info != null && cal.info.length() <= 64 && cal.info.indexOf(61) == -1 && cal.info.indexOf(10) == -1) {
            this.appendEscapedLine(sb, "info=" + cal.info);
        }
        if (cal.getInvertY()) {
            sb.append("inverty=true\n");
        }
        if (this.saveName) {
            this.appendEscapedLine(sb, "name=" + this.imp.getTitle());
        }
        if (this.imp.getType() == 3) {
            sb.append("8bitcolor=true\n");
        }
        sb.append('\u0000');
        return new String(sb);
    }

    void appendEscapedLine(StringBuffer sb, String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= ' ' && c < '\u007f' && c != '\\') {
                sb.append(c);
                continue;
            }
            if (c > '\uffff') continue;
            sb.append("\\u");
            sb.append(Tools.int2hex(c, 4));
        }
        sb.append('\n');
    }

    public static void setJpegQuality(int quality) {
        jpegQuality = quality;
        if (jpegQuality < 0) {
            jpegQuality = 0;
        }
        if (jpegQuality > 100) {
            jpegQuality = 100;
        }
    }

    public static int getJpegQuality() {
        return jpegQuality;
    }

    public static void setBufferSize(int bufferSize) {
        bsize = bufferSize;
        if (bsize < 2048) {
            bsize = 2048;
        }
    }

    static {
        bsize = 32768;
        FileSaver.setJpegQuality(Prefs.getInt("jpeg", 85));
        defaultDirectory = null;
    }
}

