/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import ij.measure.Calibration;
import ij.plugin.Straightener;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;

public class ProfilePlot {
    static final int MIN_WIDTH = 350;
    static final double ASPECT_RATIO = 0.5;
    private double min;
    private double max;
    private boolean minAndMaxCalculated;
    private static double fixedMin;
    private static double fixedMax;
    protected ImagePlus imp;
    protected double[] profile;
    protected double magnification;
    protected double xInc;
    protected String units;
    protected String yLabel;
    protected float[] xValues;

    public ProfilePlot() {
    }

    public ProfilePlot(ImagePlus imp) {
        this(imp, false);
    }

    public ProfilePlot(ImagePlus imp, boolean verticalPlot) {
        int lineWidth;
        boolean rotatedRect;
        this.imp = imp;
        boolean averageHorizontally = verticalPlot;
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.error("Profile Plot", "Selection required.");
            return;
        }
        int roiType = roi.getType();
        boolean bl = rotatedRect = roi != null && roi instanceof RotatedRectRoi;
        if (!roi.isLine() && roiType != 0 && !rotatedRect) {
            IJ.error("Line or rectangular selection required.");
            return;
        }
        if (rotatedRect) {
            double[] p = ((RotatedRectRoi)roi).getParams();
            roi = new Line(p[0], p[1], p[2], p[3]);
            roi.setStrokeWidth(p[4]);
            roi.setImage(imp);
            roiType = 5;
        }
        Calibration cal = imp.getCalibration();
        this.xInc = cal.pixelWidth;
        this.units = cal.getUnits();
        this.yLabel = cal.getValueUnit();
        ImageProcessor ip = imp.getProcessor();
        this.profile = roiType == 5 ? this.getStraightLineProfile(roi, cal, ip) : (roiType == 6 || roiType == 7 ? ((lineWidth = Math.round(roi.getStrokeWidth())) <= 1 ? this.getIrregularProfile(roi, ip, cal) : this.getWideLineProfile(imp, lineWidth)) : (averageHorizontally ? this.getRowAverageProfile(roi.getBounds(), cal, ip) : ProfilePlot.getColumnAverageProfile(roi.getBounds(), ip)));
        ip.setCalibrationTable(null);
        ImageCanvas ic = imp.getCanvas();
        this.magnification = ic != null ? ic.getMagnification() : 1.0;
    }

    public Dimension getPlotSize() {
        if (this.profile == null) {
            return null;
        }
        int width = (int)((double)this.profile.length * this.magnification);
        int height = (int)((double)width * 0.5);
        if (width < 350) {
            width = 350;
            height = (int)((double)width * 0.5);
        }
        Rectangle screen = GUI.getMaxWindowBounds(this.imp != null ? this.imp.getWindow() : IJ.getInstance());
        int maxWidth = Math.min(screen.width - 200, 1000);
        if (width > maxWidth) {
            width = maxWidth;
            height = (int)((double)width * 0.5);
        }
        return new Dimension(width, height);
    }

    public void createWindow() {
        Plot plot = this.getPlot();
        if (plot != null) {
            plot.show();
        }
    }

    public Plot getPlot() {
        if (this.profile == null) {
            return null;
        }
        String xLabel = "Distance (" + this.units + ")";
        int n = this.profile.length;
        if (this.xValues == null) {
            this.xValues = new float[n];
            for (int i = 0; i < n; ++i) {
                this.xValues[i] = (float)((double)i * this.xInc);
            }
        }
        float[] yValues = new float[n];
        for (int i = 0; i < n; ++i) {
            yValues[i] = (float)this.profile[i];
        }
        boolean fixedYScale = fixedMin != 0.0 || fixedMax != 0.0;
        Plot plot = new Plot("Plot of " + this.getShortTitle(this.imp), xLabel, this.yLabel, this.xValues, yValues);
        if (fixedYScale) {
            double[] a = Tools.getMinMax(this.xValues);
            plot.setLimits(a[0], a[1], fixedMin, fixedMax);
        }
        return plot;
    }

    String getShortTitle(ImagePlus imp) {
        String title = imp.getTitle();
        int index = title.lastIndexOf(46);
        if (index > 0 && title.length() - index <= 5) {
            title = title.substring(0, index);
        }
        return title;
    }

    public double[] getProfile() {
        return this.profile;
    }

    public double getMin() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.min;
    }

    public double getMax() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.max;
    }

    public static void setMinAndMax(double min, double max) {
        fixedMin = min;
        fixedMax = max;
        IJ.register(ProfilePlot.class);
    }

    public static double getFixedMin() {
        return fixedMin;
    }

    public static double getFixedMax() {
        return fixedMax;
    }

    double[] getStraightLineProfile(Roi roi, Calibration cal, ImageProcessor ip) {
        ip.setInterpolate(PlotWindow.interpolate);
        Line line = (Line)roi;
        double[] values = line.getPixels();
        if (values == null) {
            return null;
        }
        if (cal != null && cal.pixelWidth != cal.pixelHeight) {
            FloatPolygon p = line.getFloatPoints();
            double dx = p.xpoints[1] - p.xpoints[0];
            double dy = p.ypoints[1] - p.ypoints[0];
            double pixelLength = Math.sqrt(dx * dx + dy * dy);
            dx = cal.pixelWidth * dx;
            dy = cal.pixelHeight * dy;
            double calibratedLength = Math.sqrt(dx * dx + dy * dy);
            this.xInc = calibratedLength * 1.0 / pixelLength;
        }
        return values;
    }

    double[] getRowAverageProfile(Rectangle rect, Calibration cal, ImageProcessor ip) {
        double[] profile = new double[rect.height];
        int[] counts = new int[rect.height];
        ip.setInterpolate(false);
        for (int x = rect.x; x < rect.x + rect.width; ++x) {
            double[] aLine = ip.getLine(x, rect.y, x, rect.y + rect.height - 1);
            for (int i = 0; i < rect.height; ++i) {
                if (Double.isNaN(aLine[i])) continue;
                int n = i;
                profile[n] = profile[n] + aLine[i];
                int n2 = i;
                counts[n2] = counts[n2] + 1;
            }
        }
        for (int i = 0; i < rect.height; ++i) {
            int n = i;
            profile[n] = profile[n] / (double)counts[i];
        }
        if (cal != null) {
            this.xInc = cal.pixelHeight;
        }
        return profile;
    }

    public static double[] getColumnAverageProfile(Rectangle rect, ImageProcessor ip) {
        double[] profile = new double[rect.width];
        int[] counts = new int[rect.width];
        ip.setInterpolate(false);
        for (int y = rect.y; y < rect.y + rect.height; ++y) {
            double[] aLine = ip.getLine(rect.x, y, rect.x + rect.width - 1, y);
            for (int i = 0; i < rect.width; ++i) {
                if (Double.isNaN(aLine[i])) continue;
                int n = i;
                profile[n] = profile[n] + aLine[i];
                int n2 = i;
                counts[n2] = counts[n2] + 1;
            }
        }
        for (int i = 0; i < rect.width; ++i) {
            int n = i;
            profile[n] = profile[n] / (double)counts[i];
        }
        return profile;
    }

    double[] getIrregularProfile(Roi roi, ImageProcessor ip, Calibration cal) {
        boolean interpolate = PlotWindow.interpolate;
        boolean calcXValues = cal != null && cal.pixelWidth != cal.pixelHeight;
        FloatPolygon p = roi.getFloatPolygon();
        int n = p.npoints;
        float[] xpoints = p.xpoints;
        float[] ypoints = p.ypoints;
        ArrayList<Double> values = new ArrayList<Double>();
        double inc = 0.01;
        double distance = 0.0;
        double distance2 = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double lastx = 0.0;
        double lasty = 0.0;
        double x2 = xpoints[0];
        double y2 = ypoints[0];
        for (int i = 1; i < n; ++i) {
            double x1 = x2;
            double y1 = y2;
            double x = x1;
            double y = y1;
            x2 = xpoints[i];
            y2 = ypoints[i];
            dx = x2 - x1;
            dy = y2 - y1;
            distance = Math.sqrt(dx * dx + dy * dy);
            double xinc = dx * inc / distance;
            double yinc = dy * inc / distance;
            int n2 = (int)(distance / inc);
            if (n == 2) {
                ++n2;
            }
            do {
                if ((distance2 = Math.sqrt((dx = x - lastx) * dx + (dy = y - lasty) * dy)) >= 1.0 - inc / 2.0) {
                    double value = interpolate ? ip.getInterpolatedValue(x, y) : (double)ip.getPixelValue((int)Math.round(x), (int)Math.round(y));
                    values.add(value);
                    lastx = x;
                    lasty = y;
                }
                x += xinc;
                y += yinc;
            } while (--n2 > 0);
        }
        double[] values2 = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            values2[i] = (Double)values.get(i);
        }
        return values2;
    }

    double[] getWideLineProfile(ImagePlus imp, int lineWidth) {
        Roi roi = imp.getRoi();
        if (roi == null) {
            return null;
        }
        if (roi instanceof PolygonRoi && roi.getState() == 0) {
            return null;
        }
        roi = (Roi)roi.clone();
        ImageProcessor ip2 = new Straightener().straightenLine(imp, lineWidth);
        if (ip2 == null) {
            return null;
        }
        int width = ip2.getWidth();
        int height = ip2.getHeight();
        if (ip2 instanceof FloatProcessor) {
            return ProfilePlot.getColumnAverageProfile(new Rectangle(0, 0, width, height), ip2);
        }
        this.profile = new double[width];
        ip2.setInterpolate(false);
        for (int y = 0; y < height; ++y) {
            double[] aLine = ip2.getLine(0.0, y, width - 1, y);
            for (int i = 0; i < width; ++i) {
                int n = i;
                this.profile[n] = this.profile[n] + aLine[i];
            }
        }
        int i = 0;
        while (i < width) {
            int n = i++;
            this.profile[n] = this.profile[n] / (double)height;
        }
        return this.profile;
    }

    void findMinAndMax() {
        if (this.profile == null) {
            return;
        }
        double min = this.profile[0];
        double max = this.profile[0];
        for (int i = 1; i < this.profile.length; ++i) {
            double value = this.profile[i];
            if (value < min) {
                min = value;
                continue;
            }
            if (!(value > max)) continue;
            max = value;
        }
        this.min = min;
        this.max = max;
    }
}

