/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.HistogramPlot;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.gui.RoiListener;
import ij.gui.TrimmedButton;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class HistogramWindow
extends ImageWindow
implements Measurements,
ActionListener,
ClipboardOwner,
ImageListener,
RoiListener,
Runnable {
    private static final double SCALE = HistogramPlot.SCALE;
    static final int HIST_WIDTH = HistogramPlot.HIST_WIDTH;
    static final int HIST_HEIGHT = HistogramPlot.HIST_HEIGHT;
    static final int XMARGIN = HistogramPlot.XMARGIN;
    static final int YMARGIN = HistogramPlot.YMARGIN;
    static final int WIN_WIDTH = HistogramPlot.WIN_WIDTH;
    static final int WIN_HEIGHT = HistogramPlot.WIN_HEIGHT;
    static final int BAR_HEIGHT = HistogramPlot.BAR_HEIGHT;
    static final int INTENSITY1 = 0;
    static final int INTENSITY2 = 1;
    static final int RGB = 2;
    static final int RED = 3;
    static final int GREEN = 4;
    static final int BLUE = 5;
    protected ImageStatistics stats;
    protected long[] histogram;
    protected LookUpTable lut;
    protected Rectangle frame = null;
    protected Button list;
    protected Button save;
    protected Button copy;
    protected Button log;
    protected Button live;
    protected Button rgb;
    protected Label value;
    protected Label count;
    protected static String defaultDirectory = null;
    protected int decimalPlaces;
    protected int digits;
    protected long newMaxCount;
    protected int plotScale = 1;
    protected boolean logScale;
    protected Calibration cal;
    protected int yMax;
    public static int nBins = 256;
    private int srcImageID;
    private ImagePlus srcImp;
    private Thread bgThread;
    private boolean doUpdate;
    private int rgbMode = -1;
    private String blankLabel;
    private boolean stackHistogram;
    private Font font = new Font("SansSerif", 0, (int)(12.0 * SCALE));
    private boolean showBins;
    private int col1;
    private int col2;
    private int row1;
    private int row2;
    private int row3;
    private int row4;
    private int row5;

    public HistogramWindow(HistogramPlot plot, ImagePlus srcImp) {
        super(plot);
        this.srcImageID = srcImp.getID();
        this.frame = plot.frame;
        this.histogram = plot.histogram;
        this.cal = plot.cal;
        this.stats = plot.stats;
        this.yMax = plot.yMax;
        this.newMaxCount = plot.newMaxCount;
        this.showBins = plot.showBins;
        this.rgbMode = plot.rgbMode;
        this.col1 = plot.col1;
        this.col2 = plot.col2;
        this.row1 = plot.row1;
        this.row2 = plot.row2;
        this.row3 = plot.row3;
        this.row4 = plot.row4;
        this.row5 = plot.row5;
        if (this.list == null) {
            this.setup(srcImp);
        }
    }

    public HistogramWindow(ImagePlus imp) {
        super(NewImage.createRGBImage("Histogram of " + imp.getShortTitle(), WIN_WIDTH, WIN_HEIGHT, 1, 4));
        this.showHistogram(imp, 256, 0.0, 0.0);
    }

    public HistogramWindow(String title, ImagePlus imp, int bins) {
        super(NewImage.createRGBImage(title, WIN_WIDTH, WIN_HEIGHT, 1, 4));
        this.showHistogram(imp, bins, 0.0, 0.0);
    }

    public HistogramWindow(String title, ImagePlus imp, int bins, double histMin, double histMax) {
        super(NewImage.createRGBImage(title, WIN_WIDTH, WIN_HEIGHT, 1, 4));
        this.showHistogram(imp, bins, histMin, histMax);
    }

    public HistogramWindow(String title, ImagePlus imp, int bins, double histMin, double histMax, int yMax) {
        super(NewImage.createRGBImage(title, WIN_WIDTH, WIN_HEIGHT, 1, 4));
        this.yMax = yMax;
        this.showHistogram(imp, bins, histMin, histMax);
    }

    public HistogramWindow(String title, ImagePlus imp, ImageStatistics stats) {
        super(NewImage.createRGBImage(title, WIN_WIDTH, WIN_HEIGHT, 1, 4));
        this.yMax = stats.histYMax;
        this.showHistogram(imp, stats);
    }

    public void showHistogram(ImagePlus imp, int bins) {
        this.showHistogram(imp, bins, 0.0, 0.0);
    }

    public void showHistogram(ImagePlus imp, int bins, double histMin, double histMax) {
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        ImageProcessor ip = imp.getProcessor();
        if (ip.isThreshold() && ip.getLutUpdateMode() == 2) {
            limitToThreshold = false;
        }
        if (imp.isRGB() && this.rgbMode < 0) {
            this.rgbMode = 0;
        }
        if (this.rgbMode == 3 || this.rgbMode == 4 || this.rgbMode == 5) {
            int channel = this.rgbMode - 2;
            ColorProcessor cp = (ColorProcessor)imp.getProcessor();
            ip = cp.getChannel(channel, null);
            ImagePlus imp2 = new ImagePlus("", ip);
            imp2.setRoi(imp.getRoi());
            this.stats = imp2.getStatistics(27, bins, histMin, histMax);
        } else {
            this.stats = this.rgbMode == 2 ? this.RGBHistogram(imp, bins, histMin, histMax) : imp.getStatistics(27 + (limitToThreshold ? 256 : 0), bins, histMin, histMax);
        }
        this.showHistogram(imp, this.stats);
    }

    private ImageStatistics RGBHistogram(ImagePlus imp, int bins, double histMin, double histMax) {
        ImageProcessor ip = (ColorProcessor)imp.getProcessor();
        ip = ip.crop();
        int w = ip.getWidth();
        int h = ip.getHeight();
        ByteProcessor ip2 = new ByteProcessor(w * 3, h);
        ByteProcessor temp = null;
        for (int i = 0; i < 3; ++i) {
            temp = ((ColorProcessor)ip).getChannel(i + 1, temp);
            ip2.insert(temp, i * w, 0);
        }
        ImagePlus imp2 = new ImagePlus("imp2", ip2);
        return imp2.getStatistics(27, bins, histMin, histMax);
    }

    public void showHistogram(ImagePlus srcImp, ImageStatistics stats) {
        boolean fixedRange;
        ImageProcessor ip;
        if (srcImp.isRGB() && this.rgbMode < 0) {
            this.rgbMode = 0;
        }
        this.stackHistogram = stats.stackStatistics;
        if (this.list == null) {
            this.setup(srcImp);
        }
        this.stats = stats;
        this.cal = srcImp.getCalibration();
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        srcImp.getMask();
        this.histogram = stats.getHistogram();
        if (limitToThreshold && this.histogram.length == 256 && (ip = srcImp.getProcessor()).isThreshold()) {
            int i;
            int lower = this.scaleDown(ip, ip.getMinThreshold());
            int upper = this.scaleDown(ip, ip.getMaxThreshold());
            for (i = 0; i < lower; ++i) {
                this.histogram[i] = 0L;
            }
            for (i = upper + 1; i < 256; ++i) {
                this.histogram[i] = 0L;
            }
        }
        this.lut = srcImp.createLut();
        int type = srcImp.getType();
        boolean bl = fixedRange = type == 0 || type == 3 || srcImp.isRGB();
        if (this.imp == null) {
            IJ.showStatus("imp==null");
            return;
        }
        ImageProcessor ip2 = this.imp.getProcessor();
        ip2.setColor(Color.white);
        ip2.resetRoi();
        ip2.fill();
        ImageProcessor srcIP = srcImp.getProcessor();
        this.drawHistogram(srcImp, ip2, fixedRange, stats.histMin, stats.histMax);
        this.imp.updateAndDraw();
    }

    private void setup(ImagePlus imp) {
        boolean isRGB = imp.isRGB();
        Panel buttons = new Panel();
        int hgap = IJ.isMacOSX() || isRGB ? 1 : 5;
        buttons.setLayout(new FlowLayout(2, hgap, 0));
        int trim = IJ.isMacOSX() ? 6 : 0;
        this.list = new TrimmedButton("List", trim);
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.copy = new TrimmedButton("Copy", trim);
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.log = new TrimmedButton("Log", trim);
        this.log.addActionListener(this);
        buttons.add(this.log);
        if (!this.stackHistogram) {
            this.live = new TrimmedButton("Live", trim);
            this.live.addActionListener(this);
            buttons.add(this.live);
        }
        if (imp != null && isRGB && !this.stackHistogram) {
            this.rgb = new TrimmedButton("RGB", trim);
            this.rgb.addActionListener(this);
            buttons.add(this.rgb);
        }
        this.value = new Label(" ");
        this.count = new Label(" ");
        this.add(buttons);
        GUI.scale(buttons);
        this.pack();
        if (IJ.isMacOSX() && IJ.isJava18()) {
            IJ.wait(50);
            this.pack();
        }
    }

    public void setup() {
        this.setup(null);
    }

    @Override
    public void mouseMoved(int x, int y) {
        ImageProcessor ip;
        ImageProcessor imageProcessor = ip = this.imp != null ? this.imp.getProcessor() : null;
        if (ip == null) {
            return;
        }
        if (this.frame != null && x >= this.frame.x && x <= this.frame.x + this.frame.width) {
            int index = (int)((double)(x -= this.frame.x) * (SCALE * (double)this.histogram.length) / (double)HIST_WIDTH / SCALE);
            if (index >= this.histogram.length) {
                index = this.histogram.length - 1;
            }
            double value = this.cal.getCValue(this.stats.histMin + (double)index * this.stats.binSize);
            this.drawValueAndCount(ip, value, this.histogram[index]);
        } else {
            this.drawValueAndCount(ip, Double.NaN, -1L);
        }
        this.imp.updateAndDraw();
    }

    protected void drawHistogram(ImageProcessor ip, boolean fixedRange) {
        this.drawHistogram(null, ip, fixedRange, 0.0, 0.0);
    }

    void drawHistogram(ImagePlus imp, ImageProcessor ip, boolean fixedRange, double xMin, double xMax) {
        long maxCount2 = 0L;
        int mode2 = 0;
        ip.setColor(Color.black);
        ip.setLineWidth(1);
        this.decimalPlaces = Analyzer.getPrecision();
        this.digits = this.cal.calibrated() || this.stats.binSize != 1.0 ? this.decimalPlaces : 0;
        long saveModalCount = this.histogram[this.stats.mode];
        for (int i = 0; i < this.histogram.length; ++i) {
            if (this.histogram[i] <= maxCount2 || i == this.stats.mode) continue;
            maxCount2 = this.histogram[i];
            mode2 = i;
        }
        this.newMaxCount = this.histogram[this.stats.mode];
        if (this.newMaxCount > maxCount2 * 2L && maxCount2 != 0L) {
            this.newMaxCount = (int)((double)maxCount2 * 1.5);
        }
        if (this.logScale || IJ.shiftKeyDown() && !this.liveMode()) {
            this.drawLogPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
        }
        this.drawPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
        this.histogram[this.stats.mode] = saveModalCount;
        int x = XMARGIN + 1;
        int y = YMARGIN + HIST_HEIGHT + 2;
        if (imp == null) {
            this.lut.drawUnscaledColorBar(ip, x - 1, y, HIST_WIDTH, BAR_HEIGHT);
        } else {
            this.drawAlignedColorBar(imp, xMin, xMax, ip, x - 1, y, HIST_WIDTH, BAR_HEIGHT);
        }
        this.drawText(ip, x, y += BAR_HEIGHT + (int)(15.0 * SCALE), fixedRange);
        this.srcImageID = imp.getID();
    }

    void drawAlignedColorBar(ImagePlus imp, double xMin, double xMax, ImageProcessor ip, int x, int y, int width, int height) {
        ImageProcessor ipSource = imp.getProcessor();
        float[] pixels = null;
        FloatProcessor ipRamp = null;
        if (this.rgbMode >= 0) {
            ipRamp = new FloatProcessor(width, height);
            if (this.rgbMode == 3) {
                ipRamp.setColorModel(LUT.createLutFromColor(Color.red));
            } else if (this.rgbMode == 4) {
                ipRamp.setColorModel(LUT.createLutFromColor(Color.green));
            } else if (this.rgbMode == 5) {
                ipRamp.setColorModel(LUT.createLutFromColor(Color.blue));
            }
            pixels = (float[])((ImageProcessor)ipRamp).getPixels();
        } else {
            pixels = new float[width * height];
        }
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                pixels[i + width * j] = (float)(xMin + (double)i * (xMax - xMin) / (double)(width - 1));
            }
        }
        double min = ipSource.getMin();
        double max = ipSource.getMax();
        if (ipSource.getNChannels() == 1) {
            ColorModel cm = null;
            if (imp.isComposite()) {
                if (this.stats != null && this.stats.pixelCount > ipSource.getPixelCount()) {
                    cm = LUT.createLutFromColor(Color.white);
                    min = this.stats.min;
                    max = this.stats.max;
                } else {
                    cm = ((CompositeImage)imp).getChannelLut();
                }
            } else {
                cm = !ipSource.isThreshold() ? ipSource.getColorModel() : ipSource.getCurrentColorModel();
            }
            ipRamp = new FloatProcessor(width, height, pixels, cm);
        }
        ((ImageProcessor)ipRamp).setMinAndMax(min, max);
        ImageProcessor bar = null;
        bar = ip instanceof ColorProcessor ? ipRamp.convertToRGB() : ipRamp.convertToByte(true);
        ip.insert(bar, x, y);
        ip.setColor(Color.black);
        ip.drawRect(x - 1, y, width + 2, height);
    }

    int scaleDown(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return (int)((threshold - min) / (max - min) * 255.0);
        }
        return 0;
    }

    void drawPlot(long maxCount, ImageProcessor ip) {
        if (maxCount == 0L) {
            maxCount = 1L;
        }
        this.frame = new Rectangle(XMARGIN, YMARGIN, HIST_WIDTH, HIST_HEIGHT);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        if (this.histogram.length == 256) {
            double scale2 = (double)HIST_WIDTH / 256.0;
            int barWidth = 1;
            if (SCALE > 1.0) {
                barWidth = 2;
            }
            if (SCALE > 2.0) {
                barWidth = 3;
            }
            for (int i = 0; i < 256; ++i) {
                int x = (int)((double)i * scale2);
                int y = (int)((double)HIST_HEIGHT * (double)this.histogram[i] / (double)maxCount);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                for (int j = 0; j < barWidth; ++j) {
                    ip.drawLine(x + j + XMARGIN, YMARGIN + HIST_HEIGHT, x + j + XMARGIN, YMARGIN + HIST_HEIGHT - y);
                }
            }
        } else if (this.histogram.length <= HIST_WIDTH) {
            for (int i = 0; i < HIST_WIDTH; ++i) {
                int index = (int)((double)i * (double)this.histogram.length / (double)HIST_WIDTH);
                int y = (int)((double)HIST_HEIGHT * (double)this.histogram[index] / (double)maxCount);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                ip.drawLine(i + XMARGIN, YMARGIN + HIST_HEIGHT, i + XMARGIN, YMARGIN + HIST_HEIGHT - y);
            }
        } else {
            double xscale = (double)HIST_WIDTH / (double)this.histogram.length;
            for (int i = 0; i < this.histogram.length; ++i) {
                long value = this.histogram[i];
                if (value <= 0L) continue;
                int y = (int)((double)HIST_HEIGHT * (double)value / (double)maxCount);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                int x = (int)((double)i * xscale) + XMARGIN;
                ip.drawLine(x, YMARGIN + HIST_HEIGHT, x, YMARGIN + HIST_HEIGHT - y);
            }
        }
    }

    void drawLogPlot(long maxCount, ImageProcessor ip) {
        this.frame = new Rectangle(XMARGIN, YMARGIN, HIST_WIDTH, HIST_HEIGHT);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        double max = Math.log(maxCount);
        ip.setColor(Color.gray);
        if (this.histogram.length == 256) {
            double scale2 = (double)HIST_WIDTH / 256.0;
            int barWidth = 1;
            if (SCALE > 1.0) {
                barWidth = 2;
            }
            if (SCALE > 2.0) {
                barWidth = 3;
            }
            for (int i = 0; i < 256; ++i) {
                int y;
                int x = (int)((double)i * scale2);
                int n = y = this.histogram[i] == 0L ? 0 : (int)((double)HIST_HEIGHT * Math.log(this.histogram[i]) / max);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                for (int j = 0; j < barWidth; ++j) {
                    ip.drawLine(x + j + XMARGIN, YMARGIN + HIST_HEIGHT, x + j + XMARGIN, YMARGIN + HIST_HEIGHT - y);
                }
            }
        } else if (this.histogram.length <= HIST_WIDTH) {
            for (int i = 0; i < HIST_WIDTH; ++i) {
                int y;
                int index = (int)((double)i * (double)this.histogram.length / (double)HIST_WIDTH);
                int n = y = this.histogram[index] == 0L ? 0 : (int)((double)HIST_HEIGHT * Math.log(this.histogram[index]) / max);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                ip.drawLine(i + XMARGIN, YMARGIN + HIST_HEIGHT, i + XMARGIN, YMARGIN + HIST_HEIGHT - y);
            }
        } else {
            double xscale = (double)HIST_WIDTH / (double)this.histogram.length;
            for (int i = 0; i < this.histogram.length; ++i) {
                long value = this.histogram[i];
                if (value <= 0L) continue;
                int y = (int)((double)HIST_HEIGHT * Math.log(value) / max);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                int x = (int)((double)i * xscale) + XMARGIN;
                ip.drawLine(x, YMARGIN + HIST_HEIGHT, x, YMARGIN + HIST_HEIGHT - y);
            }
        }
        ip.setColor(Color.black);
    }

    void drawText(ImageProcessor ip, int x, int y, boolean fixedRange) {
        ip.setFont(this.font);
        ip.setAntialiasedText(true);
        double hmin = this.cal.getCValue(this.stats.histMin);
        double hmax = this.cal.getCValue(this.stats.histMax);
        double range = hmax - hmin;
        if (fixedRange && !this.cal.calibrated() && hmin == 0.0 && hmax == 255.0) {
            range = 256.0;
        }
        ip.drawString(this.d2s(hmin), x - 4, y);
        ip.drawString(this.d2s(hmax), x + HIST_WIDTH - this.getWidth(hmax, ip) + 10, y);
        if (this.rgbMode >= 0) {
            x += HIST_WIDTH / 2;
            ++y;
            ip.setJustification(1);
            boolean weighted = ((ColorProcessor)ip).weightedHistogram();
            switch (this.rgbMode) {
                case 0: {
                    ip.drawString(weighted ? "Intensity (weighted)" : "Intensity (unweighted)", x, y);
                    break;
                }
                case 1: {
                    ip.drawString(weighted ? "Intensity (unweighted)" : "Intensity (weighted)", x, y);
                    break;
                }
                case 2: {
                    ip.drawString("R+G+B", x, y);
                    break;
                }
                case 3: {
                    ip.drawString("Red", x, y);
                    break;
                }
                case 4: {
                    ip.drawString("Green", x, y);
                    break;
                }
                case 5: {
                    ip.drawString("Blue", x, y);
                }
            }
            ip.setJustification(0);
        }
        double binWidth = range / (double)this.stats.nBins;
        this.showBins = (binWidth = Math.abs(binWidth)) != 1.0 || !fixedRange;
        this.col1 = XMARGIN + 5;
        this.col2 = XMARGIN + HIST_WIDTH / 2;
        this.row1 = y + (int)(25.0 * SCALE);
        if (this.showBins) {
            this.row1 -= (int)(8.0 * SCALE);
        }
        this.row2 = this.row1 + (int)(15.0 * SCALE);
        this.row3 = this.row2 + (int)(15.0 * SCALE);
        this.row4 = this.row3 + (int)(15.0 * SCALE);
        this.row5 = this.row4 + (int)(15.0 * SCALE);
        long count = this.stats.longPixelCount > 0L ? this.stats.longPixelCount : (long)this.stats.pixelCount;
        String modeCount = " (" + this.stats.maxCount + ")";
        if (this.histogram != null) {
            int mcount = 0;
            for (int i = 0; i < this.histogram.length; ++i) {
                if (this.histogram[i] != (long)this.stats.maxCount) continue;
                ++mcount;
            }
            if (mcount > 1) {
                modeCount = modeCount + "*";
            }
        }
        if (modeCount.length() > 12) {
            modeCount = "";
        }
        ip.drawString("N: " + count, this.col1, this.row1);
        ip.drawString("Min: " + this.d2s(this.stats.min), this.col2, this.row1);
        ip.drawString("Mean: " + this.d2s(this.stats.mean), this.col1, this.row2);
        ip.drawString("Max: " + this.d2s(this.stats.max), this.col2, this.row2);
        ip.drawString("StdDev: " + this.d2s(this.stats.stdDev), this.col1, this.row3);
        ip.drawString("Mode: " + this.d2s(this.stats.dmode) + modeCount, this.col2, this.row3);
        if (this.showBins) {
            ip.drawString("Bins: " + this.d2s(this.stats.nBins), this.col1, this.row4);
            ip.drawString("Bin Width: " + this.d2s(binWidth), this.col2, this.row4);
        }
        this.drawValueAndCount(ip, Double.NaN, -1L);
    }

    private void drawValueAndCount(ImageProcessor ip, double value, long count) {
        int y = this.showBins ? this.row4 : this.row3;
        ip.setRoi(0, y, WIN_WIDTH, WIN_HEIGHT - y);
        ip.setColor(Color.white);
        ip.fill();
        ip.setColor(Color.black);
        String sValue = Double.isNaN(value) ? "---" : this.d2s(value);
        String sCount = count == -1L ? "---" : "" + count;
        int row = this.showBins ? this.row5 : this.row4;
        ip.drawString("Value: " + sValue, this.col1, row);
        ip.drawString("Count: " + sCount, this.col2, row);
    }

    private String d2s(double d) {
        if ((double)((int)d) == d) {
            return IJ.d2s(d, 0);
        }
        return IJ.d2s(d, 3, 8);
    }

    int getWidth(double d, ImageProcessor ip) {
        return ip.getStringWidth(this.d2s(d));
    }

    public ResultsTable getResultsTable() {
        String vheading;
        int decimalPlaces = Analyzer.getPrecision();
        if (this.digits == 0 && this.stats.binSize != 1.0) {
            this.digits = decimalPlaces;
        }
        ResultsTable rt = new ResultsTable();
        rt.setPrecision(this.digits);
        String string = vheading = this.stats.binSize == 1.0 ? "value" : "bin start";
        if (this.cal.calibrated() && !this.cal.isSigned16Bit()) {
            for (int i = 0; i < this.stats.nBins; ++i) {
                rt.setValue("level", i, (double)i);
                rt.setValue(vheading, i, this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize));
                rt.setValue("count", i, (double)this.histogram[i]);
            }
        } else {
            for (int i = 0; i < this.stats.nBins; ++i) {
                if (this.stats.binSize != 1.0) {
                    rt.setValue("index", i, (double)i);
                }
                rt.setValue(vheading, i, this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize));
                rt.setValue("count", i, (double)this.histogram[i]);
            }
        }
        return rt;
    }

    public void showList() {
        ResultsTable rt = this.getResultsTable();
        rt.show(this.getTitle());
    }

    protected void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying histogram values...");
        CharArrayWriter aw = new CharArrayWriter(this.stats.nBins * 4);
        PrintWriter pw = new PrintWriter(aw);
        for (int i = 0; i < this.stats.nBins; ++i) {
            pw.print(ResultsTable.d2s(this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize), this.digits) + "\t" + this.histogram[i] + "\n");
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " characters copied to Clipboard");
    }

    void replot() {
        ImageProcessor ip = this.imp.getProcessor();
        this.frame = new Rectangle(XMARGIN, YMARGIN, HIST_WIDTH, HIST_HEIGHT);
        ip.setColor(Color.white);
        ip.setRoi(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height);
        ip.fill();
        ip.resetRoi();
        ip.setColor(Color.black);
        ip.setLineWidth(1);
        if (this.logScale) {
            this.drawLogPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
            this.drawPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
        } else {
            this.drawPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
        }
        this.imp.updateAndDraw();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.live) {
            this.toggleLiveMode();
        } else if (b == this.rgb) {
            this.changeChannel();
        } else if (b == this.list) {
            this.showList();
            if (!Recorder.scriptMode()) {
                Recorder.record("Table.showHistogramTable");
            }
        } else if (b == this.copy) {
            this.copyToClipboard();
        } else if (b == this.log) {
            this.logScale = !this.logScale;
            this.replot();
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public int[] getHistogram() {
        int[] hist = new int[this.histogram.length];
        for (int i = 0; i < this.histogram.length; ++i) {
            hist[i] = (int)this.histogram[i];
        }
        return hist;
    }

    public double[] getXValues() {
        double[] values = new double[this.stats.nBins];
        for (int i = 0; i < this.stats.nBins; ++i) {
            values[i] = this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize);
        }
        return values;
    }

    private void toggleLiveMode() {
        if (this.liveMode()) {
            this.removeListeners();
        } else {
            this.enableLiveMode();
        }
    }

    private void changeChannel() {
        ImagePlus imp = WindowManager.getImage(this.srcImageID);
        if (imp == null || !imp.isRGB()) {
            return;
        }
        ++this.rgbMode;
        if (this.rgbMode > 5) {
            this.rgbMode = 0;
        }
        ColorProcessor cp = (ColorProcessor)imp.getProcessor();
        boolean weighted = cp.weightedHistogram();
        if (this.rgbMode == 1) {
            double[] weights = cp.getRGBWeights();
            if (weighted) {
                cp.setRGBWeights(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
            } else {
                cp.setRGBWeights(0.299, 0.587, 0.114);
            }
            this.showHistogram(imp, 256);
            cp.setRGBWeights(weights);
        } else {
            this.showHistogram(imp, 256);
        }
    }

    private boolean liveMode() {
        return this.live != null && this.live.getForeground() == Color.red;
    }

    private void enableLiveMode() {
        if (this.bgThread == null) {
            this.srcImp = WindowManager.getImage(this.srcImageID);
            if (this.srcImp == null) {
                return;
            }
            this.bgThread = new Thread((Runnable)this, "Live Histogram");
            this.bgThread.setPriority(Math.max(this.bgThread.getPriority() - 3, 1));
            this.bgThread.start();
            this.imageUpdated(this.srcImp);
        }
        this.createListeners();
        if (this.srcImp != null) {
            this.imageUpdated(this.srcImp);
        }
    }

    @Override
    public void imageOpened(ImagePlus imp) {
    }

    @Override
    public synchronized void imageUpdated(ImagePlus imp) {
        if (imp == this.srcImp) {
            this.doUpdate = true;
            this.notify();
        }
    }

    @Override
    public synchronized void roiModified(ImagePlus img, int id) {
        if (img == this.srcImp) {
            this.doUpdate = true;
            this.notify();
        }
    }

    @Override
    public void imageClosed(ImagePlus imp) {
        if (imp == this.srcImp || imp == this.imp) {
            if (this.bgThread != null) {
                this.bgThread.interrupt();
            }
            this.bgThread = null;
            this.removeListeners();
            this.srcImp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.doUpdate && this.srcImp != null) {
                if (this.srcImp.getRoi() != null) {
                    IJ.wait(50);
                }
                if (this.srcImp != null) {
                    if (this.srcImp.getBitDepth() == 16 && ImagePlus.getDefault16bitRange() != 0) {
                        this.showHistogram(this.srcImp, 256, 0.0, Math.pow(2.0, ImagePlus.getDefault16bitRange()) - 1.0);
                    } else {
                        this.showHistogram(this.srcImp, 256);
                    }
                }
            }
            HistogramWindow histogramWindow = this;
            synchronized (histogramWindow) {
                if (this.doUpdate) {
                    this.doUpdate = false;
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }

    private void createListeners() {
        if (this.srcImp == null) {
            return;
        }
        ImagePlus.addImageListener(this);
        Roi.addRoiListener(this);
        if (this.live != null) {
            Font font = this.live.getFont();
            this.live.setFont(new Font(font.getName(), 1, font.getSize()));
            this.live.setForeground(Color.red);
        }
    }

    private void removeListeners() {
        if (this.srcImp == null) {
            return;
        }
        ImagePlus.removeImageListener(this);
        Roi.removeRoiListener(this);
        if (this.live != null) {
            Font font = this.live.getFont();
            this.live.setFont(new Font(font.getName(), 0, font.getSize()));
            this.live.setForeground(Color.black);
        }
    }
}

