/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GUI;
import ij.gui.HTMLDialog;
import ij.gui.ImagePanel;
import ij.gui.MultiLineLabel;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.TrimmedButton;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.measure.ResultsTable;
import ij.plugin.ScreenGrabber;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Recorder;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class GenericDialog
extends Dialog
implements ActionListener,
TextListener,
FocusListener,
ItemListener,
KeyListener,
AdjustmentListener,
WindowListener {
    protected Vector numberField;
    protected Vector stringField;
    protected Vector checkbox;
    protected Vector choice;
    protected Vector slider;
    protected Vector radioButtonGroups;
    protected TextArea textArea1;
    protected TextArea textArea2;
    protected Vector defaultValues;
    protected Vector defaultText;
    protected Vector defaultStrings;
    protected Vector defaultChoiceIndexes;
    protected Component theLabel;
    private Button okay;
    private Button cancel;
    private Button no;
    private Button help;
    private String helpLabel = "Help";
    private boolean wasCanceled;
    private boolean wasOKed;
    private int nfIndex;
    private int sfIndex;
    private int cbIndex;
    private int choiceIndex;
    private int textAreaIndex;
    private int radioButtonIndex;
    private GridBagConstraints c;
    private boolean firstNumericField = true;
    private boolean firstSlider = true;
    private boolean invalidNumber;
    private String errorMessage;
    private Hashtable labels;
    private boolean macro;
    private String macroOptions;
    private boolean addToSameRow;
    private boolean addToSameRowCalled;
    private int topInset;
    private int leftInset;
    private int bottomInset;
    private boolean customInsets;
    private Vector sliderIndexes;
    private Vector sliderScales;
    private Vector sliderDigits;
    private Checkbox previewCheckbox;
    private Vector dialogListeners;
    private PlugInFilterRunner pfr;
    private String previewLabel = " Preview";
    private static final String previewRunning = "wait...";
    private boolean recorderOn;
    private char echoChar;
    private boolean hideCancelButton;
    private boolean centerDialog = true;
    private String helpURL;
    private boolean smartRecording;
    private Vector imagePanels;
    protected static GenericDialog instance;
    private boolean firstPaint = true;
    private boolean fontSizeSet;
    private boolean showDialogCalled;
    private boolean optionsRecorded;
    private Label lastLabelAdded;
    private int[] windowIDs;
    private String[] windowTitles;

    public GenericDialog(String title) {
        this(title, null);
    }

    private static Frame getParentFrame() {
        return null;
    }

    public GenericDialog(String title, Frame parent) {
        super(parent, title, true);
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            this.setFont(ij.getFont());
        }
        this.okay = new Button("  OK  ");
        this.cancel = new Button("Cancel");
        if (Prefs.blackCanvas) {
            this.setForeground(SystemColor.controlText);
            this.setBackground(SystemColor.control);
        }
        GridBagLayout grid = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(grid);
        this.macroOptions = Macro.getOptions();
        this.macro = this.macroOptions != null;
        this.addKeyListener(this);
        this.addWindowListener(this);
    }

    public void addNumericField(String label, double defaultValue) {
        int decimalPlaces = (double)((int)defaultValue) == defaultValue ? 0 : 3;
        int columnWidth = decimalPlaces == 3 ? 8 : 6;
        this.addNumericField(label, defaultValue, decimalPlaces, columnWidth, null);
    }

    public void addNumericField(String label, double defaultValue, int digits) {
        this.addNumericField(label, defaultValue, digits, 6, null);
    }

    public void addNumericField(String label, double defaultValue, int digits, int columns, String units) {
        Label fieldLabel;
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        this.lastLabelAdded = fieldLabel = this.makeLabel(label2);
        if (this.addToSameRow) {
            this.c.gridx = -1;
            this.c.insets.left = 10;
        } else {
            this.c.gridx = 0;
            ++this.c.gridy;
            this.c.insets = this.firstNumericField ? this.getInsets(5, 0, 3, 0) : this.getInsets(0, 0, 3, 0);
        }
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.add((Component)fieldLabel, this.c);
        if (this.addToSameRow) {
            this.c.insets.left = 0;
            this.addToSameRow = false;
        }
        if (this.numberField == null) {
            this.numberField = new Vector(5);
            this.defaultValues = new Vector(5);
            this.defaultText = new Vector(5);
        }
        if (IJ.isWindows()) {
            columns -= 2;
        }
        if (columns < 1) {
            columns = 1;
        }
        boolean scientificNotationAsNeeded = false;
        if (digits < 0) {
            digits = -digits;
            scientificNotationAsNeeded = true;
        }
        String defaultString = IJ.d2s(defaultValue, digits);
        if (scientificNotationAsNeeded) {
            defaultString = ResultsTable.d2s(defaultValue, digits);
        }
        if (Double.isNaN(defaultValue)) {
            defaultString = "";
        }
        TextField tf = this.newTextField(defaultString, columns);
        if (IJ.isLinux()) {
            tf.setBackground(Color.white);
        }
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.numberField.addElement(tf);
        this.defaultValues.addElement(defaultValue);
        this.defaultText.addElement(tf.getText());
        this.c.gridx = -1;
        this.c.anchor = 17;
        tf.setEditable(true);
        this.firstNumericField = false;
        if (units == null || units.equals("")) {
            this.add((Component)tf, this.c);
        } else {
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0, 0, 0));
            panel.add(tf);
            panel.add(new Label(" " + units));
            this.add((Component)panel, this.c);
        }
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
    }

    private Label makeLabel(String label) {
        if (IJ.isMacintosh()) {
            label = label + " ";
        }
        return new Label(label);
    }

    private void saveLabel(Object component, String label) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        if (label.length() > 0) {
            label = Macro.trimKey(label.trim());
        }
        if (label.length() > 0 && this.hasLabel(label)) {
            label = label + "_0";
            int n = 1;
            while (this.hasLabel(label)) {
                label = label.substring(0, label.lastIndexOf(95));
                label = label + "_" + n;
                ++n;
            }
        }
        this.labels.put(component, label);
    }

    private boolean hasLabel(String label) {
        for (Object o : this.labels.keySet()) {
            if (!this.labels.get(o).equals(label)) continue;
            return true;
        }
        return false;
    }

    public void addStringField(String label, String defaultText) {
        this.addStringField(label, defaultText, 8);
    }

    public void addStringField(String label, String defaultText, int columns) {
        Label fieldLabel;
        String label2;
        if (this.addToSameRow && label.equals("_")) {
            label = "";
        }
        if ((label2 = label).indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        this.lastLabelAdded = fieldLabel = this.makeLabel(label2);
        boolean custom = this.customInsets;
        if (this.addToSameRow) {
            this.c.gridx = -1;
            this.addToSameRow = false;
        } else {
            this.c.gridx = 0;
            ++this.c.gridy;
            this.c.insets = this.stringField == null ? this.getInsets(5, 0, 5, 0) : this.getInsets(0, 0, 5, 0);
        }
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.add((Component)fieldLabel, this.c);
        if (this.stringField == null) {
            this.stringField = new Vector(4);
            this.defaultStrings = new Vector(4);
        }
        TextField tf = this.newTextField(defaultText, columns);
        if (IJ.isLinux()) {
            tf.setBackground(Color.white);
        }
        tf.setEchoChar(this.echoChar);
        this.echoChar = '\u0000';
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.c.gridx = -1;
        this.c.anchor = 17;
        this.c.gridwidth = columns <= 8 ? 1 : 0;
        this.c.insets.left = 0;
        tf.setEditable(true);
        this.add((Component)tf, this.c);
        this.stringField.addElement(tf);
        this.defaultStrings.addElement(defaultText);
        tf.setDropTarget(null);
        new DropTarget(tf, new TextDropTarget(tf));
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
    }

    public void setEchoChar(char echoChar) {
        this.echoChar = echoChar;
    }

    public void addDirectoryField(String label, String defaultPath) {
        int columns;
        int n = columns = defaultPath != null ? Math.max(defaultPath.length(), 25) : 25;
        if (columns > 60) {
            columns = 60;
        }
        this.addDirectoryField(label, defaultPath, columns);
    }

    public void addDirectoryField(String label, String defaultPath, int columns) {
        defaultPath = IJ.addSeparator(defaultPath);
        this.addStringField(label, defaultPath, columns);
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        TextField text = (TextField)this.stringField.lastElement();
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints constraints = layout.getConstraints(text);
        TrimmedButton button = new TrimmedButton("Browse", IJ.isMacOSX() ? 10 : 0);
        BrowseButtonListener listener = new BrowseButtonListener(label, text, "dir");
        button.addActionListener(listener);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(text);
        panel.add(button);
        layout.setConstraints(panel, constraints);
        this.add(panel);
        if (Recorder.record || this.macro) {
            this.saveLabel(panel, label);
        }
    }

    public void addFileField(String label, String defaultPath) {
        int columns;
        int n = columns = defaultPath != null ? Math.max(defaultPath.length(), 25) : 25;
        if (columns > 60) {
            columns = 60;
        }
        this.addFileField(label, defaultPath, columns);
    }

    public void addFileField(String label, String defaultPath, int columns) {
        this.addStringField(label, defaultPath, columns);
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        TextField text = (TextField)this.stringField.lastElement();
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints constraints = layout.getConstraints(text);
        TrimmedButton button = new TrimmedButton("Browse", IJ.isMacOSX() ? 10 : 0);
        BrowseButtonListener listener = new BrowseButtonListener(label, text, "file");
        button.addActionListener(listener);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(text);
        panel.add(button);
        layout.setConstraints(panel, constraints);
        this.add(panel);
        if (Recorder.record || this.macro) {
            this.saveLabel(panel, label);
        }
    }

    public void addButton(String label, ActionListener listener) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Button button = new Button(label);
        button.addActionListener(listener);
        button.addKeyListener(this);
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        Panel panel = new Panel();
        this.addPanel(panel);
        GridBagConstraints constraints = layout.getConstraints(panel);
        this.remove(panel);
        layout.setConstraints(button, constraints);
        this.add(button);
    }

    public void addImageChoice(String label, String defaultImage) {
        if (this.windowTitles == null) {
            this.windowIDs = WindowManager.getIDList();
            if (this.windowIDs == null) {
                this.windowIDs = new int[0];
            }
            this.windowTitles = new String[this.windowIDs.length];
            for (int i = 0; i < this.windowIDs.length; ++i) {
                ImagePlus image = WindowManager.getImage(this.windowIDs[i]);
                this.windowTitles[i] = image == null ? "" : image.getTitle();
            }
        }
        this.addChoice(label, this.windowTitles, defaultImage);
    }

    public ImagePlus getNextImage() {
        int index = this.getNextChoiceIndex();
        return index < 0 ? null : WindowManager.getImage(this.windowIDs[index]);
    }

    public <E extends Enum<E>> void addEnumChoice(String label, E defaultItem) {
        Class<E> enumClass = defaultItem.getDeclaringClass();
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        String[] items = new String[enums.length];
        for (int i = 0; i < enums.length; ++i) {
            items[i] = enums[i].name();
        }
        this.addChoice(label, items, defaultItem.name());
    }

    public <E extends Enum<E>> void addEnumChoice(String label, E[] enumArray, E defaultItem) {
        String[] items = new String[enumArray.length];
        boolean contained = false;
        for (int i = 0; i < enumArray.length; ++i) {
            if (enumArray[i] == defaultItem) {
                contained = true;
            }
            items[i] = ((Enum)enumArray[i]).name();
        }
        if (!contained) {
            defaultItem = enumArray[0];
        }
        this.addChoice(label, items, defaultItem.name());
    }

    public <E extends Enum<E>> E getNextEnumChoice(Class<E> enumClass) {
        String choiceString = this.getNextChoice();
        return Enum.valueOf(enumClass, choiceString);
    }

    public void addCheckbox(String label, boolean defaultValue) {
        this.addCheckbox(label, defaultValue, false);
    }

    private void addCheckbox(String label, boolean defaultValue, boolean isPreview) {
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        if (this.addToSameRow) {
            this.c.gridx = -1;
            this.c.insets.left = 10;
            this.addToSameRow = false;
        } else {
            this.c.gridx = 0;
            ++this.c.gridy;
            this.c.insets = this.checkbox == null ? this.getInsets(15, 20, 0, 0) : this.getInsets(0, 20, 0, 0);
        }
        this.c.anchor = 17;
        this.c.gridwidth = 2;
        if (this.checkbox == null) {
            this.checkbox = new Vector(4);
        }
        Checkbox cb = new Checkbox(label2);
        cb.setState(defaultValue);
        cb.addItemListener(this);
        cb.addKeyListener(this);
        this.add((Component)cb, this.c);
        this.c.insets.left = 0;
        this.checkbox.addElement(cb);
        if (!isPreview && (Recorder.record || this.macro)) {
            this.saveLabel(cb, label);
        }
        if (isPreview) {
            this.previewCheckbox = cb;
        }
    }

    public void addPreviewCheckbox(PlugInFilterRunner pfr) {
        if (this.previewCheckbox != null) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && imp.isComposite() && ((CompositeImage)imp).getMode() == 1) {
            return;
        }
        this.pfr = pfr;
        this.addCheckbox(this.previewLabel, false, true);
    }

    public void addPreviewCheckbox(PlugInFilterRunner pfr, String label) {
        if (this.previewCheckbox != null) {
            return;
        }
        this.previewLabel = label;
        this.pfr = pfr;
        this.addCheckbox(this.previewLabel, false, true);
    }

    public void addCheckboxGroup(int rows, int columns, String[] labels, boolean[] defaultValues) {
        this.addCheckboxGroup(rows, columns, labels, defaultValues, null);
    }

    public void addCheckboxGroup(int rows, int columns, String[] labels, boolean[] defaultValues, String[] headings) {
        Panel panel = new Panel();
        int nRows = headings != null ? rows + 1 : rows;
        panel.setLayout(new GridLayout(nRows, columns, 6, 0));
        int startCBIndex = this.cbIndex;
        if (this.checkbox == null) {
            this.checkbox = new Vector(12);
        }
        if (headings != null) {
            Font font = new Font("SansSerif", 1, 12);
            for (int i = 0; i < columns; ++i) {
                if (i > headings.length - 1 || headings[i] == null) {
                    panel.add(new Label(""));
                    continue;
                }
                Label label = new Label(headings[i]);
                label.setFont(font);
                panel.add(label);
            }
        }
        int i1 = 0;
        int[] index = new int[labels.length];
        for (int row = 0; row < rows; ++row) {
            int i2;
            for (int col = 0; col < columns && (i2 = col * rows + row) < labels.length; ++col) {
                index[i1] = i2;
                String label = labels[i1];
                if (label == null || label.length() == 0) {
                    Label lbl = new Label("");
                    panel.add(lbl);
                    ++i1;
                    continue;
                }
                if (label.indexOf(95) != -1) {
                    label = label.replace('_', ' ');
                }
                Checkbox cb = new Checkbox(label);
                this.checkbox.addElement(cb);
                cb.setState(defaultValues[i1]);
                cb.addItemListener(this);
                if (Recorder.record || this.macro) {
                    this.saveLabel(cb, labels[i1]);
                }
                if (IJ.isLinux()) {
                    Panel panel2 = new Panel();
                    panel2.setLayout(new BorderLayout());
                    panel2.add("West", cb);
                    panel.add(panel2);
                } else {
                    panel.add(cb);
                }
                ++i1;
            }
        }
        this.c.gridx = 0;
        ++this.c.gridy;
        this.c.gridwidth = 0;
        this.c.anchor = 17;
        this.c.insets = this.getInsets(10, 0, 0, 0);
        this.addToSameRow = false;
        this.add((Component)panel, this.c);
    }

    public void addRadioButtonGroup(String label, String[] items, int rows, int columns, String defaultItem) {
        this.addToSameRow = false;
        Panel panel = new Panel();
        int n = items.length;
        panel.setLayout(new GridLayout(rows, columns, 0, 0));
        CheckboxGroup cg = new CheckboxGroup();
        for (int i = 0; i < n; ++i) {
            Checkbox cb = new Checkbox(items[i], cg, items[i].equals(defaultItem));
            cb.addItemListener(this);
            panel.add(cb);
        }
        if (this.radioButtonGroups == null) {
            this.radioButtonGroups = new Vector();
        }
        this.radioButtonGroups.addElement(cg);
        Insets insets = this.getInsets(5, 10, 0, 0);
        if (label == null || label.equals("")) {
            label = "rbg" + this.radioButtonGroups.size();
            insets.top += 5;
        } else {
            this.setInsets(10, insets.left, 0);
            this.addMessage(label);
            insets.top = 2;
            insets.left += 10;
        }
        this.c.gridx = 0;
        ++this.c.gridy;
        this.c.gridwidth = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(insets.top, insets.left, 0, 0);
        this.add((Component)panel, this.c);
        if (Recorder.record || this.macro) {
            this.saveLabel(cg, label);
        }
    }

    public void addChoice(String label, String[] items, String defaultItem) {
        Label fieldLabel;
        String label2 = label;
        if (label2.indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        this.lastLabelAdded = fieldLabel = this.makeLabel(label2);
        if (this.addToSameRow) {
            this.c.gridx = -1;
            this.addToSameRow = false;
        } else {
            this.c.gridx = 0;
            ++this.c.gridy;
            this.c.insets = this.choice == null ? this.getInsets(5, 0, 5, 0) : this.getInsets(0, 0, 5, 0);
        }
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        if (this.choice == null) {
            this.choice = new Vector(4);
            this.defaultChoiceIndexes = new Vector(4);
        }
        this.add((Component)fieldLabel, this.c);
        Choice thisChoice = new Choice();
        thisChoice.addKeyListener(this);
        thisChoice.addItemListener(this);
        for (int i = 0; i < items.length; ++i) {
            thisChoice.addItem(items[i]);
        }
        if (defaultItem != null) {
            thisChoice.select(defaultItem);
        } else {
            thisChoice.select(0);
        }
        this.c.gridx = -1;
        this.c.anchor = 17;
        this.add((Component)thisChoice, this.c);
        this.choice.addElement(thisChoice);
        int index = thisChoice.getSelectedIndex();
        this.defaultChoiceIndexes.addElement(index);
        if (Recorder.record || this.macro) {
            this.saveLabel(thisChoice, label);
        }
    }

    public void addMessage(String text) {
        this.addMessage(text, null, null);
    }

    public void addMessage(String text, Font font) {
        this.addMessage(text, font, null);
    }

    public void addMessage(String text, Font font, Color color) {
        this.theLabel = null;
        this.theLabel = text.indexOf(10) >= 0 ? new MultiLineLabel(text) : new Label(text);
        if (this.addToSameRow) {
            this.c.gridx = -1;
            this.addToSameRow = false;
        } else {
            this.c.gridx = 0;
            ++this.c.gridy;
            this.c.insets = this.getInsets("".equals(text) ? 0 : 10, 20, 0, 0);
        }
        this.c.gridwidth = 0;
        this.c.anchor = 17;
        this.c.fill = 2;
        if (font != null) {
            if (Prefs.getGuiScale() > 1.0) {
                font = font.deriveFont((float)((double)font.getSize() * Prefs.getGuiScale()));
            }
            this.theLabel.setFont(font);
        }
        if (color != null) {
            this.theLabel.setForeground(color);
        }
        this.add(this.theLabel, this.c);
        this.c.fill = 0;
    }

    public void addTextAreas(String text1, String text2, int rows, int columns) {
        if (this.textArea1 != null) {
            return;
        }
        Panel panel = new Panel();
        int scrollbars = 3;
        if (text1 != null && text1.endsWith("SCROLLBARS_BOTH")) {
            scrollbars = 0;
            text1 = text1.substring(0, text1.length() - 15);
        }
        if (text1 != null && text1.endsWith("SCROLLBARS_VERTICAL_ONLY")) {
            scrollbars = 1;
            text1 = text1.substring(0, text1.length() - 24);
        }
        Font font = new Font("SansSerif", 0, (int)(14.0 * Prefs.getGuiScale()));
        this.textArea1 = new TextArea(text1, rows, columns, scrollbars);
        if (IJ.isLinux()) {
            this.textArea1.setBackground(Color.white);
        }
        this.textArea1.setFont(font);
        this.textArea1.addTextListener(this);
        panel.add(this.textArea1);
        if (text2 != null) {
            this.textArea2 = new TextArea(text2, rows, columns, scrollbars);
            if (IJ.isLinux()) {
                this.textArea2.setBackground(Color.white);
            }
            this.textArea2.setFont(font);
            panel.add(this.textArea2);
        }
        this.c.gridx = 0;
        ++this.c.gridy;
        this.c.gridwidth = 0;
        this.c.anchor = 17;
        this.c.insets = this.getInsets(15, 20, 0, 0);
        this.addToSameRow = false;
        this.add((Component)panel, this.c);
    }

    public void addSlider(String label, double minValue, double maxValue, double defaultValue) {
        if (defaultValue < minValue) {
            defaultValue = minValue;
        }
        if (defaultValue > maxValue) {
            defaultValue = maxValue;
        }
        int digits = 0;
        double scale = 1.0;
        if (maxValue - minValue <= 5.0 && (minValue != (double)((int)minValue) || maxValue != (double)((int)maxValue) || defaultValue != (double)((int)defaultValue))) {
            scale = 50.0;
            minValue *= scale;
            maxValue *= scale;
            defaultValue *= scale;
            digits = 2;
        }
        this.addSlider(label, minValue, maxValue, defaultValue, scale, digits);
    }

    public void addSlider(String label, double minValue, double maxValue, double defaultValue, double stepSize) {
        double scale;
        int digits;
        if (stepSize <= 0.0) {
            stepSize = 1.0;
        }
        if ((digits = GenericDialog.digits(stepSize)) == 1 && "Angle:".equals(label)) {
            digits = 2;
        }
        if ((scale = 1.0 / Math.abs(stepSize)) <= 0.0) {
            scale = 1.0;
        }
        if (defaultValue < minValue) {
            defaultValue = minValue;
        }
        if (defaultValue > maxValue) {
            defaultValue = maxValue;
        }
        this.addSlider(label, minValue *= scale, maxValue *= scale, defaultValue *= scale, scale, digits);
    }

    private static int digits(double d) {
        if (d == (double)((int)d)) {
            return 0;
        }
        String s = Double.toString(d);
        int ePos = s.indexOf("E");
        if (ePos == -1) {
            ePos = s.indexOf("e");
        }
        int dotPos = s.indexOf(".");
        int digits = 0;
        if (ePos == -1) {
            digits = s.substring(dotPos + 1).length();
        } else {
            String number = s.substring(dotPos + 1, ePos);
            if (!number.equals("0")) {
                digits += number.length();
            }
            digits -= Integer.valueOf(s.substring(ePos + 1)).intValue();
        }
        return digits;
    }

    private void addSlider(String label, double minValue, double maxValue, double defaultValue, double scale, int digits) {
        Label fieldLabel;
        String label2;
        String mv;
        int columns = 4 + digits - 2;
        if (columns < 4) {
            columns = 4;
        }
        if (minValue < 0.0) {
            ++columns;
        }
        if ((mv = IJ.d2s(maxValue, 0)).length() > 4 && digits == 0) {
            columns += mv.length() - 4;
        }
        if ((label2 = label).indexOf(95) != -1) {
            label2 = label2.replace('_', ' ');
        }
        this.lastLabelAdded = fieldLabel = this.makeLabel(label2);
        if (this.addToSameRow) {
            this.c.gridx = -1;
            this.c.insets.bottom += 3;
            this.addToSameRow = false;
        } else {
            this.c.gridx = 0;
            ++this.c.gridy;
            this.c.insets = this.getInsets(0, 0, 3, 0);
        }
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.add((Component)fieldLabel, this.c);
        if (this.slider == null) {
            this.slider = new Vector(5);
            this.sliderIndexes = new Vector(5);
            this.sliderScales = new Vector(5);
            this.sliderDigits = new Vector(5);
        }
        Scrollbar s = new Scrollbar(0, (int)defaultValue, 1, (int)minValue, (int)maxValue + 1);
        GUI.fixScrollbar(s);
        this.slider.addElement(s);
        s.addAdjustmentListener(this);
        s.setUnitIncrement(1);
        if (IJ.isMacOSX()) {
            s.addKeyListener(this);
        }
        s.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Scrollbar sb = (Scrollbar)e.getSource();
                int value = sb.getValue() + e.getWheelRotation();
                sb.setValue(value);
                for (int i = 0; i < GenericDialog.this.slider.size(); ++i) {
                    if (sb != GenericDialog.this.slider.elementAt(i)) continue;
                    int index = (Integer)GenericDialog.this.sliderIndexes.get(i);
                    TextField tf = (TextField)GenericDialog.this.numberField.elementAt(index);
                    double scale = (Double)GenericDialog.this.sliderScales.get(i);
                    int digits = (Integer)GenericDialog.this.sliderDigits.get(i);
                    tf.setText("" + IJ.d2s((double)sb.getValue() / scale, digits));
                }
            }
        });
        if (this.numberField == null) {
            this.numberField = new Vector(5);
            this.defaultValues = new Vector(5);
            this.defaultText = new Vector(5);
        }
        if (IJ.isWindows()) {
            columns -= 2;
        }
        if (columns < 1) {
            columns = 1;
        }
        TextField tf = this.newTextField(IJ.d2s(defaultValue / scale, digits), columns);
        tf.addActionListener(this);
        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(this);
        this.numberField.addElement(tf);
        this.sliderIndexes.add(this.numberField.size() - 1);
        this.sliderScales.add(scale);
        this.sliderDigits.add(digits);
        this.defaultValues.addElement(defaultValue / scale);
        this.defaultText.addElement(tf.getText());
        tf.setEditable(true);
        this.firstSlider = false;
        Panel panel = new Panel();
        GridBagLayout pgrid = new GridBagLayout();
        GridBagConstraints pc = new GridBagConstraints();
        panel.setLayout(pgrid);
        pc.gridx = 0;
        pc.gridy = 0;
        pc.gridwidth = 1;
        pc.ipadx = 85;
        pc.anchor = 17;
        panel.add((Component)s, pc);
        pc.ipadx = 0;
        pc.gridx = 1;
        pc.insets = new Insets(5, 5, 0, 0);
        pc.anchor = 13;
        panel.add((Component)tf, pc);
        this.c.gridx = -1;
        this.c.gridwidth = 1;
        this.c.anchor = 17;
        this.c.insets.left = 0;
        this.c.insets.bottom -= 3;
        this.add((Component)panel, this.c);
        if (Recorder.record || this.macro) {
            this.saveLabel(tf, label);
        }
    }

    private TextField newTextField(String txt, int columns) {
        if (IJ.isLinux()) {
            return new TrimmedTextField(txt, columns);
        }
        return new TextField(txt, columns);
    }

    public void addPanel(Panel panel) {
        this.addPanel(panel, 17, this.addToSameRow ? this.c.insets : this.getInsets(5, 0, 0, 0));
    }

    public void addPanel(Panel panel, int constraints, Insets insets) {
        if (this.addToSameRow) {
            this.c.gridx = -1;
            this.addToSameRow = false;
        } else {
            this.c.gridx = 0;
            ++this.c.gridy;
        }
        this.c.gridwidth = 2;
        this.c.anchor = constraints;
        this.c.insets = insets;
        this.add((Component)panel, this.c);
    }

    public void addImage(ImagePlus image) {
        if (image == null) {
            return;
        }
        ImagePanel imagePanel = new ImagePanel(image);
        this.addPanel(imagePanel);
        if (this.imagePanels == null) {
            this.imagePanels = new Vector();
        }
        this.imagePanels.add(imagePanel);
    }

    public void setInsets(int top, int left, int bottom) {
        this.topInset = top;
        this.leftInset = left;
        this.bottomInset = bottom;
        this.customInsets = true;
    }

    public void addToSameRow() {
        this.addToSameRow = true;
        this.addToSameRowCalled = true;
    }

    public void setOKLabel(String label) {
        this.okay.setLabel(label);
    }

    public void setCancelLabel(String label) {
        this.cancel.setLabel(label);
    }

    public void setHelpLabel(String label) {
        this.helpLabel = label;
    }

    public void setSmartRecording(boolean smartRecording) {
        this.smartRecording = smartRecording;
    }

    public void enableYesNoCancel() {
        this.enableYesNoCancel(" Yes ", " No ");
    }

    public void enableYesNoCancel(String yesLabel, String noLabel) {
        this.okay.setLabel(yesLabel);
        if (this.no != null) {
            this.no.setLabel(noLabel);
        } else if (noLabel != null) {
            this.no = new Button(noLabel);
        }
    }

    public void hideCancelButton() {
        this.hideCancelButton = true;
    }

    Insets getInsets(int top, int left, int bottom, int right) {
        if (this.customInsets) {
            this.customInsets = false;
            return new Insets(this.topInset, this.leftInset, this.bottomInset, 0);
        }
        return new Insets(top, left, bottom, right);
    }

    public void addDialogListener(DialogListener dl) {
        if (this.dialogListeners == null) {
            this.dialogListeners = new Vector();
        }
        this.dialogListeners.addElement(dl);
    }

    public boolean wasCanceled() {
        if (this.wasCanceled && !Thread.currentThread().getName().endsWith("Script_Macro$")) {
            Macro.abort();
        }
        return this.wasCanceled;
    }

    public boolean wasOKed() {
        return this.wasOKed || this.macro;
    }

    public double getNextNumber() {
        double value;
        if (this.numberField == null) {
            return -1.0;
        }
        TextField tf = (TextField)this.numberField.elementAt(this.nfIndex);
        String theText = tf.getText();
        String label = null;
        if (this.macro) {
            label = (String)this.labels.get(tf);
            theText = Macro.getValue(this.macroOptions, label, theText);
        }
        String originalText = (String)this.defaultText.elementAt(this.nfIndex);
        double defaultValue = (Double)this.defaultValues.elementAt(this.nfIndex);
        boolean skipRecording = false;
        if (theText.equals(originalText)) {
            value = defaultValue;
            if (this.smartRecording) {
                skipRecording = true;
            }
        } else if (theText.startsWith("0x")) {
            value = this.parseHex(theText.substring(2));
        } else {
            Double d = this.getValue(theText);
            if (d != null) {
                value = d;
            } else {
                Interpreter interp;
                if (theText.startsWith("&")) {
                    theText = theText.substring(1);
                }
                double d2 = value = (interp = Interpreter.getInstance()) != null ? interp.getVariable2(theText) : Double.NaN;
                if (Double.isNaN(value)) {
                    this.invalidNumber = true;
                    this.errorMessage = "\"" + theText + "\" is an invalid number";
                    value = Double.NaN;
                    if (this.macro) {
                        IJ.error("Macro Error", "Numeric value expected in run() function\n \n\t Dialog box title: \"" + this.getTitle() + "\"\n\t Key: \"" + label.toLowerCase(Locale.US) + "\"\n\t Value or variable name: \"" + theText + "\"");
                    }
                }
            }
        }
        if (this.recorderOn && !skipRecording) {
            this.recordOption(tf, this.trim(theText));
        }
        ++this.nfIndex;
        return value;
    }

    int parseHex(String hexString) {
        int n = 0;
        try {
            n = Integer.parseInt(hexString, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private String trim(String value) {
        if (value.endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        if (value.endsWith(".00")) {
            value = value.substring(0, value.length() - 3);
        }
        return value;
    }

    private void recordOption(Object component, String value) {
        if (this.labels == null) {
            return;
        }
        String label = (String)this.labels.get(component);
        if (value.equals("")) {
            value = "[]";
        }
        Recorder.recordOption(label, value);
    }

    private void recordCheckboxOption(Checkbox cb) {
        String label = (String)this.labels.get(cb);
        if (label != null) {
            if (cb.getState()) {
                Recorder.recordOption(label);
            } else if (Recorder.getCommandOptions() == null) {
                Recorder.recordOption(" ");
            }
        }
    }

    protected Double getValue(String text) {
        Double d;
        try {
            d = Double.valueOf(text);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        return d;
    }

    public double parseDouble(String s) {
        if (s == null) {
            return Double.NaN;
        }
        double value = Tools.parseDouble(s);
        if (Double.isNaN(value)) {
            Interpreter interp;
            if (s.startsWith("&")) {
                s = s.substring(1);
            }
            value = (interp = Interpreter.getInstance()) != null ? interp.getVariable2(s) : Double.NaN;
        }
        return value;
    }

    public boolean invalidNumber() {
        boolean wasInvalid = this.invalidNumber;
        this.invalidNumber = false;
        return wasInvalid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getNextString() {
        boolean numberExpected;
        if (this.stringField == null) {
            return "";
        }
        TextField tf = (TextField)this.stringField.elementAt(this.sfIndex);
        String theText = tf.getText();
        String label = this.labels != null ? (String)this.labels.get(tf) : "";
        boolean bl = numberExpected = theText != null && theText.length() > 0 && (Character.isDigit(theText.charAt(0)) || theText.startsWith("-"));
        if (this.macro && (theText = Macro.getValue(this.macroOptions, label, theText)) != null && (theText.startsWith("&") || numberExpected || label.toLowerCase(Locale.US).startsWith(theText))) {
            Interpreter interp;
            String s;
            if (theText.startsWith("&")) {
                theText = theText.substring(1);
            }
            String string = s = (interp = Interpreter.getInstance()) != null ? interp.getVariableAsString(theText) : null;
            if (s != null) {
                theText = s;
            }
        }
        if (this.recorderOn && !label.equals("")) {
            String s = theText;
            if (s != null && s.length() >= 3 && Character.isLetter(s.charAt(0)) && s.charAt(1) == ':' && s.charAt(2) == '\\') {
                s = s.replaceAll("\\\\", "/");
            }
            s = Recorder.fixString(s);
            if (!this.smartRecording || !s.equals((String)this.defaultStrings.elementAt(this.sfIndex))) {
                this.recordOption(tf, s);
            } else if (Recorder.getCommandOptions() == null) {
                Recorder.recordOption(" ");
            }
        }
        ++this.sfIndex;
        return theText;
    }

    public boolean getNextBoolean() {
        if (this.checkbox == null) {
            return false;
        }
        Checkbox cb = (Checkbox)this.checkbox.elementAt(this.cbIndex);
        if (this.recorderOn) {
            this.recordCheckboxOption(cb);
        }
        boolean state = cb.getState();
        if (this.macro) {
            String label = (String)this.labels.get(cb);
            String key = Macro.trimKey(label);
            state = this.isMatch(this.macroOptions, key + " ");
        }
        ++this.cbIndex;
        return state;
    }

    boolean isMatch(String s1, String s2) {
        if (s1.startsWith(s2)) {
            return true;
        }
        s2 = " " + s2;
        int len1 = s1.length();
        int len2 = s2.length();
        boolean inLiteral = false;
        for (int i = 0; i < len1 - len2 + 1; ++i) {
            char c = s1.charAt(i);
            if (inLiteral && c == ']') {
                inLiteral = false;
            } else if (c == '[') {
                inLiteral = true;
            }
            if (c != s2.charAt(0) || inLiteral || i > 1 && s1.charAt(i - 1) == '=') continue;
            boolean match = true;
            for (int j = 0; j < len2; ++j) {
                if (s2.charAt(j) == s1.charAt(i + j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public String getNextChoice() {
        String label;
        if (this.choice == null) {
            return "";
        }
        Choice thisChoice = (Choice)this.choice.elementAt(this.choiceIndex);
        String item = thisChoice.getSelectedItem();
        if (this.macro && (item = Macro.getValue(this.macroOptions, label = (String)this.labels.get(thisChoice), item)) != null && item.startsWith("&")) {
            item = this.getChoiceVariable(item);
        }
        if (this.recorderOn) {
            this.recordOption(thisChoice, item);
        }
        ++this.choiceIndex;
        return item;
    }

    public int getNextChoiceIndex() {
        if (this.choice == null) {
            return -1;
        }
        Choice thisChoice = (Choice)this.choice.elementAt(this.choiceIndex);
        int index = thisChoice.getSelectedIndex();
        if (this.macro) {
            String label = (String)this.labels.get(thisChoice);
            String oldItem = thisChoice.getSelectedItem();
            int oldIndex = thisChoice.getSelectedIndex();
            String item = Macro.getValue(this.macroOptions, label, oldItem);
            if (item != null && item.startsWith("&")) {
                item = this.getChoiceVariable(item);
            }
            thisChoice.select(item);
            index = thisChoice.getSelectedIndex();
            if (index == oldIndex && !item.equals(oldItem)) {
                String s;
                Interpreter interp = Interpreter.getInstance();
                String string = s = interp != null ? interp.getStringVariable(item) : null;
                if (s == null) {
                    IJ.error(this.getTitle(), "\"" + item + "\" is not a valid choice for \"" + label + "\"");
                } else {
                    item = s;
                }
            }
        }
        if (this.recorderOn) {
            String item;
            int defaultIndex = (Integer)this.defaultChoiceIndexes.elementAt(this.choiceIndex);
            if (!(this.smartRecording && index == defaultIndex || (item = thisChoice.getSelectedItem()).equals("*None*") && this.getTitle().equals("Merge Channels"))) {
                this.recordOption(thisChoice, thisChoice.getSelectedItem());
            }
        }
        ++this.choiceIndex;
        return index;
    }

    public String getNextRadioButton() {
        if (this.radioButtonGroups == null) {
            return null;
        }
        CheckboxGroup cg = (CheckboxGroup)this.radioButtonGroups.elementAt(this.radioButtonIndex);
        ++this.radioButtonIndex;
        Checkbox checkbox = cg.getSelectedCheckbox();
        String item = "null";
        if (checkbox != null) {
            item = checkbox.getLabel();
        }
        if (this.macro) {
            String label = (String)this.labels.get(cg);
            item = Macro.getValue(this.macroOptions, label, item);
        }
        if (this.recorderOn) {
            this.recordOption(cg, item);
        }
        return item;
    }

    private String getChoiceVariable(String item) {
        String s;
        item = item.substring(1);
        Interpreter interp = Interpreter.getInstance();
        String string = s = interp != null ? interp.getStringVariable(item) : null;
        if (s == null) {
            double value;
            double d = value = interp != null ? interp.getVariable2(item) : Double.NaN;
            if (!Double.isNaN(value)) {
                s = (double)((int)value) == value ? "" + (int)value : "" + value;
            }
        }
        if (s != null) {
            item = s;
        }
        return item;
    }

    public String getNextText() {
        String text = null;
        String key = "text1";
        if (this.textAreaIndex == 0 && this.textArea1 != null) {
            text = this.textArea1.getText();
            if (this.macro) {
                text = Macro.getValue(this.macroOptions, "text1", text);
            }
        } else if (this.textAreaIndex == 1 && this.textArea2 != null) {
            text = this.textArea2.getText();
            if (this.macro) {
                text = Macro.getValue(this.macroOptions, "text2", text);
            }
            key = "text2";
        }
        ++this.textAreaIndex;
        if (this.recorderOn && text != null) {
            String text2 = text;
            String cmd = Recorder.getCommand();
            if (cmd != null && cmd.equals("Calibrate...")) {
                text2 = text2.replace('\n', ' ');
            }
            if (cmd != null && cmd.equals("Convolve...") && !text2.endsWith("\n")) {
                text2 = text2 + "\n";
            }
            text2 = Recorder.fixString(text2);
            Recorder.recordOption(key, text2);
        }
        return text;
    }

    public void showDialog() {
        this.showDialogCalled = true;
        this.addToSameRow = false;
        if (this.macro) {
            this.dispose();
            this.recorderOn = Recorder.record && Recorder.recordInMacros;
        } else {
            boolean addHelp;
            if (this.pfr != null) {
                this.pfr.setDialog(this);
            }
            Panel buttons = new Panel();
            buttons.setLayout(new FlowLayout(1, 5, 0));
            this.okay.addActionListener(this);
            this.okay.addKeyListener(this);
            if (!this.hideCancelButton) {
                this.cancel.addActionListener(this);
                this.cancel.addKeyListener(this);
            }
            if (this.no != null) {
                this.no.addActionListener(this);
                this.no.addKeyListener(this);
            }
            boolean bl = addHelp = this.helpURL != null;
            if (addHelp) {
                this.help.setLabel(this.helpLabel);
                this.help.addActionListener(this);
                this.help.addKeyListener(this);
            }
            if (IJ.isWindows() || Prefs.dialogCancelButtonOnRight) {
                buttons.add(this.okay);
                if (this.no != null) {
                    buttons.add(this.no);
                }
                if (!this.hideCancelButton) {
                    buttons.add(this.cancel);
                }
                if (addHelp) {
                    buttons.add(this.help);
                }
            } else {
                if (addHelp) {
                    buttons.add(this.help);
                }
                if (this.no != null) {
                    buttons.add(this.no);
                }
                if (!this.hideCancelButton) {
                    buttons.add(this.cancel);
                }
                buttons.add(this.okay);
            }
            if (this.addToSameRow) {
                this.c.gridx = -1;
            } else {
                this.c.gridx = 0;
                ++this.c.gridy;
            }
            this.c.anchor = 13;
            this.c.gridwidth = this.addToSameRowCalled ? 0 : 2;
            this.c.insets = new Insets(15, 0, 0, 0);
            this.add((Component)buttons, this.c);
            instance = this;
            Font font = this.getFont();
            if (!this.fontSizeSet && font != null && Prefs.getGuiScale() != 1.0) {
                this.fontSizeSet = true;
                this.setFont(font.deriveFont((float)((double)font.getSize() * Prefs.getGuiScale())));
            }
            this.pack();
            if (this.okay != null && this.numberField == null && this.stringField == null && this.checkbox == null && this.choice == null && this.slider == null && this.radioButtonGroups == null && this.textArea1 == null) {
                this.okay.requestFocusInWindow();
            }
            this.setup();
            if (this.centerDialog) {
                GUI.centerOnImageJScreen(this);
            }
            this.resetCounters();
            this.setVisible(true);
        }
    }

    void finalizeRecording() {
        if (this.optionsRecorded) {
            return;
        }
        this.optionsRecorded = true;
        if (!this.wasCanceled && this.dialogListeners != null && this.dialogListeners.size() > 0) {
            try {
                this.resetCounters();
                ((DialogListener)this.dialogListeners.elementAt(0)).dialogItemChanged(this, null);
            }
            catch (Exception err) {
                IJ.beep();
                IJ.log("ERROR: " + err + "\nin DialogListener of " + this.dialogListeners.elementAt(0) + "\nat " + err.getStackTrace()[0] + "\nfrom " + err.getStackTrace()[1]);
            }
            this.recorderOn = false;
        }
        this.resetCounters();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(!this.fontSizeSet && Prefs.getGuiScale() != 1.0 && font != null ? font.deriveFont((float)((double)font.getSize() * Prefs.getGuiScale())) : font);
        this.fontSizeSet = true;
    }

    public void resetCounters() {
        this.nfIndex = 0;
        this.sfIndex = 0;
        this.cbIndex = 0;
        this.choiceIndex = 0;
        this.textAreaIndex = 0;
        this.radioButtonIndex = 0;
        this.invalidNumber = false;
    }

    public Vector getNumericFields() {
        return this.numberField;
    }

    public Vector getStringFields() {
        return this.stringField;
    }

    public Vector getCheckboxes() {
        return this.checkbox;
    }

    public Vector getChoices() {
        return this.choice;
    }

    public Vector getSliders() {
        return this.slider;
    }

    public Vector getRadioButtonGroups() {
        return this.radioButtonGroups;
    }

    public TextArea getTextArea1() {
        return this.textArea1;
    }

    public TextArea getTextArea2() {
        return this.textArea2;
    }

    public Component getMessage() {
        return this.theLabel;
    }

    public Checkbox getPreviewCheckbox() {
        return this.previewCheckbox;
    }

    public boolean isPreviewActive() {
        return this.previewCheckbox != null && this.previewCheckbox.getState();
    }

    public Button[] getButtons() {
        return new Button[]{this.okay, this.cancel, this.no, this.help};
    }

    public void previewRunning(boolean isRunning) {
        if (this.previewCheckbox != null) {
            this.previewCheckbox.setLabel(isRunning ? previewRunning : this.previewLabel);
            if (IJ.isMacOSX()) {
                this.repaint();
            }
        }
    }

    public void centerDialog(boolean b) {
        this.centerDialog = b;
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this.centerDialog = false;
    }

    public void setDefaultString(int index, String str) {
        if (this.defaultStrings != null && index >= 0 && index < this.defaultStrings.size()) {
            this.defaultStrings.set(index, str);
        }
    }

    protected void setup() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okay || source == this.cancel | source == this.no) {
            this.wasCanceled = source == this.cancel;
            this.wasOKed = source == this.okay;
            this.dispose();
        } else if (source == this.help) {
            if (this.hideCancelButton) {
                if (this.helpURL != null && this.helpURL.equals("")) {
                    this.notifyListeners(e);
                    return;
                }
                this.wasOKed = true;
                this.dispose();
            }
            this.showHelp();
        } else {
            this.notifyListeners(e);
        }
    }

    @Override
    public void textValueChanged(TextEvent e) {
        this.notifyListeners(e);
        if (this.slider == null) {
            return;
        }
        Object source = e.getSource();
        for (int i = 0; i < this.slider.size(); ++i) {
            TextField tf;
            double value;
            int index = (Integer)this.sliderIndexes.get(i);
            if (source != this.numberField.elementAt(index) || Double.isNaN(value = Tools.parseDouble((tf = (TextField)this.numberField.elementAt(index)).getText()))) continue;
            Scrollbar sb = (Scrollbar)this.slider.elementAt(i);
            double scale = (Double)this.sliderScales.get(i);
            sb.setValue((int)(value * scale));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.notifyListeners(e);
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof TextField) {
            ((TextField)c).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof TextField) {
            ((TextField)c).select(0, 0);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Component component = e.getComponent();
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        if (component instanceof Scrollbar && (keyCode == 37 || keyCode == 39)) {
            Scrollbar sb = (Scrollbar)component;
            int value = sb.getValue();
            if (keyCode == 39) {
                sb.setValue(value + 1);
            } else {
                sb.setValue(value - 1);
            }
            for (int i = 0; i < this.slider.size(); ++i) {
                if (sb != this.slider.elementAt(i)) continue;
                int index = (Integer)this.sliderIndexes.get(i);
                TextField tf = (TextField)this.numberField.elementAt(index);
                double scale = (Double)this.sliderScales.get(i);
                int digits = (Integer)this.sliderDigits.get(i);
                tf.setText("" + IJ.d2s((double)sb.getValue() / scale, digits));
            }
            this.notifyListeners(e);
            return;
        }
        if (keyCode == 10 && this.textArea1 == null && this.okay != null && this.okay.isEnabled()) {
            this.wasOKed = true;
            if (IJ.isMacOSX()) {
                this.accessTextFields();
            }
            this.dispose();
        } else if (keyCode == 27) {
            this.wasCanceled = true;
            this.dispose();
            IJ.resetEscape();
        } else if (keyCode == 87 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            this.wasCanceled = true;
            this.dispose();
        }
    }

    void accessTextFields() {
        int i;
        if (this.stringField != null) {
            for (i = 0; i < this.stringField.size(); ++i) {
                ((TextField)this.stringField.elementAt(i)).getText();
            }
        }
        if (this.numberField != null) {
            for (i = 0; i < this.numberField.size(); ++i) {
                ((TextField)this.numberField.elementAt(i)).getText();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        boolean shift;
        int keyCode = e.getKeyCode();
        IJ.setKeyUp(keyCode);
        int flags = e.getModifiers();
        boolean control = (flags & 2) != 0;
        boolean meta = (flags & 4) != 0;
        boolean bl = shift = (flags & 1) != 0;
        if (keyCode == 71 && shift && (control || meta)) {
            new ScreenGrabber().run("");
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public Insets getInsets() {
        Insets i = super.getInsets();
        return new Insets(i.top + 10, i.left + 10, i.bottom + 10, i.right + 10);
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        for (int i = 0; i < this.slider.size(); ++i) {
            if (source != this.slider.elementAt(i)) continue;
            Scrollbar sb = (Scrollbar)source;
            int index = (Integer)this.sliderIndexes.get(i);
            TextField tf = (TextField)this.numberField.elementAt(index);
            double scale = (Double)this.sliderScales.get(i);
            int digits = (Integer)this.sliderDigits.get(i);
            tf.setText("" + IJ.d2s((double)sb.getValue() / scale, digits));
        }
    }

    private void notifyListeners(AWTEvent e) {
        boolean workaroundOSXbug;
        if (this.dialogListeners == null) {
            return;
        }
        boolean everythingOk = true;
        for (int i = 0; everythingOk && i < this.dialogListeners.size(); ++i) {
            try {
                this.resetCounters();
                if (this instanceof NonBlockingGenericDialog) {
                    Recorder.resetCommandOptions();
                }
                if (((DialogListener)this.dialogListeners.elementAt(i)).dialogItemChanged(this, e)) continue;
                everythingOk = false;
                continue;
            }
            catch (Exception err) {
                IJ.beep();
                IJ.log("ERROR: " + err + "\nin DialogListener of " + this.dialogListeners.elementAt(i) + "\nat " + err.getStackTrace()[0] + "\nfrom " + err.getStackTrace()[1]);
            }
        }
        this.resetCounters();
        boolean bl = workaroundOSXbug = IJ.isMacOSX() && this.okay != null && !this.okay.isEnabled() && everythingOk;
        if (everythingOk && this.recorderOn) {
            this.optionsRecorded = true;
        }
        if (this.previewCheckbox != null) {
            this.previewCheckbox.setEnabled(everythingOk);
        }
        if (this.okay != null) {
            this.okay.setEnabled(everythingOk);
        }
        if (workaroundOSXbug) {
            this.repaint();
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.imagePanels != null) {
            for (int i = 0; i < this.imagePanels.size(); ++i) {
                ((ImagePanel)this.imagePanels.get(i)).repaint();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstPaint && IJ.isMacOSX() && IJ.isJava18()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IJ.wait(50);
                    Dimension size = GenericDialog.this.getSize();
                    if (size != null) {
                        GenericDialog.this.setSize(size.width + 2, size.height + 2);
                    }
                    GenericDialog.this.firstPaint = false;
                }
            });
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.wasCanceled = true;
        this.dispose();
    }

    public void addHelp(String url) {
        this.help = new Button(this.helpLabel);
        this.helpURL = url;
    }

    void showHelp() {
        if (this.helpURL.startsWith("<html>")) {
            String title = this.getTitle() + " " + this.helpLabel;
            if (this instanceof NonBlockingGenericDialog) {
                new HTMLDialog(title, this.helpURL, false);
            } else {
                new HTMLDialog((Dialog)this, title, this.helpURL);
            }
        } else {
            String macro = "call('ij.plugin.BrowserLauncher.open', '" + this.helpURL + "');";
            new MacroRunner(macro);
        }
    }

    protected boolean isMacro() {
        return this.macro;
    }

    public static GenericDialog getInstance() {
        return instance;
    }

    @Override
    public void dispose() {
        super.dispose();
        instance = null;
        if (!this.macro) {
            this.recorderOn = Recorder.record;
            IJ.wait(25);
        }
        this.resetCounters();
        this.finalizeRecording();
        this.resetCounters();
    }

    public Label getLabel() {
        return this.lastLabelAdded;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    static String getString(DropTargetDropEvent event) throws IOException, UnsupportedFlavorException {
        String text = null;
        DataFlavor fileList = DataFlavor.javaFileListFlavor;
        if (event.isDataFlavorSupported(fileList)) {
            event.acceptDrop(1);
            List list = (List)event.getTransferable().getTransferData(fileList);
            text = ((File)list.get(0)).getAbsolutePath();
        } else if (event.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            event.acceptDrop(1);
            text = (String)event.getTransferable().getTransferData(DataFlavor.stringFlavor);
            if (text.startsWith("file://")) {
                text = text.substring(7);
            }
            text = GenericDialog.stripSuffix(GenericDialog.stripSuffix(text, "\n"), "\r").replaceAll("%20", " ");
        } else {
            event.rejectDrop();
            return null;
        }
        event.dropComplete(text != null);
        return text;
    }

    static String stripSuffix(String s, String suffix) {
        return !s.endsWith(suffix) ? s : s.substring(0, s.length() - suffix.length());
    }

    private class TrimmedTextField
    extends TextField {
        public TrimmedTextField(String text, int columns) {
            super(text, columns);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            if (d != null) {
                d.width = d.width;
                d.height = d.height * 3 / 4;
            }
            return d;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    private class BrowseButtonListener
    implements ActionListener {
        private String label;
        private TextField textField;
        private String mode;

        public BrowseButtonListener(String label, TextField textField, String mode) {
            this.label = label;
            this.textField = textField;
            this.mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String path = null;
            String dialogTitle = this.label;
            if (dialogTitle == null || dialogTitle.length() == 0) {
                dialogTitle = this.mode.equals("dir") ? "a Folder" : "a File";
            } else if (dialogTitle.endsWith(":")) {
                dialogTitle = dialogTitle.substring(0, dialogTitle.length() - 1);
            }
            dialogTitle = "Select " + dialogTitle;
            if (this.mode.equals("dir")) {
                boolean setDefaultDir;
                String saveDefaultDir = OpenDialog.getDefaultDirectory();
                String dir = this.textField.getText();
                boolean bl = setDefaultDir = dir != null && !dir.equals("");
                if (setDefaultDir) {
                    OpenDialog.setDefaultDirectory(dir);
                }
                path = IJ.getDir(dialogTitle);
                if (setDefaultDir) {
                    OpenDialog.setDefaultDirectory(saveDefaultDir);
                }
            } else {
                OpenDialog od = new OpenDialog(dialogTitle, null);
                String directory = od.getDirectory();
                String name = od.getFileName();
                if (name != null) {
                    path = directory + name;
                }
            }
            if (path != null) {
                this.textField.setText(path);
            }
        }
    }

    static class TextDropTarget
    extends DropTargetAdapter {
        TextField text;
        DataFlavor flavor = DataFlavor.stringFlavor;

        public TextDropTarget(TextField text) {
            this.text = text;
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                String path = GenericDialog.getString(event);
                path = Recorder.fixPath(path);
                if (!path.endsWith("/") && new File(path).isDirectory()) {
                    path = path + "/";
                }
                this.text.setText(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

