/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers.ome.zarr;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.DoubleStream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.writers.ome.zarr.OMEZarrWriter;
import qupath.lib.objects.PathObject;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.interfaces.ROI;

public class OMEZarrWriterCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(OMEZarrWriterCommand.class);
    private static final IntegerProperty scaledDownsample = PathPrefs.createPersistentPreference((String)"ome-zarr-scaled-downsample", (int)4);
    private static final IntegerProperty tileSize = PathPrefs.createPersistentPreference((String)"ome-zarr-tile-size", (int)512);
    private static final BooleanProperty allZ = PathPrefs.createPersistentPreference((String)"ome-zarr-all-z", (boolean)true);
    private static final BooleanProperty allT = PathPrefs.createPersistentPreference((String)"ome-zarr-all-t", (boolean)true);
    private static final IntegerProperty numberOfThreads = PathPrefs.createPersistentPreference((String)"ome-zarr-number-threads", (int)Runtime.getRuntime().availableProcessors());
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final QuPathGUI qupath;
    private Future<?> task;

    public OMEZarrWriterCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        ImageData imageData;
        if (this.task != null && !this.task.isDone()) {
            if (Dialogs.showConfirmDialog((String)QuPathResources.getString((String)"Action.BioFormats.omeZarrWriter"), (String)QuPathResources.getString((String)"Action.BioFormats.stopCurrentExport"))) {
                this.task.cancel(true);
            } else {
                return;
            }
        }
        if ((imageData = this.qupath.getViewer().getImageData()) == null) {
            GuiTools.showNoImageError((String)QuPathResources.getString((String)"Action.BioFormats.omeZarrWriter"));
            return;
        }
        ParameterList parameters = OMEZarrWriterCommand.createParameters(imageData.getServerMetadata());
        if (!GuiTools.showParameterDialog((String)QuPathResources.getString((String)"Action.BioFormats.exportOMEZarr"), (ParameterList)parameters)) {
            return;
        }
        OMEZarrWriterCommand.updatePreferences(parameters);
        File fileOutput = OMEZarrWriterCommand.promptOutputDirectory();
        if (fileOutput == null) {
            return;
        }
        OMEZarrWriter.Builder builder = this.createBuilder(parameters, (ImageData<BufferedImage>)imageData);
        this.task = this.executor.submit(() -> {
            try (OMEZarrWriter writer = builder.build(fileOutput.getAbsolutePath());){
                Dialogs.showInfoNotification((String)QuPathResources.getString((String)"Action.BioFormats.omeZarrWriter"), (String)MessageFormat.format(QuPathResources.getString((String)"Action.BioFormats.exportingTo"), fileOutput.getAbsolutePath()));
                writer.writeImage();
            }
            catch (IOException e) {
                logger.error("Error while writing Zarr image", (Throwable)e);
                Dialogs.showErrorMessage((String)QuPathResources.getString((String)"Action.BioFormats.omeZarrWriter"), (String)e.getLocalizedMessage());
                return;
            }
            catch (InterruptedException e) {
                logger.warn("OME Zarr writer closed by interrupt (possibly due to user cancelling it)", (Throwable)e);
                return;
            }
            Dialogs.showInfoNotification((String)QuPathResources.getString((String)"Action.BioFormats.omeZarrWriter"), (String)MessageFormat.format(QuPathResources.getString((String)"Action.BioFormats.exportComplete"), fileOutput.getName()));
        });
    }

    private static ParameterList createParameters(ImageServerMetadata metadata) {
        ParameterList parameters = new ParameterList().addIntParameter("scaledDownsample", QuPathResources.getString((String)"Action.BioFormats.pyramidalDownsample"), scaledDownsample.getValue().intValue(), "", 1.0, 8.0, QuPathResources.getString((String)"Action.BioFormats.pyramidalDownsampleDetail")).addIntParameter("tileSize", QuPathResources.getString((String)"Action.BioFormats.tileSize"), tileSize.getValue().intValue(), "px", QuPathResources.getString((String)"Action.BioFormats.tileSizeDetail")).addBooleanParameter("allZ", QuPathResources.getString((String)"Action.BioFormats.allZSlices"), allZ.getValue().booleanValue(), QuPathResources.getString((String)"Action.BioFormats.allZSlicesDetail")).addBooleanParameter("allT", QuPathResources.getString((String)"Action.BioFormats.allTimepoints"), allT.getValue().booleanValue(), QuPathResources.getString((String)"Action.BioFormats.allTimepointsDetail")).addIntParameter("numberOfThreads", QuPathResources.getString((String)"Action.BioFormats.numberOfThreads"), numberOfThreads.getValue().intValue(), "", 1.0, (double)Runtime.getRuntime().availableProcessors(), QuPathResources.getString((String)"Action.BioFormats.numberOfThreadsDetail"));
        parameters.setHiddenParameters(metadata.getSizeZ() == 1, new String[]{"allZ"});
        parameters.setHiddenParameters(metadata.getSizeT() == 1, new String[]{"allT"});
        return parameters;
    }

    private static void updatePreferences(ParameterList parameters) {
        scaledDownsample.set(parameters.getIntParameterValue("scaledDownsample").intValue());
        tileSize.set(parameters.getIntParameterValue("tileSize").intValue());
        allZ.set(parameters.getBooleanParameterValue("allZ").booleanValue());
        allT.set(parameters.getBooleanParameterValue("allT").booleanValue());
        numberOfThreads.set(parameters.getIntParameterValue("numberOfThreads").intValue());
    }

    private static File promptOutputDirectory() {
        File fileOutput = FileChoosers.promptToSaveFile((String)QuPathResources.getString((String)"Action.BioFormats.writeOMEZarr"), null, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)QuPathResources.getString((String)"Action.BioFormats.omeZarr"), (String[])new String[]{".ome.zarr"})});
        if (fileOutput == null) {
            return null;
        }
        if (!fileOutput.getAbsolutePath().endsWith(".ome.zarr")) {
            Dialogs.showErrorMessage((String)QuPathResources.getString((String)"Action.BioFormats.omeZarrWriter"), (String)QuPathResources.getString((String)"Action.BioFormats.invalidZarrExtension"));
            return null;
        }
        if (fileOutput.exists()) {
            Dialogs.showErrorMessage((String)QuPathResources.getString((String)"Action.BioFormats.omeZarrWriter"), (String)QuPathResources.getString((String)"Action.BioFormats.directoryAlreadyExists"));
            return null;
        }
        return fileOutput;
    }

    private OMEZarrWriter.Builder createBuilder(ParameterList parameters, ImageData<BufferedImage> imageData) {
        PathObject selected;
        OMEZarrWriter.Builder builder = new OMEZarrWriter.Builder((ImageServer<BufferedImage>)imageData.getServer()).parallelize(parameters.getIntParameterValue("numberOfThreads")).tileSize(parameters.getIntParameterValue("tileSize")).downsamples(DoubleStream.iterate(1.0, d -> (int)((double)imageData.getServer().getWidth() / d) > parameters.getIntParameterValue("tileSize") && (int)((double)imageData.getServer().getHeight() / d) > parameters.getIntParameterValue("tileSize"), d -> d * (double)parameters.getIntParameterValue("scaledDownsample").intValue()).toArray());
        if (!parameters.getBooleanParameterValue("allZ").booleanValue()) {
            builder.zSlices(this.qupath.getViewer().getZPosition(), this.qupath.getViewer().getZPosition() + 1);
        }
        if (!parameters.getBooleanParameterValue("allT").booleanValue()) {
            builder.timePoints(this.qupath.getViewer().getTPosition(), this.qupath.getViewer().getTPosition() + 1);
        }
        if ((selected = imageData.getHierarchy().getSelectionModel().getSelectedObject()) != null && selected.hasROI() && selected.getROI().isArea()) {
            builder.region(ImageRegion.createInstance((ROI)selected.getROI()));
        }
        return builder;
    }
}

