/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers.ome.zarr;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.WrappedBufferedImageServer;
import qupath.lib.images.writers.ImageWriter;
import qupath.lib.images.writers.ome.zarr.OMEZarrWriter;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class OMEZarrImageWriter
implements ImageWriter<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(OMEZarrImageWriter.class);

    public String getName() {
        return "OME-Zarr";
    }

    public Collection<String> getExtensions() {
        return List.of("ome.zarr");
    }

    public boolean supportsT() {
        return true;
    }

    public boolean supportsZ() {
        return true;
    }

    public boolean supportsRGB() {
        return true;
    }

    public boolean supportsImageType(ImageServer<BufferedImage> server) {
        return true;
    }

    public boolean supportsPyramidal() {
        return true;
    }

    public boolean supportsPixelSize() {
        return true;
    }

    public String getDetails() {
        return "Write image as an OME-Zarr image. Format is flexible, preserving most image metadata.";
    }

    public Class<BufferedImage> getImageClass() {
        return BufferedImage.class;
    }

    public void writeImage(ImageServer<BufferedImage> server, RegionRequest region, String pathOutput) throws IOException {
        try (OMEZarrWriter writer = new OMEZarrWriter.Builder(server).region((ImageRegion)region).build(pathOutput);){
            writer.writeImage();
        }
        catch (InterruptedException e) {
            logger.debug("Zarr image writing to {} interrupted", (Object)pathOutput, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    public void writeImage(BufferedImage img, String pathOutput) throws IOException {
        this.writeImage((ImageServer<BufferedImage>)new WrappedBufferedImageServer(null, img), pathOutput);
    }

    public void writeImage(ImageServer<BufferedImage> server, String pathOutput) throws IOException {
        this.writeImage(server, RegionRequest.createInstance(server), pathOutput);
    }

    public void writeImage(ImageServer<BufferedImage> server, RegionRequest region, OutputStream stream) throws IOException {
        throw new UnsupportedOperationException("Zarr images can't be written to output streams");
    }

    public void writeImage(BufferedImage img, OutputStream stream) throws IOException {
        this.writeImage((ImageServer<BufferedImage>)new WrappedBufferedImageServer(null, img), stream);
    }

    public void writeImage(ImageServer<BufferedImage> server, OutputStream stream) throws IOException {
        this.writeImage(server, RegionRequest.createInstance(server), stream);
    }
}

