/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers.ome.zarr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import qupath.lib.common.ColorTools;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelCalibration;

class OMEZarrAttributesCreator {
    private static final String VERSION = "0.4";
    private final ImageServerMetadata metadata;

    public OMEZarrAttributesCreator(ImageServerMetadata metadata) {
        this.metadata = metadata;
    }

    public Map<String, Object> getGroupAttributes() {
        return Map.of("multiscales", List.of(Map.of("axes", this.getAxes(), "datasets", this.getDatasets(), "name", this.metadata.getName(), "version", VERSION)), "omero", Map.of("name", this.metadata.getName(), "version", VERSION, "channels", this.getChannels(), "rdefs", Map.of("defaultT", 0, "defaultZ", 0, "model", "color")), "bioformats2raw.layout", 3);
    }

    public Map<String, Object> getLevelAttributes() {
        ArrayList<String> arrayDimensions = new ArrayList<String>();
        if (this.metadata.getSizeT() > 1) {
            arrayDimensions.add("t");
        }
        if (this.metadata.getSizeC() > 1) {
            arrayDimensions.add("c");
        }
        if (this.metadata.getSizeZ() > 1) {
            arrayDimensions.add("z");
        }
        arrayDimensions.add("y");
        arrayDimensions.add("x");
        return Map.of("_ARRAY_DIMENSIONS", arrayDimensions);
    }

    private List<Map<String, Object>> getAxes() {
        ArrayList<Map<String, Object>> axes = new ArrayList<Map<String, Object>>();
        if (this.metadata.getSizeT() > 1) {
            axes.add(this.getAxis(Dimension.T));
        }
        if (this.metadata.getSizeC() > 1) {
            axes.add(this.getAxis(Dimension.C));
        }
        if (this.metadata.getSizeZ() > 1) {
            axes.add(this.getAxis(Dimension.Z));
        }
        axes.add(this.getAxis(Dimension.Y));
        axes.add(this.getAxis(Dimension.X));
        return axes;
    }

    private List<Map<String, Object>> getDatasets() {
        return IntStream.range(0, this.metadata.getPreferredDownsamplesArray().length).mapToObj(level -> Map.of("path", "s" + level, "coordinateTransformations", List.of(this.getCoordinateTransformation((float)this.metadata.getPreferredDownsamplesArray()[level])))).toList();
    }

    private List<Map<String, Object>> getChannels() {
        double d;
        if (this.metadata.isRGB()) {
            d = 2.147483647E9;
        } else {
            switch (this.metadata.getPixelType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case UINT8: 
                case INT8: {
                    d = 127.0;
                    break;
                }
                case UINT16: 
                case INT16: {
                    d = 32767.0;
                    break;
                }
                case UINT32: 
                case INT32: {
                    d = 2.147483647E9;
                    break;
                }
                case FLOAT32: {
                    d = 3.4028234663852886E38;
                    break;
                }
                case FLOAT64: {
                    d = Double.MAX_VALUE;
                }
            }
        }
        Double maxValue = d;
        return this.metadata.getChannels().stream().map(channel -> Map.of("active", true, "coefficient", 1.0, "color", String.format("%02X%02X%02X", ColorTools.unpackRGB((int)channel.getColor())[0], ColorTools.unpackRGB((int)channel.getColor())[1], ColorTools.unpackRGB((int)channel.getColor())[2]), "family", "linear", "inverted", false, "label", channel.getName(), "window", Map.of("start", 0.0, "end", maxValue, "min", 0.0, "max", maxValue))).toList();
    }

    private Map<String, Object> getAxis(Dimension dimension) {
        HashMap<String, Object> axis = new HashMap<String, Object>();
        axis.put("name", switch (dimension.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "x";
            case 1 -> "y";
            case 2 -> "z";
            case 4 -> "t";
            case 3 -> "c";
        });
        axis.put("type", switch (dimension.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2 -> "space";
            case 4 -> "time";
            case 3 -> "channel";
        });
        switch (dimension.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                if (!this.metadata.getPixelCalibration().getPixelWidthUnit().equals(PixelCalibration.MICROMETER)) break;
                axis.put("unit", "micrometer");
                break;
            }
            case 4: {
                axis.put("unit", switch (this.metadata.getTimeUnit()) {
                    default -> throw new MatchException(null, null);
                    case TimeUnit.NANOSECONDS -> "nanosecond";
                    case TimeUnit.MICROSECONDS -> "microsecond";
                    case TimeUnit.MILLISECONDS -> "millisecond";
                    case TimeUnit.SECONDS -> "second";
                    case TimeUnit.MINUTES -> "minute";
                    case TimeUnit.HOURS -> "hour";
                    case TimeUnit.DAYS -> "day";
                });
            }
        }
        return axis;
    }

    private Map<String, Object> getCoordinateTransformation(float downsample) {
        ArrayList<Float> scales = new ArrayList<Float>();
        if (this.metadata.getSizeT() > 1) {
            if (!Double.isNaN(this.metadata.getPixelCalibration().getTimepoint(0)) && !Double.isNaN(this.metadata.getPixelCalibration().getTimepoint(1))) {
                scales.add(Float.valueOf((float)(this.metadata.getPixelCalibration().getTimepoint(1) - this.metadata.getPixelCalibration().getTimepoint(0))));
            } else {
                scales.add(Float.valueOf(1.0f));
            }
        }
        if (this.metadata.getSizeC() > 1) {
            scales.add(Float.valueOf(1.0f));
        }
        if (this.metadata.getSizeZ() > 1) {
            scales.add(Float.valueOf(this.metadata.getPixelCalibration().getZSpacing().floatValue()));
        }
        scales.add(Float.valueOf(this.metadata.getPixelCalibration().getPixelHeight().floatValue() * downsample));
        scales.add(Float.valueOf(this.metadata.getPixelCalibration().getPixelWidth().floatValue() * downsample));
        return Map.of("type", "scale", "scale", scales);
    }

    private static enum Dimension {
        X,
        Y,
        Z,
        C,
        T;

    }
}

