/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers.ome.zarr;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.Channel;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.OME;
import ome.xml.model.Objective;
import ome.xml.model.ObjectiveSettings;
import ome.xml.model.Pixels;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import qupath.lib.common.ColorTools;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelType;

class OMEXMLCreator {
    private static final Logger logger = LoggerFactory.getLogger(OMEXMLCreator.class);
    private static final String NAMESPACE_ATTRIBUTE = "xmlns";
    private static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final String INSTRUMENT_ID = "Instrument:0";
    private static final String IMAGE_ID = "Image:0";
    private static final String OBJECTIVE_ID = "Objective:0";
    private static final String PIXELS_ID = "Pixels:0";

    private OMEXMLCreator() {
        throw new RuntimeException("This class is not instantiable.");
    }

    public static Optional<String> create(ImageServerMetadata metadata) {
        Optional<String> optional;
        Instrument instrument;
        OME ome = new OME();
        Instrument instrument2 = instrument = Double.isNaN(metadata.getMagnification()) ? null : OMEXMLCreator.createInstrument(metadata.getMagnification());
        if (instrument != null) {
            ome.addInstrument(instrument);
        }
        ome.addImage(OMEXMLCreator.createImage(metadata, instrument));
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = ome.asXMLElement(document);
        root.setAttribute(NAMESPACE_ATTRIBUTE, NAMESPACE);
        document.appendChild(root);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8)));
            optional = Optional.ofNullable(os.toString(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error("Error while creating OME XML content", (Throwable)e);
                return Optional.empty();
            }
        }
        os.close();
        return optional;
    }

    private static Instrument createInstrument(double magnification) {
        Instrument instrument = new Instrument();
        instrument.setID(INSTRUMENT_ID);
        instrument.addObjective(OMEXMLCreator.createObjective(magnification));
        return instrument;
    }

    private static Image createImage(ImageServerMetadata metadata, Instrument instrument) {
        Image image = new Image();
        image.setID(IMAGE_ID);
        image.setPixels(OMEXMLCreator.createPixels(metadata));
        if (instrument != null) {
            image.linkInstrument(instrument);
            ObjectiveSettings settings = new ObjectiveSettings();
            settings.setID(OBJECTIVE_ID);
            image.setObjectiveSettings(settings);
        }
        return image;
    }

    private static Objective createObjective(double magnification) {
        Objective objective = new Objective();
        objective.setID(OBJECTIVE_ID);
        objective.setNominalMagnification(Double.valueOf(magnification));
        return objective;
    }

    private static Pixels createPixels(ImageServerMetadata metadata) {
        Pixels pixels = new Pixels();
        pixels.setID(PIXELS_ID);
        pixels.setSizeX(new PositiveInteger(Integer.valueOf(metadata.getWidth())));
        pixels.setSizeY(new PositiveInteger(Integer.valueOf(metadata.getHeight())));
        pixels.setSizeZ(new PositiveInteger(Integer.valueOf(metadata.getSizeZ())));
        pixels.setSizeC(new PositiveInteger(Integer.valueOf(metadata.getSizeC())));
        pixels.setSizeT(new PositiveInteger(Integer.valueOf(metadata.getSizeT())));
        pixels.setDimensionOrder(DimensionOrder.XYZCT);
        pixels.setType(switch (metadata.getPixelType()) {
            default -> throw new MatchException(null, null);
            case PixelType.UINT8 -> ome.xml.model.enums.PixelType.UINT8;
            case PixelType.INT8 -> ome.xml.model.enums.PixelType.INT8;
            case PixelType.UINT16 -> ome.xml.model.enums.PixelType.UINT16;
            case PixelType.INT16 -> ome.xml.model.enums.PixelType.INT16;
            case PixelType.UINT32 -> ome.xml.model.enums.PixelType.UINT32;
            case PixelType.INT32 -> ome.xml.model.enums.PixelType.INT32;
            case PixelType.FLOAT32 -> ome.xml.model.enums.PixelType.FLOAT;
            case PixelType.FLOAT64 -> ome.xml.model.enums.PixelType.DOUBLE;
        });
        if (!Double.isNaN(metadata.getPixelCalibration().getPixelWidthMicrons())) {
            pixels.setPhysicalSizeX(new Length((Number)metadata.getPixelCalibration().getPixelWidthMicrons(), UNITS.MICROMETRE));
        }
        if (!Double.isNaN(metadata.getPixelCalibration().getPixelHeightMicrons())) {
            pixels.setPhysicalSizeY(new Length((Number)metadata.getPixelCalibration().getPixelHeightMicrons(), UNITS.MICROMETRE));
        }
        if (!Double.isNaN(metadata.getPixelCalibration().getZSpacingMicrons())) {
            pixels.setPhysicalSizeZ(new Length((Number)metadata.getPixelCalibration().getZSpacingMicrons(), UNITS.MICROMETRE));
        }
        if (metadata.getSizeT() > 1 && !Double.isNaN(metadata.getTimepoint(0)) && !Double.isNaN(metadata.getTimepoint(1))) {
            Double d = Math.abs(metadata.getTimepoint(1) - metadata.getTimepoint(0));
            pixels.setTimeIncrement(new Time((Number)d, switch (metadata.getTimeUnit()) {
                default -> throw new MatchException(null, null);
                case TimeUnit.NANOSECONDS -> UNITS.NANOSECOND;
                case TimeUnit.MICROSECONDS -> UNITS.MICROSECOND;
                case TimeUnit.MILLISECONDS -> UNITS.MILLISECOND;
                case TimeUnit.SECONDS -> UNITS.SECOND;
                case TimeUnit.MINUTES -> UNITS.MINUTE;
                case TimeUnit.HOURS -> UNITS.HOUR;
                case TimeUnit.DAYS -> UNITS.DAY;
            }));
        }
        for (ImageChannel channel : metadata.getChannels()) {
            pixels.addChannel(OMEXMLCreator.createChannel(metadata, channel));
        }
        return pixels;
    }

    private static Channel createChannel(ImageServerMetadata metadata, ImageChannel imageChannel) {
        Channel channel = new Channel();
        channel.setID("Channel:" + metadata.getChannels().indexOf(imageChannel));
        channel.setColor(new Color(Integer.valueOf(OMEXMLCreator.packRGBA(ColorTools.red((int)imageChannel.getColor()), ColorTools.green((int)imageChannel.getColor()), ColorTools.blue((int)imageChannel.getColor())))));
        channel.setName(imageChannel.getName());
        return channel;
    }

    private static int packRGBA(int r, int g, int b) {
        return ((r & 0xFF) << 24) + ((g & 0xFF) << 16) + ((b & 0xFF) << 8) + 255;
    }
}

