/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.bioformats;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import ome.xml.model.AffineTransform;
import ome.xml.model.BinData;
import ome.xml.model.Ellipse;
import ome.xml.model.Label;
import ome.xml.model.Line;
import ome.xml.model.Mask;
import ome.xml.model.Point;
import ome.xml.model.Polygon;
import ome.xml.model.Polyline;
import ome.xml.model.Rectangle;
import ome.xml.model.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.images.ContourTracing;
import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.images.SimpleImages;
import qupath.lib.analysis.images.SimpleModifiableImage;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

class BioFormatsShapeConverter {
    private static final Logger logger = LoggerFactory.getLogger(BioFormatsShapeConverter.class);
    private static final String POINT_DELIMITER = " ";
    private static final String POINT_COORDINATE_DELIMITER = ",";

    private BioFormatsShapeConverter() {
        throw new AssertionError((Object)"This class is not instantiable.");
    }

    public static Optional<ROI> convertShapeToRoi(Shape shape) {
        logger.debug("Converting {} to QuPath ROI", (Object)shape);
        Shape shape2 = shape;
        Objects.requireNonNull(shape2);
        Shape shape3 = shape2;
        int n = 0;
        Optional<Object> optionalRoi = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Mask.class, Rectangle.class, Ellipse.class, Label.class, Line.class, Point.class, Polygon.class, Polyline.class}, (Object)shape3, n)) {
            case 0 -> {
                Mask mask = (Mask)shape3;
                yield Optional.ofNullable(BioFormatsShapeConverter.convertMask(mask));
            }
            case 1 -> {
                Rectangle rectangle = (Rectangle)shape3;
                yield Optional.of(BioFormatsShapeConverter.convertRectangle(rectangle));
            }
            case 2 -> {
                Ellipse ellipse = (Ellipse)shape3;
                yield Optional.of(BioFormatsShapeConverter.convertEllipse(ellipse));
            }
            case 3 -> {
                Label label = (Label)shape3;
                yield Optional.of(BioFormatsShapeConverter.convertLabel(label));
            }
            case 4 -> {
                Line line = (Line)shape3;
                yield Optional.of(BioFormatsShapeConverter.convertLine(line));
            }
            case 5 -> {
                Point point = (Point)shape3;
                yield Optional.of(BioFormatsShapeConverter.convertPoint(point));
            }
            case 6 -> {
                Polygon polygon = (Polygon)shape3;
                yield Optional.of(BioFormatsShapeConverter.convertPolygon(polygon));
            }
            case 7 -> {
                Polyline polyline = (Polyline)shape3;
                yield Optional.of(BioFormatsShapeConverter.convertPolyLine(polyline));
            }
            default -> {
                logger.debug("Unknown shape {}. Cannot convert it to QuPath ROI", (Object)shape);
                yield Optional.empty();
            }
        };
        return optionalRoi.map(roi -> {
            AffineTransform transform = shape.getTransform();
            if (transform == null) {
                logger.debug("No transform in {}, so returning {} without applying any transform", (Object)shape, roi);
                return roi;
            }
            logger.debug("Transform {} detected in {}, so applying it to {}", new Object[]{transform, shape, roi});
            return RoiTools.transformROI((ROI)roi, (java.awt.geom.AffineTransform)new java.awt.geom.AffineTransform(transform.getA00(), transform.getA10(), transform.getA01(), transform.getA11(), transform.getA02(), transform.getA12()));
        });
    }

    private static ROI convertMask(Mask mask) {
        int height;
        double maskHeight;
        double maskWidth;
        logger.debug("Converting mask {} to QuPath ROI", (Object)mask);
        BinData binData = mask.getBinData();
        if (binData == null) {
            logger.debug("Binary data of {} null, cannot convert it to ROI", (Object)mask);
            return null;
        }
        long nPixels = binData.getLength() == null ? (long)binData.getBase64Binary().length : (Long)binData.getLength().getValue();
        int width = (int)Math.round(Math.sqrt((double)nPixels * ((maskWidth = mask.getWidth() == null ? 0.0 : mask.getWidth()) / (maskHeight = mask.getHeight() == null ? 0.0 : mask.getHeight()))));
        if ((long)width * (long)(height = (int)(nPixels / (long)width)) != nPixels) {
            logger.debug("Couldn't figure out dimensions: {}x{} != {} pixels. Cannot convert {}", new Object[]{width, height, nPixels, mask});
            return null;
        }
        byte[] array = binData.getBase64Binary();
        if (array == null) {
            logger.debug("Base64 byte array of {} null, cannot convert it to ROI", (Object)mask);
            return null;
        }
        SimpleModifiableImage simpleImage = SimpleImages.createFloatImage((int)width, (int)height);
        int i = 0;
        while ((long)i < nPixels) {
            if (array[i] != 0) {
                simpleImage.setValue(i % width, i / width, 1.0f);
            }
            ++i;
        }
        return ContourTracing.createTracedROI((SimpleImage)simpleImage, (double)1.0, (double)1.0, (RegionRequest)RegionRequest.createInstance((String)"", (double)1.0, (int)(mask.getX() == null ? 0 : mask.getX().intValue()), (int)(mask.getY() == null ? 0 : mask.getY().intValue()), (int)simpleImage.getWidth(), (int)simpleImage.getHeight(), (ImagePlane)BioFormatsShapeConverter.createImagePlane((Shape)mask)));
    }

    private static ROI convertRectangle(Rectangle rectangle) {
        logger.debug("Converting rectangle {} to QuPath rectangle ROI", (Object)rectangle);
        return ROIs.createRectangleROI((double)(rectangle.getX() == null ? 0.0 : rectangle.getX()), (double)(rectangle.getY() == null ? 0.0 : rectangle.getY()), (double)(rectangle.getWidth() == null ? 0.0 : rectangle.getWidth()), (double)(rectangle.getHeight() == null ? 0.0 : rectangle.getHeight()), (ImagePlane)BioFormatsShapeConverter.createImagePlane((Shape)rectangle));
    }

    private static ROI convertEllipse(Ellipse ellipse) {
        logger.debug("Converting ellipse {} to QuPath ellipse ROI", (Object)ellipse);
        double x = ellipse.getX() == null ? 0.0 : ellipse.getX();
        double y = ellipse.getY() == null ? 0.0 : ellipse.getY();
        double radiusX = ellipse.getRadiusX() == null ? 0.0 : ellipse.getRadiusX();
        double radiusY = ellipse.getRadiusY() == null ? 0.0 : ellipse.getRadiusY();
        return ROIs.createEllipseROI((double)(x - radiusX), (double)(y - radiusY), (double)(radiusX * 2.0), (double)(radiusY * 2.0), (ImagePlane)BioFormatsShapeConverter.createImagePlane((Shape)ellipse));
    }

    private static ROI convertLabel(Label label) {
        logger.debug("Converting label {} to QuPath point ROI", (Object)label);
        return ROIs.createPointsROI((double)(label.getX() == null ? 0.0 : label.getX()), (double)(label.getY() == null ? 0.0 : label.getY()), (ImagePlane)BioFormatsShapeConverter.createImagePlane((Shape)label));
    }

    private static ROI convertLine(Line line) {
        logger.debug("Converting line {} to QuPath line ROI", (Object)line);
        return ROIs.createLineROI((double)(line.getX1() == null ? 0.0 : line.getX1()), (double)(line.getY1() == null ? 0.0 : line.getY1()), (double)(line.getX2() == null ? 0.0 : line.getX2()), (double)(line.getY2() == null ? 0.0 : line.getY2()), (ImagePlane)BioFormatsShapeConverter.createImagePlane((Shape)line));
    }

    private static ROI convertPoint(Point point) {
        logger.debug("Converting point {} to QuPath point ROI", (Object)point);
        return ROIs.createPointsROI((double)(point.getX() == null ? 0.0 : point.getX()), (double)(point.getY() == null ? 0.0 : point.getY()), (ImagePlane)BioFormatsShapeConverter.createImagePlane((Shape)point));
    }

    private static ROI convertPolygon(Polygon polygon) {
        logger.debug("Converting polygon {} to QuPath polygon ROI", (Object)polygon);
        return ROIs.createPolygonROI(BioFormatsShapeConverter.parseStringPoints(polygon.getPoints() == null ? "" : polygon.getPoints()), (ImagePlane)BioFormatsShapeConverter.createImagePlane((Shape)polygon));
    }

    private static ROI convertPolyLine(Polyline polyline) {
        logger.debug("Converting polyline {} to QuPath polyline ROI", (Object)polyline);
        return ROIs.createPolylineROI(BioFormatsShapeConverter.parseStringPoints(polyline.getPoints() == null ? "" : polyline.getPoints()), (ImagePlane)BioFormatsShapeConverter.createImagePlane((Shape)polyline));
    }

    private static ImagePlane createImagePlane(Shape shape) {
        if (shape.getTheC() == null) {
            return ImagePlane.getPlane((int)(shape.getTheZ() == null ? 0 : (Integer)shape.getTheZ().getValue()), (int)(shape.getTheT() == null ? 0 : (Integer)shape.getTheT().getValue()));
        }
        return ImagePlane.getPlaneWithChannel((int)((Integer)shape.getTheC().getValue()), (int)(shape.getTheZ() == null ? 0 : (Integer)shape.getTheZ().getValue()), (int)(shape.getTheT() == null ? 0 : (Integer)shape.getTheT().getValue()));
    }

    private static List<Point2> parseStringPoints(String pointsString) {
        logger.debug("Converting {} to a list of points", (Object)pointsString);
        return Arrays.stream(pointsString.split(POINT_DELIMITER)).map(pointStr -> {
            String[] point = pointStr.split(POINT_COORDINATE_DELIMITER);
            if (point.length > 1) {
                try {
                    return new Point2(Double.parseDouble(point[0]), Double.parseDouble(point[1]));
                }
                catch (NumberFormatException e) {
                    logger.debug("Cannot convert {} to two double elements", pointStr, (Object)e);
                    return null;
                }
            }
            logger.debug("Cannot find two elements in {}", pointStr);
            return null;
        }).filter(Objects::nonNull).toList();
    }
}

