/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.bioformats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.StringProperty;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.prefs.annotations.BooleanPref;
import qupath.fx.prefs.annotations.DirectoryPref;
import qupath.fx.prefs.annotations.IntegerPref;
import qupath.fx.prefs.annotations.PrefCategory;
import qupath.fx.prefs.annotations.StringPref;
import qupath.fx.prefs.controlsfx.PropertySheetUtils;
import qupath.lib.common.Version;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.extensions.QuPathExtension;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.images.servers.bioformats.BioFormatsServerBuilder;
import qupath.lib.images.servers.bioformats.BioFormatsServerOptions;
import qupath.lib.images.writers.ome.OMEPyramidWriterCommand;
import qupath.lib.images.writers.ome.zarr.OMEZarrWriterCommand;

public class BioFormatsOptionsExtension
implements QuPathExtension {
    private static final Logger logger = LoggerFactory.getLogger(BioFormatsOptionsExtension.class);
    private String bfVersion = null;

    public void installExtension(QuPathGUI qupath) {
        this.bfVersion = BioFormatsServerBuilder.getBioFormatsVersion();
        if (this.bfVersion == null) {
            Dialogs.showErrorMessage((String)this.getName(), (String)"The Bio-Formats extension is installed, but 'bioformats_package.jar' is missing!\n\nPlease make sure both .jar files are copied to the QuPath extensions folder.");
            return;
        }
        logger.info("Bio-Formats version {}", (Object)this.bfVersion);
        OmeTiffWriterAction actions = new OmeTiffWriterAction(qupath);
        qupath.installActions((Collection)ActionTools.getAnnotatedActions((Object)actions));
        qupath.installActions((Collection)ActionTools.getAnnotatedActions((Object)new OmeZarrWriterAction(qupath)));
        BioFormatsPreferences prefs = new BioFormatsPreferences();
        qupath.getPreferencePane().getPropertySheet().getItems().addAll((Collection)PropertySheetUtils.parseAnnotatedItemsWithResources((LocalizedResourceManager)QuPathResources.getLocalizedResourceManager(), (Object)prefs));
        if (BioFormatsServerOptions.allowMemoization()) {
            this.logMemoizationStatus(prefs.options);
        }
    }

    private void logMemoizationStatus(BioFormatsServerOptions options) {
        if (BioFormatsServerOptions.allowMemoization()) {
            int millis = options.getMemoizationTimeMillis();
            if (millis < 0) {
                logger.info("If Bio-Formats is slow to load images, setting the Bio-Formats memoization time in QuPath's preferences may help (this will create temp files)");
            } else {
                logger.info("Bio-Formats memoization time limit: {} ms (temp files may be created to speed up image loading)", (Object)millis);
            }
        }
    }

    private static void fillCollectionWithTokens(String text, Collection<String> collection) {
        BioFormatsOptionsExtension.fillCollectionWithTokens(new StringTokenizer(text), collection);
    }

    private static void fillCollectionWithTokens(StringTokenizer tokenizer, Collection<String> collection) {
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        collection.clear();
        collection.addAll(list);
    }

    public String getName() {
        if (this.bfVersion == null) {
            return QuPathResources.getString((String)"Extension.BioFormats") + " (Bio-Formats library is missing!)";
        }
        return QuPathResources.getString((String)"Extension.BioFormats") + " (Bio-Formats " + this.bfVersion + ")";
    }

    public String getDescription() {
        Object text = QuPathResources.getString((String)"Extension.BioFormats.description");
        if (this.bfVersion == null) {
            text = (String)text + "\n" + QuPathResources.getString((String)"Extension.BioFormats.missing.description");
        }
        return text;
    }

    public Version getQuPathVersion() {
        return this.getVersion();
    }

    public static class OmeTiffWriterAction {
        @ActionMenu(value={"Menu.File", "Menu.File.ExportImage"})
        @ActionConfig(value="Action.BioFormats.exportOmeTif")
        public final Action actionWriter;

        OmeTiffWriterAction(QuPathGUI qupath) {
            this.actionWriter = ActionTools.createAction((Runnable)new OMEPyramidWriterCommand(qupath), (String)"OME-TIFF");
        }
    }

    public static class OmeZarrWriterAction {
        @ActionMenu(value={"Menu.File", "Menu.File.ExportImage"})
        @ActionConfig(value="Action.BioFormats.omeZarr")
        public final Action actionWriter;

        public OmeZarrWriterAction(QuPathGUI qupath) {
            this.actionWriter = ActionTools.createAction((Runnable)new OMEZarrWriterCommand(qupath), (String)"OME-Zarr");
        }
    }

    @PrefCategory(value="Prefs.BioFormats")
    public static class BioFormatsPreferences {
        private BioFormatsServerOptions options = BioFormatsServerOptions.getInstance();
        @BooleanPref(value="Prefs.BioFormats.enable")
        public final BooleanProperty enableBioformats = PathPrefs.createPersistentPreference((String)"bfEnableBioformats", (boolean)this.options.bioformatsEnabled());
        @BooleanPref(value="Prefs.BioFormats.localOnly")
        public final BooleanProperty filesOnly = PathPrefs.createPersistentPreference((String)"bfFilesOnly", (boolean)this.options.getFilesOnly());
        @BooleanPref(value="Prefs.BioFormats.useParallelization")
        public final BooleanProperty useParallelization = PathPrefs.createPersistentPreference((String)"bfUseParallelization", (boolean)this.options.requestParallelization());
        @IntegerPref(value="Prefs.BioFormats.memoizationTimeMillis")
        public final IntegerProperty memoizationTimeMillis = PathPrefs.createPersistentPreference((String)"bfMemoizationTimeMillis", (int)this.options.getMemoizationTimeMillis());
        @DirectoryPref(value="Prefs.BioFormats.pathMemoization")
        public final StringProperty pathMemoization = PathPrefs.createPersistentPreference((String)"bfPathMemoization", (String)this.options.getPathMemoization());
        @StringPref(value="Prefs.BioFormats.alwaysUseExtensions")
        public final StringProperty useExtensions = PathPrefs.createPersistentPreference((String)"bfUseAlwaysExtensions", (String)String.join((CharSequence)" ", this.options.getUseAlwaysExtensions()));
        @StringPref(value="Prefs.BioFormats.skipExtensions")
        public final StringProperty skipExtensions = PathPrefs.createPersistentPreference((String)"bfSkipAlwaysExtensions", (String)String.join((CharSequence)" ", this.options.getSkipAlwaysExtensions()));

        private BioFormatsPreferences() {
            this.options.setFilesOnly(this.filesOnly.get());
            this.options.setPathMemoization((String)this.pathMemoization.get());
            this.options.setBioformatsEnabled(this.enableBioformats.get());
            this.options.setRequestParallelization(this.useParallelization.get());
            this.options.setMemoizationTimeMillis(this.memoizationTimeMillis.get());
            BioFormatsOptionsExtension.fillCollectionWithTokens((String)this.useExtensions.get(), this.options.getUseAlwaysExtensions());
            BioFormatsOptionsExtension.fillCollectionWithTokens((String)this.skipExtensions.get(), this.options.getSkipAlwaysExtensions());
            this.enableBioformats.addListener((v, o, n) -> this.options.setBioformatsEnabled((boolean)n));
            this.filesOnly.addListener((v, o, n) -> this.options.setFilesOnly((boolean)n));
            this.useParallelization.addListener((v, o, n) -> this.options.setRequestParallelization((boolean)n));
            this.memoizationTimeMillis.addListener((v, o, n) -> this.options.setMemoizationTimeMillis(n.intValue()));
            this.pathMemoization.addListener((v, o, n) -> this.options.setPathMemoization((String)n));
            this.useExtensions.addListener((v, o, n) -> BioFormatsOptionsExtension.fillCollectionWithTokens(n, this.options.getUseAlwaysExtensions()));
            this.skipExtensions.addListener((v, o, n) -> BioFormatsOptionsExtension.fillCollectionWithTokens(n, this.options.getSkipAlwaysExtensions()));
        }
    }
}

