/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.bioformats;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.formats.ClassList;
import loci.formats.DimensionSwapper;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Memoizer;
import loci.formats.MetadataTools;
import loci.formats.ReaderWrapper;
import loci.formats.gui.AWTImageTools;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.in.ZarrReader;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEPyramidStore;
import loci.formats.ome.OMEXMLMetadata;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.meta.MetadataRoot;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Shape;
import ome.xml.model.primitives.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.images.servers.bioformats.BioFormatsServerBuilder;
import qupath.lib.images.servers.bioformats.BioFormatsServerOptions;
import qupath.lib.images.servers.bioformats.BioFormatsShapeConverter;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectReader;
import qupath.lib.objects.PathObjects;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class BioFormatsImageServer
extends AbstractTileableImageServer
implements PathObjectReader {
    private static final Logger logger = LoggerFactory.getLogger(BioFormatsImageServer.class);
    private static long MAX_PARALLELIZATION_MEMO_SIZE = 0x1000000L;
    private URI uri;
    private static int MIN_TILE_SIZE = 32;
    private static int DEFAULT_TILE_SIZE = 512;
    private static final Pattern ZARR_FILE_PATTERN = Pattern.compile("\\.zarr/?(\\d+/?)?$");
    private static Collection<String> extraImageNames = new HashSet<String>(Arrays.asList("overview", "label", "thumbnail", "macro", "macro image", "macro mask image", "label image", "overview image", "thumbnail image"));
    private ImageServerMetadata originalMetadata;
    private String[] args;
    private String filePathOrUrl;
    private Map<String, ImageServerBuilder.ServerBuilder<BufferedImage>> imageMap = null;
    private Map<String, Integer> associatedImageMap = null;
    private int series = 0;
    private String format;
    private ColorModel colorModel;
    private ReaderPool readerPool;
    private String path;
    private BioFormatsArgs bfArgs;

    public BioFormatsImageServer(URI uri, String ... args) throws FormatException, IOException, DependencyException, ServiceException, URISyntaxException {
        this(uri, BioFormatsServerOptions.getInstance(), args);
    }

    static BioFormatsImageServer checkSupport(URI uri, BioFormatsServerOptions options, String ... args) throws IOException {
        try {
            BioFormatsImageServer server = new BioFormatsImageServer(uri, options, args);
            IFormatReader reader = server.readerPool.getMainReader();
            if (reader.getSizeX() > 0 && reader.getSizeY() > 0 && reader.openBytes(0, 0, 0, 1, 1) != null) {
                return server;
            }
            throw new IOException("Unable to read bytes from " + String.valueOf(uri));
        }
        catch (Throwable t) {
            throw ReaderPool.convertToIOException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BioFormatsImageServer(URI uri, BioFormatsServerOptions options, String ... args) throws FormatException, IOException, DependencyException, ServiceException, URISyntaxException {
        long startTime = System.currentTimeMillis();
        int width = 0;
        int height = 0;
        int nChannels = 1;
        int nZSlices = 1;
        int nTimepoints = 1;
        int tileWidth = 0;
        int tileHeight = 0;
        double pixelWidth = Double.NaN;
        double pixelHeight = Double.NaN;
        double zSpacing = Double.NaN;
        double magnification = Double.NaN;
        if (uri.toString().endsWith(".zattrs") || uri.toString().endsWith(".zgroup")) {
            uri = new File(uri).getParentFile().toURI();
        }
        if (args.length == 0) {
            if (uri.getFragment() != null) {
                args = new String[]{"--series", uri.getFragment()};
            } else if (uri.getQuery() != null) {
                String query = uri.getQuery();
                String seriesQuery = "series=";
                String nameQuery = "name=";
                if (query.startsWith(seriesQuery)) {
                    args = new String[]{"--series", query.substring(seriesQuery.length())};
                } else if (query.startsWith(nameQuery)) {
                    args = new String[]{"--name", query.substring(nameQuery.length())};
                }
            }
            uri = new URI(uri.getScheme(), uri.getHost(), uri.getPath(), null);
        }
        this.uri = uri;
        this.bfArgs = BioFormatsArgs.parse(args);
        int seriesIndex = this.bfArgs.series;
        String requestedSeriesName = this.bfArgs.seriesName;
        if (requestedSeriesName.isBlank()) {
            requestedSeriesName = null;
        }
        try {
            Path path = GeneralTools.toPath((URI)uri);
            if (path != null) {
                this.filePathOrUrl = path.toRealPath(new LinkOption[0]).toString();
            }
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (this.filePathOrUrl == null) {
                logger.debug("Using URI as file path: {}", (Object)uri);
                this.filePathOrUrl = uri.toString();
            }
        }
        ArrayList<ImageChannel> channels = new ArrayList<ImageChannel>();
        this.readerPool = new ReaderPool(options, this.filePathOrUrl, this.bfArgs, channels);
        IFormatReader reader = this.readerPool.getMainReader();
        OMEPyramidStore meta = (OMEPyramidStore)reader.getMetadataStore();
        int largestSeries = -1;
        int firstSeries = -1;
        long mostPixels = -1L;
        long firstPixels = -1L;
        IFormatReader iFormatReader = reader;
        synchronized (iFormatReader) {
            boolean isRGB;
            int nImages = meta.getImageCount();
            this.imageMap = new LinkedHashMap<String, ImageServerBuilder.ServerBuilder<BufferedImage>>(nImages);
            this.associatedImageMap = new LinkedHashMap<String, Integer>(nImages);
            for (int s = 0; s < nImages; ++s) {
                String name = "Series " + s;
                String originalImageName = this.getImageName((OMEXMLMetadata)meta, s);
                if (originalImageName == null) {
                    originalImageName = "";
                }
                String imageName = originalImageName;
                try {
                    if (!imageName.isEmpty()) {
                        name = name + " (" + imageName + ")";
                    }
                    long sizeX = meta.getPixelsSizeX(s).getNumberValue().longValue();
                    long sizeY = meta.getPixelsSizeY(s).getNumberValue().longValue();
                    long sizeC = meta.getPixelsSizeC(s).getNumberValue().longValue();
                    long sizeZ = meta.getPixelsSizeZ(s).getNumberValue().longValue();
                    long sizeT = meta.getPixelsSizeT(s).getNumberValue().longValue();
                    reader.setSeries(s);
                    assert ((long)reader.getSizeX() == sizeX);
                    assert ((long)reader.getSizeY() == sizeY);
                    int nResolutions = reader.getResolutionCount();
                    for (int r = 1; r < nResolutions; ++r) {
                        reader.setResolution(r);
                        int sizeXR = reader.getSizeX();
                        int sizeYR = reader.getSizeY();
                        if (sizeXR > 0 && sizeYR > 0 && (long)sizeXR <= sizeX && (long)sizeYR <= sizeY) continue;
                        throw new IllegalArgumentException("Resolution " + r + " size " + sizeXR + " x " + sizeYR + " invalid!");
                    }
                    if (reader.getResolutionCount() == 1 && (extraImageNames.contains(originalImageName.toLowerCase()) || extraImageNames.contains(name.toLowerCase().trim()))) {
                        logger.debug("Adding associated image {} (thumbnail={})", (Object)name, (Object)reader.isThumbnailSeries());
                        this.associatedImageMap.put(name, s);
                    } else if (this.imageMap.containsKey(name)) {
                        logger.warn("Duplicate image called {} - only the first will be used", (Object)name);
                    } else {
                        if (firstSeries < 0) {
                            firstSeries = s;
                            firstPixels = sizeX * sizeY * sizeZ * sizeT;
                        }
                        this.imageMap.put(name, (ImageServerBuilder.ServerBuilder<BufferedImage>)ImageServerBuilder.DefaultImageServerBuilder.createInstance(BioFormatsServerBuilder.class, null, (URI)uri, (String[])this.bfArgs.backToArgs(s)));
                    }
                    if (seriesIndex < 0) {
                        if (requestedSeriesName == null) {
                            long nPixels = sizeX * sizeY * sizeZ * sizeT;
                            if (nPixels > mostPixels) {
                                largestSeries = s;
                                mostPixels = nPixels;
                            }
                        } else if (requestedSeriesName.equals(name) || requestedSeriesName.equals(this.getImageName((OMEXMLMetadata)meta, s)) || requestedSeriesName.contentEquals(meta.getImageName(s))) {
                            seriesIndex = s;
                        }
                    }
                    logger.debug("Found image '{}', size: {} x {} x {} x {} x {} (xyczt)", new Object[]{imageName, sizeX, sizeY, sizeC, sizeZ, sizeT});
                    continue;
                }
                catch (Exception e) {
                    if (!(seriesIndex >= 0 && seriesIndex != s || requestedSeriesName != null && !requestedSeriesName.equals(imageName))) {
                        logger.warn("Error attempting to read series " + s + " (" + imageName + ") - will be skipped", (Throwable)e);
                        continue;
                    }
                    logger.trace("Error attempting to read series " + s + " (" + imageName + ") - will be skipped", (Throwable)e);
                }
            }
            if (this.imageMap.size() == 1 && seriesIndex < 0) {
                seriesIndex = firstSeries;
            } else if (this.imageMap.size() > 1) {
                if (seriesIndex < 0) {
                    seriesIndex = mostPixels > firstPixels * 4L ? largestSeries : firstSeries;
                }
                uri = new URI(uri.getScheme(), uri.getHost(), uri.getPath(), Integer.toString(seriesIndex));
            }
            if (seriesIndex < 0) {
                throw new IOException("Unable to find any valid images within " + String.valueOf(uri));
            }
            this.series = seriesIndex;
            reader.setSeries(this.series);
            this.format = reader.getFormat();
            logger.debug("Reading format: {}", (Object)this.format);
            try {
                String objectiveID = meta.getObjectiveSettingsID(this.series);
                int objectiveIndex = -1;
                int instrumentIndex = -1;
                int nInstruments = meta.getInstrumentCount();
                block33: for (int i = 0; i < nInstruments; ++i) {
                    int nObjectives = meta.getObjectiveCount(i);
                    int o = 0;
                    while (0 < nObjectives) {
                        if (objectiveID.equals(meta.getObjectiveID(i, o))) {
                            instrumentIndex = i;
                            objectiveIndex = o;
                            continue block33;
                        }
                        ++o;
                    }
                }
                if (instrumentIndex < 0) {
                    logger.warn("Cannot find objective for ref {}", (Object)objectiveID);
                } else {
                    Double magnificationObject = meta.getObjectiveNominalMagnification(instrumentIndex, objectiveIndex);
                    if (magnificationObject == null) {
                        logger.warn("Nominal objective magnification missing for {}:{}", (Object)instrumentIndex, (Object)objectiveIndex);
                    } else {
                        magnification = magnificationObject;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Unable to parse magnification: {}", (Object)e.getLocalizedMessage());
            }
            width = reader.getSizeX();
            height = reader.getSizeY();
            if (reader instanceof ZarrReader) {
                ZarrReader zarrReader = (ZarrReader)reader;
                zarrReader.setResolution(0, true);
            }
            tileWidth = reader.getOptimalTileWidth();
            tileHeight = reader.getOptimalTileHeight();
            nChannels = reader.getSizeC();
            if (tileWidth != width) {
                tileWidth = BioFormatsImageServer.getDefaultTileLength(tileWidth, width);
            }
            if (tileHeight != height) {
                tileHeight = BioFormatsImageServer.getDefaultTileLength(tileHeight, height);
            }
            nZSlices = reader.getSizeZ();
            nTimepoints = reader.getSizeT();
            PixelType pixelType = switch (reader.getPixelType()) {
                case 8 -> {
                    logger.warn("Pixel type is BIT! This is not currently supported by QuPath.");
                    yield PixelType.UINT8;
                }
                case 0 -> {
                    logger.warn("Pixel type is INT8! This is not currently supported by QuPath.");
                    yield PixelType.INT8;
                }
                case 1 -> PixelType.UINT8;
                case 2 -> PixelType.INT16;
                case 3 -> PixelType.UINT16;
                case 4 -> PixelType.INT32;
                case 5 -> {
                    logger.warn("Pixel type is UINT32! This is not currently supported by QuPath.");
                    yield PixelType.UINT32;
                }
                case 6 -> PixelType.FLOAT32;
                case 7 -> PixelType.FLOAT64;
                default -> throw new IllegalArgumentException("Unsupported pixel type " + reader.getPixelType());
            };
            int bpp = reader.getBitsPerPixel();
            Integer minValue = null;
            Integer maxValue = null;
            if (bpp < pixelType.getBitsPerPixel()) {
                if (pixelType.isSignedInteger()) {
                    minValue = -((int)Math.pow(2.0, bpp - 1));
                    maxValue = (int)(Math.pow(2.0, bpp - 1) - 1.0);
                } else if (pixelType.isUnsignedInteger()) {
                    maxValue = (int)(Math.pow(2.0, bpp) - 1.0);
                }
            }
            boolean bl = isRGB = reader.isRGB() && pixelType == PixelType.UINT8;
            if (isRGB && nChannels == 4) {
                logger.warn("Removing alpha channel");
                nChannels = 3;
            } else if (nChannels != 3) {
                isRGB = false;
            }
            if (isRGB) {
                channels.addAll(ImageChannel.getDefaultRGBChannels());
            } else {
                ArrayList<Color> tempColors = new ArrayList<Color>(nChannels);
                ArrayList<Object> tempNames = new ArrayList<Object>(nChannels);
                try {
                    int metaChannelCount = meta.getChannelCount(this.series);
                    if (metaChannelCount == nChannels) {
                        for (int c = 0; c < nChannels; ++c) {
                            try {
                                String channelName = meta.getChannelName(this.series, c);
                                Color color = meta.getChannelColor(this.series, c);
                                tempNames.add(channelName);
                                tempColors.add(color);
                                continue;
                            }
                            catch (Exception e) {
                                logger.warn("Unable to parse name or color for channel {}", (Object)c);
                                logger.debug("Unable to parse color", (Throwable)e);
                            }
                        }
                    } else {
                        logger.debug("Attempting to parse {} channels with metadata channel count {}", (Object)nChannels, (Object)metaChannelCount);
                        int ind = 0;
                        for (int cInd = 0; cInd < metaChannelCount; ++cInd) {
                            int nSamples = (Integer)meta.getChannelSamplesPerPixel(this.series, cInd).getValue();
                            String baseChannelName = meta.getChannelName(this.series, cInd);
                            if (baseChannelName != null && baseChannelName.isBlank()) {
                                baseChannelName = null;
                            }
                            Color color = meta.getChannelColor(this.series, cInd);
                            for (int sampleInd = 0; sampleInd < nSamples; ++sampleInd) {
                                String channelName = baseChannelName == null ? "Channel " + (ind + 1) : baseChannelName.strip() + " " + (sampleInd + 1);
                                tempNames.add(channelName);
                                tempColors.add(color);
                                ++ind;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("Exception parsing channels " + e.getLocalizedMessage(), (Throwable)e);
                }
                if (nChannels != tempNames.size() || tempNames.size() != tempColors.size()) {
                    logger.warn("The channel names and colors read from the metadata don't match the expected number of channels!");
                    logger.warn("Be very cautious working with channels, since the names and colors may be misaligned, incorrect or default values.");
                    long nNames = tempNames.stream().filter(n -> n != null && !n.isBlank()).count();
                    long nColors = tempColors.stream().filter(n -> n != null).count();
                    logger.warn("(I expected {} channels, but found {} names and {} colors)", new Object[]{nChannels, nNames, nColors});
                }
                for (int c = 0; c < nChannels; ++c) {
                    Object channelName = c < tempNames.size() ? (String)tempNames.get(c) : null;
                    Color color = c < tempColors.size() ? (Color)tempColors.get(c) : null;
                    Integer channelColor = null;
                    channelColor = color != null ? Integer.valueOf(ColorTools.packARGB((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue())) : (nChannels == 1 ? Integer.valueOf(ColorTools.packRGB((int)255, (int)255, (int)255)) : ImageChannel.getDefaultChannelColor((int)c));
                    if (channelName == null || ((String)channelName).isBlank()) {
                        channelName = "Channel " + (c + 1);
                    }
                    channels.add(ImageChannel.getInstance((String)channelName, (Integer)channelColor));
                }
                assert (nChannels == channels.size());
                if (nChannels == 3 && pixelType == PixelType.UINT8 && channels.equals(ImageChannel.getDefaultRGBChannels())) {
                    isRGB = true;
                    this.colorModel = ColorModel.getRGBdefault();
                } else {
                    this.colorModel = ColorModelFactory.createColorModel((PixelType)pixelType, channels);
                }
            }
            double[] timepoints = null;
            TimeUnit timeUnit = null;
            try {
                Length xSize = meta.getPixelsPhysicalSizeX(this.series);
                Length ySize = meta.getPixelsPhysicalSizeY(this.series);
                if (xSize != null && ySize != null) {
                    pixelWidth = xSize.value(UNITS.MICROMETER).doubleValue();
                    pixelHeight = ySize.value(UNITS.MICROMETER).doubleValue();
                } else {
                    pixelWidth = Double.NaN;
                    pixelHeight = Double.NaN;
                }
                if (nZSlices > 1) {
                    Length zSize = meta.getPixelsPhysicalSizeZ(this.series);
                    zSpacing = zSize != null ? zSize.value(UNITS.MICROMETER).doubleValue() : Double.NaN;
                }
                if (nTimepoints > 1) {
                    logger.warn("Time stamps read from Bioformats have not been fully verified & should not be relied upon (values updated in v0.6.0)");
                    Time timeIncrement = meta.getPixelsTimeIncrement(this.series);
                    if (timeIncrement != null) {
                        timepoints = new double[nTimepoints];
                        double timeIncrementSeconds = timeIncrement.value(UNITS.SECOND).doubleValue();
                        for (int t = 0; t < nTimepoints; ++t) {
                            timepoints[t] = (double)t * timeIncrementSeconds;
                        }
                        timeUnit = TimeUnit.SECONDS;
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error parsing metadata", (Throwable)e);
                pixelWidth = Double.NaN;
                pixelHeight = Double.NaN;
                zSpacing = Double.NaN;
                timepoints = null;
                timeUnit = null;
            }
            int nResolutions = reader.getResolutionCount();
            ImageServerMetadata.ImageResolutionLevel.Builder resolutionBuilder = new ImageServerMetadata.ImageResolutionLevel.Builder(width, height).addFullResolutionLevel();
            for (int i = 1; i < nResolutions; ++i) {
                reader.setResolution(i);
                try {
                    int w = reader.getSizeX();
                    int h = reader.getSizeY();
                    if (w <= 0 || h <= 0) {
                        logger.warn("Invalid resolution size {} x {}! Will skip this level, but something seems wrong...", (Object)w, (Object)h);
                        continue;
                    }
                    if ("CellSens VSI".equals(this.format)) {
                        double downsampleX = (double)width / (double)w;
                        double downsampleY = (double)height / (double)h;
                        double downsample = Math.pow(2.0, i);
                        if (!GeneralTools.almostTheSame((double)downsampleX, (double)downsampleY, (double)0.01)) {
                            logger.warn("Non-matching downsamples calculated for level {} ({} and {}); will use {} instead", new Object[]{i, downsampleX, downsampleY, downsample});
                            resolutionBuilder.addLevel(downsample, w, h);
                            continue;
                        }
                    }
                    resolutionBuilder.addLevel(w, h);
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Error attempting to extract resolution " + i + " for " + this.getImageName((OMEXMLMetadata)meta, this.series), (Throwable)e);
                    break;
                }
            }
            Object imageName = this.getFile().getName();
            String shortName = this.getImageName((OMEXMLMetadata)meta, seriesIndex);
            if (shortName == null || shortName.isBlank()) {
                if (this.imageMap.size() > 1) {
                    imageName = (String)imageName + " - Series " + seriesIndex;
                }
            } else if (!((String)imageName).equals(shortName)) {
                imageName = (String)imageName + " - " + shortName;
            }
            this.args = args;
            List resolutions = resolutionBuilder.build();
            this.path = this.createID();
            ImageServerMetadata.Builder builder = new ImageServerMetadata.Builder(((Object)((Object)this)).getClass(), this.path, width, height).minValue((Number)minValue).maxValue((Number)maxValue).name((String)imageName).channels(channels).sizeZ(nZSlices).sizeT(nTimepoints).levels((Collection)resolutions).pixelType(pixelType).rgb(isRGB);
            if (Double.isFinite(magnification)) {
                builder = builder.magnification(magnification);
            }
            if (timeUnit != null && timepoints != null) {
                builder = builder.timepoints(timeUnit, timepoints);
            }
            if (Double.isFinite(pixelWidth + pixelHeight)) {
                builder = builder.pixelSizeMicrons((Number)pixelWidth, (Number)pixelHeight);
            }
            if (Double.isFinite(zSpacing)) {
                builder = builder.zSpacingMicrons((Number)zSpacing);
            }
            if ((long)tileWidth * (long)tileHeight * (long)nChannels * (long)(bpp / 8) >= Integer.MAX_VALUE) {
                builder.preferredTileSize(Math.min(DEFAULT_TILE_SIZE, width), Math.min(DEFAULT_TILE_SIZE, height));
            } else {
                builder.preferredTileSize(tileWidth, tileHeight);
            }
            this.originalMetadata = builder.build();
        }
        ImageIO.setUseCache(false);
        long endTime = System.currentTimeMillis();
        logger.debug(String.format("Initialization time: %d ms", endTime - startTime));
    }

    static int getDefaultTileLength(int tileLength, int imageLength) {
        if (tileLength <= 0) {
            tileLength = DEFAULT_TILE_SIZE;
        } else if (tileLength < MIN_TILE_SIZE) {
            tileLength = (int)Math.ceil((double)MIN_TILE_SIZE / (double)tileLength) * tileLength;
        }
        return Math.min(tileLength, imageLength);
    }

    private String getImageName(OMEXMLMetadata meta, int series) {
        String name = meta.getImageName(series);
        if (name == null) {
            return null;
        }
        while (name.endsWith("\u0000")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public String getFormat() {
        return this.format;
    }

    public Collection<URI> getURIs() {
        return Collections.singletonList(this.uri);
    }

    public String createID() {
        String id = ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.uri.toString();
        if (this.args.length > 0) {
            id = id + "[" + String.join((CharSequence)", ", this.args) + "]";
        }
        return id;
    }

    public void setMetadata(ImageServerMetadata metadata) {
        ImageServerMetadata currentMetadata = this.getMetadata();
        super.setMetadata(metadata);
        if (currentMetadata != metadata && !currentMetadata.getLevels().equals(metadata.getLevels())) {
            logger.warn("Can't set metadata to use incompatible pyramid levels - reverting to original pyramid levels");
            super.setMetadata(new ImageServerMetadata.Builder(metadata).levels((Collection)currentMetadata.getLevels()).build());
        }
    }

    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return ImageServerBuilder.DefaultImageServerBuilder.createInstance(BioFormatsServerBuilder.class, (ImageServerMetadata)this.getMetadata(), (URI)this.uri, (String[])this.args);
    }

    int getPreferredTileWidth() {
        return this.getMetadata().getPreferredTileWidth();
    }

    int getPreferredTileHeight() {
        return this.getMetadata().getPreferredTileHeight();
    }

    public int getSeries() {
        return this.series;
    }

    public BufferedImage readTile(TileRequest tileRequest) throws IOException {
        try {
            return this.readerPool.openImage(tileRequest, this.series, this.nChannels(), this.isRGB(), this.colorModel);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public String getServerType() {
        return "Bio-Formats";
    }

    public synchronized void close() throws Exception {
        super.close();
        this.readerPool.close();
    }

    boolean containsSubImages() {
        return this.imageMap != null && !this.imageMap.isEmpty();
    }

    public OMEPyramidStore getMetadataStore() {
        return this.readerPool.metadata;
    }

    public String dumpMetadata() {
        try {
            OMEPyramidStore metadata = this.getMetadataStore();
            return metadata.dumpXML();
        }
        catch (Exception e) {
            logger.error("Unable to dump metadata", (Throwable)e);
            return null;
        }
    }

    public List<String> getAssociatedImageList() {
        if (this.associatedImageMap == null || this.associatedImageMap.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.associatedImageMap.keySet());
    }

    public BufferedImage getAssociatedImage(String name) {
        if (this.associatedImageMap == null || !this.associatedImageMap.containsKey(name)) {
            throw new IllegalArgumentException("No associated image with name '" + name + "' for " + this.getPath());
        }
        int series = this.associatedImageMap.get(name);
        try {
            return this.readerPool.openSeries(series);
        }
        catch (Exception e) {
            logger.error("Error reading associated image " + name + ": " + e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public File getFile() {
        return this.filePathOrUrl == null ? null : new File(this.filePathOrUrl);
    }

    Map<String, ImageServerBuilder.ServerBuilder<BufferedImage>> getImageBuilders() {
        return Collections.unmodifiableMap(this.imageMap);
    }

    public ImageServerMetadata getOriginalMetadata() {
        return this.originalMetadata;
    }

    public Collection<PathObject> readPathObjects() {
        IFormatReader reader = this.readerPool.nextQueuedReader();
        if (reader == null) {
            logger.debug("Cannot get reader. Returning no path objects");
            return List.of();
        }
        reader.setSeries(this.series);
        MetadataRoot metadataRoot = reader.getMetadataStore().getRoot();
        if (!(metadataRoot instanceof OMEXMLMetadataRoot)) {
            logger.debug("Metadata store of reader {} not instance of OMEXMLMetadataRoot. Returning no path objects", (Object)reader.getMetadataStore());
            return List.of();
        }
        OMEXMLMetadataRoot metadata = (OMEXMLMetadataRoot)metadataRoot;
        return IntStream.range(0, metadata.sizeOfROIList()).mapToObj(arg_0 -> ((OMEXMLMetadataRoot)metadata).getROI(arg_0)).map(bioFormatsRoi -> {
            ROI roi;
            logger.debug("Converting {} to QuPath path object", bioFormatsRoi);
            List<Shape> shapes = IntStream.range(0, bioFormatsRoi.getUnion().sizeOfShapeList()).mapToObj(i -> bioFormatsRoi.getUnion().getShape(i)).filter(Objects::nonNull).toList();
            List rois = shapes.stream().map(BioFormatsShapeConverter::convertShapeToRoi).flatMap(Optional::stream).toList();
            if (rois.stream().allMatch(ROI::isPoint)) {
                logger.debug("Got point ROIs {} from {}. Combining them", rois, bioFormatsRoi);
                roi = ROIs.createPointsROI(rois.stream().map(ROI::getAllPoints).flatMap(Collection::stream).distinct().toList(), (ImagePlane)(rois.isEmpty() ? ImagePlane.getDefaultPlane() : ((ROI)rois.getFirst()).getImagePlane()));
            } else {
                logger.debug("Got non point ROIs {} from {}. Creating union from it", rois, bioFormatsRoi);
                roi = RoiTools.union(rois);
            }
            PathObject pathObject = PathObjects.createAnnotationObject((ROI)roi);
            try {
                pathObject.setID(UUID.fromString(bioFormatsRoi.getID()));
                logger.debug("ID {} of {} set to {}", new Object[]{bioFormatsRoi.getID(), bioFormatsRoi, pathObject});
            }
            catch (IllegalArgumentException | NullPointerException e) {
                logger.debug("ID {} of {} is not a valid UUID", new Object[]{bioFormatsRoi.getID(), bioFormatsRoi, e});
            }
            Optional<Boolean> locked = shapes.stream().map(Shape::getLocked).filter(Objects::nonNull).findAny();
            if (locked.isPresent()) {
                pathObject.setLocked(locked.get().booleanValue());
                logger.debug("Locked status {} of {} set to {}", new Object[]{locked.get(), bioFormatsRoi, pathObject});
            } else {
                logger.debug("Locked status not found in {}", bioFormatsRoi);
            }
            pathObject.setName(bioFormatsRoi.getName());
            logger.debug("PathObject {} created from {}", (Object)pathObject, bioFormatsRoi);
            return pathObject;
        }).toList();
    }

    static String getSupportedReaderClass(String path) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        path = path.toLowerCase();
        for (Class cls : ReaderPool.getDefaultClassList().getClasses()) {
            IFormatReader reader = (IFormatReader)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (reader.isThisType(path, false)) {
                return cls.getName();
            }
            for (String s : reader.getSuffixes()) {
                if (s == null || s.isBlank() || !path.endsWith(s.toLowerCase())) continue;
                return cls.getName();
            }
        }
        return null;
    }

    static class ReaderPool
    implements AutoCloseable {
        private static final Logger logger = LoggerFactory.getLogger(ReaderPool.class);
        private static final int DEFAULT_TIMEOUT_SECONDS = 60;
        private static final int MAX_QUEUE_CAPACITY = 128;
        private static ClassList<IFormatReader> defaultClassList;
        private String id;
        private BioFormatsServerOptions options;
        private BioFormatsArgs args;
        private ClassList<IFormatReader> classList;
        private volatile boolean isClosed = false;
        private AtomicInteger totalReaders = new AtomicInteger(0);
        private List<IFormatReader> additionalReaders = Collections.synchronizedList(new ArrayList());
        private ArrayBlockingQueue<IFormatReader> queue;
        private OMEPyramidStore metadata;
        private IFormatReader mainReader;
        private ForkJoinTask<?> task;
        private final List<ImageChannel> channels;
        private int timeoutSeconds;
        private static final Cleaner cleaner;
        private final List<Cleaner.Cleanable> cleanables = new ArrayList<Cleaner.Cleanable>();
        private static Map<String, Long> memoizationSizeMap;
        private static File dirMemoTemp;
        private static Set<File> tempMemoFiles;

        ReaderPool(BioFormatsServerOptions options, String id, BioFormatsArgs args, List<ImageChannel> channels) throws FormatException, IOException {
            this.id = id;
            this.options = options;
            this.args = args;
            this.channels = channels;
            this.queue = new ArrayBlockingQueue(128);
            this.metadata = (OMEPyramidStore)MetadataTools.createOMEXMLMetadata();
            this.timeoutSeconds = this.getTimeoutSeconds();
            long startTime = System.currentTimeMillis();
            this.mainReader = this.createReader(options, null, id, (MetadataStore)this.metadata, args);
            long endTime = System.currentTimeMillis();
            logger.debug("Reader {} created in {} ms", (Object)this.mainReader, (Object)(endTime - startTime));
            this.queue.add(this.mainReader);
            this.classList = ReaderPool.unwrapClasslist(this.mainReader);
        }

        private int getTimeoutSeconds() {
            String timeoutString = System.getProperty("bioformats.readerpool.timeout", null);
            if (timeoutString != null) {
                try {
                    return Integer.parseInt(timeoutString);
                }
                catch (NumberFormatException e) {
                    logger.warn("Unable to parse timeout value: {}", (Object)timeoutString, (Object)e);
                }
            }
            return 60;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static ClassList<IFormatReader> getDefaultClassList() {
            if (defaultClassList != null) return defaultClassList;
            Class<BioFormatsImageServer> clazz = BioFormatsImageServer.class;
            synchronized (BioFormatsImageServer.class) {
                if (defaultClassList != null) return defaultClassList;
                ClassList classes = new ClassList(IFormatReader.class);
                for (Class cls : ImageReader.getDefaultReaderClasses().getClasses()) {
                    try {
                        IFormatReader instance = (IFormatReader)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (instance == null) continue;
                        classes.addClass(cls);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        logger.debug("Cannot instantiate reader class " + cls.getName() + ": " + t.getMessage());
                    }
                }
                defaultClassList = classes;
                // ** MonitorExit[var0] (shouldn't be in output)
                return defaultClassList;
            }
        }

        IFormatReader getMainReader() {
            return this.mainReader;
        }

        private void createAdditionalReader(BioFormatsServerOptions options, ClassList<IFormatReader> classList, String id, BioFormatsArgs args) {
            try {
                if (this.isClosed) {
                    return;
                }
                logger.debug("Requesting new reader for thread {}", (Object)Thread.currentThread());
                IFormatReader newReader = this.createReader(options, classList, id, null, args);
                if (newReader != null) {
                    this.additionalReaders.add(newReader);
                    this.queue.add(newReader);
                    logger.debug("Created new reader (total={})", (Object)this.additionalReaders.size());
                } else {
                    logger.warn("New Bio-Formats reader could not be created (returned null)");
                }
            }
            catch (Exception e) {
                logger.error("Error creating additional readers: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }

        private int getMaxReaders() {
            int max = this.options == null ? Runtime.getRuntime().availableProcessors() : this.options.getMaxReaders();
            return Math.min(128, Math.max(1, max));
        }

        private IFormatReader createReader(BioFormatsServerOptions options, ClassList<IFormatReader> classList, String id, MetadataStore store, BioFormatsArgs args) throws FormatException, IOException {
            ZarrReader imageReader;
            int maxReaders = this.getMaxReaders();
            int nReaders = this.totalReaders.getAndIncrement();
            if (this.mainReader != null && nReaders > maxReaders) {
                logger.warn("No new reader will be created (already created {}, max readers {})", (Object)nReaders, (Object)maxReaders);
                this.totalReaders.decrementAndGet();
                return null;
            }
            Matcher zarrMatcher = ZARR_FILE_PATTERN.matcher(id.toLowerCase());
            if (new File(id).isDirectory() || zarrMatcher.find()) {
                MetadataOptions metadataOptions;
                imageReader = new ZarrReader();
                if (id.startsWith("https") && (metadataOptions = imageReader.getMetadataOptions()) instanceof DynamicMetadataOptions) {
                    DynamicMetadataOptions zarrOptions = (DynamicMetadataOptions)metadataOptions;
                    zarrOptions.set("omezarr.alt_store", id);
                }
            } else {
                imageReader = classList != null ? new ImageReader(classList) : new ImageReader(ReaderPool.getDefaultClassList());
            }
            imageReader.setFlattenedResolutions(false);
            MetadataOptions metadataOptions = imageReader.getMetadataOptions();
            Map<String, String> readerOptions = args.readerOptions;
            if (!readerOptions.isEmpty() && metadataOptions instanceof DynamicMetadataOptions) {
                for (Map.Entry<String, String> option : readerOptions.entrySet()) {
                    ((DynamicMetadataOptions)metadataOptions).set(option.getKey(), option.getValue());
                }
            }
            Memoizer memoizer = null;
            int memoizationTimeMillis = options.getMemoizationTimeMillis();
            File dir = null;
            File fileMemo = null;
            boolean useTempMemoDirectory = false;
            if (BioFormatsServerOptions.allowMemoization() && memoizationTimeMillis >= 0) {
                String pathMemoization = options.getPathMemoization();
                if (pathMemoization != null && !pathMemoization.trim().isEmpty() && !(dir = new File(pathMemoization)).isDirectory()) {
                    logger.warn("Memoization path does not refer to a valid directory, will be ignored: {}", (Object)dir.getAbsolutePath());
                    dir = null;
                }
                if (dir == null) {
                    dir = ReaderPool.getTempMemoDir(true);
                    boolean bl = useTempMemoDirectory = dir != null;
                }
                if (dir != null) {
                    try {
                        memoizer = new Memoizer((IFormatReader)imageReader, (long)memoizationTimeMillis, dir);
                        fileMemo = memoizer.getMemoFile(id);
                        if (fileMemo != null && fileMemo.toPath() != null) {
                            imageReader = memoizer;
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Unable to use memoization: {}", (Object)e.getLocalizedMessage());
                        logger.debug(e.getLocalizedMessage(), (Throwable)e);
                        fileMemo = null;
                        memoizer = null;
                    }
                }
            }
            if (store != null) {
                imageReader.setMetadataStore(store);
            } else {
                imageReader.setMetadataStore((MetadataStore)new DummyMetadata());
                imageReader.setOriginalMetadataPopulated(false);
            }
            String swapDimensions = args.getSwapDimensions();
            if (swapDimensions != null) {
                logger.debug("Creating DimensionSwapper for {}", (Object)swapDimensions);
            }
            if (id != null) {
                if (fileMemo != null) {
                    if (useTempMemoDirectory) {
                        tempMemoFiles.add(fileMemo);
                    }
                    long memoizationFileSize = fileMemo == null ? 0L : fileMemo.length();
                    boolean memoFileExists = fileMemo != null && fileMemo.exists();
                    try {
                        if (swapDimensions != null) {
                            imageReader = DimensionSwapper.makeDimensionSwapper((IFormatReader)imageReader);
                        }
                        imageReader.setId(id);
                    }
                    catch (Exception e) {
                        if (memoFileExists) {
                            logger.warn("Problem with memoization file {} ({}), will try to delete it", (Object)fileMemo.getName(), (Object)e.getLocalizedMessage());
                            fileMemo.delete();
                        }
                        imageReader.close();
                        if (swapDimensions != null) {
                            imageReader = DimensionSwapper.makeDimensionSwapper((IFormatReader)imageReader);
                        }
                        imageReader.setId(id);
                    }
                    long l = memoizationFileSize = fileMemo == null ? 0L : fileMemo.length();
                    if (memoizationFileSize > 0L) {
                        if (memoizationFileSize > MAX_PARALLELIZATION_MEMO_SIZE) {
                            logger.warn(String.format("The memoization file is very large (%.1f MB) - parallelization may be turned off to save memory", (double)memoizationFileSize / 1048576.0));
                        }
                        memoizationSizeMap.put(id, memoizationFileSize);
                    }
                    if (memoizationFileSize == 0L) {
                        logger.debug("No memoization file generated for {}", (Object)id);
                    } else if (!memoFileExists) {
                        logger.debug(String.format("Generating memoization file %s (%.2f MB)", fileMemo.getAbsolutePath(), (double)memoizationFileSize / 1024.0 / 1024.0));
                    } else {
                        logger.debug("Memoization file exists at {}", (Object)fileMemo.getAbsolutePath());
                    }
                } else {
                    if (swapDimensions != null) {
                        imageReader = DimensionSwapper.makeDimensionSwapper((IFormatReader)imageReader);
                    }
                    imageReader.setId(id);
                }
            }
            if (swapDimensions != null) {
                if (args.series >= 0) {
                    imageReader.setSeries(args.series);
                }
                ((DimensionSwapper)imageReader).swapDimensions(swapDimensions);
            }
            this.cleanables.add(cleaner.register(this, new ReaderCleaner(Integer.toString(this.cleanables.size() + 1), (IFormatReader)imageReader)));
            return imageReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IFormatReader nextQueuedReader() {
            IFormatReader nextReader = this.queue.poll();
            if (nextReader != null) {
                return nextReader;
            }
            ReaderPool readerPool = this;
            synchronized (readerPool) {
                if (!this.isClosed && (this.task == null || this.task.isDone()) && this.totalReaders.get() < this.getMaxReaders()) {
                    logger.debug("Requesting reader for {}", (Object)this.id);
                    this.task = ForkJoinPool.commonPool().submit(() -> this.createAdditionalReader(this.options, this.classList, this.id, this.args));
                }
            }
            if (this.isClosed) {
                return null;
            }
            try {
                IFormatReader reader = this.queue.poll(this.timeoutSeconds, TimeUnit.SECONDS);
                if (reader == null) {
                    logger.warn("Bio-Formats reader request timed out after {} seconds - returning main reader", (Object)this.timeoutSeconds);
                    return this.mainReader;
                }
                return reader;
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted exception when awaiting next queued reader: {}", (Object)e.getLocalizedMessage());
                return this.isClosed ? null : this.mainReader;
            }
        }

        /*
         * Exception decompiling
         */
        BufferedImage openImage(TileRequest tileRequest, int series, int nChannels, boolean isRGB, ColorModel colorModel) throws IOException, InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static IOException convertToIOException(Throwable t) {
            String message;
            if (GeneralTools.isMac() && (message = t.getMessage()) != null) {
                if (message.contains("ome.jxrlib.JXRJNI")) {
                    return new IOException("Bio-Formats does not support JPEG-XR on Apple Silicon: " + t.getMessage(), t);
                }
                if (message.contains("org.libjpegturbo.turbojpeg.TJDecompressor")) {
                    return new IOException("Bio-Formats does not currently support libjpeg-turbo on Apple Silicon", t);
                }
            }
            if (t instanceof IOException) {
                IOException e = (IOException)t;
                return e;
            }
            return new IOException(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage openSeries(int series) throws InterruptedException, FormatException, IOException {
            IFormatReader reader = null;
            try {
                IFormatReader iFormatReader = reader = this.nextQueuedReader();
                synchronized (iFormatReader) {
                    BufferedImage bufferedImage;
                    int previousSeries = reader.getSeries();
                    try {
                        reader.setSeries(series);
                        int nResolutions = reader.getResolutionCount();
                        if (nResolutions > 0) {
                            reader.setResolution(0);
                        }
                        byte[] bytesSimple = reader.openBytes(reader.getIndex(0, 0, 0));
                        bufferedImage = AWTImageTools.openImage((byte[])bytesSimple, (IFormatReader)reader, (int)reader.getSizeX(), (int)reader.getSizeY());
                    }
                    catch (Throwable throwable) {
                        reader.setSeries(previousSeries);
                        throw throwable;
                    }
                    reader.setSeries(previousSeries);
                    return bufferedImage;
                }
            }
            finally {
                this.queue.put(reader);
            }
        }

        private static ClassList<IFormatReader> unwrapClasslist(IFormatReader reader) {
            while (reader instanceof ReaderWrapper || reader instanceof ImageReader) {
                if (reader instanceof ReaderWrapper) {
                    ReaderWrapper wrapper = (ReaderWrapper)reader;
                    reader = wrapper.getReader();
                    continue;
                }
                reader = ((ImageReader)reader).getReader();
            }
            ClassList classlist = new ClassList(IFormatReader.class);
            classlist.addClass(reader.getClass());
            return classlist;
        }

        @Override
        public void close() throws Exception {
            logger.debug("Closing ReaderManager");
            this.isClosed = true;
            if (this.task != null && !this.task.isDone()) {
                this.task.cancel(true);
            }
            for (Cleaner.Cleanable c : this.cleanables) {
                try {
                    c.clean();
                }
                catch (Exception e) {
                    logger.error("Exception during cleanup: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }

        public long getMemoizationFileSize(String id) {
            return memoizationSizeMap.getOrDefault(id, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static File getTempMemoDir(boolean create) throws IOException {
            if (!create || dirMemoTemp != null) return dirMemoTemp;
            Class<ReaderPool> clazz = ReaderPool.class;
            synchronized (ReaderPool.class) {
                if (dirMemoTemp != null) return dirMemoTemp;
                Path path = Files.createTempDirectory("qupath-memo-", new FileAttribute[0]);
                dirMemoTemp = path.toFile();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        ReaderPool.deleteTempMemoFiles();
                    }
                });
                logger.warn("Temp memoization directory created at {}", (Object)dirMemoTemp);
                logger.warn("If you want to avoid this warning, either specify a memoization directory in the preferences or turn off memoization by setting the time to < 0");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return dirMemoTemp;
            }
        }

        private static void deleteTempMemoFiles() {
            for (File f : tempMemoFiles) {
                if (!f.exists()) continue;
                if (!f.isFile() || !f.getName().endsWith(".bfmemo")) {
                    logger.warn("Unexpected memoization file, will not delete {}", (Object)f.getAbsolutePath());
                    return;
                }
                if (f.delete()) {
                    logger.debug("Deleted temp memoization file {}", (Object)f.getAbsolutePath());
                    continue;
                }
                logger.warn("Could not delete temp memoization file {}", (Object)f.getAbsolutePath());
            }
            if (dirMemoTemp == null) {
                return;
            }
            ReaderPool.deleteEmptyDirectories(dirMemoTemp);
        }

        private static boolean deleteEmptyDirectories(File dir) {
            if (!dir.isDirectory()) {
                return false;
            }
            int nFiles = 0;
            File[] files = dir.listFiles();
            if (files == null) {
                logger.debug("Unable to list files for {}", (Object)dir);
                return false;
            }
            for (File f : files) {
                if (f.isDirectory()) {
                    if (ReaderPool.deleteEmptyDirectories(f)) continue;
                    return false;
                }
                if (!f.isFile()) continue;
                ++nFiles;
            }
            if (nFiles == 0) {
                if (dir.delete()) {
                    logger.debug("Deleting empty memoization directory {}", (Object)dir.getAbsolutePath());
                    return true;
                }
                logger.warn("Could not delete temp memoization directory {}", (Object)dir.getAbsolutePath());
                return false;
            }
            logger.warn("Temp memoization directory contains files, will not delete {}", (Object)dir.getAbsolutePath());
            return false;
        }

        private /* synthetic */ int lambda$openImage$1(int series, int channel) {
            return (Integer)this.metadata.getChannelSamplesPerPixel(series, channel).getValue();
        }

        static {
            cleaner = Cleaner.create();
            memoizationSizeMap = new ConcurrentHashMap<String, Long>();
            dirMemoTemp = null;
            tempMemoFiles = new HashSet<File>();
        }

        static class ReaderCleaner
        implements Runnable {
            private final String name;
            private final IFormatReader reader;

            ReaderCleaner(String name, IFormatReader reader) {
                this.name = name;
                this.reader = reader;
            }

            @Override
            public void run() {
                logger.debug("Cleaner {} called for {} ({})", new Object[]{this.name, this.reader, this.reader.getCurrentFile()});
                try {
                    this.reader.close(false);
                }
                catch (IOException e) {
                    logger.warn("Error when calling cleaner for {}", (Object)this.name, (Object)e);
                }
            }
        }
    }

    static class BioFormatsArgs {
        @CommandLine.Option(names={"--series", "-s"}, defaultValue="-1", description={"Series number (0-based, must be < image count for the file)"})
        int series = -1;
        @CommandLine.Option(names={"--name", "-n"}, defaultValue="", description={"Series name (legacy option, please use --series instead)"})
        String seriesName = "";
        @CommandLine.Option(names={"--dims"}, defaultValue="", description={"Swap dimensions. This should be a String of the form XYCZT, ordered according to how the image plans should be interpreted."})
        String swapDimensions = null;
        @CommandLine.Option(names={"--bfOptions"}, description={"Bio-Formats reader options"})
        Map<String, String> readerOptions = new LinkedHashMap<String, String>();
        @CommandLine.Unmatched
        List<String> unmatched = new ArrayList<String>();

        BioFormatsArgs() {
        }

        String[] backToArgs(int series) {
            ArrayList<Object> args = new ArrayList<Object>();
            if (series >= 0) {
                args.add("--series");
                args.add(Integer.toString(series));
            } else if (this.series >= 0) {
                args.add("--series");
                args.add(Integer.toString(this.series));
            } else if (this.seriesName != null && !this.seriesName.isBlank()) {
                args.add("--name");
                args.add(this.seriesName);
            }
            if (this.swapDimensions != null && !this.swapDimensions.isBlank()) {
                args.add("--dims");
                args.add(this.swapDimensions);
            }
            for (Map.Entry<String, String> option : this.readerOptions.entrySet()) {
                args.add("--bfOptions");
                args.add(option.getKey() + "=" + option.getValue());
            }
            args.addAll(this.unmatched);
            return (String[])args.toArray(String[]::new);
        }

        String getSwapDimensions() {
            return this.swapDimensions == null || this.swapDimensions.isBlank() ? null : this.swapDimensions.toUpperCase();
        }

        static BioFormatsArgs parse(String[] args) {
            BioFormatsArgs bfArgs = new BioFormatsArgs();
            new CommandLine((Object)bfArgs).parseArgs(args);
            return bfArgs;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.readerOptions == null ? 0 : this.readerOptions.hashCode());
            result = 31 * result + this.series;
            result = 31 * result + (this.seriesName == null ? 0 : this.seriesName.hashCode());
            result = 31 * result + (this.swapDimensions == null ? 0 : this.swapDimensions.hashCode());
            result = 31 * result + (this.unmatched == null ? 0 : this.unmatched.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BioFormatsArgs other = (BioFormatsArgs)obj;
            if (this.readerOptions == null ? other.readerOptions != null : !this.readerOptions.equals(other.readerOptions)) {
                return false;
            }
            if (this.series != other.series) {
                return false;
            }
            if (this.seriesName == null ? other.seriesName != null : !this.seriesName.equals(other.seriesName)) {
                return false;
            }
            if (this.swapDimensions == null ? other.swapDimensions != null : !this.swapDimensions.equals(other.swapDimensions)) {
                return false;
            }
            return !(this.unmatched == null ? other.unmatched != null : !this.unmatched.equals(other.unmatched));
        }
    }
}

