/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.logviewer.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.event.Level;

public record LogMessage(String loggerName, long timestamp, String threadName, Level level, String message, Throwable throwable) {
    public String toReadableString() {
        SimpleDateFormat formatter = new SimpleDateFormat("kk:mm:ss.SS");
        String readableString = formatter.format((Object)new Date(this.timestamp())) + "\t[" + this.threadName + "]\t" + this.level + "\t" + this.loggerName + "\t" + this.message;
        if (this.throwable != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                this.throwable.printStackTrace(pw);
            }
            readableString = readableString + "\t" + sw;
        }
        return readableString;
    }
}

