/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.djl.ui;

import ai.djl.engine.Engine;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import org.controlsfx.control.PropertySheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.prefs.annotations.DirectoryPref;
import qupath.fx.prefs.annotations.FilePref;
import qupath.fx.prefs.annotations.Pref;
import qupath.fx.prefs.annotations.PrefCategory;
import qupath.fx.prefs.controlsfx.PropertyItemParser;
import qupath.fx.prefs.controlsfx.PropertySheetBuilder;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.localization.QuPathResources;

public class LaunchScriptCommand {
    private static final Logger logger = LoggerFactory.getLogger(LaunchScriptCommand.class);
    private static final String BUNDLE_KEY = "qupath.ext.djl.ui.strings";
    public static final String KEY_CONDA_PATH = "CONDA_PATH";
    public static final String KEY_QUPATH_EXE = "QUPATH_EXE";
    public static final String KEY_PYTORCH_VERSION = "PYTORCH_VERSION";
    public static final String KEY_PYTORCH_LIBRARY_PATH = "PYTORCH_LIBRARY_PATH";
    public static final String KEY_PYTORCH_FLAVOR = "PYTORCH_FLAVOR";
    private final DjlLaunchParamsFx launchParams = new DjlLaunchParamsFx();

    public void promptForScript() {
        PropertySheet sheet = new PropertySheetBuilder().parser(new PropertyItemParser().setResourceManager(QuPathResources.getLocalizedResourceManager())).addAnnotatedProperties((Object)this.launchParams).build();
        sheet.setSearchBoxVisible(false);
        sheet.setModeSwitcherVisible(false);
        sheet.setMode(PropertySheet.Mode.NAME);
        VBox pane = new VBox();
        pane.getChildren().setAll((Object[])new Node[]{LaunchScriptCommand.createInstructionLabel("script.label1"), LaunchScriptCommand.createInstructionLabel("script.label2"), new Separator(), sheet});
        pane.setSpacing(5.0);
        pane.setPadding(new Insets(5.0));
        if (!ButtonType.OK.equals(Dialogs.builder().content((Node)pane).prefWidth(400.0).title(ResourceBundle.getBundle(BUNDLE_KEY).getString("script.title")).buttons(new ButtonType[]{ButtonType.OK, ButtonType.CANCEL}).showAndWait().orElse(ButtonType.CANCEL))) {
            return;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(KEY_QUPATH_EXE, (String)this.launchParams.qupathExecutable.get());
        params.put(KEY_CONDA_PATH, (String)this.launchParams.condaPath.get());
        params.put(KEY_QUPATH_EXE, (String)this.launchParams.qupathExecutable.get());
        String pytorchVersion = (String)this.launchParams.pytorchVersion.get();
        if (!"Default".equals(pytorchVersion)) {
            params.put(KEY_PYTORCH_VERSION, pytorchVersion);
        }
        params.put(KEY_PYTORCH_LIBRARY_PATH, (String)this.launchParams.pytorchLibraryPath.get());
        try {
            String script = LaunchScriptCommand.createLaunchScript(params);
            logger.info("Script: \n" + script);
            FileChooser.ExtensionFilter filter = GeneralTools.isWindows() ? FileChoosers.createExtensionFilter((String)"Batch file (*.bat)", (String[])new String[]{"*.bat"}) : FileChoosers.createExtensionFilter((String)"Shell script (*.sh)", (String[])new String[]{"*.sh"});
            File file = FileChoosers.promptToSaveFile((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{filter});
            if (file != null) {
                logger.info("Writing launch script to {}", (Object)file);
                Files.writeString(file.toPath(), (CharSequence)script, new OpenOption[0]);
            } else {
                logger.debug("Launch script not saved - dialog cancelled");
            }
        }
        catch (Exception e) {
            Dialogs.showErrorMessage((String)"Deep Java Library", (String)("Error creating script: " + e.getLocalizedMessage()));
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static Label createInstructionLabel(String key) {
        Label label = new Label();
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setAlignment(Pos.CENTER);
        label.setTextAlignment(TextAlignment.CENTER);
        label.setContentDisplay(ContentDisplay.CENTER);
        label.setText(ResourceBundle.getBundle(BUNDLE_KEY).getString(key));
        return label;
    }

    public static String createLaunchScript(Map<String, String> params) {
        String qupathExecutable = (params = new LinkedHashMap<String, String>(params)).remove(KEY_QUPATH_EXE);
        if (qupathExecutable == null) {
            qupathExecutable = LaunchScriptCommand.findQuPathExecutable();
        }
        if (qupathExecutable == null) {
            throw new IllegalArgumentException("No QuPath executable found!");
        }
        String condaPath = params.remove(KEY_CONDA_PATH);
        if (condaPath.startsWith(" ") || condaPath.endsWith(" ")) {
            logger.warn("Conda path has leading or trailing white space; this is probably a mistake (removing)");
            condaPath = condaPath.strip();
        }
        String pathVariable = null;
        String cudnnPath = null;
        if (condaPath != null && !condaPath.isEmpty()) {
            ArrayList<Object> paths = new ArrayList<Object>();
            paths.add(condaPath);
            paths.add(condaPath + File.separator + "bin");
            paths.add(condaPath + File.separator + "lib");
            paths.add(condaPath + File.separator + "lib" + File.separator + "site-packages" + File.separator + "torch" + File.separator + "lib");
            for (String string : paths) {
                if (Files.exists(Path.of(string, new String[0]), new LinkOption[0])) continue;
                logger.warn("Path {} does not exist", (Object)string);
            }
            File dirCudnn = LaunchScriptCommand.findCuDnnDir(new File(condaPath));
            if (dirCudnn != null) {
                cudnnPath = dirCudnn.getAbsolutePath();
            }
            pathVariable = String.join((CharSequence)File.pathSeparator, paths);
        }
        StringBuilder sb = new StringBuilder();
        if (!GeneralTools.isWindows()) {
            sb.append("#!/usr/bin/env bash").append(System.lineSeparator()).append(System.lineSeparator());
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (val == null || val.isEmpty()) continue;
            LaunchScriptCommand.appendToEnvironment(sb, key, val);
        }
        if (pathVariable != null && !pathVariable.isEmpty() && GeneralTools.isWindows() && !params.containsKey("PATH")) {
            LaunchScriptCommand.appendToEnvironment(sb, "PATH", pathVariable + File.pathSeparator + "%PATH%");
        }
        if (GeneralTools.isLinux() && !params.containsKey("LD_LIBRARY_PATH") && cudnnPath != null) {
            LaunchScriptCommand.appendToEnvironment(sb, "LD_LIBRARY_PATH", cudnnPath + File.pathSeparator + "$LD_LIBRARY_PATH");
        }
        if (!sb.toString().endsWith(System.lineSeparator() + System.lineSeparator())) {
            sb.append(System.lineSeparator());
        }
        sb.append(LaunchScriptCommand.quoteIfNeeded(qupathExecutable));
        if (pathVariable != null && !pathVariable.isEmpty() && !GeneralTools.isWindows()) {
            Object jnaPath = System.getProperty("jna.library.path");
            jnaPath = jnaPath == null || ((String)jnaPath).isEmpty() ? pathVariable : pathVariable + File.pathSeparator + (String)jnaPath;
            sb.append(" -Djna.library.path=").append(LaunchScriptCommand.quoteIfNeeded((String)jnaPath));
        }
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private static File findCuDnnDir(File dir) {
        if (!dir.exists()) {
            return null;
        }
        String name = System.mapLibraryName("cudnn");
        try {
            Path pathCuDnn = Files.walk(dir.toPath(), new FileVisitOption[0]).filter(p -> p.getFileName().toString().startsWith(name)).findFirst().orElse(null);
            logger.info("Searching for {}, found {}", (Object)name, (Object)pathCuDnn);
            return pathCuDnn == null ? null : pathCuDnn.toFile().getParentFile();
        }
        catch (IOException e) {
            logger.warn("Error searching for cudnn: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static void appendToEnvironment(StringBuilder sb, String key, String val) {
        if (val != null && !val.isEmpty()) {
            if (GeneralTools.isWindows()) {
                sb.append("set ").append(key).append("=");
            } else {
                sb.append("export ").append(key).append("=");
            }
            sb.append(LaunchScriptCommand.quoteIfNeeded(val));
            sb.append(System.lineSeparator());
        }
    }

    private static String quoteIfNeeded(String val) {
        if (val == null || val.isEmpty()) {
            return val;
        }
        if (val.contains(" ") && !val.startsWith("\"") && !val.endsWith("\"")) {
            return "\"" + val + "\"";
        }
        return val;
    }

    static String findQuPathExecutable() {
        File[] executables;
        File file = new File(QuPathGUI.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        if (file.isDirectory()) {
            throw new UnsupportedOperationException("QuPath must be packaged to find executable");
        }
        File dir = file.getParentFile();
        if (dir.getName().equals("app")) {
            dir = dir.getParentFile();
        }
        if (GeneralTools.isWindows()) {
            executables = dir.listFiles(f -> f.isFile() && f.getName().toLowerCase().endsWith(".exe"));
        } else {
            if (new File(dir.getParentFile(), "bin").exists()) {
                dir = new File(dir.getParentFile(), "bin");
            } else if (GeneralTools.isMac() && new File(dir, "MacOS").exists()) {
                dir = new File(dir, "MacOS");
            }
            executables = dir.listFiles(f -> f.isFile() && f.getName().toLowerCase().startsWith("qupath") && Files.isExecutable(f.toPath()));
        }
        if (executables.length == 0) {
            throw new IllegalArgumentException("No QuPath executable found!");
        }
        if (executables.length > 1) {
            Arrays.sort(executables, Comparator.comparingInt(f -> f.getAbsolutePath().length()).reversed());
        }
        return executables[0].getAbsolutePath();
    }

    @PrefCategory(bundle="qupath.ext.djl.ui.strings", value="script.title")
    private static class DjlLaunchParamsFx {
        @DirectoryPref(bundle="qupath.ext.djl.ui.strings", value="script.conda.path")
        private final StringProperty condaPath = new SimpleStringProperty(null);
        @Pref(bundle="qupath.ext.djl.ui.strings", value="script.pytorch.version", type=String.class, choiceMethod="getPyTorchVersions")
        private final StringProperty pytorchVersion = new SimpleStringProperty(null);
        @DirectoryPref(bundle="qupath.ext.djl.ui.strings", value="script.pytorch.path")
        private final StringProperty pytorchLibraryPath = new SimpleStringProperty("");
        @FilePref(bundle="qupath.ext.djl.ui.strings", value="script.qupath.exe")
        private final StringProperty qupathExecutable = new SimpleStringProperty("");

        private DjlLaunchParamsFx() {
            try {
                List<String> pytorchVersions = this.getPyTorchVersions();
                if (!pytorchVersions.isEmpty()) {
                    this.pytorchVersion.set((Object)pytorchVersions.get(0));
                }
            }
            catch (Exception e) {
                logger.debug("Unknown DJL version: " + Engine.getDjlVersion());
            }
            try {
                String executablePath = LaunchScriptCommand.findQuPathExecutable();
                if (executablePath != null && !executablePath.isEmpty()) {
                    this.qupathExecutable.set((Object)executablePath);
                }
            }
            catch (Exception e) {
                logger.debug("Unable to find QuPath executable");
            }
        }

        public List<String> getPyTorchVersions() {
            String version;
            return switch (version = Engine.getDjlVersion()) {
                case "0.23.0", "0.24.0", "0.25.0" -> Arrays.asList("Default", "2.0.1", "1.13.1", "1.12.1");
                case "0.26.0" -> Arrays.asList("Default", "2.1.1", "2.0.1", "1.13.1");
                case "0.32.0" -> Arrays.asList("Default", "2.5.1", "2.3.1", "2.1.2", "1.13.1");
                default -> throw new RuntimeException("Unknown DJL version: " + version);
            };
        }
    }
}

