/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.djl.ui;

import ai.djl.engine.Engine;
import ai.djl.engine.EngineException;
import ai.djl.util.Utils;
import ai.djl.util.cuda.CudaUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.djl.DjlTools;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;

public class DjlEngineCommand {
    private static final Logger logger = LoggerFactory.getLogger(DjlEngineCommand.class);
    private static final String TITLE = "Deep Java Library engines";
    private QuPathGUI qupath;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("qupath.ext.djl.ui.strings");
    private static DjlEngineCommand INSTANCE;
    private Stage stage;
    private static final Set<String> LINUX_ONLY;
    private static final Set<String> UNSUPPORTED_APPLE_SILICON;
    private final ObservableMap<String, ObjectProperty<EngineStatus>> available = FXCollections.observableHashMap();

    DjlEngineCommand(QuPathGUI qupath) {
        this.qupath = qupath;
        this.init();
    }

    private void init() {
        GridPane pane = new GridPane();
        pane.getStylesheets().add((Object)DjlEngineCommand.class.getResource("styles.css").toExternalForm());
        pane.setHgap(5.0);
        pane.setVgap(5.0);
        pane.setPadding(new Insets(10.0));
        int row = 0;
        Label label = DjlEngineCommand.createCenteredLabelForString(String.format(bundle.getString("overview.description"), Engine.getDjlVersion()));
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{label, label, label});
        Label label2 = DjlEngineCommand.createCenteredLabelForKey("overview.directories");
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{label2, label2, label2});
        Label label3 = DjlEngineCommand.createCenteredLabelForKey("overview.licensing");
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{label3, label3, label3});
        Separator separator = new Separator(Orientation.HORIZONTAL);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{separator, separator, separator});
        Label labelCuda = DjlEngineCommand.createCenteredLabelForString(DjlEngineCommand.getCudaString());
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{labelCuda, labelCuda, labelCuda});
        for (String name : Engine.getAllEngines()) {
            separator = new Separator(Orientation.HORIZONTAL);
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{separator, separator, separator});
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{separator});
            ObjectProperty status = (ObjectProperty)this.available.computeIfAbsent((Object)name, n -> new SimpleObjectProperty((Object)EngineStatus.UNKNOWN));
            Path path = Utils.getEngineCacheDir((String)name.toLowerCase());
            String tooltip = String.format(bundle.getString("tooltip.engine"), name);
            String labelNameText = name;
            if (name.equals(Engine.getDefaultEngineName())) {
                labelNameText = String.format(bundle.getString("label.defaultName"), name);
            }
            Label labelName = new Label(labelNameText);
            labelName.setStyle("-fx-font-weight: bold;");
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)tooltip, (Node[])new Node[]{labelName, labelName});
            Label labelPath = new Label(path.toString());
            Button btnDownload = new Button();
            btnDownload.setText(bundle.getString("button.download"));
            btnDownload.setPrefWidth(60.0);
            long timeoutMillis = 500L;
            btnDownload.setOnAction(e -> this.checkEngineStatus(name, (ObjectProperty<EngineStatus>)status, timeoutMillis, false));
            btnDownload.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> status.get() == EngineStatus.AVAILABLE || status.get() == EngineStatus.PENDING, (Observable[])new Observable[]{status}));
            btnDownload.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                switch (((EngineStatus)((Object)((Object)status.get()))).ordinal()) {
                    case 3: {
                        return bundle.getString("button.download.available");
                    }
                    case 4: {
                        return bundle.getString("button.download.failed");
                    }
                    case 2: {
                        return bundle.getString("button.download.pending");
                    }
                    case 0: {
                        return bundle.getString("button.download.unavailable");
                    }
                }
                return bundle.getString("button.download.unknown");
            }, (Observable[])new Observable[]{status}));
            Tooltip tooltipDownload = new Tooltip();
            tooltipDownload.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                switch (((EngineStatus)((Object)((Object)status.get()))).ordinal()) {
                    case 3: {
                        return String.format(bundle.getString("tooltip.download.available"), name);
                    }
                    case 4: {
                        return String.format(bundle.getString("tooltip.download.failed"), name);
                    }
                    case 2: {
                        return String.format(bundle.getString("tooltip.download.pending"), name);
                    }
                    case 0: {
                        return String.format(bundle.getString("tooltip.download.unavailable"), name);
                    }
                }
                return String.format(bundle.getString("tooltip.download.unknown"), name);
            }, (Observable[])new Observable[]{status}));
            btnDownload.setTooltip(tooltipDownload);
            Circle circle = new Circle(6.0);
            DjlEngineCommand.updateIconFromStatus((EngineStatus)((Object)status.get()), (Node)circle);
            Label labelPathLabel = DjlEngineCommand.createLabelForKey("label.path");
            labelPathLabel.setLabelFor((Node)labelPath);
            labelPathLabel.setContentDisplay(ContentDisplay.LEFT);
            Tooltip tooltipPath = new Tooltip();
            labelPath.setTooltip(tooltipPath);
            labelPath.setCursor(Cursor.HAND);
            labelPath.setOnMouseClicked(e -> {
                if (e.getClickCount() == 2 && Files.isDirectory(path, new LinkOption[0])) {
                    GuiTools.browseDirectory((File)path.toFile());
                } else {
                    logger.debug("Cannot open {} - directory does not exist", (Object)path);
                }
            });
            Label labelVersion = new Label(bundle.getString("label.version.unknown"));
            labelVersion.setMaxWidth(Double.MAX_VALUE);
            Label labelVersionLabel = DjlEngineCommand.createLabelForKey("label.version");
            labelVersionLabel.setLabelFor((Node)labelVersion);
            labelVersionLabel.setContentDisplay(ContentDisplay.LEFT);
            status.addListener((v, o, n) -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    tooltipPath.setText(bundle.getString("tooltip.openPath"));
                } else {
                    labelPath.setStyle("-fx-opacity: 0.5;");
                    tooltipPath.setText(bundle.getString("tooltip.pathMissing"));
                }
                DjlEngineCommand.updateIconFromStatus(n, (Node)circle);
                DjlEngineCommand.updateVersionFromStatus(n, name, labelVersion);
            });
            StackPane circlePane = new StackPane(new Node[]{circle});
            circlePane.setPadding(new Insets(5.0));
            pane.add((Node)circlePane, 0, row, 1, 2);
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)1, null, (Node[])new Node[]{labelPathLabel, labelPath});
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)1, null, (Node[])new Node[]{labelVersionLabel, labelVersion});
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)1, null, (Node[])new Node[]{btnDownload, btnDownload});
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{labelName, labelPath, btnDownload});
        }
        this.stage = new Stage();
        this.stage.setTitle(TITLE);
        this.stage.initOwner((Window)QuPathGUI.getInstance().getStage());
        this.stage.setScene(new Scene((Parent)pane));
    }

    private static void updateIconFromStatus(EngineStatus status, Node node) {
        if (status == null) {
            status = EngineStatus.UNKNOWN;
        }
        node.getStyleClass().setAll((Object[])new String[]{"djl-engine-status", status.name().toString().toLowerCase()});
    }

    private static void updateVersionFromStatus(EngineStatus status, String engineName, Label labelVersion) {
        if (status == EngineStatus.AVAILABLE) {
            try {
                Engine engine = Engine.getEngine((String)engineName);
                labelVersion.setText(engine.getVersion());
                labelVersion.setTooltip(new Tooltip(engine.getEngineName() + ":" + engine.getVersion()));
                return;
            }
            catch (Exception e) {
                logger.error("Error updating engine version: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        labelVersion.setText(bundle.getString("label.version.unknown"));
        labelVersion.setTooltip(null);
    }

    private static Label createLabelForKey(String key) {
        Label label = new Label(bundle.getString(key));
        label.setWrapText(true);
        return label;
    }

    private static Label createCenteredLabelForKey(String key) {
        return DjlEngineCommand.createCenteredLabelForString(bundle.getString(key));
    }

    private static Label createCenteredLabelForString(String s) {
        Label label = new Label(s);
        label.setWrapText(true);
        label.setAlignment(Pos.CENTER);
        label.setTextAlignment(TextAlignment.CENTER);
        label.setMaxHeight(Double.MAX_VALUE);
        label.setMaxWidth(Double.MAX_VALUE);
        return label;
    }

    private void showDialog() {
        if (this.stage.isShowing()) {
            this.stage.toFront();
        } else {
            this.stage.show();
        }
    }

    private static String getCudaString() {
        if (CudaUtils.hasCuda()) {
            StringBuilder sb = new StringBuilder().append(bundle.getString("label.cudaVersion")).append(CudaUtils.getCudaVersionString());
            for (int i = 0; i < CudaUtils.getGpuCount(); ++i) {
                sb.append("\n").append("  GPU ").append(i).append(" ").append(bundle.getString("label.computeCapability")).append(CudaUtils.getComputeCapability((int)i));
            }
            return sb.toString();
        }
        if (GeneralTools.isMac() && "aarch64".equals(System.getProperty("os.arch"))) {
            return bundle.getString("cuda.appleSilicon");
        }
        return bundle.getString("cuda.notFound");
    }

    private void checkEngineStatus(String name, ObjectProperty<EngineStatus> status, long timeoutMillis, boolean doQuietly) {
        ExecutorService pool = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)"djl-engine-request", (boolean)true));
        this.updateStatus(status, EngineStatus.PENDING);
        Future<Boolean> future = pool.submit(() -> this.checkEngineAvailability(name, status, doQuietly));
        if (timeoutMillis <= 0L) {
            return;
        }
        pool.shutdown();
        try {
            Boolean result = future.get(timeoutMillis, TimeUnit.MILLISECONDS);
            if (result != null && result.booleanValue()) {
                Dialogs.showInfoNotification((String)TITLE, (String)String.format(bundle.getString("notify.engine.available"), name));
            } else {
                logger.debug("No engine available for {}", (Object)name);
            }
        }
        catch (InterruptedException e) {
            logger.error("Requesting for engine " + name + "interrupted!", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error("Error requesting engine " + name + ": " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.debug("Request for engine {} timed out - likely either initializing or downloading", (Object)name);
        }
    }

    private void updateStatus(ObjectProperty<EngineStatus> status, EngineStatus newStatus) {
        if (Platform.isFxApplicationThread()) {
            status.set((Object)newStatus);
        } else {
            Platform.runLater(() -> this.updateStatus(status, newStatus));
        }
    }

    private Boolean checkEngineAvailability(String name, ObjectProperty<EngineStatus> status, boolean doQuietly) {
        ButtonType button;
        if (!GeneralTools.isLinux() && LINUX_ONLY.contains(name)) {
            if (!doQuietly) {
                Dialogs.showErrorMessage((String)TITLE, (String)String.format(bundle.getString("notify.engine.linuxOnly"), name));
            }
            this.updateStatus(status, EngineStatus.UNAVAILABLE);
            return Boolean.FALSE;
        }
        if (!doQuietly && GeneralTools.isMac() && UNSUPPORTED_APPLE_SILICON.contains(name) && ButtonType.NO.equals(button = Dialogs.builder().title(TITLE).alertType(Alert.AlertType.WARNING).contentText(name + " won't work on recent Macs with Apple Silicon.\nDo you want to continue anyway?").buttons(new ButtonType[]{ButtonType.YES, ButtonType.NO}).showAndWait().orElse(ButtonType.NO))) {
            this.updateStatus(status, EngineStatus.UNAVAILABLE);
            return Boolean.FALSE;
        }
        try {
            boolean isAvailable;
            this.updateStatus(status, EngineStatus.PENDING);
            if (doQuietly) {
                isAvailable = DjlTools.isEngineAvailable(name);
            } else {
                boolean bl = isAvailable = DjlTools.getEngine(name, true) != null;
            }
            if (isAvailable) {
                this.updateStatus(status, EngineStatus.AVAILABLE);
            } else {
                this.updateStatus(status, EngineStatus.UNAVAILABLE);
                if (!doQuietly) {
                    Dialogs.showWarningNotification((String)TITLE, (String)("Unable to initialize " + name + ", sorry"));
                }
            }
            return isAvailable;
        }
        catch (EngineException e) {
            if (doQuietly) {
                logger.debug("Error requesting engine: " + e.getLocalizedMessage(), (Throwable)e);
            } else {
                logger.error("Error requesting engine: " + e.getLocalizedMessage(), (Throwable)e);
                Dialogs.showErrorMessage((String)TITLE, (String)("Unable to initialize " + name + "\n- engine might not be supported on this platform, sorry"));
            }
        }
        catch (Exception e) {
            if (doQuietly) {
                logger.debug("Error requesting engine: " + e.getLocalizedMessage(), (Throwable)e);
            }
            logger.error("Error requesting engine: " + e.getLocalizedMessage(), (Throwable)e);
            Dialogs.showErrorMessage((String)TITLE, (String)("Exception when trying to download " + name + "\n" + e.getLocalizedMessage()));
        }
        this.updateStatus(status, EngineStatus.FAILED);
        return Boolean.FALSE;
    }

    public static void showDialog(QuPathGUI qupath) {
        if (INSTANCE == null) {
            INSTANCE = new DjlEngineCommand(qupath);
        }
        INSTANCE.showDialog();
    }

    static {
        LINUX_ONLY = Set.of(DjlTools.ENGINE_TENSORRT);
        UNSUPPORTED_APPLE_SILICON = Set.of(DjlTools.ENGINE_PADDLEPADDLE, DjlTools.ENGINE_TFLITE, DjlTools.ENGINE_LIGHTGBM);
    }

    private static enum EngineStatus {
        UNAVAILABLE,
        UNKNOWN,
        PENDING,
        AVAILABLE,
        FAILED;

    }
}

